/*
 * Decompiled with CFR 0.152.
 */
package ch.itmed.fop.printing.xml.elements;

import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IArticleDefaultSignature;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.services.holder.MedicationServiceHolder;
import ch.itmed.fop.printing.data.ArticleData;
import ch.itmed.fop.printing.data.ConsultationData;
import ch.itmed.fop.printing.resources.Messages;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class ArticlesElement {
    public static Element create(Document doc) throws Exception {
        return ArticlesElement.create(doc, true);
    }

    public static Element create(Document doc, IArticle article) {
        Element articlesElement = doc.createElement("Articles");
        articlesElement.appendChild(ArticlesElement.createArticleElement(doc, article));
        return articlesElement;
    }

    public static Element create(Document doc, boolean includeMedication) throws Exception {
        ConsultationData cd = new ConsultationData();
        List<ArticleData> articles = cd.load();
        if (!includeMedication) {
            articles = articles.stream().filter(ad -> !ArticlesElement.isMedication(ad, cd)).collect(Collectors.toList());
        }
        Element articlesElement = doc.createElement("Articles");
        for (ArticleData articleData : articles) {
            articlesElement.appendChild(ArticlesElement.createArticleElement(doc, articleData.getArticle()));
        }
        return articlesElement;
    }

    private static Element createArticleElement(Document doc, IArticle article) {
        ArticleData articleData = new ArticleData(article);
        Element articleElement = doc.createElement("Article");
        ArticlesElement.appendChildWithText(doc, articleElement, "Name", articleData.getName());
        ArticlesElement.appendChildWithText(doc, articleElement, "Price", articleData.getPrice());
        ArticlesElement.appendChildWithText(doc, articleElement, "DeliveryDate", articleData.getDeliveryDate());
        Optional<IArticleDefaultSignature> signatureOpt = ArticlesElement.getDefaultSignature(article);
        if (signatureOpt.isPresent()) {
            IArticleDefaultSignature signature = signatureOpt.get();
            String dosageInstructions = signature.getComment();
            if (StringUtils.isNotBlank((CharSequence)dosageInstructions)) {
                ArticlesElement.appendChildWithText(doc, articleElement, "DosageInstructions", dosageInstructions);
            }
            if (signature.getFreeText() != null && !signature.getFreeText().isEmpty()) {
                Element dose = doc.createElement("Dose");
                dose.setAttribute("Freetext", "true");
                dose.appendChild(doc.createTextNode(signature.getFreeText()));
                articleElement.appendChild(dose);
            } else if (signature.getSignatureAsDosisString() != null && !signature.getSignatureAsDosisString().isEmpty()) {
                ArticlesElement.appendDoseTable(doc, articleElement, signature);
            }
        }
        return articleElement;
    }

    private static void appendDoseTable(Document doc, Element articleElement, IArticleDefaultSignature signature) {
        String[] doses;
        Element doseTableHeader = doc.createElement("DoseTableHeader");
        ArticlesElement.appendChildWithText(doc, doseTableHeader, "HeaderItem", Messages.Medication_Dose_Morning);
        ArticlesElement.appendChildWithText(doc, doseTableHeader, "HeaderItem", Messages.Medication_Dose_Midday);
        ArticlesElement.appendChildWithText(doc, doseTableHeader, "HeaderItem", Messages.Medication_Dose_Evening);
        ArticlesElement.appendChildWithText(doc, doseTableHeader, "HeaderItem", Messages.Medication_Dose_Night);
        articleElement.appendChild(doseTableHeader);
        Element doseTableBody = doc.createElement("DoseTableBody");
        String[] stringArray = doses = new String[]{signature.getMorning(), signature.getNoon(), signature.getEvening(), signature.getNight()};
        int n = doses.length;
        int n2 = 0;
        while (n2 < n) {
            String dose = stringArray[n2];
            ArticlesElement.appendChildWithText(doc, doseTableBody, "DoseItem", dose != null ? dose : "");
            ++n2;
        }
        articleElement.appendChild(doseTableBody);
    }

    private static void appendChildWithText(Document doc, Element parent, String tagName, String textContent) {
        Element child = doc.createElement(tagName);
        child.appendChild(doc.createTextNode(textContent));
        parent.appendChild(child);
    }

    private static boolean isMedication(ArticleData ad, ConsultationData cd) {
        List<IPrescription> medication = cd.getMedication();
        if (!medication.isEmpty()) {
            return medication.stream().anyMatch(m -> ad.getArticle().getId().equals(m.getArticle().getId()));
        }
        return false;
    }

    public static Optional<IArticleDefaultSignature> getDefaultSignature(IArticle article) {
        return MedicationServiceHolder.get().getDefaultSignature(article);
    }
}

