/*
 * Decompiled with CFR 0.152.
 */
package ch.itmed.fop.printing.handlers;

import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.rcp.utils.OsgiServiceUtil;
import ch.elexis.core.services.IModelService;
import ch.itmed.fop.printing.preferences.PreferenceConstants;
import ch.itmed.fop.printing.preferences.SettingsProvider;
import ch.itmed.fop.printing.print.PrintProvider;
import ch.itmed.fop.printing.resources.ResourceProvider;
import ch.itmed.fop.printing.xml.documents.PdfTransformer;
import ch.itmed.fop.printing.xml.documents.RowaArticleMedicationLabel;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;

public class RowaArticleMedicationLabelHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String patientId = event.getParameter("rowa_article_medication_label_patient");
        String gtin = event.getParameter("rowa_article_medication_label_article");
        IPatient patient = this.getPatient(patientId);
        IPrescription prescription = this.getPatientPrescription(patient, gtin);
        try {
            InputStream xmlDoc = RowaArticleMedicationLabel.create((IPrescription)prescription, (IPatient)patient, (String)gtin);
            InputStream pdf = PdfTransformer.transformXmlToPdf((InputStream)xmlDoc, (File)ResourceProvider.getXslTemplateFile((int)10));
            String docName = "RowaArticleMedicationLabel";
            String printer = SettingsProvider.getStore(docName).getString(PreferenceConstants.getDocPreferenceConstant((String)docName, (int)0));
            PrintProvider.printPdf((InputStream)pdf, (String)printer);
        }
        catch (Exception e) {
            throw new ExecutionException("Error printing label RowaArticleMedicationLabel", (Throwable)e);
        }
        return null;
    }

    private IPatient getPatient(String patientId) throws ExecutionException {
        IModelService coreModelService = (IModelService)OsgiServiceUtil.getService(IModelService.class, (String)"(service.model.name=ch.elexis.core.model)").orElseThrow(() -> new IllegalStateException());
        return (IPatient)coreModelService.load(patientId, IPatient.class).orElseThrow(() -> new ExecutionException("Patient not found for ID: " + patientId));
    }

    private IPrescription getPatientPrescription(IPatient patient, String gtin) throws ExecutionException {
        List medications = patient.getMedication(List.of(EntryType.FIXED_MEDICATION, EntryType.RESERVE_MEDICATION, EntryType.SYMPTOMATIC_MEDICATION));
        for (IPrescription pres : medications) {
            if (!pres.getArticle().getGtin().equals(gtin)) continue;
            return pres;
        }
        throw new ExecutionException("No prescription found for gtin " + gtin + " and patientId " + patient.getId());
    }
}

