/*
 * Decompiled with CFR 0.152.
 */
package ch.itmed.fop.printing.handlers;

import ch.elexis.core.model.IPrescription;
import ch.elexis.core.ui.medication.views.MedicationTableViewerItem;
import ch.elexis.core.ui.util.SWTHelper;
import ch.itmed.fop.printing.preferences.PreferenceConstants;
import ch.itmed.fop.printing.preferences.SettingsProvider;
import ch.itmed.fop.printing.print.PrintProvider;
import ch.itmed.fop.printing.resources.Messages;
import ch.itmed.fop.printing.resources.ResourceProvider;
import ch.itmed.fop.printing.xml.documents.MedicationLabel;
import ch.itmed.fop.printing.xml.documents.PdfTransformer;
import java.io.File;
import java.io.InputStream;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MedicationLabelHandler
extends AbstractHandler {
    private static Logger logger = LoggerFactory.getLogger(MedicationLabelHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            IStructuredSelection selection = HandlerUtil.getCurrentStructuredSelection((ExecutionEvent)event);
            if (selection != null && !selection.isEmpty() && selection.getFirstElement() instanceof MedicationTableViewerItem) {
                for (Object obj : selection.toList()) {
                    if (!(obj instanceof MedicationTableViewerItem)) continue;
                    InputStream xmlDoc = MedicationLabel.create((IPrescription)((MedicationTableViewerItem)obj).getPrescription());
                    InputStream pdf = PdfTransformer.transformXmlToPdf((InputStream)xmlDoc, (File)ResourceProvider.getXslTemplateFile((int)3));
                    String docName = "MedicationLabel";
                    IPreferenceStore settingsStore = SettingsProvider.getStore(docName);
                    String printerName = settingsStore.getString(PreferenceConstants.getDocPreferenceConstant((String)docName, (int)0));
                    logger.info("Printing document MedicationLabel on printer: " + printerName);
                    PrintProvider.printPdf((InputStream)pdf, (String)printerName);
                }
            } else {
                InputStream xmlDoc = MedicationLabel.create();
                InputStream pdf = PdfTransformer.transformXmlToPdf((InputStream)xmlDoc, (File)ResourceProvider.getXslTemplateFile((int)3));
                String docName = "MedicationLabel";
                IPreferenceStore settingsStore = SettingsProvider.getStore(docName);
                String printerName = settingsStore.getString(PreferenceConstants.getDocPreferenceConstant((String)docName, (int)0));
                logger.info("Printing document MedicationLabel on printer: " + printerName);
                PrintProvider.printPdf((InputStream)pdf, (String)printerName);
            }
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg != null && msg.equals("No prescription selected")) {
                return null;
            }
            SWTHelper.showError((String)Messages.DefaultError_Title, (String)Messages.DefaultError_Message);
            logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return null;
    }
}

