/*
 * Decompiled with CFR 0.152.
 */
package ch.itmed.fop.printing.handlers;

import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IArticleDefaultSignature;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.MedicationServiceHolder;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.util.SWTHelper;
import ch.itmed.fop.printing.preferences.PreferenceConstants;
import ch.itmed.fop.printing.preferences.SettingsProvider;
import ch.itmed.fop.printing.print.PrintProvider;
import ch.itmed.fop.printing.resources.Messages;
import ch.itmed.fop.printing.resources.ResourceProvider;
import ch.itmed.fop.printing.xml.documents.ArticleLabel;
import ch.itmed.fop.printing.xml.documents.MedicationLabel;
import ch.itmed.fop.printing.xml.documents.PdfTransformer;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.StructuredSelection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArticleMedicationLabelsHandler
extends AbstractHandler {
    private static final Logger logger = LoggerFactory.getLogger(ArticleMedicationLabelsHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Optional consultationOpt;
        block4: {
            consultationOpt = ContextServiceHolder.get().getTyped(IEncounter.class);
            if (consultationOpt.isPresent()) break block4;
            SWTHelper.showError((String)Messages.DefaultError_Title, (String)Messages.DefaultError_Message);
            return null;
        }
        try {
            IEncounter consultation = (IEncounter)consultationOpt.get();
            List billedItems = consultation.getBilled();
            List medications = consultation.getPatient().getMedication(Arrays.asList(EntryType.FIXED_MEDICATION, EntryType.RESERVE_MEDICATION, EntryType.SYMPTOMATIC_MEDICATION, EntryType.SELF_DISPENSED));
            StructuredSelection selection = CoreUiUtil.getCommandSelection((String)"ch.elexis.VerrechnungsDisplay", (boolean)false);
            if (selection != null && !selection.isEmpty() && selection.getFirstElement() instanceof IBilled) {
                billedItems = selection.toList();
            }
            billedItems.stream().filter(iBilled -> iBilled.getBillable() instanceof IArticle).forEach(iBilled -> {
                try {
                    this.processBilledItem((IBilled)iBilled, medications);
                }
                catch (Exception e) {
                    logger.error("Error processing billed item: {}", iBilled, (Object)e);
                }
            });
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return null;
    }

    private void processBilledItem(IBilled iBilled, List<IPrescription> medications) throws Exception {
        IArticle article = (IArticle)iBilled.getBillable();
        Optional<IPrescription> prescriptionOpt = this.findPrescriptionByBilledId(iBilled.getId().toString(), medications);
        int amount = (int)iBilled.getAmount();
        if (prescriptionOpt.isPresent()) {
            IPrescription prescription = prescriptionOpt.get();
            String dosageInstruction = prescription.getDosageInstruction();
            String remark = prescription.getRemark();
            if (StringUtils.isNotBlank((CharSequence)dosageInstruction) || StringUtils.isNotBlank((CharSequence)remark)) {
                this.printMedicationLabels(prescription, amount);
            } else {
                this.handleAlternativePrescriptionOrDefault(article, medications, amount);
            }
        } else {
            this.handleAlternativePrescriptionOrDefault(article, medications, amount);
        }
    }

    private void handleAlternativePrescriptionOrDefault(IArticle article, List<IPrescription> medications, int amount) throws Exception {
        Optional<IPrescription> alternativePrescription = this.findAlternativePrescription(article, medications);
        if (alternativePrescription.isPresent()) {
            this.printMedicationLabels(alternativePrescription.get(), amount);
        } else {
            this.printArticleLabels(article, amount);
        }
    }

    private Optional<IPrescription> findAlternativePrescription(IArticle article, List<IPrescription> medications) {
        return medications.stream().filter(p -> p.getEntryType() == EntryType.FIXED_MEDICATION || p.getEntryType() == EntryType.RESERVE_MEDICATION || p.getEntryType() == EntryType.SYMPTOMATIC_MEDICATION).filter(p -> p.getArticle() != null && p.getArticle().equals(article)).findFirst();
    }

    private void printMedicationLabels(IPrescription prescription, int amount) throws Exception {
        File xslTemplate = ResourceProvider.getXslTemplateFile((int)3);
        String docName = "MedicationLabel";
        IPreferenceStore settingsStore = SettingsProvider.getStore(docName);
        String printerName = settingsStore.getString(PreferenceConstants.getDocPreferenceConstant((String)docName, (int)0));
        logger.info("Printing document MedicationLabel on printer: " + printerName);
        int i = 0;
        while (i < amount) {
            InputStream xmlDoc = MedicationLabel.create((IPrescription)prescription);
            InputStream pdf = PdfTransformer.transformXmlToPdf((InputStream)xmlDoc, (File)xslTemplate);
            PrintProvider.printPdf((InputStream)pdf, (String)printerName);
            ++i;
        }
    }

    private void printArticleLabels(IArticle article, int amount) throws Exception {
        String docName;
        File xslTemplate;
        InputStream xmlDoc = ArticleLabel.create((IArticle)article);
        Optional<String> dosageInstructions = ArticleMedicationLabelsHandler.getDosageInstructions(article);
        if (dosageInstructions.isPresent() && this.hasPrinterConfigured("ArticleMedicLabel")) {
            xslTemplate = ResourceProvider.getXslTemplateFile((int)9);
            docName = "ArticleMedicLabel";
        } else {
            xslTemplate = ResourceProvider.getXslTemplateFile((int)2);
            docName = "ArticleLabel";
        }
        IPreferenceStore settingsStore = SettingsProvider.getStore(docName);
        String printerName = settingsStore.getString(PreferenceConstants.getDocPreferenceConstant((String)docName, (int)0));
        logger.info("Printing document " + docName + " on printer: " + printerName);
        int i = 0;
        while (i < amount) {
            InputStream pdf = PdfTransformer.transformXmlToPdf((InputStream)xmlDoc, (File)xslTemplate);
            PrintProvider.printPdf((InputStream)pdf, (String)printerName);
            xmlDoc.reset();
            ++i;
        }
    }

    private boolean hasPrinterConfigured(String docName) {
        IPreferenceStore settingsStore = SettingsProvider.getStore(docName);
        String printerName = settingsStore.getString(PreferenceConstants.getDocPreferenceConstant((String)docName, (int)0));
        return StringUtils.isNotBlank((CharSequence)printerName);
    }

    private void handleException(Exception e) {
        String msg = e.getMessage();
        if (msg != null && (msg.equals("No patient selected") || msg.equals("No consultation selected"))) {
            return;
        }
        SWTHelper.showError((String)Messages.DefaultError_Title, (String)Messages.DefaultError_Message);
        logger.error(e.getLocalizedMessage(), (Throwable)e);
    }

    private static Optional<String> getDosageInstructions(IArticle article) {
        return MedicationServiceHolder.get().getDefaultSignature(article).map(IArticleDefaultSignature::getSignatureAsDosisString);
    }

    private Optional<IPrescription> findPrescriptionByBilledId(String billedId, List<IPrescription> prescriptions) {
        return prescriptions.stream().filter(p -> billedId.equals(p.getExtInfo((Object)"verrechnetId"))).findFirst();
    }
}

