/*
 * Decompiled with CFR 0.152.
 */
package ch.itmed.fop.printing.preferences.ui;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.preferences.ConfigServicePreferenceStore;
import ch.elexis.core.ui.util.SWTHelper;
import ch.itmed.fop.printing.preferences.PreferenceConstants;
import ch.itmed.fop.printing.preferences.ui.TemplatePreferencesDialog;
import ch.itmed.fop.printing.resources.Messages;
import java.util.function.Consumer;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public final class GeneralPreferences
extends PreferencePage
implements IWorkbenchPreferencePage {
    private String[] tableCols = new String[]{Messages.GeneralPreferences_Document, Messages.GeneralPreferences_Printer, Messages.GeneralPreferences_PaperFormat, Messages.GeneralPreferences_XslTemplate, Messages.GeneralPreferences_TextOrientation, Messages.GeneralPreferences_SettingScope, Messages.GeneralPreferences_BarcodScope};
    private static Table table;

    public void init(IWorkbench arg0) {
    }

    protected Control createContents(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayout((Layout)new GridLayout(2, false));
        table = new Table(ret, 67588);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        int i = 0;
        while (i < this.tableCols.length) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(this.tableCols[i]);
            ++i;
        }
        this.createTableContent();
        i = 0;
        while (i < this.tableCols.length) {
            table.getColumn(i).pack();
            ++i;
        }
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                TemplatePreferencesDialog dialog = new TemplatePreferencesDialog(GeneralPreferences.this.getShell(), table.getSelectionIndex());
                dialog.open();
                GeneralPreferences.updateTableRow(table.getSelectionIndex(), PreferenceConstants.getDocumentName((int)table.getSelectionIndex()));
            }
        });
        table.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)true));
        table.setSize(table.computeSize(-1, 200));
        return ret;
    }

    public boolean performOk() {
        return super.performOk();
    }

    private static void updateTableRow(int rowIndex, String docName) {
        TableItem item = table.getItem(rowIndex);
        ConfigServicePreferenceStore settingsStore = CoreHub.localCfg.get(PreferenceConstants.getDocPreferenceConstant((String)docName, (int)12), true) ? new ConfigServicePreferenceStore(ConfigServicePreferenceStore.Scope.GLOBAL) : new ConfigServicePreferenceStore(ConfigServicePreferenceStore.Scope.LOCAL);
        item.setText(1, settingsStore.getString(PreferenceConstants.getDocPreferenceConstant((String)docName, (int)0)));
        if (settingsStore.getBoolean(PreferenceConstants.getDocPreferenceConstant((String)docName, (int)4))) {
            item.setText(2, Messages.GeneralPreferences_Custom);
        } else {
            item.setText(2, settingsStore.getString(PreferenceConstants.getDocPreferenceConstant((String)docName, (int)3)));
        }
        if (settingsStore.getBoolean(PreferenceConstants.getDocPreferenceConstant((String)docName, (int)2))) {
            item.setText(3, Messages.GeneralPreferences_Custom);
        } else {
            item.setText(3, Messages.GeneralPreferences_Default);
        }
        if (settingsStore.getString(PreferenceConstants.getDocPreferenceConstant((String)docName, (int)7)).equals("90")) {
            item.setText(4, Messages.GeneralPreferences_OrientationPortrait);
        } else {
            item.setText(4, Messages.GeneralPreferences_OrientationLandscape);
        }
        if (docName.equals("BarCodeLabel")) {
            if (settingsStore.getString(PreferenceConstants.getDocPreferenceConstant((String)docName, (int)14)).equals("14")) {
                item.setText(6, Messages.TemplatePreferences_TextOrientation_BarcodePat);
            } else {
                item.setText(6, Messages.TemplatePreferences_TextOrientation_BarcodeElexis);
            }
        }
    }

    private void createTableContent() {
        PreferenceConstants.getDocumentNames().forEach(new TableConsumer());
    }

    private static class TableConsumer
    implements Consumer<String> {
        private TableConsumer() {
        }

        @Override
        public void accept(final String s) {
            final TableItem item = new TableItem(table, 0);
            ConfigServicePreferenceStore settingsStore = CoreHub.localCfg.get(PreferenceConstants.getDocPreferenceConstant((String)s, (int)12), true) ? new ConfigServicePreferenceStore(ConfigServicePreferenceStore.Scope.GLOBAL) : new ConfigServicePreferenceStore(ConfigServicePreferenceStore.Scope.LOCAL);
            item.setText(0, Messages.getDocumentName((int)(table.getItemCount() - 1)));
            item.setText(1, settingsStore.getString(PreferenceConstants.getDocPreferenceConstant((String)s, (int)0)));
            if (settingsStore.getBoolean(PreferenceConstants.getDocPreferenceConstant((String)s, (int)4))) {
                item.setText(2, Messages.GeneralPreferences_Custom);
            } else {
                item.setText(2, settingsStore.getString(PreferenceConstants.getDocPreferenceConstant((String)s, (int)3)));
            }
            if (settingsStore.getBoolean(PreferenceConstants.getDocPreferenceConstant((String)s, (int)2))) {
                item.setText(3, Messages.GeneralPreferences_Custom);
            } else {
                item.setText(3, Messages.GeneralPreferences_Default);
            }
            if (settingsStore.getString(PreferenceConstants.getDocPreferenceConstant((String)s, (int)7)).equals("90")) {
                item.setText(4, Messages.GeneralPreferences_OrientationPortrait);
            } else {
                item.setText(4, Messages.GeneralPreferences_OrientationLandscape);
            }
            if (s.equals("BarCodeLabel")) {
                if (settingsStore.getString(PreferenceConstants.getDocPreferenceConstant((String)s, (int)14)).equals("14")) {
                    item.setText(6, Messages.TemplatePreferences_TextOrientation_BarcodePat);
                } else {
                    item.setText(6, Messages.TemplatePreferences_TextOrientation_BarcodeElexis);
                }
            }
            TableEditor editor = new TableEditor(table);
            final Button button = new Button((Composite)table, 32);
            button.setSelection(CoreHub.localCfg.get(PreferenceConstants.getDocPreferenceConstant((String)s, (int)12), true));
            button.pack();
            editor.minimumWidth = button.getSize().x;
            editor.horizontalAlignment = 0x1000000;
            editor.setEditor((Control)button, item, 5);
            button.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    CoreHub.localCfg.set(PreferenceConstants.getDocPreferenceConstant((String)s, (int)12), button.getSelection());
                    GeneralPreferences.updateTableRow(table.indexOf(item), s);
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                }
            });
        }
    }
}

