/*
 * Decompiled with CFR 0.152.
 */
package ch.gpb.elexis.cst.preferences;

import ch.elexis.core.data.service.ContextServiceHolder;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.preferences.ConfigServicePreferenceStore;
import ch.gpb.elexis.cst.Messages;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class CstPreference
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static String CST_IDENTIFIER_OMNIVORE = "ch.gpb.elexis.ident.omnivore";
    public static String CST_IDENTIFIER_BRIEFE = "ch.gpb.elexis.ident.briefe";
    public static String CST_IDENTIFIER_LATESTPATH = "ch.gpb.elexis.ident.latestpath";
    public static String CST_IDENTIFIER_FILEPREFIX = "ch.gpb.elexis.ident.fileprefix";
    public static String CST_IDENTIFIER_FILEFORMAT = "ch.gpb.elexis.ident.fileformat";

    public CstPreference() {
        super(Messages.Cst_Preference_Einstellungen, 1);
        this.setPreferenceStore((IPreferenceStore)new ConfigServicePreferenceStore(ConfigServicePreferenceStore.Scope.USER));
        CstPreference.initIdentifiers();
    }

    public static void initIdentifiers() {
        if (ConfigServiceHolder.getUser((String)CST_IDENTIFIER_OMNIVORE, (String)"notset").equals("notset")) {
            ConfigServiceHolder.setUser((String)CST_IDENTIFIER_OMNIVORE, (String)CstPreference.getDefaultIdentifierOmnivore());
        }
        if (ConfigServiceHolder.getUser((String)CST_IDENTIFIER_BRIEFE, (String)"notset").equals("notset")) {
            ConfigServiceHolder.setUser((String)CST_IDENTIFIER_BRIEFE, (String)CstPreference.getDefaultIdentifierBriefe());
        }
        if (ConfigServiceHolder.getUser((String)CST_IDENTIFIER_FILEPREFIX, (String)"notset").equals("notset")) {
            ConfigServiceHolder.setUser((String)CST_IDENTIFIER_FILEPREFIX, (String)CstPreference.getDefaultFilePrefix());
        }
        if (ConfigServiceHolder.getUser((String)CST_IDENTIFIER_FILEFORMAT, (String)"notset").equals("notset")) {
            ConfigServiceHolder.setUser((String)CST_IDENTIFIER_FILEFORMAT, (String)CstPreference.getDefaultFileFormat());
        }
    }

    protected void createFieldEditors() {
        Label lblDoc = new Label(this.getFieldEditorParent(), 0);
        lblDoc.setText("Anzeigekriterien f\ufffdr CST-bezogene Dokumente:");
        GridData gdDoc = new GridData();
        gdDoc.horizontalSpan = 2;
        lblDoc.setLayoutData((Object)gdDoc);
        this.addField((FieldEditor)new StringFieldEditor(CST_IDENTIFIER_OMNIVORE, "Omnivore Document Kategorie", this.getFieldEditorParent()));
        this.addField((FieldEditor)new StringFieldEditor(CST_IDENTIFIER_BRIEFE, "Briefe (Suchkriterium Betreff)", this.getFieldEditorParent()));
        Label lblFile = new Label(this.getFieldEditorParent(), 0);
        lblFile.setText("File Export Einstellungen:");
        GridData gdFile = new GridData();
        gdFile.horizontalSpan = 2;
        gdFile.verticalIndent = 30;
        lblFile.setLayoutData((Object)gdFile);
        this.addField((FieldEditor)new StringFieldEditor(CST_IDENTIFIER_FILEPREFIX, "Prefix f\ufffdr File-Namen", this.getFieldEditorParent()));
        this.addField((FieldEditor)new StringFieldEditor(CST_IDENTIFIER_FILEFORMAT, "Datumsformat f\ufffdr File-Namen (kein : verwenden!)", this.getFieldEditorParent()));
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        boolean ret = super.performOk();
        ContextServiceHolder.get().getActiveUser().ifPresent(u -> ContextServiceHolder.get().setActiveUser(u));
        return ret;
    }

    public static String getDefaultIdentifierOmnivore() {
        return "CST";
    }

    public static String getDefaultIdentifierBriefe() {
        return "CST";
    }

    public static String getDefaultFilePrefix() {
        return "cst";
    }

    public static String getDefaultFileFormat() {
        return "yyyyMMdd_HH-mm-ss";
    }
}

