/*
 * Decompiled with CFR 0.152.
 */
package ch.gpb.elexis.cst.view.profileeditor;

import ch.elexis.core.ui.UiDesk;
import ch.gpb.elexis.cst.Messages;
import ch.gpb.elexis.cst.dialog.ProfileOverview;
import ch.gpb.elexis.cst.service.CstService;
import ch.gpb.elexis.cst.view.profileeditor.CstComposite;
import ch.gpb.elexis.cst.view.profileeditor.DateRangeComposite;
import java.util.Calendar;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Text;

public class AnzeigeOptionsComposite
extends CstComposite {
    Label lblCrawlback;
    Label lblCrawlbackDate;
    int crawlback = 0;
    Text txtCrawlback;
    Slider sldCrawlback;
    Button btnEffektiv;
    Button btnMinimax;
    Button btnA4Hoch;
    Button btnA4Quer;
    private DateRangeComposite dateRangeComposite;
    private Group grpAusrichtung;
    private Label lblShowProfiles;

    public AnzeigeOptionsComposite(Composite parent) {
        super(parent, 0);
        GridLayout gridLayout = new GridLayout(5, false);
        this.setLayout((Layout)gridLayout);
        this.createLayout(this);
        this.lblShowProfiles = new Label((Composite)this, 0);
        this.lblShowProfiles.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.lblShowProfiles.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ProfileOverview dialog = new ProfileOverview(UiDesk.getTopShell());
                dialog.create();
                if (dialog.open() != 0) {
                    return;
                }
            }
        });
        this.lblShowProfiles.setText(Messages.AnzeigeOptionsComposite_lblWoSindMeine_text);
        this.lblShowProfiles.setForeground(this.COLOR_RED);
        new Label((Composite)this, 0);
        new Label((Composite)this, 0);
        new Label((Composite)this, 0);
        new Label((Composite)this, 0);
    }

    private void createLayout(Composite anzeigeCanvas) {
        GridData gd5 = new GridData();
        gd5.verticalAlignment = 128;
        gd5.grabExcessVerticalSpace = true;
        anzeigeCanvas.setLayoutData((Object)gd5);
        Group group1 = new Group(anzeigeCanvas, 0);
        group1.setText(Messages.CstProfileEditor_Darstellungsoptionen);
        group1.setLayout((Layout)new RowLayout(512));
        this.btnEffektiv = new Button((Composite)group1, 16);
        this.btnEffektiv.setText(Messages.CstProfileEditor_Effektiv);
        this.btnEffektiv.setData((Object)"Effektiv");
        this.btnMinimax = new Button((Composite)group1, 16);
        this.btnMinimax.setText(Messages.CstProfileEditor_MinimalMaximal);
        this.btnMinimax.setData((Object)"Minimal/Maximal");
        GridData gdGroup1 = new GridData();
        gdGroup1.widthHint = 120;
        gdGroup1.verticalIndent = 20;
        gdGroup1.horizontalSpan = 2;
        group1.setLayoutData((Object)gdGroup1);
        this.grpAusrichtung = new Group(anzeigeCanvas, 0);
        GridData gd_grpAusrichtung = new GridData(16384, 0x1000000, false, false, 3, 1);
        gd_grpAusrichtung.widthHint = 120;
        gd_grpAusrichtung.verticalIndent = 20;
        this.grpAusrichtung.setLayoutData((Object)gd_grpAusrichtung);
        RowLayout rl_grpAusrichtung = new RowLayout(512);
        this.grpAusrichtung.setLayout((Layout)rl_grpAusrichtung);
        this.grpAusrichtung.setText(Messages.Cst_Text_ausrichtung);
        this.btnA4Hoch = new Button((Composite)this.grpAusrichtung, 16);
        this.btnA4Hoch.setText(Messages.Cst_Text_a4hoch);
        this.btnA4Quer = new Button((Composite)this.grpAusrichtung, 16);
        this.btnA4Quer.setText(Messages.Cst_Text_a4quer);
        this.lblCrawlback = new Label(anzeigeCanvas, 0);
        this.lblCrawlback.setSize(300, 20);
        this.lblCrawlback.setText(Messages.CstProfileEditor_Crawlback);
        GridData gdLblCrawlback = new GridData(1);
        gdLblCrawlback.verticalIndent = 20;
        gdLblCrawlback.horizontalIndent = 10;
        this.lblCrawlback.setLayoutData((Object)gdLblCrawlback);
        this.sldCrawlback = new Slider(anzeigeCanvas, 256);
        this.sldCrawlback.setBounds(115, 50, 25, 15);
        this.sldCrawlback.setMinimum(0);
        this.sldCrawlback.setMaximum(5840);
        this.sldCrawlback.setIncrement(5);
        this.sldCrawlback.setPageIncrement(10);
        this.sldCrawlback.setToolTipText(Messages.CstProfileEditor_CrawlbackTooltip);
        GridData gdSliderCrawl = new GridData();
        gdSliderCrawl.verticalIndent = 20;
        gdSliderCrawl.horizontalAlignment = 0x1000000;
        gdSliderCrawl.horizontalIndent = 50;
        this.sldCrawlback.setLayoutData((Object)gdSliderCrawl);
        this.txtCrawlback = new Text(anzeigeCanvas, 2048);
        this.txtCrawlback.setEditable(false);
        this.txtCrawlback.setBounds(115, 25, 40, 25);
        this.txtCrawlback.setText("0");
        GridData gdTextCrawl = new GridData();
        gdTextCrawl.verticalIndent = 20;
        gdTextCrawl.minimumWidth = 60;
        gdTextCrawl.widthHint = 60;
        gdTextCrawl.horizontalAlignment = 131072;
        gdTextCrawl.horizontalIndent = 20;
        this.txtCrawlback.setLayoutData((Object)gdTextCrawl);
        this.lblCrawlbackDate = new Label(anzeigeCanvas, 0);
        this.lblCrawlbackDate.setBounds(115, 25, 40, 25);
        GridData gdLblCrawlDate = new GridData();
        gdLblCrawlDate.verticalIndent = 20;
        gdLblCrawlDate.minimumWidth = 60;
        gdLblCrawlDate.widthHint = 60;
        gdLblCrawlDate.horizontalAlignment = 131072;
        gdLblCrawlDate.horizontalIndent = 20;
        this.lblCrawlbackDate.setLayoutData((Object)gdLblCrawlDate);
        this.lblCrawlbackDate.setText("Datum");
        this.sldCrawlback.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AnzeigeOptionsComposite.this.txtCrawlback.setText(new Integer(AnzeigeOptionsComposite.this.sldCrawlback.getSelection()).toString());
                AnzeigeOptionsComposite.this.lblCrawlbackDate.setText(CstService.getDateFromSubraction(AnzeigeOptionsComposite.this.sldCrawlback.getSelection()));
                AnzeigeOptionsComposite.this.crawlback = AnzeigeOptionsComposite.this.sldCrawlback.getSelection();
            }
        });
        new Label((Composite)this, 0);
        Label lblPlausiCheck = new Label(anzeigeCanvas, 0);
        lblPlausiCheck.setSize(300, 20);
        lblPlausiCheck.setText(Messages.Cst_Text_plausibilty_check);
        GridData gdLblPlausiCheck = new GridData(1);
        gdLblPlausiCheck.horizontalIndent = 10;
        lblPlausiCheck.setLayoutData((Object)gdLblPlausiCheck);
        new Label((Composite)this, 0);
        Button btnPlausiCheck = new Button(anzeigeCanvas, 32);
        GridData gdBtnPlausiCheck = new GridData(0x1000008);
        gdBtnPlausiCheck.horizontalIndent = 20;
        btnPlausiCheck.setLayoutData((Object)gdBtnPlausiCheck);
        gdBtnPlausiCheck.horizontalSpan = 2;
        btnPlausiCheck.setVisible(false);
        lblPlausiCheck.setVisible(false);
        new Label((Composite)this, 0);
        this.dateRangeComposite = new DateRangeComposite(anzeigeCanvas, 0);
        GridData gdDateRange = new GridData();
        gdDateRange.horizontalSpan = 5;
        this.dateRangeComposite.setLayoutData(gdDateRange);
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.widget;
                System.out.print(button.getText());
                if (button.getData().equals("Effektiv")) {
                    AnzeigeOptionsComposite.this.lblCrawlback.setForeground(AnzeigeOptionsComposite.this.GREEN);
                    AnzeigeOptionsComposite.this.dateRangeComposite.setLabelColor(AnzeigeOptionsComposite.this.BLACK);
                } else {
                    AnzeigeOptionsComposite.this.lblCrawlback.setForeground(AnzeigeOptionsComposite.this.BLACK);
                    AnzeigeOptionsComposite.this.dateRangeComposite.setLabelColor(AnzeigeOptionsComposite.this.GREEN);
                }
            }
        };
        this.btnEffektiv.addSelectionListener((SelectionListener)selectionListener);
        this.btnMinimax.addSelectionListener((SelectionListener)selectionListener);
        this.initDates();
    }

    public void initDates() {
        Calendar c = Calendar.getInstance();
        this.dateRangeComposite.setDateStartPeriod1(CstService.getDateByAddingDays(c.getTime(), -365));
        this.dateRangeComposite.setDateEndPeriod1(c.getTime());
        this.dateRangeComposite.setDateEndPeriod2(CstService.getDateByAddingDays(c.getTime(), -365));
        this.dateRangeComposite.setDateStartPeriod2(CstService.getDateByAddingDays(c.getTime(), -730));
        this.dateRangeComposite.setDateEndPeriod3(CstService.getDateByAddingDays(c.getTime(), -730));
        this.dateRangeComposite.setDateStartPeriod3(CstService.getDateByAddingDays(c.getTime(), -1095));
    }

    public int getCrawlback() {
        return this.crawlback;
    }

    public void setCrawlback(int crawlback) {
        this.crawlback = crawlback;
        this.sldCrawlback.setSelection(crawlback);
        this.txtCrawlback.setText(String.valueOf(crawlback));
        this.lblCrawlbackDate.setText(CstService.getDateFromSubraction(crawlback));
    }

    public DateRangeComposite getDateRangeComposite() {
        return this.dateRangeComposite;
    }

    public void setDateRangeComposite(DateRangeComposite dateRangeComposite) {
        this.dateRangeComposite = dateRangeComposite;
    }

    public String getPeriod1StartDate() {
        return CstService.getCompactFromDate(this.dateRangeComposite.cdtPeriod1Start.getSelection());
    }

    public void setPeriod1StartDate(String sCompactDate) {
        this.dateRangeComposite.cdtPeriod1Start.setSelection(CstService.getDateFromCompact(sCompactDate));
    }

    public String getPeriod1EndDate() {
        return CstService.getCompactFromDate(this.dateRangeComposite.cdtPeriod1End.getSelection());
    }

    public void setPeriod1EndDate(String sCompactDate) {
        this.dateRangeComposite.cdtPeriod1End.setSelection(CstService.getDateFromCompact(sCompactDate));
    }

    public String getPeriod2StartDate() {
        return CstService.getCompactFromDate(this.dateRangeComposite.cdtPeriod2Start.getSelection());
    }

    public void setPeriod2StartDate(String sCompactDate) {
        this.dateRangeComposite.cdtPeriod2Start.setSelection(CstService.getDateFromCompact(sCompactDate));
    }

    public String getPeriod2EndDate() {
        return CstService.getCompactFromDate(this.dateRangeComposite.cdtPeriod2End.getSelection());
    }

    public void setPeriod2EndDate(String sCompactDate) {
        this.dateRangeComposite.cdtPeriod2End.setSelection(CstService.getDateFromCompact(sCompactDate));
    }

    public String getPeriod3StartDate() {
        return CstService.getCompactFromDate(this.dateRangeComposite.cdtPeriod3Start.getSelection());
    }

    public void setPeriod3StartDate(String sCompactDate) {
        this.dateRangeComposite.cdtPeriod3Start.setSelection(CstService.getDateFromCompact(sCompactDate));
    }

    public String getPeriod3EndDate() {
        return CstService.getCompactFromDate(this.dateRangeComposite.cdtPeriod3End.getSelection());
    }

    public void setPeriod3EndDate(String sCompactDate) {
        this.dateRangeComposite.cdtPeriod3End.setSelection(CstService.getDateFromCompact(sCompactDate));
    }

    public void setAnzeigeTyp(String sAnzeigeTyp) {
        if (sAnzeigeTyp.startsWith("Effektiv")) {
            this.btnEffektiv.setSelection(true);
            this.btnMinimax.setSelection(false);
        } else {
            this.btnEffektiv.setSelection(false);
            this.btnMinimax.setSelection(true);
        }
    }

    public String getAnzeigeTyp() {
        if (this.btnEffektiv.getSelection()) {
            return "Effektiv";
        }
        return "Minimal/Maximal";
    }

    public void setAusgabeRichtung(boolean ausgabeRichtung) {
        if (ausgabeRichtung) {
            this.btnA4Hoch.setSelection(false);
            this.btnA4Quer.setSelection(true);
        } else {
            this.btnA4Hoch.setSelection(true);
            this.btnA4Quer.setSelection(false);
        }
    }

    public boolean getAusgabeRichtung() {
        return this.btnA4Quer.getSelection();
    }
}

