/*
 * Decompiled with CFR 0.152.
 */
package ch.gpb.elexis.cst.data;

import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.gpb.elexis.cst.data.CstProfile;
import ch.gpb.elexis.cst.service.CstService;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.VersionInfo;
import java.util.Date;
import java.util.List;

public class CstStateItem
extends PersistentObject {
    private static final String TABLENAME = "cststateitems";
    public static final String VERSIONID = "VERSION";
    public static final String VERSION = "3.0.0";
    public static final String ITEMRANKING = "itemsRanking";
    private JdbcLink j = CstStateItem.getConnection();
    static final String create = "CREATE TABLE `cstgroups` (\t`ID` VARCHAR(25) NOT NULL,\t`lastupdate` BIGINT(20) NULL DEFAULT NULL,\t`deleted` CHAR(1) NULL DEFAULT '0',\t`Date` CHAR(8) NULL DEFAULT '0',\t`DateCreated` CHAR(8) NULL DEFAULT '0',\t`ParentID` VARCHAR(25) NULL DEFAULT NULL,\t`ProfileID` VARCHAR(25) NULL DEFAULT NULL,\t`ItemType` CHAR(2) NULL DEFAULT NULL,\t`Name` VARCHAR(256) NULL DEFAULT NULL,\t`Description` VARCHAR(256) NULL DEFAULT NULL,\t`Parameter` BLOB NULL, \tPRIMARY KEY (`ID`)) COlLATE='utf8_general_ci'  ENGINE=InnoDB; INSERT INTO cststateitems (ID, name) VALUES (" + JdbcLink.wrap((String)"VERSION") + "," + JdbcLink.wrap((String)"3.0.0") + ");";

    static {
        CstStateItem.addMapping((String)TABLENAME, (String[])new String[]{"name=Name", "date=Date", "dateCreated=DateCreated", "description=Description", "mandantId=MandantID", "parentId=ParentID", "profileId=ProfileID", "itemType=ItemType", "parameter=Parameter"});
        if (!CstStateItem.tableExists((String)TABLENAME)) {
            CstStateItem.createOrModifyTable((String)create);
        } else {
            CstStateItem version = CstStateItem.load(VERSIONID);
            VersionInfo vi = new VersionInfo(version.get("name"));
            if (vi.isOlder(VERSION)) {
                if (version.getName() == null) {
                    version.create(VERSIONID);
                }
                version.set("name", VERSION);
            }
        }
    }

    public CstStateItem() {
    }

    public CstStateItem(String id) {
        super(id);
    }

    public static CstStateItem load(String id) {
        return new CstStateItem(id);
    }

    public CstStateItem(String date, String name, StateType type, String profileID, String parentID, String mandantID) {
        this.create(null);
        this.set("date", date);
        this.set("name", name);
        this.setInt("itemType", type.ordinal());
        this.set("mandantId", mandantID);
        this.set("parentId", parentID);
        this.set("profileId", profileID);
        this.set("dateCreated", CstService.getCompactFromDate(new Date()));
    }

    public CstStateItem(String date, String name, StateType type, String mandantID) {
        this.create(null);
        this.set("date", date);
        this.set("name", name);
        this.setInt("itemType", type.ordinal());
        this.set("mandantId", mandantID);
        this.set("dateCreated", CstService.getCompactFromDate(new Date()));
    }

    public static CstStateItem getByTypeAndProfileAndMandant(String name, String profileId, String mandantId) {
        Query qbe = new Query(CstStateItem.class);
        qbe.add("ID", "<>", VERSIONID);
        qbe.add("name", "=", name);
        qbe.add("profileId", "=", profileId);
        qbe.add("mandantId", "=", mandantId);
        List res = qbe.execute();
        if (res.isEmpty()) {
            return null;
        }
        if (res.size() > 1) {
            throw new IllegalArgumentException(String.format("There is already a category of name [%s] - [%s]", name));
        }
        return (CstStateItem)((Object)res.get(0));
    }

    public static CstStateItem getByTypeAndMandant(String name, String mandantId) {
        Query qbe = new Query(CstStateItem.class);
        qbe.add("ID", "<>", VERSIONID);
        qbe.add("name", "=", name);
        qbe.add("mandantId", "=", mandantId);
        List res = qbe.execute();
        if (res.isEmpty()) {
            return null;
        }
        if (res.size() > 1) {
            throw new IllegalArgumentException(String.format("There is already a category of name [%s] - [%s]", name));
        }
        return (CstStateItem)((Object)res.get(0));
    }

    public static CstStateItem getParent(CstStateItem child) {
        Query qbe = new Query(CstStateItem.class);
        qbe.add("ID", "<>", VERSIONID);
        qbe.add("parentId", "=", child.getId());
        List list = qbe.execute();
        if (list.isEmpty()) {
            return null;
        }
        return (CstStateItem)((Object)list.get(0));
    }

    public static List<CstStateItem> getChildren(CstStateItem parent) {
        Query qbe = new Query(CstStateItem.class);
        qbe.add("ID", "<>", VERSIONID);
        qbe.add("parentId", "=", parent.getId());
        return qbe.execute();
    }

    public static List<CstStateItem> getRootItems(CstProfile profile) {
        Query qbe = new Query(CstStateItem.class);
        qbe.add("ID", "<>", VERSIONID);
        qbe.add("profileId", "=", profile.getId());
        qbe.add("parentId", "=", null);
        qbe.orderBy(false, new String[]{"dateCreated"});
        return qbe.execute();
    }

    public static List<CstStateItem> getStateItems(CstProfile profile) {
        Query qbe = new Query(CstStateItem.class);
        qbe.add("ID", "<>", VERSIONID);
        qbe.add("profileId", "=", profile.getId());
        return qbe.execute();
    }

    public static List<CstStateItem> getStateItems(CstProfile profile, String mandantId) {
        Query qbe = new Query(CstStateItem.class);
        qbe.add("ID", "<>", VERSIONID);
        qbe.add("mandantId", "=", mandantId);
        qbe.add("profileId", "=", profile.getId());
        return qbe.execute();
    }

    public static List<CstStateItem> getStateItems() {
        Query qbe = new Query(CstStateItem.class);
        qbe.add("ID", "<>", VERSIONID);
        return qbe.execute();
    }

    public boolean delete() {
        int ret = CstStateItem.getConnection().exec("DELETE FROM  cststateitems WHERE ID =" + this.getWrappedId());
        return ret != 0;
    }

    public void setDate(String date) {
        this.set("date", date);
    }

    public String getDate() {
        return this.get("date");
    }

    public String getDateCreated() {
        return this.get("dateCreated");
    }

    public void setName(String name) {
        this.set("name", name);
    }

    public String getName() {
        return this.get("name");
    }

    public void setItemType(StateType name) {
        this.setInt("itemType", name.ordinal());
    }

    public StateType getItemType() {
        return StateType.values()[this.getInt("itemType")];
    }

    public void setDescription(String description) {
        this.set("description", description);
    }

    public String getDescription() {
        return this.get("description");
    }

    public void setParentId(String parentId) {
        this.set("parentId", parentId);
    }

    public String getParentId() {
        return this.get("parentId");
    }

    public void setProfileId(String profileId) {
        this.set("profileId", profileId);
    }

    public String getProfileId() {
        return this.get("profileId");
    }

    public void setMandantId(String mandantId) {
        this.set("mandantId", mandantId);
    }

    public String getMandantId() {
        return this.get("mandantId");
    }

    public String getLabel() {
        return null;
    }

    protected String getTableName() {
        return TABLENAME;
    }

    public Object getParent() {
        return new Object();
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CstStateItem)) {
            return false;
        }
        return this.getId().equals(((CstStateItem)((Object)obj)).getId());
    }

    public static enum StateType {
        ACTION,
        DECISION,
        REMINDER,
        TRIGGER;

    }
}

