/*
 * Decompiled with CFR 0.152.
 */
package ch.gpb.elexis.cst.dialog;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.data.Kontakt;
import ch.gpb.elexis.cst.data.CstProfile;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;

public class ProfileOverview
extends StatusDialog {
    private Table table;
    List<CstProfile> profiles;
    private int sortColumn = 0;
    private boolean sortReverse = false;
    TableViewer tableViewer;
    private List<String[]> lProf = new ArrayList<String[]>();

    public ProfileOverview(Shell parent) {
        super(parent);
        this.setShellStyle(2064);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (id == 1) {
            return null;
        }
        return super.createButton(parent, id, label, defaultButton);
    }

    protected Control createDialogArea(Composite parent) {
        Composite base = (Composite)super.createDialogArea(parent);
        Label lblNewLabel = new Label(base, 0);
        lblNewLabel.setText("Welches Profil ist bei welchem Patienten?");
        this.tableViewer = new TableViewer(base, 67584);
        this.table = this.tableViewer.getTable();
        GridData gd_table = new GridData(4, 4, true, true, 1, 1);
        gd_table.widthHint = 400;
        gd_table.minimumWidth = 400;
        this.table.setLayoutData((Object)gd_table);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        List<CstProfile> p = CstProfile.getAllProfiles(CoreHub.actMandant.getId());
        for (CstProfile cstProfile : p) {
            Kontakt k = Kontakt.load((String)cstProfile.getKontaktId());
            String[] sProf = new String[]{cstProfile.getName(), k.getLabel(), cstProfile.getTemplate(), k.getKuerzel()};
            this.lProf.add(sProf);
        }
        this.profiles = CstProfile.getAllProfiles(CoreHub.actMandant.getId());
        String[] colLabels = this.getColumnLabels();
        int[] columnWidth = this.getColumnWidth();
        SortListener sortListener = new SortListener();
        TableColumn[] cols = new TableColumn[colLabels.length];
        int i = 0;
        while (i < colLabels.length) {
            cols[i] = new TableColumn(this.table, 0);
            cols[i].setWidth(columnWidth[i]);
            cols[i].setText(colLabels[i]);
            cols[i].setData((Object)new Integer(i));
            cols[i].addSelectionListener((SelectionListener)sortListener);
            ++i;
        }
        this.tableViewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.tableViewer.setInput((Object)this);
        this.tableViewer.setSorter((ViewerSorter)new Sorter());
        return base;
    }

    private String[] getColumnLabels() {
        String[] columnLabels = new String[]{"Profile", "Patient", "Template", "Patienten-Nr"};
        return columnLabels;
    }

    private int[] getColumnWidth() {
        int[] columnWidth = new int[]{150, 150, 50, 100};
        return columnWidth;
    }

    class SortListener
    extends SelectionAdapter {
        SortListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            TableColumn col = (TableColumn)e.getSource();
            Integer colNo = (Integer)col.getData();
            if (colNo != null) {
                if (colNo == ProfileOverview.this.sortColumn) {
                    ProfileOverview.this.sortReverse = !ProfileOverview.this.sortReverse;
                } else {
                    ProfileOverview.this.sortReverse = false;
                    ProfileOverview.this.sortColumn = colNo;
                }
                ProfileOverview.this.tableViewer.refresh();
            }
        }
    }

    class Sorter
    extends ViewerSorter {
        Sorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof String[] && e2 instanceof String[]) {
                String[] d1 = (String[])e1;
                String[] d2 = (String[])e2;
                String c1 = "";
                String c2 = "";
                switch (ProfileOverview.this.sortColumn) {
                    case 0: {
                        c1 = d1[0];
                        c2 = d2[0];
                        break;
                    }
                    case 1: {
                        c1 = d1[1];
                        c2 = d2[1];
                        break;
                    }
                    case 2: {
                        c1 = d1[2];
                        c2 = d2[2];
                        break;
                    }
                    case 3: {
                        c1 = d1[3];
                        c2 = d2[3];
                    }
                }
                if (ProfileOverview.this.sortReverse) {
                    return c1.compareTo(c2);
                }
                return c2.compareTo(c1);
            }
            return 0;
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return ProfileOverview.this.lProf.toArray();
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableFontProvider,
    IColorProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            String[] tableLine = (String[])obj;
            switch (index) {
                case 0: {
                    return tableLine[0];
                }
                case 1: {
                    return tableLine[1];
                }
                case 2: {
                    if (tableLine[2].equals("1")) {
                        return "ja";
                    }
                    return "nein";
                }
                case 3: {
                    return tableLine[3];
                }
            }
            return "?";
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }

        public Image getImage(Object obj) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }

        public Font getFont(Object element, int columnIndex) {
            Font fontNormal = UiDesk.getFont((String)"Helvetica", (int)8, (int)0);
            return fontNormal;
        }

        public Color getForeground(Object element) {
            return null;
        }

        public Color getBackground(Object element) {
            String[] tableLine = (String[])element;
            if (tableLine[2].equals("1")) {
                return UiDesk.getColorFromRGB((String)"FF1188");
            }
            return null;
        }
    }
}

