/*
 * Decompiled with CFR 0.152.
 */
package ch.gpb.elexis.cst.widget;

import ch.gpb.elexis.cst.data.ValuePairTimeline;
import ch.gpb.elexis.cst.service.CstService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class ValuePairTimelineCanvas
extends Canvas {
    Font fontSmall;
    Font fontBig;
    Color ORANGE;
    Color BRIGHTGREEN;
    Color WHITE;
    Color GREY;
    Color BLACK;
    Color BLUE;
    int iPixX = 700;
    int iPixY = 120;
    int xoffBase = 4;
    int yoffBase = 140;
    int werteBereich = 1200;
    String einheit = new String();
    String befundArt = new String();
    List<ValuePairTimeline> findings = new ArrayList<ValuePairTimeline>();
    double valueRangeOfInput;
    double distBetweenLines;
    double nrOfScaleLines;
    int scaleStepWidth = 0;

    public ValuePairTimelineCanvas(Composite parent, int style, String befundArt, String einheit) {
        super(parent, style);
        this.befundArt = befundArt;
        this.einheit = einheit;
        this.WHITE = new Color(null, 255, 255, 255);
        this.ORANGE = new Color((Device)this.getDisplay(), 255, 104, 0);
        this.BRIGHTGREEN = new Color((Device)this.getDisplay(), 104, 255, 0);
        this.BLACK = new Color((Device)this.getDisplay(), 0, 0, 0);
        this.GREY = new Color((Device)this.getDisplay(), 200, 200, 200);
        this.BLUE = new Color((Device)this.getDisplay(), 30, 30, 255);
        this.fontSmall = this.createFontofSize(7);
        this.fontBig = this.createFontofSize(12);
        this.setBackground(this.WHITE);
        this.setSize(440, 500);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ValuePairTimelineCanvas.this.WHITE.dispose();
                ValuePairTimelineCanvas.this.BLACK.dispose();
                ValuePairTimelineCanvas.this.ORANGE.dispose();
                ValuePairTimelineCanvas.this.BRIGHTGREEN.dispose();
                ValuePairTimelineCanvas.this.BLUE.dispose();
                ValuePairTimelineCanvas.this.GREY.dispose();
                ValuePairTimelineCanvas.this.fontSmall.dispose();
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                ValuePairTimelineCanvas.this.paintControl(e);
            }
        });
    }

    private Font createFontofSize(int sizeOfFont) {
        Font initialFont = this.getDisplay().getSystemFont();
        FontData[] fontData = initialFont.getFontData();
        int i = 0;
        while (i < fontData.length) {
            fontData[i].setHeight(sizeOfFont);
            ++i;
        }
        Font newFont = new Font((Device)this.getDisplay(), fontData);
        return newFont;
    }

    void paintControl(PaintEvent e) {
        GC gc = e.gc;
        gc.setFont(this.fontSmall);
        gc.setBackground(this.ORANGE);
        gc.setForeground(this.GREY);
        gc.drawRectangle(this.xoffBase, this.yoffBase, this.iPixX, 1);
        gc.setFont(this.fontBig);
        gc.drawText(String.valueOf(this.befundArt), 2, 0, true);
        if (this.findings == null || this.findings.size() == 0) {
            gc.drawText("no Findings set", 20, 20);
            return;
        }
        Date dStart = CstService.getDateFromCompact(this.findings.get(0).getDate());
        Date dEnd = CstService.getDateFromCompact(this.findings.get(this.findings.size() - 1).getDate());
        long totalSpan = CstService.getNrOfDaysBetween(dStart, dEnd);
        if (this.findings == null || this.findings.size() == 0) {
            return;
        }
        double yFactor = new Double(this.iPixY) / new Double(this.werteBereich);
        gc.setFont(this.fontSmall);
        gc.setForeground(this.BLUE);
        boolean lineValue = false;
        gc.drawText(String.valueOf(this.einheit), this.iPixX + 25, this.yoffBase - new Double((double)lineValue * yFactor).intValue() - 6, true);
        gc.setForeground(this.GREY);
        int i = 1;
        while ((double)i < this.nrOfScaleLines + 1.0) {
            gc.drawLine(this.xoffBase, this.yoffBase - new Double((double)(i * this.scaleStepWidth) * yFactor).intValue(), this.iPixX, this.yoffBase - new Double((double)(i * this.scaleStepWidth) * yFactor).intValue());
            gc.drawText(String.valueOf(i * this.scaleStepWidth), this.iPixX + 25, this.yoffBase - new Double((double)(i * this.scaleStepWidth) * yFactor).intValue() - 6, true);
            ++i;
        }
        gc.setBackground(this.GREY);
        int xoff = 0;
        double xFactor = new Double(this.iPixX) / new Double(totalSpan);
        gc.setForeground(this.BLACK);
        if (this.findings.size() == 1) {
            String date = CstService.getReadableFromCompact(this.findings.get(0).getDate());
            gc.drawText(date, this.xoffBase + new Double(this.iPixX / 2).intValue(), this.yoffBase, true);
            gc.setForeground(this.BLUE);
            gc.drawLine(xoff, this.yoffBase - new Double(this.findings.get(0).getWert1() * yFactor).intValue(), xoff + this.iPixX, this.yoffBase - new Double(this.findings.get(0).getWert1() * yFactor).intValue());
            gc.drawText(String.valueOf(this.findings.get(0).getWert1()), this.xoffBase + new Double(this.iPixX / 2).intValue(), this.yoffBase - new Double(this.findings.get(0).getWert1() * yFactor).intValue(), true);
            gc.drawText(String.valueOf(this.findings.get(0).getWert2()), this.xoffBase + new Double(this.iPixX / 2).intValue(), this.yoffBase - new Double(this.findings.get(0).getWert2() * yFactor).intValue(), true);
            gc.setForeground(this.ORANGE);
        } else {
            int x = 0;
            while (x < this.findings.size()) {
                ValuePairTimeline finding = this.findings.get(x);
                int yoff = 0;
                if (x % 2 == 0) {
                    yoff = 8;
                }
                String date = CstService.getReadableFromCompact(finding.getDate());
                gc.drawText(date, this.xoffBase + new Double((double)xoff * xFactor).intValue(), this.yoffBase + yoff + 4, true);
                int corrY = 10;
                gc.setForeground(this.BLUE);
                gc.drawText(String.valueOf(finding.getWert1()), this.xoffBase + new Double((double)xoff * xFactor).intValue(), this.yoffBase - new Double(finding.getWert1() * yFactor).intValue() - corrY, true);
                gc.setForeground(this.ORANGE);
                gc.drawText(String.valueOf(finding.getWert2()), this.xoffBase + new Double((double)xoff * xFactor).intValue(), this.yoffBase - new Double(finding.getWert2() * yFactor).intValue() - corrY, true);
                gc.setForeground(this.BLACK);
                if (x < this.findings.size() - 1) {
                    long lSpan = CstService.getNrOfDaysBetween(CstService.getDateFromCompact(this.findings.get(0).getDate()), CstService.getDateFromCompact(this.findings.get(x + 1).getDate()));
                    xoff = new Long(lSpan).intValue();
                }
                ++x;
            }
        }
        gc.dispose();
    }

    private double getHighestValueInFindings() {
        if (this.findings.size() == 0) {
            return 0.0;
        }
        double highest = 0.0;
        int x = 0;
        while (x < this.findings.size()) {
            if (this.findings.get(x).getWert1() > highest) {
                highest = this.findings.get(x).getWert1();
            }
            if (this.findings.get(x).getWert2() > highest) {
                highest = this.findings.get(x).getWert2();
            }
            ++x;
        }
        return highest;
    }

    private double getLowestValueInFindings() {
        if (this.findings.size() == 0) {
            return 0.0;
        }
        double lowest = this.findings.get(0).getWert1();
        int x = 1;
        while (x < this.findings.size()) {
            if (this.findings.get(x).getWert1() < lowest) {
                lowest = this.findings.get(x).getWert1();
            }
            if (this.findings.get(x).getWert2() < lowest) {
                lowest = this.findings.get(x).getWert2();
            }
            ++x;
        }
        return lowest;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return new Point(this.iPixX + 70, 30 + this.yoffBase);
    }

    public List<ValuePairTimeline> getFindings() {
        return this.findings;
    }

    public void setFindings(List<ValuePairTimeline> findings) {
        this.findings = findings;
        Collections.sort(this.findings, new FindingsComparable());
        double lowest = this.getLowestValueInFindings();
        double highest = this.getHighestValueInFindings();
        this.valueRangeOfInput = highest - lowest;
        this.distBetweenLines = 20.0;
        this.nrOfScaleLines = 10.0;
        int num = new Double(this.getHighestValueInFindings()).intValue();
        int rounded = (num + 99) / 100 * 100;
        this.scaleStepWidth = rounded / 10;
        if (highest > 0.0 && highest < 10.0) {
            rounded = (num + 9) / 10 * 10;
            this.scaleStepWidth = 1;
        }
        this.werteBereich = rounded;
    }

    public class FindingsComparable
    implements Comparator<ValuePairTimeline> {
        @Override
        public int compare(ValuePairTimeline o1, ValuePairTimeline o2) {
            return o1.getDate().compareTo(o2.getDate());
        }
    }
}

