/*
 * Decompiled with CFR 0.152.
 */
package ch.gpb.elexis.cst.view;

import ch.elexis.core.ui.UiDesk;
import ch.elexis.data.LabResult;
import ch.elexis.data.Patient;
import ch.gpb.elexis.cst.Messages;
import ch.gpb.elexis.cst.data.CstAbstract;
import ch.gpb.elexis.cst.data.CstGroup;
import ch.gpb.elexis.cst.data.CstProfile;
import ch.gpb.elexis.cst.data.LabItemWrapper;
import ch.gpb.elexis.cst.data.ValueFinding;
import ch.gpb.elexis.cst.service.CstService;
import ch.gpb.elexis.cst.view.CstResultPart;
import ch.gpb.elexis.cst.widget.CstDangerRangeCanvas;
import ch.gpb.elexis.cst.widget.CstVorwertCanvas;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CstResultEffektiv
extends CstResultPart {
    public static final String ID = "ch.gpb.elexis.cst.cstresultminimax";
    private int printHeigth = OUTPUTHEIGTH;

    public void layoutDisplayTest(CstProfile aProfile) {
        int heigth = 20000;
        Image pointer = UiDesk.getImage((String)"hohe-view-50000h.png");
        this.baseComposite.setSize(OUTPUTWIDTH, heigth);
        this.baseComposite.setBounds(new Rectangle(0, 0, OUTPUTWIDTH, heigth));
        this.baseComposite.layout();
        Control[] controlArray = this.baseComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        Label test = new Label(this.baseComposite, 0);
        test.setImage(pointer);
        this.baseComposite.layout();
    }

    @Override
    public void layoutDisplay(CstProfile aProfile) {
        if (aProfile != null) {
            if (aProfile.getAusgabeRichtung()) {
                this.baseComposite.setSize(OUTPUTHEIGTH, OUTPUTHEIGTH);
                this.printHeigth = OUTPUTWIDTH;
            } else {
                this.baseComposite.setSize(OUTPUTWIDTH, OUTPUTHEIGTH);
            }
            this.log.info("Anzeigetyp:" + aProfile.getAnzeigeTyp());
            Control[] controlArray = this.baseComposite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.dispose();
                ++n2;
            }
            HashMap labResults = LabResult.getGrouped((Patient)this.patient);
            List<String> sortedDates = CstService.getDistinctDates(labResults);
            if (sortedDates == null || sortedDates.isEmpty()) {
                return;
            }
            int newHeigth = 0;
            this.baseComposite.setSize(OUTPUTWIDTH, 800);
            this.baseComposite.setBounds(new Rectangle(0, 0, OUTPUTWIDTH, OUTPUTHEIGTH));
            this.baseComposite.layout();
            this.baseComposite.setBackground(this.WHITE);
            Label labelPatientName = new Label(this.baseComposite, 0);
            labelPatientName.setLayoutData((Object)new GridData());
            labelPatientName.setText(this.getHeader(this.patient));
            labelPatientName.setSize(600, 40);
            labelPatientName.setFont(this.fontMedium);
            Label labelProfileData = new Label(this.baseComposite, 0);
            labelProfileData.setLayoutData((Object)new GridData());
            labelProfileData.setText(this.getSubTitle(this.patient, aProfile));
            labelProfileData.setSize(600, 40);
            labelProfileData.setFont(this.fontSmall);
            Map itemRanking = aProfile.getMap("itemsRanking");
            CstResultPart.GroupSorter groupSorter = new CstResultPart.GroupSorter(itemRanking);
            List<CstGroup> cstGroups = aProfile.getCstGroups();
            Collections.sort(cstGroups, groupSorter);
            int count = 0;
            for (CstGroup group : cstGroups) {
                Label l1 = new Label(this.baseComposite, 0);
                GridData gd = new GridData(-1, 22);
                l1.setLayoutData((Object)gd);
                l1.setText(" " + group.getName() + " ");
                l1.setFont(this.fontBig);
                l1.setBackground(this.GRAY);
                l1.setForeground(this.WHITE);
                List<LabItemWrapper> labitems = group.getLabitems();
                Map itemRanking2 = group.getMap("itemsRanking");
                CstResultPart.LabItemSorter labItemSorter = new CstResultPart.LabItemSorter(itemRanking2);
                Collections.sort(labitems, labItemSorter);
                for (LabItemWrapper labItem : labitems) {
                    Label l2 = new Label(this.baseComposite, 0);
                    l2.setLayoutData((Object)new GridData(794, 20));
                    String txL2 = "         " + String.valueOf(++count) + ": " + labItem.getLabItem().getName() + " ";
                    if (labItem.getLabItem().getEinheit().length() > 0) {
                        txL2 = txL2 + " (" + labItem.getLabItem().getEinheit() + ")";
                    }
                    l2.setText(txL2);
                    l2.setFont(this.fontMedium);
                    l2.setBackground(this.LIGHTGRAY);
                    Composite lineCompo = new Composite(this.baseComposite, 4);
                    GridLayout lineLayout = new GridLayout();
                    lineLayout.numColumns = 2;
                    lineCompo.setLayout((Layout)lineLayout);
                    GridData lineData = new GridData(4, 4, true, true, 1, 1);
                    lineData.grabExcessHorizontalSpace = true;
                    lineData.grabExcessVerticalSpace = true;
                    lineCompo.setSize(OUTPUTWIDTH, 100);
                    lineCompo.setBackground(this.WHITE);
                    lineCompo.setLayoutData((Object)lineData);
                    Composite leftCompo = new Composite(lineCompo, 0);
                    GridLayout leftLayout = new GridLayout();
                    leftCompo.setLayout((Layout)leftLayout);
                    GridData leftData = new GridData(4, 4, true, true, 1, 1);
                    leftData.grabExcessHorizontalSpace = false;
                    leftData.grabExcessVerticalSpace = true;
                    leftCompo.setSize(400, 100);
                    leftCompo.setLayoutData((Object)leftData);
                    leftCompo.setBackground(this.WHITE);
                    Composite rightCompo = new Composite(lineCompo, 0);
                    GridLayout rightLayout = new GridLayout();
                    rightLayout.numColumns = 1;
                    rightCompo.setLayout((Layout)rightLayout);
                    rightCompo.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
                    rightCompo.setSize(400, 100);
                    rightCompo.setBackground(this.WHITE);
                    newHeigth += lineCompo.getSize().y;
                    if (!labItem.isDisplayOnce()) {
                        if (!CstService.hasValueForName(labItem.getLabItem().getName(), labItem.getLabItem().getKuerzel(), labResults)) {
                            this.addNoValuesLabel(leftCompo);
                        } else {
                            Object sDateOfLatestLabresult = sortedDates.get(sortedDates.size() - 1);
                            this.log.info("Searching result for date:  " + (String)sDateOfLatestLabresult + "\tLabitem: " + labItem.getLabItem().getName() + "\tPat.ID:" + aProfile.getKontaktId(), (Object)4);
                            LabResult labResultLatest = CstService.getValueForNameAndDate(labItem.getLabItem().getName(), (String)sDateOfLatestLabresult, labItem.getLabItem().getKuerzel(), labResults);
                            ArrayList<String> datesForVorwert = new ArrayList<String>(sortedDates);
                            if (aProfile.getCrawlBack() > 0) {
                                String sNewestDate = sortedDates.get(sortedDates.size() - 1);
                                if (labResultLatest == null) {
                                    int i = sortedDates.size() - 1;
                                    while (i >= 0) {
                                        String sDateAtIndex = sortedDates.get(i);
                                        datesForVorwert.remove(i);
                                        long daysBetween = CstService.getDayCountFromCompact(sDateAtIndex, sNewestDate);
                                        long crawlBack = aProfile.getCrawlBack();
                                        if (daysBetween > crawlBack) break;
                                        LabResult labResultIndex = CstService.getValueForNameAndDate(labItem.getLabItem().getName(), sDateAtIndex, labItem.getLabItem().getKuerzel(), labResults);
                                        if (labResultIndex != null) {
                                            labResultLatest = labResultIndex;
                                            sDateOfLatestLabresult = sDateAtIndex;
                                            break;
                                        }
                                        --i;
                                    }
                                } else {
                                    datesForVorwert.remove(datesForVorwert.size() - 1);
                                }
                            } else {
                                datesForVorwert.remove(datesForVorwert.size() - 1);
                            }
                            double[] dRanges = this.extractRefValues(labItem.getLabItem());
                            double dRangeStart = dRanges[0];
                            double dRangeEnd = dRanges[1];
                            String sResult = "";
                            try {
                                if (labResultLatest != null && labResultLatest.getResult() != null) {
                                    sResult = labResultLatest.getResult();
                                    this.log.info("raw result: " + sResult);
                                }
                            }
                            catch (Exception e1) {
                                this.log.info("Error opening result view: " + e1.getMessage() + " " + labItem.getLabItem().getName(), (Object)4);
                            }
                            double dResult = -1.0;
                            dResult = CstService.getNumericFromLabResult(sResult);
                            ArrayList<ValueFinding> findings = new ArrayList<ValueFinding>();
                            Collections.reverse(datesForVorwert);
                            for (String fDate : datesForVorwert) {
                                LabResult resultVorwert;
                                Date startDateProfile;
                                Date dateResult = CstService.getDateFromCompact(fDate);
                                if (dateResult.compareTo(startDateProfile = CstService.getDateFromCompact(this.profile.getValidFrom())) < 0 || (resultVorwert = CstService.getValueForNameAndDate(labItem.getLabItem().getName(), fDate, labItem.getLabItem().getKuerzel(), labResults)) == null) continue;
                                String sResultV = null;
                                try {
                                    sResultV = resultVorwert.getResult();
                                }
                                catch (Exception e) {
                                    this.log.error("Error getting result effektiv: " + e.getMessage(), (Object)2);
                                    continue;
                                }
                                double dResultV = 0.0;
                                dResultV = CstService.getNumericFromLabResult(sResultV);
                                ValueFinding f = new ValueFinding();
                                if (this.patient.getGeschlecht().toLowerCase().equals("m")) {
                                    f.setRefMstart(dRangeStart);
                                    f.setRefMend(dRangeEnd);
                                    f.setRefFstart(0.0);
                                    f.setRefFend(0.0);
                                } else {
                                    f.setRefFstart(dRangeStart);
                                    f.setRefFend(dRangeEnd);
                                    f.setRefMstart(0.0);
                                    f.setRefMend(0.0);
                                }
                                f.setValue(dResultV);
                                f.setDateOfFinding(CstService.getDateFromCompact(fDate));
                                f.setParam(sResultV);
                                findings.add(f);
                            }
                            CstVorwertCanvas vCanvas = new CstVorwertCanvas(leftCompo, this.profile.getAusgabeRichtung(), 0);
                            vCanvas.setFindings(findings);
                            GridLayout vorwertLayout = new GridLayout();
                            vCanvas.setLayout((Layout)vorwertLayout);
                            GridData vorwertData = new GridData();
                            vorwertData.horizontalAlignment = 4;
                            vorwertData.grabExcessHorizontalSpace = true;
                            vCanvas.setLayoutData(vorwertData);
                            if (dResult == -1.0) {
                                Label label = new Label(leftCompo, 0);
                                label.setText("No result for Lab Item " + labItem.getLabItem().getName() + " on " + CstService.getGermanFromCompact((String)sDateOfLatestLabresult));
                                GridData gdLabelNoValue = new GridData(1, 0x1000000, false, false, 2, 1);
                                label.setLayoutData((Object)gdLabelNoValue);
                            } else {
                                CstDangerRangeCanvas drc2 = new CstDangerRangeCanvas(leftCompo, this.profile.getAusgabeRichtung(), 0, dRangeStart, dRangeEnd, dResult, sResult, labItem.getLabItem().getName(), CstService.getGermanFromCompact((String)sDateOfLatestLabresult));
                                GridLayout drcLayout = new GridLayout();
                                GridData drcData = new GridData(1, 0x1000000, false, false, 2, 1);
                                drcData.verticalIndent = 30;
                                drcData.horizontalAlignment = 1;
                                drc2.setLayout((Layout)drcLayout);
                                drc2.setLayoutData(drcData);
                            }
                        }
                    } else {
                        StringBuffer lblText = new StringBuffer(Messages.CstResultEffektiv_hinweis_einmal_im_leben);
                        Label lblDisplayOnce = new Label(leftCompo, 0);
                        GridData gdDisplayOnce = new GridData(4, 4, true, true, 1, 1);
                        gdDisplayOnce.grabExcessHorizontalSpace = true;
                        gdDisplayOnce.horizontalAlignment = 4;
                        gdDisplayOnce.verticalAlignment = 128;
                        gdDisplayOnce.widthHint = aProfile.getAusgabeRichtung() ? 858 : 530;
                        lblDisplayOnce.setLayoutData((Object)gdDisplayOnce);
                        lblDisplayOnce.setBackground(this.WHITE);
                        int countValues = 0;
                        for (String date : sortedDates) {
                            LabResult labResultOnce = CstService.getValueForNameAndDate(labItem.getLabItem().getName(), date, labItem.getLabItem().getKuerzel(), labResults);
                            if (labResultOnce == null) continue;
                            ++countValues;
                        }
                        LabResult labResultOnce = null;
                        Collections.reverse(sortedDates);
                        for (String date : sortedDates) {
                            labResultOnce = CstService.getValueForNameAndDate(labItem.getLabItem().getName(), date, labItem.getLabItem().getKuerzel(), labResults);
                            if (labResultOnce != null) break;
                        }
                        if (labResultOnce == null) {
                            lblText.append(Messages.CstResultEffektiv_resultat_nie_ermittelt);
                        } else {
                            if (countValues > 1) {
                                lblText.append(Messages.CstResultEffktiv_hinweis_immer_anzeigen);
                            }
                            lblText.append("\n\n");
                            lblText.append("Resultat:\t\t");
                            lblText.append(labResultOnce.getResult());
                            lblText.append("\nDatum:\t\t");
                            lblText.append(labResultOnce.getDate());
                            lblText.append("\nReferenz:\t");
                            if (this.patient.getGeschlecht().toLowerCase().equals("m")) {
                                lblText.append(labItem.getLabItem().getRefM());
                            } else {
                                lblText.append(labItem.getLabItem().getRefW());
                            }
                        }
                        lblDisplayOnce.setText(lblText.toString());
                    }
                    Text txtAbstract = new Text(rightCompo, 72);
                    txtAbstract.setFont(this.fontSmall);
                    txtAbstract.setSize(210, 190);
                    GridData gdTxtAbstract = new GridData(1040);
                    gdTxtAbstract.verticalAlignment = 128;
                    gdTxtAbstract.horizontalAlignment = 1;
                    gdTxtAbstract.widthHint = 210;
                    gdTxtAbstract.heightHint = 190;
                    gdTxtAbstract.grabExcessVerticalSpace = true;
                    txtAbstract.setLayoutData((Object)gdTxtAbstract);
                    txtAbstract.setBackground(this.LIGHTGRAY);
                    CstAbstract cabstract = CstAbstract.getByLaboritemId(labItem.getLabItem().getId());
                    if (cabstract != null) {
                        txtAbstract.setText(cabstract.getDescription1());
                    } else {
                        txtAbstract.setText(Messages.Cst_Text_no_abstract_available);
                    }
                    newHeigth += lineCompo.getSize().y + 40;
                    this.checkPageBreak(this.baseComposite);
                }
            }
            this.baseComposite.pack();
            int currentHeigth = this.baseComposite.getSize().y;
            int pageCnt = currentHeigth / this.printHeigth;
            int rmn = (pageCnt + 1) * this.printHeigth - currentHeigth;
            if (rmn < this.printHeigth) {
                this.addLine(this.baseComposite, rmn);
            }
            this.addBefunde(this.baseComposite);
            this.baseComposite.pack();
        }
    }

    @Override
    public void visible(boolean mode) {
    }
}

