/*
 * Decompiled with CFR 0.152.
 */
package ch.gpb.elexis.cst.view;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.events.RefreshingPartListener;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.IRefreshable;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.gpb.elexis.cst.Messages;
import ch.gpb.elexis.cst.data.CstGastroColo;
import ch.gpb.elexis.cst.data.CstGroup;
import ch.gpb.elexis.cst.data.CstProfile;
import ch.gpb.elexis.cst.data.CstProimmun;
import ch.gpb.elexis.cst.dialog.CstCopyProfileDialog;
import ch.gpb.elexis.cst.dialog.CstGroupSelectionDialog;
import ch.gpb.elexis.cst.dialog.CstNewProfileDialog;
import ch.gpb.elexis.cst.dialog.ProfileDetailDialog;
import ch.gpb.elexis.cst.service.CstService;
import ch.gpb.elexis.cst.view.CstResultEffektiv;
import ch.gpb.elexis.cst.view.CstResultMiniMax;
import ch.gpb.elexis.cst.view.CstResultPart;
import ch.gpb.elexis.cst.view.profileeditor.AnzeigeOptionsComposite;
import ch.gpb.elexis.cst.view.profileeditor.BefundSelectionComposite;
import ch.gpb.elexis.cst.view.profileeditor.CstDocumentsComposite;
import ch.gpb.elexis.cst.view.profileeditor.DateRangeComposite;
import ch.gpb.elexis.cst.view.profileeditor.GastroComposite;
import ch.gpb.elexis.cst.view.profileeditor.HilfeComposite;
import ch.gpb.elexis.cst.view.profileeditor.ProImmunComposite;
import ch.gpb.elexis.cst.view.profileeditor.RemindersComposite;
import ch.gpb.elexis.cst.view.profileeditor.TemplateComposite;
import ch.gpb.elexis.cst.view.profileeditor.TherapieVorschlagComposite;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CstProfileEditor
extends ViewPart
implements IRefreshable {
    public static final String ID = "ch.gpb.elexis.cst.views.cstprofileeditor";
    private CheckboxTableViewer tableViewerProfiles;
    private CheckboxTableViewer tableViewerCstGroups;
    private Action actionCreateProfile;
    private Action actionDeleteProfile;
    private Action actionRemoveCstGroup;
    private Action actionAddCstGroup;
    private Action actionCopyProfile;
    private Action doubleClickAction;
    private Table tableProfile;
    private Table tableCstGroup;
    private int sortColumn = 0;
    private boolean sortReverse = false;
    private List<CstProfile> cstProfiles;
    private List<CstGroup> cstGroups = new ArrayList<CstGroup>();
    private List<CstGroup> dialogCstGroups = new ArrayList<CstGroup>();
    static final String AB = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    static Random rnd = new Random();
    Patient patient;
    Label labelLeft;
    Label lblCrawlback;
    Label lblCrawlbackDate;
    DateRangeComposite dateRangeComposite;
    CstDocumentsComposite docComposite;
    ProImmunComposite proImmunComposite;
    GastroComposite gastroComposite;
    TherapieVorschlagComposite therapieComposite;
    AnzeigeOptionsComposite aoComposite;
    TemplateComposite templateComposite;
    RemindersComposite stateComposite;
    private CTabFolder ctabs;
    private ScrolledForm scrolledForm;
    Map<Object, Object> itemRanking = null;
    CstCopyProfileDialog dialog = null;
    private Logger log = LoggerFactory.getLogger((String)CstProfileEditor.class.getName());
    private boolean isRepeatedDialog;
    private RefreshingPartListener udpateOnVisible = new RefreshingPartListener((ViewPart)this);

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
    }

    public void dispose() {
        super.dispose();
        this.getSite().getPage().removePartListener((IPartListener2)this.udpateOnVisible);
    }

    @Optional
    @Inject
    void activePatient(IPatient pat) {
        CoreUiUtil.runAsyncIfActive(() -> {
            if (this.patient == null || !this.patient.getId().equals(((Patient)NoPoUtil.loadAsPersistentObject((Identifiable)pat)).getId())) {
                this.patient = (Patient)NoPoUtil.loadAsPersistentObject((Identifiable)pat);
                if (this.patient != null) {
                    this.log.debug("Cst receives event with patient:" + this.patient.getName());
                    this.labelLeft.setText(Messages.Cst_Text_Profile_fuer + " " + this.patient.getName() + " " + this.patient.getVorname());
                    this.labelLeft.redraw();
                    this.loadProfileData();
                    this.selectFirstRow();
                    this.tableProfile.setFocus();
                }
            }
        }, (Object)this.tableProfile);
    }

    public void createPartControl(Composite parent) {
        this.patient = ElexisEventDispatcher.getSelectedPatient();
        Canvas baseCanvas = new Canvas(parent, 4);
        baseCanvas.setBackground(new Color((Device)Display.getDefault(), 239, 239, 239));
        FillLayout glBase = new FillLayout();
        glBase.type = 512;
        GridData gdBase = new GridData();
        gdBase.horizontalAlignment = 4;
        gdBase.grabExcessHorizontalSpace = true;
        baseCanvas.setLayout((Layout)glBase);
        Canvas profileParameterCanvas = new Canvas((Composite)baseCanvas, 4);
        GridLayout profileGridLayout = new GridLayout(1, true);
        profileParameterCanvas.setBackground(new Color((Device)Display.getDefault(), 239, 239, 239));
        profileParameterCanvas.setLayout((Layout)profileGridLayout);
        GridData gd = new GridData();
        gd.grabExcessVerticalSpace = false;
        gd.grabExcessHorizontalSpace = false;
        profileParameterCanvas.setLayoutData((Object)gd);
        profileParameterCanvas.setSize(400, 400);
        this.scrolledForm = UiDesk.getToolkit().createScrolledForm((Composite)profileParameterCanvas);
        this.scrolledForm.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        Composite body = this.scrolledForm.getBody();
        body.setLayout((Layout)new FillLayout());
        this.ctabs = new CTabFolder(body, 0);
        this.ctabs.setLayout((Layout)new FillLayout());
        Canvas buttonCanvas = new Canvas((Composite)profileParameterCanvas, 0);
        GridLayout glButtonCanvas = new GridLayout();
        GridData gdButtonCanvas = new GridData();
        gdButtonCanvas.horizontalAlignment = 0x1000000;
        gdButtonCanvas.verticalAlignment = 1;
        glButtonCanvas.numColumns = 3;
        buttonCanvas.setSize(-1, 40);
        buttonCanvas.setLayoutData((Object)gdButtonCanvas);
        buttonCanvas.setLayout((Layout)glButtonCanvas);
        Button btnSaveCstProfile = new Button((Composite)buttonCanvas, 2048);
        btnSaveCstProfile.setText(Messages.CstProfileEditor_SaveProfile);
        btnSaveCstProfile.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 13: {
                        CstProfileEditor.this.saveCstProfile();
                    }
                }
            }
        });
        Button btnShowResult = new Button((Composite)buttonCanvas, 2048);
        btnShowResult.setText(Messages.CstProfileEditor_AuswertungAnzeigen);
        btnShowResult.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 13: {
                        CstProfileEditor.this.showResultPage();
                    }
                }
            }
        });
        CTabItem ciTmp = new CTabItem(this.ctabs, 0);
        ciTmp.setText(Messages.CstProfileEditor_Anzeige);
        this.aoComposite = new AnzeigeOptionsComposite((Composite)this.ctabs);
        ciTmp.setControl((Control)this.aoComposite);
        BefundSelectionComposite befundSelectionComposite = new BefundSelectionComposite((Composite)this.ctabs);
        CTabItem ciBsc = new CTabItem(this.ctabs, 0);
        ciBsc.setText(Messages.CstProfileEditor_Auswahlbefunde);
        ciBsc.setControl((Control)befundSelectionComposite);
        CTabItem ci4 = new CTabItem(this.ctabs, 0);
        ci4.setText(Messages.CstProfileEditor_Therapievorschlag);
        this.therapieComposite = new TherapieVorschlagComposite((Composite)this.ctabs);
        ci4.setControl((Control)this.therapieComposite);
        CTabItem ci8 = new CTabItem(this.ctabs, 0);
        ci8.setText(Messages.Cst_Text_cst_documents);
        this.docComposite = new CstDocumentsComposite((Composite)this.ctabs, this.getViewSite());
        ci8.setControl((Control)this.docComposite);
        CTabItem ci9 = new CTabItem(this.ctabs, 0);
        ci9.setText(Messages.CstProfileEditor_Proimmun);
        this.proImmunComposite = new ProImmunComposite((Composite)this.ctabs);
        ci9.setControl((Control)this.proImmunComposite);
        CTabItem ci10 = new CTabItem(this.ctabs, 0);
        ci10.setText(Messages.CstProfileEditor_GastroColo);
        this.gastroComposite = new GastroComposite((Composite)this.ctabs);
        ci10.setControl((Control)this.gastroComposite);
        CTabItem ci12 = new CTabItem(this.ctabs, 0);
        ci12.setText(Messages.TemplateComposite_template_title);
        TemplateComposite templateComposite = new TemplateComposite((Composite)this.ctabs);
        ci12.setControl((Control)templateComposite);
        CTabItem ci11 = new CTabItem(this.ctabs, 0);
        ci11.setText(Messages.HilfeComposite_hilfe_text);
        HilfeComposite hilfeComposite = new HilfeComposite((Composite)this.ctabs);
        ci11.setControl((Control)hilfeComposite);
        SashForm sashform = new SashForm((Composite)baseCanvas, 4);
        GridData gdSash = new GridData();
        gdSash.heightHint = 400;
        gdSash.horizontalAlignment = 4;
        sashform.setLayoutData((Object)gdSash);
        sashform.setLayout((Layout)new GridLayout());
        sashform.setSashWidth(2);
        Composite child1 = new Composite((Composite)sashform, 4);
        GridLayout gridLayoutLeft = new GridLayout();
        gridLayoutLeft.numColumns = 1;
        child1.setLayout((Layout)gridLayoutLeft);
        Composite child2 = new Composite((Composite)sashform, 4);
        GridLayout gridLayoutRight = new GridLayout();
        gridLayoutRight.numColumns = 1;
        child2.setLayout((Layout)gridLayoutRight);
        sashform.setWeights(new int[]{200, 300});
        this.labelLeft = new Label(child1, 0x1000800);
        if (this.patient == null) {
            this.labelLeft.setText(Messages.CstCategory_nopatientselected);
        } else {
            this.labelLeft.setText(Messages.Cst_Text_Profile_fuer + " " + this.patient.getName() + " " + this.patient.getVorname());
        }
        this.labelLeft.setSize(100, 20);
        this.labelLeft.setFont(this.createBoldFont(this.labelLeft.getFont()));
        this.labelLeft.setForeground(UiDesk.getColor((String)"blau"));
        this.labelLeft.setBackground(new Color((Device)Display.getDefault(), 251, 247, 247));
        GridData gridDataLabelLeft = new GridData();
        gridDataLabelLeft.horizontalAlignment = 4;
        gridDataLabelLeft.grabExcessHorizontalSpace = true;
        this.labelLeft.setLayoutData((Object)gridDataLabelLeft);
        this.tableProfile = new Table(child1, 66340);
        GridData gridDataTableLeft = new GridData();
        gridDataTableLeft.horizontalAlignment = 4;
        gridDataTableLeft.verticalAlignment = 4;
        gridDataTableLeft.grabExcessHorizontalSpace = true;
        gridDataTableLeft.grabExcessVerticalSpace = true;
        gridDataTableLeft.minimumHeight = 200;
        gridDataTableLeft.heightHint = 200;
        this.tableProfile.setLayoutData((Object)gridDataTableLeft);
        Label labelRight = new Label(child2, 0x1000800);
        labelRight.setText("Profile Items (CST Groups)");
        labelRight.setSize(100, 20);
        labelRight.setFont(this.createBoldFont(labelRight.getFont()));
        labelRight.setBackground(new Color((Device)Display.getDefault(), 251, 247, 247));
        GridData gridDataLabelRight = new GridData();
        gridDataLabelRight.horizontalAlignment = 4;
        gridDataLabelRight.grabExcessHorizontalSpace = true;
        labelRight.setLayoutData((Object)gridDataLabelRight);
        this.tableCstGroup = new Table(child2, 66340);
        GridData gridDataTableRight = new GridData();
        gridDataTableRight.horizontalAlignment = 4;
        gridDataTableRight.verticalAlignment = 4;
        gridDataTableRight.grabExcessHorizontalSpace = true;
        gridDataTableRight.grabExcessVerticalSpace = true;
        gridDataTableRight.minimumHeight = 200;
        gridDataTableRight.heightHint = 200;
        this.tableCstGroup.setLayoutData((Object)gridDataTableRight);
        Composite movebuttonDummyCompo = new Composite(child1, 0);
        GridData gdDummyMovebutton = new GridData();
        movebuttonDummyCompo.setLayoutData((Object)gdDummyMovebutton);
        gdDummyMovebutton.heightHint = 30;
        Composite movebuttonCompo = new Composite(child2, 0);
        GridLayout movebuttonGridLayout = new GridLayout(2, true);
        movebuttonCompo.setLayout((Layout)movebuttonGridLayout);
        movebuttonCompo.setSize(400, 30);
        GridData gdButtonCompo = new GridData(128);
        gdButtonCompo.minimumHeight = 30;
        gdButtonCompo.heightHint = 30;
        gdButtonCompo.horizontalAlignment = 0x1000000;
        gdButtonCompo.verticalAlignment = 1;
        movebuttonCompo.setLayoutData((Object)gdButtonCompo);
        Image imgArrowUp = UiDesk.getImage((String)"arrow-up");
        Image imgArrowDown = UiDesk.getImage((String)"arrow-down");
        Button btnArrowUp = new Button(movebuttonCompo, 2048);
        Button btnArrowDown = new Button(movebuttonCompo, 2048);
        btnArrowDown.setText(Messages.Button_MoveDown);
        btnArrowUp.setText(Messages.Button_MoveUp);
        btnArrowUp.setImage(imgArrowUp);
        btnArrowDown.setImage(imgArrowDown);
        GridData gdArrowUp = new GridData(128);
        GridData gdArrowDown = new GridData(128);
        btnArrowUp.setLayoutData((Object)gdArrowUp);
        btnArrowDown.setLayoutData((Object)gdArrowDown);
        btnArrowUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CstProfileEditor.this.moveItemUp();
            }
        });
        btnArrowDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CstProfileEditor.this.moveItemDown();
            }
        });
        this.cstProfiles = new ArrayList<CstProfile>();
        String[] colLabels = this.getCategoryColumnLabels();
        int[] columnWidth = this.getProfileColumnWidth();
        ProfileSortListener categorySortListener = new ProfileSortListener();
        TableColumn[] cols = new TableColumn[colLabels.length];
        int i = 0;
        while (i < colLabels.length) {
            cols[i] = new TableColumn(this.tableProfile, 0);
            cols[i].setWidth(columnWidth[i]);
            cols[i].setText(colLabels[i]);
            cols[i].setData((Object)new Integer(i));
            cols[i].addSelectionListener((SelectionListener)categorySortListener);
            ++i;
        }
        this.tableProfile.setHeaderVisible(true);
        this.tableProfile.setLinesVisible(true);
        String[] colLabels2 = this.getCstGroupColumnLabels();
        int[] columnWidth2 = this.getCstGroupColumnWidth();
        TableColumn[] cols2 = new TableColumn[colLabels.length];
        int i2 = 0;
        while (i2 < colLabels2.length) {
            cols2[i2] = new TableColumn(this.tableCstGroup, 0);
            cols2[i2].setWidth(columnWidth2[i2]);
            cols2[i2].setText(colLabels2[i2]);
            cols2[i2].setData((Object)new Integer(i2));
            ++i2;
        }
        this.tableCstGroup.setHeaderVisible(true);
        this.tableCstGroup.setLinesVisible(true);
        this.tableViewerProfiles = new CheckboxTableViewer(this.tableProfile);
        this.tableViewerProfiles.setContentProvider((IContentProvider)new ProfileContentProvider());
        this.tableViewerProfiles.setLabelProvider((IBaseLabelProvider)new ProfileLabelProvider());
        this.tableViewerProfiles.setSorter((ViewerSorter)new ProfileSorter());
        this.tableViewerProfiles.setInput((Object)this.getViewSite());
        if (this.tableProfile.getItems().length > 0) {
            this.tableProfile.select(0);
        }
        this.tableViewerProfiles.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)CstProfileEditor.this.tableViewerProfiles.getSelection();
                CstProfile selProfile = (CstProfile)selection.getFirstElement();
                if (selProfile != null) {
                    CstProfileEditor.this.itemRanking = selProfile.getMap("itemsRanking");
                    CstProfileEditor.this.cstGroups = selProfile.getCstGroups();
                    if (CstProfileEditor.this.itemRanking == null || CstProfileEditor.this.itemRanking.size() == 0) {
                        Hashtable<String, Integer> ranking = new Hashtable<String, Integer>();
                        int i = 1;
                        for (CstGroup item : CstProfileEditor.this.cstGroups) {
                            ranking.put(item.getId(), i++);
                        }
                        CstProfileEditor.this.itemRanking = (Map)ranking.clone();
                        selProfile.setMap("itemsRanking", ranking);
                    }
                    CstProfileEditor.this.loadCstProfile(selProfile);
                    CstProfileEditor.this.tableViewerCstGroups.refresh();
                }
            }
        });
        this.tableViewerCstGroups = new CheckboxTableViewer(this.tableCstGroup);
        this.tableViewerCstGroups.setContentProvider((IContentProvider)new CstGroupContentProvider());
        this.tableViewerCstGroups.setLabelProvider((IBaseLabelProvider)new CstGroupLabelProvider());
        this.tableViewerCstGroups.setSorter((ViewerSorter)new CstGroupSorter());
        this.tableViewerCstGroups.setInput((Object)this.getViewSite());
        this.ctabs.setSelection(this.ctabs.getItem(0));
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.tableViewerProfiles.getControl(), "ch.gpb.elexis.cst.viewer");
        this.makeActions();
        this.hookContextMenuCategory();
        this.hookContextMenuLabItem();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        this.getSite().getPage().addPartListener((IPartListener2)this.udpateOnVisible);
    }

    private void moveItemUp() {
        IStructuredSelection selection2 = (IStructuredSelection)this.tableViewerProfiles.getSelection();
        CstProfile selProfile = (CstProfile)selection2.getFirstElement();
        try {
            IStructuredSelection selection = (IStructuredSelection)this.tableViewerCstGroups.getSelection();
            CstGroup selItem = (CstGroup)((Object)selection.getFirstElement());
            if (selItem == null) {
                return;
            }
            int selIndex = this.tableViewerCstGroups.getTable().getSelectionIndex();
            if (selIndex < 1) {
                return;
            }
            TableItem tableItem = this.tableViewerCstGroups.getTable().getItem(selIndex - 1);
            CstGroup aboveItem = (CstGroup)((Object)tableItem.getData());
            int rank1 = (Integer)this.itemRanking.get(selItem.getId());
            int rank2 = (Integer)this.itemRanking.get(aboveItem.getId());
            this.itemRanking.put(selItem.getId(), rank1 - 1);
            this.itemRanking.put(aboveItem.getId(), rank2 + 1);
            selProfile.setMap("itemsRanking", this.itemRanking);
            this.tableViewerCstGroups.refresh();
        }
        catch (Exception e) {
            this.log.error(e.toString());
            this.showMessage("Fehler: die Reihenfolge der CST Gruppen muss neu initialisiert werden.");
            this.reinitRanking(selProfile);
        }
    }

    private void moveItemDown() {
        IStructuredSelection selection2 = (IStructuredSelection)this.tableViewerProfiles.getSelection();
        CstProfile selProfile = (CstProfile)selection2.getFirstElement();
        try {
            IStructuredSelection selection = (IStructuredSelection)this.tableViewerCstGroups.getSelection();
            CstGroup selItem = (CstGroup)((Object)selection.getFirstElement());
            if (selItem == null) {
                return;
            }
            int selIndex = this.tableViewerCstGroups.getTable().getSelectionIndex();
            if (selIndex + 1 >= this.tableViewerCstGroups.getTable().getItemCount()) {
                return;
            }
            TableItem tableItem = this.tableViewerCstGroups.getTable().getItem(selIndex + 1);
            CstGroup belowItem = (CstGroup)((Object)tableItem.getData());
            int rank1 = (Integer)this.itemRanking.get(selItem.getId());
            int rank2 = (Integer)this.itemRanking.get(belowItem.getId());
            this.itemRanking.put(selItem.getId(), rank1 + 1);
            this.itemRanking.put(belowItem.getId(), rank2 - 1);
            selProfile.setMap("itemsRanking", this.itemRanking);
            this.tableViewerCstGroups.refresh();
        }
        catch (Exception e) {
            this.log.error(e.toString());
            this.showMessage("Fehler: die Reihenfolge der CST Gruppen muss neu initialisiert werden.");
            this.reinitRanking(selProfile);
        }
    }

    private void showResultPage() {
        TableItem[] selItemC = this.tableProfile.getSelection();
        if (selItemC.length == 0) {
            this.showMessage(Messages.Cst_Text_Bitte_Profil_auswaehlen);
            return;
        }
        CstProfile selProfile = (CstProfile)selItemC[0].getData();
        if (selProfile.getCstGroups().size() == 0) {
            MessageBox dialog = new MessageBox(UiDesk.getTopShell(), 292);
            dialog.setText(Messages.Cst_Text_profil_unvollstaendig);
            dialog.setMessage(Messages.Cst_Text_profil_hat_keine_gruppen);
            int returnCode = dialog.open();
            if (returnCode == 256) {
                return;
            }
        }
        try {
            CstResultPart viewer;
            if (selProfile.getAnzeigeTyp().equals("Effektiv")) {
                viewer = (CstResultEffektiv)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("ch.gpb.elexis.cst.cstresulteffektiv");
                if (viewer == null) {
                    viewer = (CstResultEffektiv)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ch.gpb.elexis.cst.cstresulteffektiv");
                }
                viewer.setProfile(selProfile);
                viewer = (CstResultEffektiv)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ch.gpb.elexis.cst.cstresulteffektiv");
            }
            if (selProfile.getAnzeigeTyp().equals("Minimal/Maximal")) {
                viewer = (CstResultMiniMax)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("ch.gpb.elexis.cst.cstresultminimax");
                if (viewer == null) {
                    viewer = (CstResultMiniMax)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ch.gpb.elexis.cst.cstresultminimax");
                }
                viewer.setProfile(selProfile);
                viewer = (CstResultMiniMax)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ch.gpb.elexis.cst.cstresultminimax");
            }
        }
        catch (PartInitException e) {
            this.log.info("Error opening result view: " + e.getMessage(), (Object)4);
        }
    }

    private CTabItem getTabitemByName(CTabFolder cTabFolder, String title) {
        CTabItem[] items;
        CTabItem[] cTabItemArray = items = cTabFolder.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            if (item.getText().equals(title)) {
                return item;
            }
            ++n2;
        }
        return null;
    }

    private void saveCstProfile() {
        int saveSelIdx = this.tableProfile.getSelectionIndex();
        TableItem[] selItemC = this.tableProfile.getSelection();
        CstProfile selProfile = (CstProfile)selItemC[0].getData();
        Map mAuswahl = selProfile.getMap("Auswahlbefunde");
        if (mAuswahl == null) {
            this.showMessage("Map Auswahl lacks in profile. Create?");
            Hashtable map = new Hashtable();
            selProfile.setMap("Auswahlbefunde", map);
        }
        CTabItem ciBefundauswahl = this.getTabitemByName(this.ctabs, Messages.CstProfileEditor_Auswahlbefunde);
        BefundSelectionComposite befundSelectionComposite = (BefundSelectionComposite)ciBefundauswahl.getControl();
        selProfile.setMap("Auswahlbefunde", befundSelectionComposite.getSelection(mAuswahl));
        CTabItem ci = this.getTabitemByName(this.ctabs, Messages.CstProfileEditor_Therapievorschlag);
        TherapieVorschlagComposite ca2 = (TherapieVorschlagComposite)ci.getControl();
        selProfile.setTherapievorschlag(ca2.getTextTherapie());
        selProfile.setDiagnose(ca2.getTextDiagnose());
        ci = this.getTabitemByName(this.ctabs, Messages.TemplateComposite_template_title);
        TemplateComposite templateComposite = (TemplateComposite)ci.getControl();
        selProfile.setTemplate(templateComposite.isTemplate() ? "1" : "0");
        selProfile.setOutputHeader(templateComposite.getOutputHeader());
        ci = this.getTabitemByName(this.ctabs, Messages.CstProfileEditor_Anzeige);
        AnzeigeOptionsComposite aoComposite = (AnzeigeOptionsComposite)ci.getControl();
        selProfile.setPeriod1DateStart(aoComposite.getPeriod1StartDate());
        selProfile.setPeriod1DateEnd(aoComposite.getPeriod1EndDate());
        selProfile.setPeriod2DateStart(aoComposite.getPeriod2StartDate());
        selProfile.setPeriod2DateEnd(aoComposite.getPeriod1StartDate());
        selProfile.setPeriod3DateStart(aoComposite.getPeriod3StartDate());
        selProfile.setPeriod3DateEnd(aoComposite.getPeriod3EndDate());
        selProfile.setCrawlBack(aoComposite.getCrawlback());
        selProfile.setAnzeigeTyp(aoComposite.getAnzeigeTyp());
        selProfile.setAusgabeRichtung(aoComposite.getAusgabeRichtung());
        CstProimmun cstProImmun = CstProimmun.getByProfileId(selProfile.getId());
        if (cstProImmun == null) {
            cstProImmun = new CstProimmun();
        }
        cstProImmun.setDatum(this.proImmunComposite.getDate());
        cstProImmun.setText1(this.proImmunComposite.getReaktionsStaerke1());
        cstProImmun.setText2(this.proImmunComposite.getReaktionsStaerke2());
        cstProImmun.setText3(this.proImmunComposite.getReaktionsStaerke3());
        cstProImmun.setText4(this.proImmunComposite.getReaktionsStaerke4());
        cstProImmun.setTested(this.proImmunComposite.getTested());
        cstProImmun.setToBeTested(this.proImmunComposite.getToBeTested());
        ci = this.getTabitemByName(this.ctabs, Messages.CstProfileEditor_GastroColo);
        GastroComposite gastroComposite = (GastroComposite)ci.getControl();
        CstGastroColo dbObjGastro = CstGastroColo.getByProfileId(selProfile.getId());
        if (dbObjGastro == null) {
            dbObjGastro = new CstGastroColo();
            dbObjGastro.setDatumColo(CstService.getCompactFromDate(new Date()));
            dbObjGastro.setDatumGastro(CstService.getCompactFromDate(new Date()));
        }
        dbObjGastro.setDatumGastro(gastroComposite.getGastroDatum());
        dbObjGastro.setDatumColo(gastroComposite.getColoDatum());
        dbObjGastro.setText1(gastroComposite.getTxtGastroMakro());
        dbObjGastro.setText2(gastroComposite.getTxtGastroHisto());
        dbObjGastro.setText3(gastroComposite.getTxtColoMakro());
        dbObjGastro.setText4(gastroComposite.getTxtColoHisto());
        dbObjGastro.setGastroMakroBefund(gastroComposite.getBefundGastroMakro());
        dbObjGastro.setGastroHistoBefund(gastroComposite.getBefundGastroHisto());
        dbObjGastro.setColoMakroBefund(gastroComposite.getBefundColoMakro());
        dbObjGastro.setColoHistoBefund(gastroComposite.getBefundColoHisto());
        this.loadProfileData();
        this.loadCstProfile(selProfile);
        this.tableProfile.setSelection(saveSelIdx);
    }

    private void loadCstProfile(CstProfile selProfile) {
        Map mapAuswahl = selProfile.getMap("Auswahlbefunde");
        CTabItem[] cTabItemArray = this.ctabs.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            if (item.getText().startsWith(Messages.CstProfileEditor_Auswahlbefunde)) {
                BefundSelectionComposite befundSelectionComposite = (BefundSelectionComposite)item.getControl();
                befundSelectionComposite.setSelection(mapAuswahl);
            }
            if (item.getText().startsWith(Messages.CstProfileEditor_Anzeige)) {
                AnzeigeOptionsComposite aoComposite = (AnzeigeOptionsComposite)item.getControl();
                aoComposite.setCrawlback(selProfile.getCrawlBack());
                aoComposite.setPeriod1StartDate(selProfile.getPeriod1DateStart());
                aoComposite.setPeriod1EndDate(selProfile.getPeriod1DateEnd());
                aoComposite.setPeriod2StartDate(selProfile.getPeriod2DateStart());
                aoComposite.setPeriod2EndDate(selProfile.getPeriod2DateEnd());
                aoComposite.setPeriod3StartDate(selProfile.getPeriod3DateStart());
                aoComposite.setPeriod3EndDate(selProfile.getPeriod3DateEnd());
                aoComposite.setAnzeigeTyp(selProfile.getAnzeigeTyp());
                aoComposite.setAusgabeRichtung(selProfile.getAusgabeRichtung());
            }
            if (item.getText().startsWith(Messages.Cst_Text_cst_documents)) {
                CstDocumentsComposite docComposite = (CstDocumentsComposite)item.getControl();
                docComposite.clear();
            }
            if (item.getText().startsWith("Reminders")) {
                RemindersComposite composite = (RemindersComposite)item.getControl();
                composite.setProfile(selProfile);
            }
            if (item.getText().startsWith(Messages.TemplateComposite_template_title)) {
                TemplateComposite templateComposite = (TemplateComposite)item.getControl();
                templateComposite.setTemplate(selProfile.getTemplate().equals("1"));
                templateComposite.setOutputHeader(selProfile.getOutputHeader());
            }
            if (item.getText().startsWith(Messages.CstProfileEditor_Therapievorschlag)) {
                TherapieVorschlagComposite therapieComposite = (TherapieVorschlagComposite)item.getControl();
                therapieComposite.setTextTherapie(selProfile.getTherapievorschlag());
                therapieComposite.setTextDiagnose(selProfile.getDiagnose());
            }
            if (item.getText().startsWith(Messages.CstProfileEditor_Proimmun)) {
                ProImmunComposite proimmunCompo = (ProImmunComposite)item.getControl();
                CstProimmun cstProImmun = CstProimmun.getByProfileId(selProfile.getId());
                if (cstProImmun == null) {
                    cstProImmun = new CstProimmun(selProfile.getId(), CstService.getCompactFromDate(new Date()));
                }
                proimmunCompo.setDate(cstProImmun.getDatum());
                proimmunCompo.setTested(cstProImmun.getTested());
                proimmunCompo.setToBeTested(cstProImmun.getToBeTested());
                proimmunCompo.setReaktionsStaerke1(cstProImmun.getText1());
                proimmunCompo.setReaktionsStaerke2(cstProImmun.getText2());
                proimmunCompo.setReaktionsStaerke3(cstProImmun.getText3());
                proimmunCompo.setReaktionsStaerke4(cstProImmun.getText4());
            }
            if (item.getText().startsWith(Messages.CstProfileEditor_GastroColo)) {
                GastroComposite gastroCompo = (GastroComposite)item.getControl();
                gastroCompo.clear();
                CstGastroColo dbObj = CstGastroColo.getByProfileId(selProfile.getId());
                if (dbObj == null) {
                    dbObj = new CstGastroColo(selProfile.getId(), CstService.getCompactFromDate(new Date()), CstService.getCompactFromDate(new Date()));
                }
                gastroCompo.setGastroDatum(dbObj.getDatumGastro());
                gastroCompo.setColoDatum(dbObj.getDatumColo());
                gastroCompo.setBefundColoHisto(dbObj.getColoHistoBefund());
                gastroCompo.setBefundColoMakro(dbObj.getColoMakroBefund());
                gastroCompo.setBefundGastroMakro(dbObj.getGastroMakroBefund());
                gastroCompo.setBefundGastroHisto(dbObj.getGastroHistoBefund());
                gastroCompo.setTxtGastroMakro(dbObj.getText1());
                gastroCompo.setTxtGastroHisto(dbObj.getText2());
                gastroCompo.setTxtColoMakro(dbObj.getText3());
                gastroCompo.setTxtColoHisto(dbObj.getText4());
            }
            ++n2;
        }
    }

    private void loadProfileData() {
        Mandant m = CoreHub.actMandant;
        this.log.info("load CST Profiles for mandant: " + m.getId() + " " + m.getName(), (Object)4);
        this.log.info("and patient: " + this.patient.getId() + " " + this.patient.getName(), (Object)4);
        this.cstProfiles = CstProfile.getCstGroups(this.patient, m.getId());
        this.tableViewerProfiles.refresh();
        if (!this.cstProfiles.isEmpty()) {
            this.tableViewerProfiles.setSelection((ISelection)new StructuredSelection(this.tableViewerProfiles.getElementAt(0)), true);
        } else {
            this.therapieComposite.clear();
            this.docComposite.clear();
            this.cstGroups.clear();
            this.gastroComposite.clear();
            this.aoComposite.initDates();
        }
        if (this.tableViewerProfiles != null) {
            this.tableViewerProfiles.refresh();
            this.tableProfile.setFocus();
        }
        if (this.tableViewerCstGroups != null) {
            this.tableViewerCstGroups.refresh();
        }
    }

    private void selectFirstRow() {
        if (this.tableViewerProfiles != null) {
            Object obj = this.tableViewerProfiles.getElementAt(0);
            if (!this.cstProfiles.isEmpty() && obj != null) {
                this.tableViewerProfiles.setSelection((ISelection)new StructuredSelection(this.tableViewerProfiles.getElementAt(0)), true);
            }
        }
    }

    private void selectRow(int row) {
        if (this.tableViewerProfiles != null) {
            Object obj = this.tableViewerProfiles.getElementAt(row);
            if (!this.cstProfiles.isEmpty() && obj != null) {
                this.tableViewerProfiles.setSelection((ISelection)new StructuredSelection(this.tableViewerProfiles.getElementAt(row)), true);
            }
        }
    }

    private Font createBoldFont(Font baseFont) {
        FontData fd = baseFont.getFontData()[0];
        Font font = new Font(baseFont.getDevice(), fd.getName(), 10, fd.getStyle() | 1);
        return font;
    }

    private String[] getCategoryColumnLabels() {
        String[] columnLabels = new String[]{Messages.CstCategory_name, Messages.CstCategory_description, Messages.Cst_Text_anzeigen_ab};
        return columnLabels;
    }

    private String[] getCstGroupColumnLabels() {
        String[] columnLabels = new String[]{Messages.CstLaborPrefs_type, Messages.CstCategory_description, Messages.CstProfile_Ranking};
        return columnLabels;
    }

    private int[] getProfileColumnWidth() {
        int[] columnWidth = new int[]{120, 50, 100};
        return columnWidth;
    }

    private int[] getCstGroupColumnWidth() {
        int[] columnWidth = new int[]{120, 150, 200};
        return columnWidth;
    }

    private void hookContextMenuCategory() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                CstProfileEditor.this.fillContextMenuCategory(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.tableViewerProfiles.getControl());
        this.tableViewerProfiles.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.tableViewerProfiles);
    }

    private void hookContextMenuLabItem() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                CstProfileEditor.this.fillContextMenuLabItem(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.tableViewerCstGroups.getControl());
        this.tableViewerCstGroups.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.tableViewerCstGroups);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionCreateProfile);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionDeleteProfile);
    }

    private void fillContextMenuCategory(IMenuManager manager) {
        manager.add((IAction)this.actionCreateProfile);
        manager.add((IAction)this.actionDeleteProfile);
        manager.add((IAction)this.actionCopyProfile);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillContextMenuLabItem(IMenuManager manager) {
        manager.add((IAction)this.actionRemoveCstGroup);
        manager.add((IAction)this.actionAddCstGroup);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionCreateProfile);
        manager.add((IAction)this.actionDeleteProfile);
        manager.add((IAction)this.actionCopyProfile);
    }

    private void makeActions() {
        this.actionCreateProfile = new Action(){

            public void run() {
                CstNewProfileDialog dialog = new CstNewProfileDialog(CstProfileEditor.this.tableViewerProfiles.getControl().getShell(), CoreHub.actMandant);
                dialog.create();
                if (CstProfileEditor.this.isRepeatedDialog) {
                    dialog.setErrorMessage(Messages.Cst_Text_cstprofile_exists);
                }
                CstProfileEditor.this.isRepeatedDialog = false;
                if (dialog.open() == 0) {
                    if (dialog.getGroupName().length() < 1) {
                        return;
                    }
                } else {
                    return;
                }
                try {
                    Mandant m = CoreHub.actMandant;
                    if (m != null) {
                        if (CstProfileEditor.this.patient != null) {
                            Calendar now = Calendar.getInstance();
                            now.add(1, -2);
                            CstProfile target = new CstProfile(dialog.getGroupName(), dialog.getGroupDescription(), null, CstProfileEditor.this.patient.getId(), m.getId(), CstService.getCompactFromDate(now.getTime()), CstService.getCompactFromDate(new Date()), "1");
                            CstProfile profileTemplate = dialog.getProfileToCopyFrom();
                            if (profileTemplate != null) {
                                CstProfileEditor.this.log.debug("Selected a profile to copy from: " + profileTemplate.getName());
                                CstService.copyProfile(profileTemplate, target);
                            } else {
                                CstProfile selProfile;
                                CstProimmun cstProImmun;
                                Hashtable auswahlBefunde = new Hashtable();
                                target.setMap("Auswahlbefunde", auswahlBefunde);
                                target.setAnzeigeTyp("Effektiv");
                                target.setPeriod1DateStart(CstService.getCompactFromDate(CstService.getDateByAddingDays(now.getTime(), -365)));
                                target.setPeriod1DateEnd(CstService.getCompactFromDate(now.getTime()));
                                target.setPeriod2DateStart(CstService.getCompactFromDate(CstService.getDateByAddingDays(now.getTime(), -365)));
                                target.setPeriod2DateEnd(CstService.getCompactFromDate(CstService.getDateByAddingDays(now.getTime(), -730)));
                                target.setPeriod3DateStart(CstService.getCompactFromDate(CstService.getDateByAddingDays(now.getTime(), -730)));
                                target.setPeriod3DateEnd(CstService.getCompactFromDate(CstService.getDateByAddingDays(now.getTime(), -1095)));
                                TableItem[] selItem = CstProfileEditor.this.tableProfile.getSelection();
                                if (selItem.length != 0 && (cstProImmun = CstProimmun.getByProfileId((selProfile = (CstProfile)selItem[0].getData()).getId())) != null) {
                                    CstProimmun newCstProImmun = new CstProimmun(target.getId(), cstProImmun.getDatum());
                                    newCstProImmun.setProfileId(target.getId());
                                    newCstProImmun.setTested(cstProImmun.getTested());
                                    newCstProImmun.setToBeTested(cstProImmun.getToBeTested());
                                    newCstProImmun.setText1(cstProImmun.getText1());
                                    newCstProImmun.setText2(cstProImmun.getText2());
                                    newCstProImmun.setText3(cstProImmun.getText3());
                                    newCstProImmun.setText4(cstProImmun.getText4());
                                }
                            }
                            CstProfileEditor.this.loadProfileData();
                            TableItem[] items = CstProfileEditor.this.tableProfile.getItems();
                            int i = 0;
                            while (i < items.length) {
                                TableItem item = items[i];
                                CstProfile g = (CstProfile)item.getData();
                                if (g.getId().equals(target.getId())) {
                                    CstProfileEditor.this.selectRow(i);
                                    break;
                                }
                                ++i;
                            }
                            CstProfileEditor.this.tableViewerProfiles.refresh(true);
                            CstProfileEditor.this.tableProfile.setFocus();
                        }
                    } else {
                        CstProfileEditor.this.log.info("Error no mandant available ", (Object)4);
                    }
                }
                catch (Exception e) {
                    CstProfileEditor.this.log.info("CST Category already exists: " + e.getMessage(), (Object)4);
                    CstProfileEditor.this.isRepeatedDialog = true;
                    CstProfileEditor.this.actionCreateProfile.run();
                }
            }
        };
        this.actionCreateProfile.setText(Messages.Cst_Text_create_cstprofile);
        this.actionCreateProfile.setToolTipText(Messages.Cst_Text_create_cstprofile_tooltip);
        this.actionCreateProfile.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_ADD"));
        this.actionDeleteProfile = new Action(){

            public void run() {
                TableItem[] selItem = CstProfileEditor.this.tableProfile.getSelection();
                if (selItem.length == 0) {
                    return;
                }
                CstProfile selProfile = (CstProfile)selItem[0].getData();
                String sMsg = String.format(Messages.Cst_Text_confirm_delete_profile, selProfile.getName());
                MessageBox dialog = new MessageBox(UiDesk.getTopShell(), 292);
                dialog.setText("Delete Profile");
                dialog.setMessage(sMsg);
                int returnCode = dialog.open();
                if (returnCode == 256) {
                    return;
                }
                CstGastroColo.getByProfileId(selProfile.getId()).delete();
                CstProimmun.getByProfileId(selProfile.getId()).delete();
                selProfile.delete();
                CstProfileEditor.this.loadProfileData();
                CstProfileEditor.this.tableViewerProfiles.refresh();
                CstProfileEditor.this.selectFirstRow();
                CstProfileEditor.this.tableProfile.setFocus();
            }
        };
        this.actionDeleteProfile.setText(Messages.Cst_Text_delete_profile);
        this.actionDeleteProfile.setToolTipText(Messages.Cst_Text_delete_profile_tooltip);
        this.actionDeleteProfile.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_DELETE"));
        this.actionCopyProfile = new Action(){

            public void run() {
                UiDesk.asyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        NullProgressMonitor monitor = new NullProgressMonitor();
                        String msg = "Patienten-Liste erstellen";
                        CstProfileEditor.this.showBusy(true);
                        monitor.beginTask(msg, 7);
                        monitor.subTask("Einlesen der Aktualisierungsdaten");
                        monitor.worked(1);
                        TableItem[] selItem = (this).CstProfileEditor.this.tableProfile.getSelection();
                        if (selItem.length == 0) {
                            return;
                        }
                        CstProfile selProfile = (CstProfile)selItem[0].getData();
                        (this).CstProfileEditor.this.dialog = new CstCopyProfileDialog((this).CstProfileEditor.this.tableViewerProfiles.getControl().getShell());
                        (this).CstProfileEditor.this.dialog.create();
                        monitor.worked(1);
                        if ((this).CstProfileEditor.this.dialog.open() == 0) {
                            List<Patient> selPatient = (this).CstProfileEditor.this.dialog.getSelItems();
                            if (selPatient.size() == 0) {
                                return;
                            }
                            Mandant m = CoreHub.actMandant;
                            if (m != null) {
                                CstService service = new CstService();
                                service.copyProfile(selProfile, selPatient, m);
                            }
                        }
                        CstProfileEditor.this.loadProfileData();
                        (this).CstProfileEditor.this.tableViewerProfiles.refresh();
                        CstProfileEditor.this.selectFirstRow();
                        (this).CstProfileEditor.this.tableProfile.setFocus();
                        CstProfileEditor.this.showBusy(false);
                        monitor.worked(1);
                        monitor.done();
                    }
                });
            }
        };
        this.actionCopyProfile.setText(Messages.Cst_Text_copy_profile);
        this.actionCopyProfile.setToolTipText(Messages.Cst_Text_copy_profile_tooltip);
        this.actionCopyProfile.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
        this.actionRemoveCstGroup = new Action(){

            public void run() {
                TableItem[] selItems = CstProfileEditor.this.tableProfile.getSelection();
                TableItem[] selItemC = CstProfileEditor.this.tableProfile.getSelection();
                CstProfile selGroup = (CstProfile)selItemC[0].getData();
                TableItem[] selItem = CstProfileEditor.this.tableCstGroup.getSelection();
                if (selItem.length == 0) {
                    return;
                }
                CstGroup labItem = (CstGroup)((Object)selItem[0].getData());
                selGroup.removeCstGroup(labItem);
                CstProfileEditor.this.loadProfileData();
                CstProfileEditor.this.tableProfile.setSelection(selItems[0]);
                CstProfileEditor.this.tableViewerProfiles.refresh();
                CstProfileEditor.this.tableViewerCstGroups.refresh();
                CstProfileEditor.this.reinitRanking(selGroup);
                CstProfileEditor.this.tableProfile.setFocus();
            }
        };
        this.actionRemoveCstGroup.setText(Messages.Cst_Text_delete_cstgroup_from_profile);
        this.actionRemoveCstGroup.setToolTipText(Messages.Cst_Text_delete_cstgroup_from_profile_tooltip);
        this.actionRemoveCstGroup.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_DELETE"));
        this.actionAddCstGroup = new Action(){

            public void run() {
                TableItem[] selItems = CstProfileEditor.this.tableProfile.getSelection();
                CstProfileEditor.this.dialogCstGroups = CstGroup.getCstGroups();
                CstGroupSelectionDialog dialog = new CstGroupSelectionDialog(CstProfileEditor.this.tableViewerCstGroups.getControl().getShell(), CstProfileEditor.this.dialogCstGroups);
                dialog.create();
                if (dialog.open() != 0) {
                    return;
                }
                List<CstGroup> itemsToAdd = dialog.getSelItems();
                TableItem[] selItemC = CstProfileEditor.this.tableProfile.getSelection();
                if (selItemC == null || selItemC.length < 1) {
                    return;
                }
                CstProfile selProfile = (CstProfile)selItemC[0].getData();
                if (selProfile == null) {
                    return;
                }
                try {
                    selProfile.addItems(itemsToAdd);
                }
                catch (Exception e) {
                    CstProfileEditor.this.showMessage(Messages.Cst_Text_cstgroup_exists_in_profile);
                }
                CstProfileEditor.this.loadProfileData();
                CstProfileEditor.this.tableProfile.setSelection(selItems[0]);
                CstProfileEditor.this.tableViewerProfiles.refresh();
                CstProfileEditor.this.tableViewerCstGroups.refresh();
                CstProfileEditor.this.reinitRanking(selProfile);
                CstProfileEditor.this.tableProfile.setFocus();
            }
        };
        this.actionAddCstGroup.setText(Messages.Cst_Text_add_cstgroup_to_profile);
        this.actionAddCstGroup.setToolTipText(Messages.Cst_Text_add_cstgroup_to_profile);
        this.actionAddCstGroup.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_ADD"));
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = CstProfileEditor.this.tableViewerProfiles.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                CstProfile profile = (CstProfile)obj;
                ProfileDetailDialog dialog = new ProfileDetailDialog(CstProfileEditor.this.tableViewerProfiles.getControl().getShell());
                dialog.create();
                dialog.setName(profile.getName());
                dialog.setDescription(profile.getDescription());
                dialog.setValidFrom(profile.getValidFrom());
                if (dialog.open() == 0) {
                    profile.setName(dialog.getName());
                    profile.setDescription(dialog.getDescription());
                    profile.setValidFrom(dialog.getValidFrom());
                    CstProfileEditor.this.loadProfileData();
                    CstProfileEditor.this.tableViewerProfiles.setSelection(selection);
                }
            }
        };
    }

    private CstProfile getSelectedProfile() {
        TableItem[] selItem = this.tableProfile.getSelection();
        if (selItem.length == 0) {
            return null;
        }
        CstProfile selProf = (CstProfile)selItem[0].getData();
        return selProf;
    }

    private void reinitRanking(CstProfile selGroup) {
        this.cstGroups = selGroup.getCstGroups();
        Hashtable<String, Integer> ranking = new Hashtable<String, Integer>();
        int x = 1;
        for (CstGroup item : this.cstGroups) {
            ranking.put(item.getId(), x++);
        }
        this.itemRanking = (Map)ranking.clone();
        selGroup.setMap("itemsRanking", ranking);
    }

    private void hookDoubleClickAction() {
        this.tableViewerProfiles.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CstProfileEditor.this.doubleClickAction.run();
            }
        });
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.tableViewerProfiles.getControl().getShell(), (String)"CST View", (String)message);
    }

    public void setFocus() {
        this.tableViewerProfiles.getControl().setFocus();
        Patient prevPatient = this.patient;
        this.patient = ElexisEventDispatcher.getSelectedPatient();
        if (this.patient == null) {
            this.log.info("kein patient ausgew\ufffdhlt", (Object)4);
        } else {
            this.log.info("patient ausgew\ufffdhlt" + this.patient.getName(), (Object)4);
            this.labelLeft.setText(Messages.Cst_Text_Profile_fuer + " " + this.patient.getName() + " " + this.patient.getVorname());
            if (prevPatient != null && !prevPatient.getId().toString().equals(this.patient.getId().toString())) {
                this.loadProfileData();
            }
        }
    }

    public void refresh() {
        this.activePatient(ContextServiceHolder.get().getActivePatient().orElse(null));
    }

    class CstGroupContentProvider
    implements IStructuredContentProvider {
        CstGroupContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            TableItem[] selItem = CstProfileEditor.this.tableProfile.getSelection();
            if (selItem.length == 0) {
                return CstProfileEditor.this.cstGroups.toArray();
            }
            CstProfile selProf = (CstProfile)selItem[0].getData();
            return selProf.getCstGroups().toArray();
        }
    }

    class CstGroupLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableFontProvider,
    IColorProvider {
        CstGroupLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            CstGroup labItem = (CstGroup)((Object)obj);
            switch (index) {
                case 0: {
                    return labItem.getName();
                }
                case 1: {
                    return labItem.getDescription();
                }
                case 2: {
                    Object ranking = CstProfileEditor.this.itemRanking.get(labItem.getId());
                    if (ranking == null) {
                        CstProfileEditor.this.reinitRanking(CstProfileEditor.this.getSelectedProfile());
                    }
                    return String.valueOf(CstProfileEditor.this.itemRanking.get(labItem.getId()));
                }
            }
            return "?";
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }

        public Image getImage(Object obj) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }

        public Font getFont(Object element, int columnIndex) {
            Font font = null;
            return font;
        }

        public Color getForeground(Object element) {
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }
    }

    class CstGroupSorter
    extends ViewerSorter {
        CstGroupSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof CstGroup && e2 instanceof CstGroup) {
                CstGroup d1 = (CstGroup)((Object)e1);
                CstGroup d2 = (CstGroup)((Object)e2);
                Integer r1 = (Integer)CstProfileEditor.this.itemRanking.get(d1.getId());
                Integer r2 = (Integer)CstProfileEditor.this.itemRanking.get(d2.getId());
                if (r1 == null || r2 == null) {
                    return 0;
                }
                return r1.compareTo(r2);
            }
            return 0;
        }
    }

    public static enum GroupTokens {
        GASTRO_MAKRO,
        GASTRO_HISTO,
        COLO_MAKRO,
        COLO_HISTO;

    }

    class ProfileContentProvider
    implements IStructuredContentProvider {
        ProfileContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return CstProfileEditor.this.cstProfiles.toArray();
        }
    }

    class ProfileLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableFontProvider,
    IColorProvider {
        ProfileLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            CstProfile cstProfile = (CstProfile)obj;
            switch (index) {
                case 0: {
                    return cstProfile.getName();
                }
                case 1: {
                    return cstProfile.getDescription();
                }
                case 2: {
                    return CstService.parseCompactDate(cstProfile.getValidFrom());
                }
                case 3: {
                    return CstService.parseCompactDate(cstProfile.getValidTo());
                }
            }
            return "";
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }

        public Font getFont(Object element, int columnIndex) {
            Font font = null;
            return font;
        }

        public Color getForeground(Object element) {
            CstProfile cstProfile = (CstProfile)element;
            if (cstProfile.getTemplate().equals("1")) {
                return UiDesk.getColorFromRGB((String)"ff0000");
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }
    }

    class ProfileSortListener
    extends SelectionAdapter {
        ProfileSortListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            TableColumn col = (TableColumn)e.getSource();
            Integer colNo = (Integer)col.getData();
            if (colNo != null) {
                if (colNo == CstProfileEditor.this.sortColumn) {
                    CstProfileEditor.this.sortReverse = !CstProfileEditor.this.sortReverse;
                } else {
                    CstProfileEditor.this.sortReverse = false;
                    CstProfileEditor.this.sortColumn = colNo;
                }
                CstProfileEditor.this.tableViewerProfiles.refresh();
            }
        }
    }

    class ProfileSorter
    extends ViewerSorter {
        ProfileSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof CstProfile && e2 instanceof CstProfile) {
                CstProfile d1 = (CstProfile)e1;
                CstProfile d2 = (CstProfile)e2;
                String c1 = "";
                String c2 = "";
                switch (CstProfileEditor.this.sortColumn) {
                    case 0: {
                        c1 = d1.getName();
                        c2 = d2.getName();
                        break;
                    }
                    case 1: {
                        c1 = d1.getDescription();
                        c2 = d2.getDescription();
                        break;
                    }
                    case 2: {
                        c1 = d1.getValidFrom();
                        c2 = d2.getValidFrom();
                    }
                }
                if (CstProfileEditor.this.sortReverse) {
                    return c1.compareTo(c2);
                }
                return c2.compareTo(c1);
            }
            return 0;
        }
    }
}

