/*
 * Decompiled with CFR 0.152.
 */
package ch.gpb.elexis.cst.dialog;

import ch.elexis.core.ui.UiDesk;
import ch.elexis.data.Mandant;
import ch.gpb.elexis.cst.data.CstProfile;
import ch.gpb.elexis.cst.data.CstStateItem;
import ch.gpb.elexis.cst.widget.ImageCombo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CstReminderDialog
extends TitleAreaDialog {
    private Text txtFirstName;
    private Text lastNameText;
    CstStateItem.StateType selectedType;
    private String groupName;
    ImageCombo combo;
    private String groupDescription;
    Mandant mandant;
    CDateTime dateTime;
    Date selDate;
    ArrayList<CstProfile> options = new ArrayList();
    Map<Integer, Image> imageMap = new HashMap<Integer, Image>();

    public CstReminderDialog(Shell parentShell, Mandant mandant) {
        super(parentShell);
        this.mandant = mandant;
        this.imageMap.put(CstStateItem.StateType.ACTION.ordinal(), UiDesk.getImage((String)"reminder_action.png"));
        this.imageMap.put(CstStateItem.StateType.DECISION.ordinal(), UiDesk.getImage((String)"reminder_decision.png"));
        this.imageMap.put(CstStateItem.StateType.REMINDER.ordinal(), UiDesk.getImage((String)"reminder_reminder.png"));
        this.imageMap.put(CstStateItem.StateType.TRIGGER.ordinal(), UiDesk.getImage((String)"reminder_trigger.png"));
    }

    public void create() {
        super.create();
        this.setTitle("Erzeugt neuen Reminder");
        this.setMessage("Bitte w\ufffdhlen Sie Namen und Typ des Reminders", 1);
    }

    protected Control createDialogArea(Composite parent) {
        CstStateItem.StateType[] stateTypes;
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(2, false);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)layout);
        this.createFirstName(container);
        this.createLastName(container);
        Label lblNewLabel_1 = new Label(container, 0);
        lblNewLabel_1.setText("Datum:");
        this.dateTime = new CDateTime(container, 2098179);
        Label lblNewLabel = new Label(container, 0);
        lblNewLabel.setText("Typ: ");
        this.combo = new ImageCombo(container, 0);
        this.combo.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.combo.setBackground(UiDesk.getColorFromRGB((String)"FFFFFF"));
        CstStateItem.StateType[] stateTypeArray = stateTypes = CstStateItem.StateType.values();
        int n = stateTypes.length;
        int n2 = 0;
        while (n2 < n) {
            CstStateItem.StateType stateType = stateTypeArray[n2];
            this.combo.add(this.imageMap.get(stateType.ordinal()), stateType.name());
            ++n2;
        }
        this.combo.select(0);
        return area;
    }

    private void createFirstName(Composite container) {
        Label lbtFirstName = new Label(container, 0);
        lbtFirstName.setText("Name: ");
        GridData dataFirstName = new GridData();
        dataFirstName.grabExcessHorizontalSpace = true;
        dataFirstName.horizontalAlignment = 4;
        this.txtFirstName = new Text(container, 2048);
        this.txtFirstName.setLayoutData((Object)dataFirstName);
    }

    private void createLastName(Composite container) {
        Label lbtLastName = new Label(container, 0);
        lbtLastName.setText("Beschreibung: ");
        GridData dataLastName = new GridData();
        dataLastName.grabExcessHorizontalSpace = true;
        dataLastName.horizontalAlignment = 4;
        this.lastNameText = new Text(container, 2048);
        this.lastNameText.setLayoutData((Object)dataLastName);
    }

    protected boolean isResizable() {
        return true;
    }

    private void saveInput() {
        this.groupName = this.txtFirstName.getText();
        this.groupDescription = this.lastNameText.getText();
        if (this.combo.getSelectionIndex() > -1) {
            this.selectedType = CstStateItem.StateType.values()[this.combo.getSelectionIndex()];
        }
        this.selDate = this.dateTime.getSelection();
    }

    protected void okPressed() {
        this.saveInput();
        super.okPressed();
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getGroupDescription() {
        return this.groupDescription;
    }

    public CstStateItem.StateType getItemType() {
        return this.selectedType;
    }

    public void setName(String name) {
        this.txtFirstName.setText(name);
    }

    public void setDescription(String name) {
        this.lastNameText.setText(name);
    }

    public void setType(CstStateItem.StateType type) {
        this.combo.select(type.ordinal());
    }

    public void setDate(Date date) {
        this.dateTime.setSelection(date);
    }

    public Date getDate() {
        return this.selDate;
    }
}

