/*
 * Decompiled with CFR 0.152.
 */
package ch.gpb.elexis.cst.view;

import ch.elexis.data.LabResult;
import ch.elexis.data.Patient;
import ch.gpb.elexis.cst.Messages;
import ch.gpb.elexis.cst.data.CstAbstract;
import ch.gpb.elexis.cst.data.CstGroup;
import ch.gpb.elexis.cst.data.CstProfile;
import ch.gpb.elexis.cst.data.LabItemWrapper;
import ch.gpb.elexis.cst.data.MinimaxValue;
import ch.gpb.elexis.cst.service.CstService;
import ch.gpb.elexis.cst.view.CstResultPart;
import ch.gpb.elexis.cst.widget.DisplayOnceCanvas;
import ch.gpb.elexis.cst.widget.MinimaxCanvas;
import ch.gpb.elexis.cst.widget.NoValuesCanvas;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class CstResultMiniMax
extends CstResultPart {
    public static final String ID = "ch.gpb.elexis.cst.cstresulteffektiv";

    @Override
    public void layoutDisplay(CstProfile aProfile) {
        if (aProfile != null) {
            this.log.info("Anzeigetyp:" + aProfile.getAnzeigeTyp(), (Object)4);
            this.baseComposite.setSize(OUTPUTWIDTH, OUTPUTHEIGTH);
            Control[] controlArray = this.baseComposite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.dispose();
                ++n2;
            }
            Patient patient = Patient.load((String)this.profile.getKontaktId());
            HashMap labResults = LabResult.getGrouped((Patient)patient);
            List<String> sortedDates = CstService.getDistinctDates(labResults);
            if (sortedDates == null || sortedDates.isEmpty()) {
                return;
            }
            int newHeigth = 0;
            this.baseComposite.setSize(820, 120);
            this.baseComposite.layout();
            this.baseComposite.setBackground(this.WHITE);
            Label labelPatientName = new Label(this.baseComposite, 0);
            labelPatientName.setLayoutData((Object)new GridData());
            labelPatientName.setText(this.getHeader(patient));
            labelPatientName.setSize(600, 40);
            labelPatientName.setFont(this.fontMedium);
            Label labelProfileData = new Label(this.baseComposite, 0);
            labelProfileData.setLayoutData((Object)new GridData());
            labelProfileData.setText(this.getSubTitle(patient, aProfile));
            labelProfileData.setSize(600, 40);
            labelProfileData.setFont(this.fontSmall);
            Map itemRanking = aProfile.getMap("itemsRanking");
            CstResultPart.GroupSorter groupSorter = new CstResultPart.GroupSorter(itemRanking);
            List<CstGroup> cstGroups = aProfile.getCstGroups();
            Collections.sort(cstGroups, groupSorter);
            for (CstGroup group : cstGroups) {
                List<LabItemWrapper> labitems = group.getLabitems();
                Map itemRanking2 = group.getMap("itemsRanking");
                CstResultPart.LabItemSorter labItemSorter = new CstResultPart.LabItemSorter(itemRanking2);
                Collections.sort(labitems, labItemSorter);
                for (LabItemWrapper labItem : labitems) {
                    Composite lineCompo = new Composite(this.baseComposite, 0);
                    lineCompo.setSize(790, 120);
                    lineCompo.setBackground(this.WHITE);
                    GridData lineData = new GridData(1, 1, false, false, 1, 1);
                    lineData.grabExcessHorizontalSpace = false;
                    lineData.verticalAlignment = 1;
                    lineData.horizontalAlignment = 1;
                    lineData.widthHint = 790;
                    lineCompo.setLayoutData((Object)lineData);
                    newHeigth += lineCompo.getSize().y;
                    Object txL2 = "";
                    if (labItem.getLabItem().getEinheit().length() > 0) {
                        txL2 = (String)txL2 + " (" + labItem.getLabItem().getEinheit() + ")";
                    }
                    MinimaxValue minimaxValue = new MinimaxValue();
                    minimaxValue.setName(group.getName() + ": " + labItem.getLabItem().getName() + (String)txL2);
                    CstAbstract cabstract = CstAbstract.getByLaboritemId(labItem.getLabItem().getId());
                    if (cabstract != null) {
                        minimaxValue.setAbstract(cabstract.getDescription1());
                    } else {
                        minimaxValue.setAbstract(Messages.Cst_Text_no_abstract_available);
                    }
                    double[] dResult = this.extractRefValues(labItem.getLabItem());
                    minimaxValue.setRangeStart(dResult[0]);
                    minimaxValue.setRangeEnd(dResult[1]);
                    if (!labItem.isDisplayOnce()) {
                        if (!CstService.hasValueForName(labItem.getLabItem().getName(), labItem.getLabItem().getKuerzel(), labResults)) {
                            NoValuesCanvas onceCAnvas = new NoValuesCanvas(lineCompo, 2048);
                            StringBuffer lblText = new StringBuffer("F\ufffdr diesen Laborwert gibt es keine Werte bei diesem Patienten");
                            minimaxValue.setText(lblText.toString());
                            onceCAnvas.setFinding(minimaxValue);
                        } else {
                            Date dateNow = new Date();
                            Date dateBefore = CstService.getDateFromCompact(aProfile.getPeriod1DateStart());
                            minimaxValue.setDateStartOfSpan1(dateBefore);
                            minimaxValue.setDateEndOfSpan1(CstService.getDateFromCompact(aProfile.getPeriod1DateEnd()));
                            LabResult labResultMax1 = CstService.getMaxValueForTimespan(labItem.getLabItem().getName(), labItem.getLabItem().getKuerzel(), dateBefore, dateNow, labResults);
                            if (labResultMax1 != null) {
                                minimaxValue.setMaxOfSpan1(CstService.getNumericFromLabResult(labResultMax1.getResult()));
                            } else {
                                minimaxValue.setMaxOfSpan1(-1.0);
                            }
                            LabResult labResultMin1 = CstService.getMinValueForTimespan(labItem.getLabItem().getName(), labItem.getLabItem().getKuerzel(), dateBefore, dateNow, labResults);
                            if (labResultMin1 != null) {
                                minimaxValue.setMinOfSpan1(CstService.getNumericFromLabResult(labResultMin1.getResult()));
                            } else {
                                minimaxValue.setMinOfSpan1(-1.0);
                            }
                            Date dateBefore2 = CstService.getDateFromCompact(aProfile.getPeriod2DateStart());
                            dateBefore = CstService.getDateFromCompact(aProfile.getPeriod2DateEnd());
                            minimaxValue.setDateStartOfSpan2(dateBefore2);
                            minimaxValue.setDateEndOfSpan2(dateBefore);
                            LabResult labResultMax2 = CstService.getMaxValueForTimespan(labItem.getLabItem().getName(), labItem.getLabItem().getKuerzel(), dateBefore2, dateBefore, labResults);
                            if (labResultMax2 != null) {
                                minimaxValue.setMaxOfSpan2(CstService.getNumericFromLabResult(labResultMax2.getResult()));
                            } else {
                                minimaxValue.setMaxOfSpan2(-1.0);
                            }
                            LabResult labResultMin2 = CstService.getMinValueForTimespan(labItem.getLabItem().getName(), labItem.getLabItem().getKuerzel(), dateBefore2, dateBefore, labResults);
                            if (labResultMin2 != null) {
                                minimaxValue.setMinOfSpan2(CstService.getNumericFromLabResult(labResultMin2.getResult()));
                            } else {
                                minimaxValue.setMinOfSpan2(-1.0);
                            }
                            Date dateBefore3 = CstService.getDateFromCompact(aProfile.getPeriod3DateStart());
                            dateBefore2 = CstService.getDateFromCompact(aProfile.getPeriod3DateEnd());
                            minimaxValue.setDateStartOfSpan3(dateBefore3);
                            minimaxValue.setDateEndOfSpan3(dateBefore2);
                            LabResult labResultMax3 = CstService.getMaxValueForTimespan(labItem.getLabItem().getName(), labItem.getLabItem().getKuerzel(), dateBefore3, dateBefore2, labResults);
                            if (labResultMax3 != null) {
                                minimaxValue.setMaxOfSpan3(CstService.getNumericFromLabResult(labResultMax3.getResult()));
                            } else {
                                minimaxValue.setMaxOfSpan3(-1.0);
                            }
                            LabResult labResultMin3 = CstService.getMinValueForTimespan(labItem.getLabItem().getName(), labItem.getLabItem().getKuerzel(), dateBefore3, dateBefore2, labResults);
                            if (labResultMin3 != null) {
                                minimaxValue.setMinOfSpan3(CstService.getNumericFromLabResult(labResultMin3.getResult()));
                            } else {
                                minimaxValue.setMinOfSpan3(-1.0);
                            }
                            MinimaxCanvas minimaxCanvas = new MinimaxCanvas(lineCompo, 2048);
                            minimaxCanvas.setFinding(minimaxValue);
                        }
                    } else {
                        int countValues = 0;
                        String sDateResult = null;
                        for (String date : sortedDates) {
                            LabResult labResultOnce = CstService.getValueForNameAndDate(labItem.getLabItem().getName(), date, labItem.getLabItem().getKuerzel(), labResults);
                            if (labResultOnce == null) continue;
                            sDateResult = date;
                            ++countValues;
                        }
                        LabResult labResultOnce = null;
                        Collections.reverse(sortedDates);
                        for (String date : sortedDates) {
                            labResultOnce = CstService.getValueForNameAndDate(labItem.getLabItem().getName(), date, labItem.getLabItem().getKuerzel(), labResults);
                            if (labResultOnce != null) break;
                        }
                        DisplayOnceCanvas onceCAnvas = new DisplayOnceCanvas(lineCompo, 2048);
                        onceCAnvas.setFinding(minimaxValue);
                        StringBuffer lblText = new StringBuffer(Messages.CstResultEffektiv_hinweis_einmal_im_leben);
                        if (labResultOnce == null) {
                            lblText.append(Messages.CstResultEffektiv_resultat_nie_ermittelt);
                        } else if (countValues > 1) {
                            lblText.append(Messages.CstResultEffktiv_hinweis_immer_anzeigen);
                        }
                        minimaxValue.setText(lblText.toString());
                        if (labResultOnce != null) {
                            minimaxValue.setMaxOfSpan3(new Double(CstService.getNumericFromLabResult(labResultOnce.getResult())));
                            minimaxValue.setDateStartOfSpan3(CstService.getDateFromCompact(sDateResult));
                        } else {
                            minimaxValue.setMaxOfSpan3(-1.0);
                        }
                    }
                    this.checkPageBreak(this.baseComposite);
                }
            }
            this.baseComposite.pack();
            int currentHeigth = this.baseComposite.getSize().y;
            int printHeigth = this.profile.getAusgabeRichtung() ? 794 : 1123;
            int pageCnt = currentHeigth / printHeigth;
            int rmn = (pageCnt + 1) * printHeigth - currentHeigth;
            if (rmn < printHeigth) {
                this.addLine(this.baseComposite, rmn);
            }
            this.addBefunde(this.baseComposite);
        }
    }

    @Override
    public void visible(boolean mode) {
    }
}

