/*
 * Decompiled with CFR 0.152.
 */
package ch.gpb.elexis.cst.util;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileInputStream;
import javax.imageio.ImageIO;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class ImageUtils {
    public static BufferedImage convertToAWT(ImageData data) {
        ColorModel colorModel = null;
        PaletteData palette = data.palette;
        if (palette.isDirect) {
            colorModel = new DirectColorModel(data.depth, palette.redMask, palette.greenMask, palette.blueMask);
            BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(data.width, data.height), false, null);
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    int pixel = data.getPixel(x, y);
                    RGB rgb = palette.getRGB(pixel);
                    bufferedImage.setRGB(x, y, rgb.red << 16 | rgb.green << 8 | rgb.blue);
                    ++x;
                }
                ++y;
            }
            return bufferedImage;
        }
        RGB[] rgbs = palette.getRGBs();
        byte[] red = new byte[rgbs.length];
        byte[] green = new byte[rgbs.length];
        byte[] blue = new byte[rgbs.length];
        int i = 0;
        while (i < rgbs.length) {
            RGB rgb = rgbs[i];
            red[i] = (byte)rgb.red;
            green[i] = (byte)rgb.green;
            blue[i] = (byte)rgb.blue;
            ++i;
        }
        colorModel = data.transparentPixel != -1 ? new IndexColorModel(data.depth, rgbs.length, red, green, blue, data.transparentPixel) : new IndexColorModel(data.depth, rgbs.length, red, green, blue);
        BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(data.width, data.height), false, null);
        WritableRaster raster = bufferedImage.getRaster();
        int[] pixelArray = new int[1];
        int y = 0;
        while (y < data.height) {
            int x = 0;
            while (x < data.width) {
                int pixel;
                pixelArray[0] = pixel = data.getPixel(x, y);
                raster.setPixel(x, y, pixelArray);
                ++x;
            }
            ++y;
        }
        return bufferedImage;
    }

    public static ImageData convertToSWT(BufferedImage bufferedImage) {
        if (bufferedImage.getColorModel() instanceof DirectColorModel) {
            DirectColorModel colorModel = (DirectColorModel)bufferedImage.getColorModel();
            PaletteData palette = new PaletteData(colorModel.getRedMask(), colorModel.getGreenMask(), colorModel.getBlueMask());
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    int rgb = bufferedImage.getRGB(x, y);
                    int pixel = palette.getPixel(new RGB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF));
                    data.setPixel(x, y, pixel);
                    if (colorModel.hasAlpha()) {
                        data.setAlpha(x, y, rgb >> 24 & 0xFF);
                    }
                    ++x;
                }
                ++y;
            }
            return data;
        }
        if (bufferedImage.getColorModel() instanceof IndexColorModel) {
            IndexColorModel colorModel = (IndexColorModel)bufferedImage.getColorModel();
            int size = colorModel.getMapSize();
            byte[] reds = new byte[size];
            byte[] greens = new byte[size];
            byte[] blues = new byte[size];
            colorModel.getReds(reds);
            colorModel.getGreens(greens);
            colorModel.getBlues(blues);
            RGB[] rgbs = new RGB[size];
            int i = 0;
            while (i < rgbs.length) {
                rgbs[i] = new RGB(reds[i] & 0xFF, greens[i] & 0xFF, blues[i] & 0xFF);
                ++i;
            }
            PaletteData palette = new PaletteData(rgbs);
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            data.transparentPixel = colorModel.getTransparentPixel();
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[1];
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    raster.getPixel(x, y, pixelArray);
                    data.setPixel(x, y, pixelArray[0]);
                    ++x;
                }
                ++y;
            }
            return data;
        }
        return null;
    }

    static ImageData createSampleImage(Display display) {
        Image image = new Image((Device)display, 100, 100);
        Rectangle bounds = image.getBounds();
        GC gc = new GC((Drawable)image);
        gc.setBackground(display.getSystemColor(9));
        gc.fillRectangle(bounds);
        gc.setBackground(display.getSystemColor(5));
        gc.fillOval(0, 0, bounds.width, bounds.height);
        gc.setForeground(display.getSystemColor(3));
        gc.drawLine(0, 0, bounds.width, bounds.height);
        gc.drawLine(bounds.width, 0, 0, bounds.height);
        gc.dispose();
        ImageData data = image.getImageData();
        image.dispose();
        return data;
    }

    public static BufferedImage[] splitImage(BufferedImage image, int rows, int cols) throws Exception {
        int chunks = rows * cols;
        int chunkWidth = image.getWidth() / cols;
        int chunkHeight = image.getHeight() / rows;
        int count = 0;
        BufferedImage[] imgs = new BufferedImage[chunks];
        int x = 0;
        while (x < rows) {
            int y = 0;
            while (y < cols) {
                int imageType = image.getType();
                if (imageType == 0) {
                    imageType = 5;
                }
                imgs[count] = new BufferedImage(chunkWidth, chunkHeight, imageType);
                Graphics2D gr = imgs[count++].createGraphics();
                gr.drawImage(image, 0, 0, chunkWidth, chunkHeight, chunkWidth * y, chunkHeight * x, chunkWidth * y + chunkWidth, chunkHeight * x + chunkHeight, null);
                gr.dispose();
                ++y;
            }
            ++x;
        }
        int i = 0;
        while (i < imgs.length) {
            ImageIO.write((RenderedImage)imgs[i], "jpg", new File("D:\\tmp", "img" + i + ".jpg"));
            ++i;
        }
        return imgs;
    }

    public static BufferedImage[] splitImageByHeigth(BufferedImage image, int heigth) throws Exception {
        int rows = image.getHeight() / heigth;
        int remainingHeigth = image.getHeight() - heigth * rows;
        if (remainingHeigth > 0) {
            ++rows;
        }
        int chunkWidth = image.getWidth();
        int chunkHeight = heigth;
        int chunks = rows;
        int count = 0;
        BufferedImage[] imgs = new BufferedImage[chunks];
        int x = 0;
        while (x < rows) {
            int imageType = image.getType();
            if (imageType == 0) {
                imageType = 5;
            }
            imgs[count] = new BufferedImage(chunkWidth, chunkHeight, imageType);
            Graphics2D gr = imgs[count++].createGraphics();
            gr.drawRect(0, 0, chunkWidth, chunkHeight);
            if (image.getHeight() - chunkHeight * x < heigth) {
                int rmnHeigth = image.getHeight() - chunkHeight * x;
                gr.setBackground(Color.WHITE);
                gr.clearRect(0, 0, chunkWidth, chunkHeight);
                gr.drawImage(image, 0, 0, chunkWidth, rmnHeigth, 0, chunkHeight * x, chunkWidth, chunkHeight * x + rmnHeigth, null);
            } else {
                gr.drawImage(image, 0, 0, chunkWidth, chunkHeight, 0, chunkHeight * x, chunkWidth, chunkHeight * x + chunkHeight, null);
            }
            gr.dispose();
            ++x;
        }
        return imgs;
    }

    public static float PixelsToPoints(float value, int dpi) {
        return value / (float)dpi * 72.0f;
    }

    public static void main(String[] args) {
        try {
            File file = new File("D:\\tmp\\debug.png");
            FileInputStream fis = new FileInputStream(file);
            BufferedImage image = ImageIO.read(fis);
            BufferedImage[] imgs = ImageUtils.splitImageByHeigth(image, 1123);
            int i = 0;
            while (i < imgs.length) {
                ImageIO.write((RenderedImage)imgs[i], "png", new File("D:\\tmp", "img" + (i + 1) + ".png"));
                ++i;
            }
            fis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

