/*
 * Decompiled with CFR 0.152.
 */
package ch.gpb.elexis.cst.widget;

import ch.elexis.core.ui.UiDesk;
import ch.gpb.elexis.cst.data.MinimaxValue;
import ch.gpb.elexis.cst.service.CstService;
import ch.gpb.elexis.cst.widget.CstCanvas;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Composite;

public class MinimaxCanvas
extends CstCanvas {
    int iPixX = 774;
    int iPixY = 140;
    int xoffBase = 4;
    int yoffBase = 140;
    int werteBereich = 160;
    MinimaxValue finding = new MinimaxValue();

    public MinimaxCanvas(Composite parent, int style) {
        super(parent, style);
        this.setBackground(WHITE);
        this.setSize(this.iPixX, this.iPixY);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                MinimaxCanvas.this.paintControl(e);
            }
        });
    }

    public MinimaxValue getFinding() {
        return this.finding;
    }

    public void setFinding(MinimaxValue finding) {
        this.finding = finding;
    }

    void paintControl(PaintEvent e) {
        GC gc = e.gc;
        gc.setFont(this.fontSmall);
        if (this.finding == null) {
            gc.drawText("no Finding set", 20, 20);
            return;
        }
        int xOff1 = 0;
        int xOff2 = 170;
        int xOff3 = 340;
        int xOff4 = 510;
        gc.setForeground(BLUE);
        gc.setFont(this.fontBig);
        gc.setForeground(DARKGRAY);
        gc.drawLine(xOff2, 0, xOff2, this.iPixY);
        gc.drawLine(xOff3, 0, xOff3, this.iPixY);
        gc.drawLine(xOff4, 0, xOff4, this.iPixY);
        gc.drawLine(this.iPixX, 0, this.iPixX, this.iPixY);
        StringBuffer title = new StringBuffer(this.finding.getName());
        if (this.finding.getRangeStart() > 0.0 && this.finding.getRangeEnd() > 0.0) {
            title.append(" (");
            title.append(this.finding.getRangeStart());
            title.append(" - ");
            title.append(this.finding.getRangeEnd());
            title.append(" )");
        } else {
            title.append(" (keine Ref.Werte)");
        }
        gc.drawText(title.toString(), xOff1, 2, true);
        gc.setFont(this.fontSmall);
        gc.setForeground(BLUE);
        gc.drawText("Zeitspanne \r\nvon\t" + CstService.getGermanFromDate(this.finding.getDateStartOfSpan3()) + "\r\nbis\t" + CstService.getGermanFromDate(this.finding.getDateEndOfSpan3()) + ": ", xOff1 + 10, 30);
        if (this.finding.getMaxOfSpan3() == -1.0) {
            gc.drawText("Maximum:\t keine Werte", xOff1 + 10, 80, true);
        } else {
            gc.drawText("Maximum:\t " + this.finding.getMaxOfSpan3(), xOff1 + 10, 80, true);
        }
        if (this.finding.getMinOfSpan3() == -1.0) {
            gc.drawText("Minimum:\t keine Werte", xOff1 + 10, 96, true);
        } else {
            gc.drawText("Minimum:\t " + this.finding.getMinOfSpan3(), xOff1 + 10, 96, true);
        }
        gc.setForeground(ORANGE);
        gc.drawText("Zeitspanne \r\nvon\t" + CstService.getGermanFromDate(this.finding.getDateStartOfSpan2()) + "\r\nbis\t" + CstService.getGermanFromDate(this.finding.getDateEndOfSpan2()) + ": ", xOff2 + 10, 30);
        if (this.finding.getMaxOfSpan2() == -1.0) {
            gc.drawText("Maximum:\t keine Werte", xOff2 + 10, 80, true);
        } else {
            gc.drawText("Maximum:\t " + this.finding.getMaxOfSpan2(), xOff2 + 10, 80, true);
        }
        if (this.finding.getMinOfSpan2() == -1.0) {
            gc.drawText("Minimum:\t keine Werte", xOff2 + 10, 96, true);
        } else {
            gc.drawText("Minimum:\t " + this.finding.getMinOfSpan2(), xOff2 + 10, 96, true);
        }
        gc.setForeground(BLACK);
        gc.drawText("Zeitspanne \r\nvon\t" + CstService.getGermanFromDate(this.finding.getDateStartOfSpan1()) + "\r\nbis\t" + CstService.getGermanFromDate(this.finding.getDateEndOfSpan1()) + ": ", xOff3 + 10, 30);
        if (this.finding.getMaxOfSpan1() == -1.0) {
            gc.drawText("Maximum:\tkeine Werte", xOff3 + 10, 80, true);
        } else {
            gc.drawText("Maximum:\t " + this.finding.getMaxOfSpan1(), xOff3 + 10, 80, true);
        }
        if (this.finding.getMinOfSpan1() == -1.0) {
            gc.drawText("Minimum:\t keine Werte", xOff3 + 10, 96, true);
        } else {
            gc.drawText("Minimum:\t " + this.finding.getMinOfSpan1(), xOff3 + 10, 96, true);
        }
        TextLayout layout = new TextLayout((Device)this.getDisplay());
        layout.setText(this.finding.getAbstract());
        layout.setWidth(250);
        Font fontNormal = UiDesk.getFont((String)"Helvetica", (int)7, (int)0);
        layout.setFont(fontNormal);
        layout.draw(gc, xOff4 + 4, 4);
        gc.dispose();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return new Point(this.iPixX, this.iPixY);
    }
}

