/*
 * Decompiled with CFR 0.152.
 */
package ch.gpb.elexis.cst.dialog;

import ch.elexis.data.Mandant;
import ch.gpb.elexis.cst.Messages;
import ch.gpb.elexis.cst.data.CstProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CstNewProfileDialog
extends TitleAreaDialog {
    private Text txtFirstName;
    private Text lastNameText;
    CstProfile selectedProfile;
    private String groupName;
    private String groupDescription;
    Combo combo;
    Mandant mandant;
    HashMap hash = new HashMap();
    ArrayList<CstProfile> options = new ArrayList();

    public CstNewProfileDialog(Shell parentShell, Mandant mandant) {
        super(parentShell);
        this.mandant = mandant;
    }

    public void create() {
        super.create();
        this.setTitle(Messages.Cst_Text_create_cstprofile);
        this.setMessage(Messages.Cst_Text_Enter_name_for_cstprofile, 1);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(2, false);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)layout);
        this.createFirstName(container);
        this.createLastName(container);
        Label lblNewLabel = new Label(container, 0);
        lblNewLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblNewLabel.setText(Messages.CstCategoryDialog_lblNewLabel_text);
        this.combo = new Combo(container, 0);
        this.combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        List<CstProfile> cstProfiles = CstProfile.getAllProfiles(this.mandant.getId());
        Collections.sort(cstProfiles);
        for (CstProfile cstProfile : cstProfiles) {
            if (!cstProfile.getTemplate().equals("1")) continue;
            Object line = cstProfile.getName();
            if (cstProfile.getDescription().length() > 0) {
                line = (String)line + " (" + cstProfile.getDescription() + ")";
            }
            this.combo.add((String)line);
            this.options.add(cstProfile);
        }
        return area;
    }

    private void createFirstName(Composite container) {
        Label lbtFirstName = new Label(container, 0);
        lbtFirstName.setText(Messages.CstProfile_name);
        GridData dataFirstName = new GridData();
        dataFirstName.grabExcessHorizontalSpace = true;
        dataFirstName.horizontalAlignment = 4;
        this.txtFirstName = new Text(container, 2048);
        this.txtFirstName.setLayoutData((Object)dataFirstName);
    }

    private void createLastName(Composite container) {
        Label lbtLastName = new Label(container, 0);
        lbtLastName.setText(Messages.CstCategory_description);
        GridData dataLastName = new GridData();
        dataLastName.grabExcessHorizontalSpace = true;
        dataLastName.horizontalAlignment = 4;
        this.lastNameText = new Text(container, 2048);
        this.lastNameText.setLayoutData((Object)dataLastName);
    }

    protected boolean isResizable() {
        return true;
    }

    private void saveInput() {
        this.groupName = this.txtFirstName.getText();
        this.groupDescription = this.lastNameText.getText();
        if (this.combo.getSelectionIndex() > -1) {
            this.selectedProfile = this.options.get(this.combo.getSelectionIndex());
        }
    }

    protected void okPressed() {
        this.saveInput();
        super.okPressed();
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getGroupDescription() {
        return this.groupDescription;
    }

    public CstProfile getProfileToCopyFrom() {
        return this.selectedProfile;
    }
}

