/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.stickynotes.ui;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.Heartbeat;
import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.events.RefreshingPartListener;
import ch.elexis.core.ui.preferences.ConfigServicePreferenceStore;
import ch.elexis.core.ui.text.EnhancedTextField;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.IRefreshable;
import ch.elexis.data.Patient;
import ch.elexis.stickynotes.Messages;
import ch.elexis.stickynotes.data.StickyNote;
import jakarta.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.ViewPart;

public class StickyNotesView
extends ViewPart
implements IRefreshable,
Heartbeat.HeartListener {
    private ScrolledForm form;
    EnhancedTextField etf;
    Patient actPatient;
    StickyNote actNote;
    ConfigServicePreferenceStore prefs;
    private RefreshingPartListener udpateOnVisible = new RefreshingPartListener(this){

        public void partDeactivated(IWorkbenchPartReference partRef) {
            if (StickyNotesView.this.actPatient != null) {
                if (StickyNotesView.this.actNote == null) {
                    StickyNotesView.this.actNote = StickyNote.load(StickyNotesView.this.actPatient);
                }
                StickyNotesView.this.actNote.setText(StickyNotesView.this.etf.getContentsAsXML());
            }
        }

        public void partVisible(IWorkbenchPartReference partRef) {
            CoreHub.heart.addListener((Heartbeat.HeartListener)StickyNotesView.this);
            super.partVisible(partRef);
        }

        public void partHidden(IWorkbenchPartReference partRef) {
            CoreHub.heart.removeListener((Heartbeat.HeartListener)StickyNotesView.this);
        }
    };

    @Inject
    void activePatient(@Optional IPatient patient) {
        CoreUiUtil.runAsyncIfActive(() -> {
            if (patient != null) {
                this.doSelect((Patient)NoPoUtil.loadAsPersistentObject((Identifiable)patient));
            } else {
                this.deselect();
            }
        }, (Object)this.form);
    }

    @Inject
    void activeUser(@Optional IUser user) {
        Display.getDefault().asyncExec(() -> {
            if (user != null) {
                this.prefs = new ConfigServicePreferenceStore(ConfigServicePreferenceStore.Scope.USER);
            }
        });
    }

    public void createPartControl(Composite parent) {
        this.prefs = new ConfigServicePreferenceStore(ConfigServicePreferenceStore.Scope.USER);
        this.form = UiDesk.getToolkit().createScrolledForm(parent);
        this.form.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        Composite body = this.form.getBody();
        body.setLayout((Layout)new GridLayout());
        this.etf = new EnhancedTextField(body);
        this.etf.connectGlobalActions(this.getViewSite());
        this.etf.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.getSite().getPage().addPartListener((IPartListener2)this.udpateOnVisible);
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener2)this.udpateOnVisible);
        super.dispose();
    }

    public void setFocus() {
        this.etf.setFocus();
    }

    public void refresh() {
        this.activePatient(ContextServiceHolder.get().getActivePatient().orElse(null));
    }

    private void deselect() {
        this.actNote = null;
        this.actPatient = null;
        this.etf.setText("");
        this.setPartName(Messages.StickyNotesView_StickyNotesName);
    }

    private void doSelect(Patient pat) {
        if (pat == null) {
            this.deselect();
        } else {
            this.actPatient = pat;
            this.actNote = StickyNote.load(this.actPatient);
            this.etf.setText(this.actNote.getText());
            this.setPartName(Messages.StickyNotesView_StickyNotesNameDash + this.actPatient.getLabel());
            RGB rgbBackground = PreferenceConverter.getColor((IPreferenceStore)this.prefs, (String)"sticky_notes/col_background");
            RGB rgbForeground = PreferenceConverter.getColor((IPreferenceStore)this.prefs, (String)"sticky_notes/col_foreground");
            if (rgbBackground.equals((Object)rgbForeground)) {
                rgbBackground = Display.getCurrent().getSystemColor(7).getRGB();
                rgbForeground = Display.getCurrent().getSystemColor(2).getRGB();
            }
            UiDesk.getColorRegistry().put("sticky_notes/col_background", rgbBackground);
            Color back = UiDesk.getColorRegistry().get("sticky_notes/col_background");
            UiDesk.getColorRegistry().put("sticky_notes/col_foreground", rgbForeground);
            Color fore = UiDesk.getColorRegistry().get("sticky_notes/col_foreground");
            this.etf.getControl().setBackground(back);
            this.etf.getControl().setForeground(fore);
        }
    }

    public void heartbeat() {
        if (this.actPatient == null) {
            this.actPatient = ElexisEventDispatcher.getSelectedPatient();
        }
        if (this.actPatient != null && this.actNote == null) {
            this.actNote = StickyNote.load(this.actPatient);
        }
    }
}

