/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.regiomed.order.ui.model;

import ch.elexis.regiomed.order.model.RegiomedProductLookupResponse;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class SearchProductViewModel {
    private final RegiomedProductLookupResponse.ProductResult product;
    private final int index;
    private final Map<String, Integer> localStocks = new HashMap<String, Integer>();

    public SearchProductViewModel(RegiomedProductLookupResponse.ProductResult product, int index) {
        this.product = product;
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public String getProdName() {
        return this.escapeHtml(this.product.prodName);
    }

    public String getManufacturer() {
        return this.escapeHtml(this.product.manufacturer);
    }

    public String getEan() {
        return this.escapeHtml(this.product.ean);
    }

    public String getMessage() {
        return this.escapeHtml(this.product.message);
    }

    public String getPrice() {
        return String.format("%.2f", this.product.price);
    }

    public String getStock() {
        return this.escapeHtml(this.product.availableInventory);
    }

    public boolean hasStock() {
        return StringUtils.isNotBlank((CharSequence)this.product.availableInventory);
    }

    public void addLocalStock(String stockCode, int quantity) {
        this.localStocks.put(stockCode, quantity);
    }

    public Map<String, Integer> getLocalStocks() {
        return this.localStocks;
    }

    public int getTotalLocalStock() {
        return this.localStocks.values().stream().mapToInt(Integer::intValue).sum();
    }

    public String getLocalStocksJson() {
        String json = this.localStocks.entrySet().stream().map(e -> "\"" + (String)e.getKey() + "\":" + String.valueOf(e.getValue())).collect(Collectors.joining(","));
        return "{" + json + "}";
    }

    public int getColorIndexForStock(String stockCode) {
        if (stockCode == null) {
            return 0;
        }
        return Math.abs(stockCode.hashCode()) % 5;
    }

    public String getRowColorClass() {
        if (this.localStocks.isEmpty()) {
            return "";
        }
        if (this.localStocks.size() > 1) {
            return "stock-row-mixed";
        }
        String stockCode = this.localStocks.keySet().iterator().next();
        return "stock-row-" + this.getColorIndexForStock(stockCode);
    }

    private String escapeHtml(String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return "";
        }
        return text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;");
    }

    private int getHueForStock(String stockCode) {
        if (stockCode == null) {
            return 0;
        }
        return Math.abs(stockCode.hashCode() + 10) % 360;
    }

    public String getStockBadgeStyle(String stockCode) {
        int hue = this.getHueForStock(stockCode);
        return "background-color: hsl(" + hue + ", 30%, 50%); color: white;";
    }

    public String getRowStyle() {
        if (this.localStocks.isEmpty()) {
            return "";
        }
        if (this.localStocks.size() > 1) {
            return "background-color: #fffdf0; border-left: 4px solid #e0c060;";
        }
        String stockCode = this.localStocks.keySet().iterator().next();
        int hue = this.getHueForStock(stockCode);
        return "background-color: hsl(" + hue + ", 50%, 92%); border-left: 4px solid hsl(" + hue + ", 50%, 40%);";
    }
}

