/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.regiomed.order.ui;

import ch.elexis.regiomed.order.messages.Messages;
import ch.elexis.regiomed.order.model.RegiomedAlternativesResponse;
import ch.elexis.regiomed.order.model.RegiomedOrderResponse;
import ch.elexis.regiomed.order.service.RegiomedServerService;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class RegiomedCheckController {
    private final RegiomedOrderResponse response;
    private final RegiomedServerService serverService;
    private final Set<String> removedIdentifiers = new HashSet<String>();
    private final Map<String, String> replacements = new HashMap<String, String>();
    private final Map<String, String> replacementNames = new HashMap<String, String>();
    private final Map<String, Integer> replacementInventory = new HashMap<String, Integer>();
    private final Set<String> forcedItems = new HashSet<String>();
    private final Set<String> articlesWithAlternatives = new HashSet<String>();

    public RegiomedCheckController(RegiomedOrderResponse response, RegiomedServerService serverService) {
        this.response = response;
        this.serverService = serverService;
        if (response.getAlternatives() != null) {
            response.getAlternatives().forEach(alt -> {
                boolean bl = this.articlesWithAlternatives.add(this.makeKey(alt.getPharmaCodeOrg(), alt.getEanIDOrg()));
            });
        }
    }

    public void replaceArticle(String orgKey, String newKey, String newName, int newStock) {
        this.replacements.put(orgKey, newKey);
        this.replacementNames.put(orgKey, newName);
        this.replacementInventory.put(orgKey, newStock);
        this.forcedItems.remove(orgKey);
        this.updateArticleStatus(orgKey);
    }

    public void updateQuantity(String pharma, String ean, int newQty) {
        if (this.response.getArticles() == null) {
            return;
        }
        String key = this.makeKey(pharma, ean);
        for (RegiomedOrderResponse.ArticleResult art : this.response.getArticles()) {
            if (!this.makeKey(art.getPharmaCode(), art.getEanID()).equals(key)) continue;
            art.setQuantity(newQty);
            this.updateArticleStatus(key);
            break;
        }
    }

    public void removeArticle(String key) {
        if (!this.removedIdentifiers.contains(key)) {
            this.removedIdentifiers.add(key);
            this.replacements.remove(key);
            this.replacementInventory.remove(key);
            this.forcedItems.remove(key);
        }
    }

    public void resetArticle(String key) {
        this.removedIdentifiers.remove(key);
        this.replacements.remove(key);
        this.replacementNames.remove(key);
        this.replacementInventory.remove(key);
        this.forcedItems.remove(key);
    }

    public void forceArticle(String key) {
        this.forcedItems.add(key);
    }

    public void loadMissingAlternatives() {
        if (this.response.getArticles() == null) {
            return;
        }
        List toLoad = this.response.getArticles().stream().filter(this::isCalculatedError).filter(a -> !this.articlesWithAlternatives.contains(this.makeKey(a.getPharmaCode(), a.getEanID()))).collect(Collectors.toList());
        for (RegiomedOrderResponse.ArticleResult a2 : toLoad) {
            this.fetchMissingAlternatives(a2);
        }
    }

    private void updateArticleStatus(String key) {
        for (RegiomedOrderResponse.ArticleResult art : this.response.getArticles()) {
            boolean isStockOK;
            if (!this.makeKey(art.getPharmaCode(), art.getEanID()).equals(key)) continue;
            boolean isReplaced = this.replacements.containsKey(key);
            int qty = art.getQuantity();
            int stock = isReplaced ? this.replacementInventory.getOrDefault(key, Integer.MAX_VALUE).intValue() : art.getAvailableInventory();
            boolean bl = isStockOK = stock <= 0 || qty <= stock;
            if (isStockOK) {
                art.setSuccessAvailability(true);
                art.setAvailState(Messages.RegiomedCheckDialog_Yes);
                String successMsg = Messages.RegiomedCheckDialog_AvailableQtyAdjusted;
                art.setAvailMsg(successMsg);
                if (!isReplaced) break;
                art.setSuccess(true);
                art.setInfo(successMsg);
                break;
            }
            art.setSuccessAvailability(false);
            if (isReplaced) {
                art.setSuccess(false);
            }
            art.setAvailState(Messages.RegiomedCheckDialog_No);
            String displayStock = stock == Integer.MAX_VALUE ? "?" : String.valueOf(stock);
            String errorMsg = MessageFormat.format(Messages.RegiomedCheckDialog_QtyExceedsStock, qty, displayStock);
            art.setAvailMsg(errorMsg);
            art.setInfo(errorMsg);
            if (this.articlesWithAlternatives.contains(key)) break;
            this.fetchMissingAlternatives(art);
            break;
        }
    }

    private void fetchMissingAlternatives(RegiomedOrderResponse.ArticleResult art) {
        RegiomedAlternativesResponse altResp = this.serverService.fetchAlternatives(String.valueOf(art.getPharmaCode()));
        if (altResp != null && altResp.getAlternatives() != null && !altResp.getAlternatives().isEmpty()) {
            if (this.response.getAlternatives() == null) {
                this.response.setAlternatives(new ArrayList<RegiomedOrderResponse.AlternativeResult>());
            }
            List converted = altResp.getAlternatives().stream().map(item -> {
                RegiomedOrderResponse.AlternativeResult res = new RegiomedOrderResponse.AlternativeResult();
                res.setPharmaCodeOrg(art.getPharmaCode());
                res.setEanIDOrg(art.getEanID());
                res.setDescriptionOrg(art.getDescription());
                res.setPharmaCode(item.getPharmaCode());
                res.setEanID(item.getEan());
                res.setDescription(item.getProdName());
                res.setPrice(item.getPrice());
                res.setAvailState(item.getAvailState());
                res.setAvailMsg(item.getAvailMessage());
                res.setAltType(item.getAltType());
                return res;
            }).collect(Collectors.toList());
            this.response.getAlternatives().addAll(converted);
            this.articlesWithAlternatives.add(this.makeKey(art.getPharmaCode(), art.getEanID()));
        }
    }

    public boolean isCalculatedError(RegiomedOrderResponse.ArticleResult a) {
        String key = this.makeKey(a.getPharmaCode(), a.getEanID());
        if (this.removedIdentifiers.contains(key)) {
            return false;
        }
        if (this.forcedItems.contains(key)) {
            return false;
        }
        if (this.replacements.containsKey(key)) {
            return !a.isSuccess();
        }
        if (!a.isSuccess()) {
            return true;
        }
        if (a.getAvailableInventory() > 0 && a.getQuantity() > a.getAvailableInventory()) {
            return true;
        }
        if (this.articlesWithAlternatives.contains(key)) {
            return !a.isSuccessAvailability();
        }
        return false;
    }

    public int getRemainingErrors() {
        if (this.response.getArticles() == null) {
            return 0;
        }
        return (int)this.response.getArticles().stream().filter(this::isCalculatedError).count();
    }

    public String makeKey(Object pharma, Object ean) {
        return (String)StringUtils.defaultIfBlank((CharSequence)String.valueOf(pharma), (CharSequence)"0") + ":" + (String)StringUtils.defaultIfBlank((CharSequence)String.valueOf(ean), (CharSequence)"0");
    }

    public Map<String, String> getReplacements() {
        return this.replacements;
    }

    public Map<String, String> getReplacementNames() {
        return this.replacementNames;
    }

    public Map<String, Integer> getReplacementInventory() {
        return this.replacementInventory;
    }

    public Set<String> getRemovedIdentifiers() {
        return this.removedIdentifiers;
    }

    public Set<String> getForcedItems() {
        return this.forcedItems;
    }

    public RegiomedOrderResponse getResponse() {
        return this.response;
    }
}

