/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.regiomed.order.model;

import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IOrderEntry;
import ch.elexis.core.ui.exchange.ArticleUtil;
import ch.elexis.regiomed.order.config.RegiomedConfig;
import ch.elexis.regiomed.order.model.RegiomedOrderRequest;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class RegiomedOrderMapper {
    public RegiomedOrderRequest mapToRequest(RegiomedConfig cfg, List<IOrderEntry> entries) {
        RegiomedOrderRequest req = new RegiomedOrderRequest();
        req.setUserEmail(cfg.getEmail());
        if (StringUtils.isNotBlank((CharSequence)cfg.getPassword())) {
            String encodedPwd = Base64.getEncoder().encodeToString(cfg.getPassword().getBytes(StandardCharsets.UTF_8));
            req.setB64Password(encodedPwd);
        } else {
            req.setB64Password(null);
        }
        req.setCheckOrder(cfg.isCheckOrder());
        req.setDeliveryType("DEFAULT");
        if (cfg.isErrorEmailEnabled() && StringUtils.isNotBlank((CharSequence)cfg.getErrorEmailAddress()) && this.isValidEmail(cfg.getErrorEmailAddress())) {
            req.setErrorEmail(cfg.getErrorEmailAddress().trim());
        } else {
            req.setErrorEmail(null);
        }
        req.setDeliveryDate(null);
        req.setPatInfo(null);
        req.setSendersUniqueID(null);
        req.setReference(null);
        for (IOrderEntry entry : entries) {
            req.getArticles().add(this.mapArticle(entry));
        }
        return req;
    }

    private RegiomedOrderRequest.Article mapArticle(IOrderEntry entry) {
        IArticle art = entry.getArticle();
        String pharmaCodeStr = ArticleUtil.getPharmaCode((IArticle)art);
        String eanStr = ArticleUtil.getEan((IArticle)art);
        int pharmaCode = 0;
        long eanId = 0L;
        try {
            if (StringUtils.isNotBlank((CharSequence)pharmaCodeStr)) {
                pharmaCode = Integer.parseInt(pharmaCodeStr.trim());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            if (StringUtils.isNotBlank((CharSequence)eanStr)) {
                eanId = Long.parseLong(eanStr.trim());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        RegiomedOrderRequest.Article a = new RegiomedOrderRequest.Article();
        a.setPharmaCode(pharmaCode);
        a.setEanID(eanId);
        a.setDescription(art.getName());
        a.setQuantity(entry.getAmount());
        return a;
    }

    private boolean isValidEmail(String value) {
        String v = StringUtils.trimToEmpty((String)value);
        int at = v.indexOf(64);
        int dot = v.lastIndexOf(46);
        return at > 0 && dot > at + 1 && dot < v.length() - 1;
    }
}

