/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.regiomed.order.client;

import ch.elexis.regiomed.order.config.RegiomedConfig;
import ch.elexis.regiomed.order.model.RegiomedAlternativesResponse;
import ch.elexis.regiomed.order.model.RegiomedOrderRequest;
import ch.elexis.regiomed.order.model.RegiomedOrderResponse;
import ch.elexis.regiomed.order.model.RegiomedProductLookupResponse;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegiomedOrderClient {
    private static final Logger log = LoggerFactory.getLogger(RegiomedOrderClient.class);
    private final Gson gson = new GsonBuilder().serializeNulls().create();

    public RegiomedOrderResponse sendOrderWithToken(RegiomedConfig config, RegiomedOrderRequest request) throws Exception {
        String token = this.fetchToken(config);
        request.clearPasswordForTokenAuth();
        String url = config.getOrderEndpoint();
        String responseBody = this.executeRequest(url, "POST", token, request);
        return this.parseResponse(responseBody, RegiomedOrderResponse.class);
    }

    public RegiomedProductLookupResponse searchProducts(RegiomedConfig config, String criteria) throws Exception {
        String token;
        if (StringUtils.isBlank((CharSequence)criteria)) {
            return new RegiomedProductLookupResponse();
        }
        String encodedCriteria = URLEncoder.encode(criteria, StandardCharsets.UTF_8).replace("+", "%20");
        String url = config.getFuzzySearchEndpoint() + encodedCriteria;
        String responseBody = this.executeRequest(url, "GET", token = this.fetchToken(config), null);
        RegiomedProductLookupResponse result = this.parseResponse(responseBody, RegiomedProductLookupResponse.class);
        return result != null ? result : new RegiomedProductLookupResponse();
    }

    public RegiomedAlternativesResponse getAlternatives(RegiomedConfig config, String type, String id) {
        if (StringUtils.isBlank((CharSequence)type) || StringUtils.isBlank((CharSequence)id)) {
            return new RegiomedAlternativesResponse();
        }
        String baseUrl = config.getAlternativesFlexEndpoint();
        String url = baseUrl + type + "/" + id;
        try {
            String token = this.fetchToken(config);
            String responseBody = this.executeRequest(url, "GET", token, null);
            RegiomedAlternativesResponse result = this.parseResponse(responseBody, RegiomedAlternativesResponse.class);
            return result != null ? result : new RegiomedAlternativesResponse();
        }
        catch (Exception e) {
            if (e.getMessage() != null && e.getMessage().contains("HTTP 404")) {
                log.info("Alternatives service not available (404) for article: " + id);
            } else {
                log.warn("Alternatives Error for URL " + url, (Throwable)e);
            }
            return new RegiomedAlternativesResponse();
        }
    }

    public boolean checkSearchAvailability(RegiomedConfig config) {
        try {
            this.searchProducts(config, "check_availability_ping");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String fetchToken(RegiomedConfig config) throws Exception {
        String url = config.getTokenEndpoint();
        String b64Password = Base64.getEncoder().encodeToString(config.getPassword().getBytes(StandardCharsets.UTF_8));
        RegiomedOrderRequest.TokenRequestBody body = new RegiomedOrderRequest.TokenRequestBody(config.getEmail(), b64Password);
        String responseBody = this.executeRequest(url, "POST", null, body);
        RegiomedOrderRequest.TokenResponse tokenResponse = (RegiomedOrderRequest.TokenResponse)this.gson.fromJson(responseBody, RegiomedOrderRequest.TokenResponse.class);
        if (tokenResponse == null || tokenResponse.getData() == null) {
            throw new RuntimeException("No data in token response.");
        }
        Object tokenToUse = null;
        if (StringUtils.isNotBlank((CharSequence)tokenResponse.getData().getToken())) {
            tokenToUse = tokenResponse.getData().getToken();
        } else if (StringUtils.isNotBlank((CharSequence)tokenResponse.getData().getTokenRaw())) {
            tokenToUse = tokenResponse.getData().getTokenRaw();
        }
        if (tokenToUse == null || StringUtils.isBlank((CharSequence)tokenToUse)) {
            throw new RuntimeException("No token included in response.");
        }
        if (!((String)tokenToUse).toLowerCase(Locale.ENGLISH).startsWith("bearer ")) {
            tokenToUse = "Bearer " + (String)tokenToUse;
        }
        return tokenToUse;
    }

    private String executeRequest(String urlStr, String method, String token, Object requestBody) throws Exception {
        int status;
        URI uri = URI.create(urlStr);
        URL url = uri.toURL();
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod(method);
        conn.setUseCaches(false);
        conn.setRequestProperty("Accept", "application/json");
        if (StringUtils.isNotBlank((CharSequence)token)) {
            conn.setRequestProperty("Authorization", token.trim());
        }
        if ("POST".equals(method)) {
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
            if (requestBody != null) {
                Throwable throwable = null;
                Object var9_11 = null;
                try (OutputStreamWriter out = new OutputStreamWriter(conn.getOutputStream(), StandardCharsets.UTF_8);){
                    out.write(this.gson.toJson(requestBody));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
        InputStream in = (status = conn.getResponseCode()) >= 200 && status < 300 ? conn.getInputStream() : conn.getErrorStream();
        String responseBody = this.readStreamToString(in);
        if (status < 200 || status >= 300) {
            throw new RuntimeException("HTTP " + status + " Error. URL: " + urlStr + " Body: " + responseBody);
        }
        return responseBody;
    }

    private <T> T parseResponse(String json, Class<T> classOfT) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        try {
            String jsonToParse = json.trim();
            if (jsonToParse.startsWith("\"")) {
                jsonToParse = (String)this.gson.fromJson(jsonToParse, String.class);
            }
            return (T)this.gson.fromJson(jsonToParse, classOfT);
        }
        catch (Exception e) {
            log.warn("Parsing error for class " + classOfT.getSimpleName(), (Throwable)e);
            throw e;
        }
    }

    private String readStreamToString(InputStream in) throws Exception {
        if (in == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return sb.toString();
    }
}

