/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.regiomed.order.model;

import ch.elexis.regiomed.order.messages.Messages;
import ch.elexis.regiomed.order.model.RegiomedOrderResponse;
import java.util.List;
import java.util.stream.Collectors;

public class RegiomedResponseHelper {
    public static boolean isOverallSuccess(RegiomedOrderResponse response) {
        if (!response.isCheckSuccess()) {
            return false;
        }
        if (response.getArticlesNOK() > 0) {
            return false;
        }
        if (response.getArticles() != null) {
            return response.getArticles().stream().allMatch(RegiomedOrderResponse.ArticleResult::isSuccess);
        }
        return true;
    }

    public static String buildErrorMessage(RegiomedOrderResponse response) {
        List bad;
        StringBuilder sb = new StringBuilder();
        if (response.getMessage() != null && !response.getMessage().isBlank()) {
            sb.append(response.getMessage());
        } else {
            sb.append(Messages.RegiomedOrderResponse_GenericErrorMessage);
        }
        if (response.getArticles() != null && !(bad = response.getArticles().stream().filter(a -> !a.isSuccess()).collect(Collectors.toList())).isEmpty()) {
            sb.append("\n").append(Messages.RegiomedOrderResponse_ProblematicArticles);
            for (RegiomedOrderResponse.ArticleResult ar : bad) {
                sb.append("\n- ").append(ar.getDescription()).append(" (Pharma: ").append(ar.getPharmaCode()).append(")");
                if (ar.getAvailMsg() != null && !ar.getAvailMsg().isBlank()) {
                    sb.append(": ").append(ar.getAvailMsg());
                }
                if (ar.getInfo() == null || ar.getInfo().isBlank()) continue;
                sb.append(" [").append(ar.getInfo()).append("]");
            }
        }
        return sb.toString();
    }
}

