/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.regiomed.order.service;

import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.ICodeElement;
import ch.elexis.core.services.ICodeElementService;
import ch.elexis.core.services.ICodeElementServiceContribution;
import ch.elexis.core.services.holder.CodeElementServiceHolder;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegiomedLocalArticleService {
    private static final Logger log = LoggerFactory.getLogger(RegiomedLocalArticleService.class);

    public IArticle findLocalArticle(String ean, int pharmaCode, String prodName) {
        IArticle article;
        if (StringUtils.isNotBlank((CharSequence)ean) && (article = this.findArticleByCode(ean)) != null) {
            return article;
        }
        if (pharmaCode > 0 && (article = this.findArticleByCode(String.valueOf(pharmaCode))) != null) {
            return article;
        }
        return null;
    }

    private IArticle findArticleByCode(String code) {
        try {
            List articleContributions = CodeElementServiceHolder.get().getContributionsByTyp(ICodeElementService.CodeElementTyp.ARTICLE);
            for (ICodeElementServiceContribution contribution : articleContributions) {
                ICodeElement element;
                Optional loadFromCode = contribution.loadFromCode(code);
                if (!loadFromCode.isPresent() || !((element = (ICodeElement)loadFromCode.get()) instanceof IArticle)) continue;
                return (IArticle)element;
            }
        }
        catch (Exception e) {
            log.error("Error resolving article by code {}", (Object)code, (Object)e);
        }
        return null;
    }
}

