/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.regiomed.order.handler;

import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IOrder;
import ch.elexis.core.model.IOrderEntry;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.OrderEntryState;
import ch.elexis.core.services.IOrderService;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.OrderServiceHolder;
import ch.elexis.core.status.ElexisStatus;
import ch.elexis.core.ui.exchange.ArticleUtil;
import ch.elexis.core.ui.exchange.IDataSender;
import ch.elexis.core.ui.exchange.XChangeException;
import ch.elexis.core.ui.exchange.elements.XChangeElement;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.BestellView;
import ch.elexis.core.utils.CoreUtil;
import ch.elexis.core.utils.OsgiServiceUtil;
import ch.elexis.data.Bestellung;
import ch.elexis.data.PersistentObject;
import ch.elexis.regiomed.order.client.RegiomedOrderClient;
import ch.elexis.regiomed.order.config.RegiomedConfig;
import ch.elexis.regiomed.order.messages.Messages;
import ch.elexis.regiomed.order.model.RegiomedOrderRequest;
import ch.elexis.regiomed.order.model.RegiomedOrderResponse;
import ch.elexis.regiomed.order.ui.RegiomedCheckDialog;
import ch.rgw.tools.StringTool;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.statushandlers.StatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegiomedSender
implements IDataSender {
    private static final Logger log = LoggerFactory.getLogger(RegiomedSender.class);
    private final List<IOrderEntry> exportedEntries = new ArrayList<IOrderEntry>();
    private int counter;
    private final RegiomedOrderClient orderClient = new RegiomedOrderClient();
    private static final String ABORT_BY_USER = "ABORT_BY_USER";

    public boolean canHandle(Class<? extends PersistentObject> clazz) {
        return clazz.equals(Bestellung.class);
    }

    public XChangeElement store(Object output) throws XChangeException {
        if (output instanceof IOrder) {
            IOrder order = (IOrder)output;
            return this.addOrder(order);
        }
        throw new XChangeException("Can't handle object of class " + output.getClass().getName());
    }

    public void finalizeExport() throws XChangeException {
        if (this.counter == 0) {
            log.info("Order contains no articles to order from Regiomed supplier");
            return;
        }
        String err = "";
        RegiomedOrderResponse finalResponse = null;
        try {
            RegiomedOrderResponse response;
            RegiomedConfig config = RegiomedConfig.load();
            RegiomedOrderRequest request = RegiomedOrderRequest.fromEntries(config, this.exportedEntries);
            finalResponse = response = this.orderClient.sendOrderWithToken(config, request);
            if (!(request.isCheckOrder() || response.orderSent || response.overallSuccess())) {
                err = response.buildErrorMessage();
                log.error("Regiomed Direct Order error: {}", (Object)err);
                throw new XChangeException(err);
            }
            if (request.isCheckOrder()) {
                RegiomedCheckDialog dialog = new RegiomedCheckDialog(Display.getDefault().getActiveShell(), response);
                int result = dialog.open();
                if (result != 0) {
                    throw new XChangeException(ABORT_BY_USER);
                }
                Set<String> deletedIds = dialog.getRemovedIdentifiers();
                if (!deletedIds.isEmpty()) {
                    this.removeDeletedEntries(deletedIds);
                    if (this.exportedEntries.isEmpty()) {
                        SWTHelper.showInfo((String)Messages.RegiomedSender_AbortTitle, (String)Messages.RegiomedSender_AllArticlesDeleted);
                        throw new XChangeException(ABORT_BY_USER);
                    }
                    request = RegiomedOrderRequest.fromEntries(config, this.exportedEntries);
                }
                request.setCheckOrder(false);
                finalResponse = response = this.orderClient.sendOrderWithToken(config, request);
                if (!response.orderSent && !response.overallSuccess()) {
                    err = response.buildErrorMessage();
                    log.error("Regiomed Final Order error: {}", (Object)err);
                    throw new XChangeException(err);
                }
            }
            if (finalResponse.articlesNOK > 0) {
                String msg = MessageFormat.format(Messages.RegiomedSender_OrderPartiallySentText, finalResponse.articlesOK, finalResponse.articlesNOK);
                SWTHelper.showInfo((String)Messages.RegiomedSender_OrderPartiallySentTitle, (String)msg);
            } else if (!CoreUtil.isTestMode()) {
                SWTHelper.showInfo((String)Messages.RegiomedSender_SuccessTitle, (String)Messages.RegiomedSender_SuccessText);
            }
            this.updateOrderEntriesStatus(this.exportedEntries, finalResponse);
            this.exportedEntries.clear();
        }
        catch (Exception ex) {
            if (ex instanceof XChangeException && ABORT_BY_USER.equals(ex.getMessage())) {
                throw (XChangeException)ex;
            }
            ElexisStatus status = new ElexisStatus(2, "ch.elexis.regiomed.order", 0, err, null, 2);
            StatusManager.getManager().handle((IStatus)status);
            String msg = Messages.RegiomedSender_ErrorSending;
            if (StringUtils.isNotBlank((CharSequence)err)) {
                msg = err;
            }
            log.error("Order could not be sent to Regiomed.", (Throwable)ex);
            SWTHelper.alert((String)Messages.RegiomedSender_ErrorTitle, (String)msg);
            throw new XChangeException(msg);
        }
    }

    private void removeDeletedEntries(Set<String> deletedIds) {
        Iterator<IOrderEntry> it = this.exportedEntries.iterator();
        while (it.hasNext()) {
            IOrderEntry entry = it.next();
            IArticle art = entry.getArticle();
            String pCode = ArticleUtil.getPharmaCode((IArticle)art);
            pCode = StringUtils.isBlank((CharSequence)pCode) ? "0" : pCode.replaceFirst("^0+(?!$)", "");
            String ean = ArticleUtil.getEan((IArticle)art);
            String key = pCode + ":" + (ean = StringUtils.isBlank((CharSequence)ean) ? "0" : ean.replaceFirst("^0+(?!$)", ""));
            if (!deletedIds.contains(key)) continue;
            it.remove();
            try {
                IOrder order = entry.getOrder();
                if (order == null) continue;
                IOrderService orderService = (IOrderService)OsgiServiceUtil.getService(IOrderService.class).orElseThrow(() -> new IllegalStateException("no order service found"));
                orderService.getHistoryService().logRemove(order, entry);
                order.getEntries().remove(entry);
                CoreModelServiceHolder.get().delete((Deleteable)entry);
            }
            catch (Exception e) {
                log.error("Error deleting OrderEntry", (Throwable)e);
            }
        }
    }

    private void updateOrderEntriesStatus(List<IOrderEntry> entries, RegiomedOrderResponse response) {
        if (response == null || response.articles == null) {
            for (IOrderEntry entry : entries) {
                entry.setState(OrderEntryState.ORDERED);
                CoreModelServiceHolder.get().save((Identifiable)entry);
            }
            return;
        }
        for (IOrderEntry entry : entries) {
            boolean isSuccess = false;
            IArticle art = entry.getArticle();
            String pharmaStr = ArticleUtil.getPharmaCode((IArticle)art);
            String eanStr = ArticleUtil.getEan((IArticle)art);
            for (RegiomedOrderResponse.ArticleResult res : response.articles) {
                if (StringUtils.isNotBlank((CharSequence)pharmaStr) && String.valueOf(res.pharmaCode).equals(pharmaStr)) {
                    isSuccess = res.success;
                    break;
                }
                if (!StringUtils.isNotBlank((CharSequence)eanStr) || !String.valueOf(res.eanID).equals(eanStr)) continue;
                isSuccess = res.success;
                break;
            }
            if (!isSuccess) continue;
            entry.setState(OrderEntryState.ORDERED);
            CoreModelServiceHolder.get().save((Identifiable)entry);
        }
    }

    private XChangeElement addOrder(IOrder order) throws XChangeException {
        String selDialogTitle;
        this.counter = 0;
        this.exportedEntries.clear();
        if (order == null) {
            throw new XChangeException(Messages.RegiomedSender_OrderEmpty);
        }
        List entries = order.getEntries();
        if (entries == null || entries.isEmpty()) {
            throw new XChangeException(Messages.RegiomedSender_OrderEmpty);
        }
        String supplierCfg = ConfigServiceHolder.getGlobal((String)"ch.elexis.regiomed.order/supplier", (String)"");
        IContact regiomedSupplier = BestellView.resolveDefaultSupplier((String)supplierCfg, (String)(selDialogTitle = Messages.RegiomedSender_NoSupplierTitle));
        if (regiomedSupplier == null) {
            return null;
        }
        for (IOrderEntry item : entries) {
            IContact articleSupplier = item.getProvider();
            if (!regiomedSupplier.equals(articleSupplier)) continue;
            IArticle artikel = item.getArticle();
            String pharmacode = ArticleUtil.getPharmaCode((IArticle)artikel);
            String eanId = ArticleUtil.getEan((IArticle)artikel);
            String description = artikel.getName();
            int quantity = item.getAmount();
            boolean hasPharmacode = !StringTool.isNothing((Object)pharmacode);
            boolean hasEan = StringUtils.isNotBlank((CharSequence)eanId);
            if (!hasPharmacode && !hasEan || quantity < 1) {
                StringBuilder msg = new StringBuilder();
                msg.append(MessageFormat.format(Messages.RegiomedSender_ArticleNotConfigured, StringUtils.defaultString((String)description)));
                if (!hasPharmacode && !hasEan) {
                    msg.append(Messages.RegiomedSender_NoPharmaNoEan);
                } else if (!hasPharmacode) {
                    msg.append(Messages.RegiomedSender_NoPharma);
                } else if (!hasEan) {
                    msg.append(Messages.RegiomedSender_NoEan);
                }
                if (quantity < 1) {
                    msg.append(Messages.RegiomedSender_InvalidAmount);
                }
                msg.append(Messages.RegiomedSender_PleaseCorrect);
                SWTHelper.alert((String)Messages.RegiomedSender_BadArticleTitle, (String)msg.toString());
                throw new XChangeException("Bad Article Config: Pharmacode: " + pharmacode + ", EAN: " + eanId + ", Name: " + description + ", Quantity: " + quantity);
            }
            this.exportedEntries.add(item);
            ++this.counter;
        }
        if (this.counter == 0) {
            throw new XChangeException(Messages.RegiomedSender_NoArticlesForSupplier);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public boolean canHandle(Identifiable identifiable) {
        String[] supplierIds;
        if (!(identifiable instanceof IOrder)) {
            return false;
        }
        IOrder iOrder = (IOrder)identifiable;
        String cfg = ConfigServiceHolder.getGlobal((String)"ch.elexis.regiomed.order/supplier", (String)"");
        if (StringUtils.isBlank((CharSequence)cfg)) {
            return false;
        }
        String[] stringArray = supplierIds = StringUtils.split((String)cfg, (char)',');
        int n = supplierIds.length;
        int n2 = 0;
        while (n2 < n) {
            void order;
            String supplierId = stringArray[n2];
            IContact supplier = CoreModelServiceHolder.get().load(supplierId, IContact.class).orElse(null);
            if (supplier != null && OrderServiceHolder.get().containsSupplier((IOrder)order, supplier)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

