/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.regiomed.order.client;

import ch.elexis.regiomed.order.config.RegiomedConfig;
import ch.elexis.regiomed.order.model.RegiomedOrderRequest;
import ch.elexis.regiomed.order.model.RegiomedOrderResponse;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegiomedOrderClient {
    private static final Logger log = LoggerFactory.getLogger(RegiomedOrderClient.class);
    private final Gson gson = new GsonBuilder().serializeNulls().create();

    public RegiomedOrderResponse sendOrderWithToken(RegiomedConfig config, RegiomedOrderRequest request) throws Exception {
        Object cleanToken;
        String endpoint = config.getOrderEndpoint();
        String token = this.fetchToken(config);
        request.clearPasswordForTokenAuth();
        URI uri = URI.create(endpoint);
        URL serverURL = uri.toURL();
        HttpURLConnection conn = (HttpURLConnection)serverURL.openConnection();
        conn.setRequestMethod("POST");
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        conn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
        conn.setRequestProperty("Accept", "application/json");
        String authHeaderValue = null;
        if (StringUtils.isNotBlank((CharSequence)token)) {
            cleanToken = token.trim();
            authHeaderValue = cleanToken;
            conn.setRequestProperty("Authorization", authHeaderValue);
        }
        cleanToken = null;
        Object var10_12 = null;
        try (OutputStreamWriter out = new OutputStreamWriter(conn.getOutputStream(), StandardCharsets.UTF_8);){
            out.write(this.gson.toJson((Object)request));
        }
        catch (Throwable throwable) {
            if (cleanToken == null) {
                cleanToken = throwable;
            } else if (cleanToken != throwable) {
                ((Throwable)cleanToken).addSuppressed(throwable);
            }
            throw cleanToken;
        }
        int status = conn.getResponseCode();
        InputStream in = status >= 200 && status < 300 ? conn.getInputStream() : conn.getErrorStream();
        String responseBody = this.readStreamToString(in);
        if (status < 200 || status >= 300) {
            throw new RuntimeException("HTTP " + status + " Error. See log for details. Body: " + responseBody);
        }
        RegiomedOrderResponse response = null;
        if (StringUtils.isNotBlank((CharSequence)responseBody)) {
            try {
                String jsonToParse = responseBody.trim();
                if (jsonToParse.startsWith("\"")) {
                    jsonToParse = (String)this.gson.fromJson(jsonToParse, String.class);
                }
                response = (RegiomedOrderResponse)this.gson.fromJson(jsonToParse, RegiomedOrderResponse.class);
            }
            catch (Exception parseEx) {
                log.warn("Parsing error", (Throwable)parseEx);
                throw parseEx;
            }
        }
        return response;
    }

    private String fetchToken(RegiomedConfig config) throws Exception {
        String tokenUrl = config.getTokenEndpoint();
        String b64Password = Base64.getEncoder().encodeToString(config.getPassword().getBytes(StandardCharsets.UTF_8));
        RegiomedOrderRequest.TokenRequestBody body = new RegiomedOrderRequest.TokenRequestBody(config.getEmail(), b64Password);
        Gson gson = new Gson();
        URI uri = URI.create(tokenUrl);
        URL url = uri.toURL();
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setUseCaches(false);
        conn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
        conn.setRequestProperty("Accept", "application/json");
        String json = gson.toJson((Object)body);
        Throwable throwable = null;
        Object var11_13 = null;
        try (OutputStreamWriter out = new OutputStreamWriter(conn.getOutputStream(), StandardCharsets.UTF_8);){
            out.write(json);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        int status = conn.getResponseCode();
        InputStream in = status >= 200 && status < 300 ? conn.getInputStream() : conn.getErrorStream();
        StringBuilder sb = new StringBuilder();
        Throwable throwable3 = null;
        Object var14_18 = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (Throwable throwable4) {
            if (throwable3 == null) {
                throwable3 = throwable4;
            } else if (throwable3 != throwable4) {
                throwable3.addSuppressed(throwable4);
            }
            throw throwable3;
        }
        String responseBody = sb.toString();
        if (status < 200 || status >= 300) {
            throw new RuntimeException("Error retrieving token (HTTP " + status + "): " + responseBody);
        }
        RegiomedOrderRequest.TokenResponse tokenResponse = (RegiomedOrderRequest.TokenResponse)gson.fromJson(responseBody, RegiomedOrderRequest.TokenResponse.class);
        if (tokenResponse == null || tokenResponse.data == null) {
            throw new RuntimeException("No data in token response.");
        }
        String tokenToUse = null;
        if (StringUtils.isNotBlank((CharSequence)tokenResponse.data.tokenRaw)) {
            tokenToUse = tokenResponse.data.tokenRaw;
        } else if (StringUtils.isNotBlank((CharSequence)tokenResponse.data.token)) {
            tokenToUse = tokenResponse.data.token;
        }
        if (StringUtils.isBlank((CharSequence)tokenToUse)) {
            throw new RuntimeException("No token included in response.");
        }
        return tokenToUse;
    }

    private String readStreamToString(InputStream in) throws Exception {
        if (in == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return sb.toString();
    }
}

