/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.privatrechnung.model.internal;

import ch.elexis.core.common.ElexisEvent;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.PrivatLeistung;
import ch.elexis.core.jpa.model.adapter.AbstractModelService;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IElexisEntityManager;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.IStoreToStringContribution;
import ch.elexis.core.services.IXidService;
import ch.elexis.privatrechnung.model.internal.Leistung;
import ch.elexis.privatrechnung.model.internal.PrivatRechnungModelAdapterFactory;
import ch.elexis.privatrechnung.model.internal.PrivatRechnungModelQuery;
import jakarta.persistence.EntityManager;
import java.util.Optional;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.EventAdmin;
import org.slf4j.LoggerFactory;

@Component(property={"service.model.name=ch.elexis.privatrechnung.model"})
public class PrivatRechnungModelService
extends AbstractModelService
implements IModelService,
IStoreToStringContribution {
    public static final String XIDDOMAIN = "www.xid.ch/id/customservice";
    @Reference(target="(id=default)")
    private IElexisEntityManager entityManager;
    @Reference
    private IXidService xidService;
    @Reference
    private EventAdmin eventAdmin;

    @Activate
    public void activate() {
        this.adapterFactory = PrivatRechnungModelAdapterFactory.getInstance();
        this.xidService.localRegisterXIDDomainIfNotExists(XIDDOMAIN, "Privatleistung", 1);
    }

    public <T> IQuery<T> getQuery(Class<T> clazz, boolean refreshCache, boolean includeDeleted) {
        return new PrivatRechnungModelQuery<T>(clazz, refreshCache, (EntityManager)this.entityManager.getEntityManager(), includeDeleted);
    }

    protected EntityManager getEntityManager(boolean managed) {
        return (EntityManager)this.entityManager.getEntityManager(managed);
    }

    protected void closeEntityManager(EntityManager entityManager) {
        this.entityManager.closeEntityManager((Object)entityManager);
    }

    protected EventAdmin getEventAdmin() {
        return this.eventAdmin;
    }

    protected ElexisEvent getCreateEvent(Identifiable identifiable) {
        return null;
    }

    public Optional<String> storeToString(Identifiable identifiable) {
        if (identifiable instanceof Leistung) {
            return Optional.of("ch.elexis.privatrechnung.data.Leistung::" + identifiable.getId());
        }
        return Optional.empty();
    }

    public Optional<Identifiable> loadFromString(String storeToString) {
        if (storeToString.startsWith("ch.elexis.privatrechnung.data.Leistung::")) {
            String[] split = this.splitIntoTypeAndId(storeToString);
            String id = split[1];
            EntityManager em = (EntityManager)this.entityManager.getEntityManager();
            EntityWithId dbObject = (EntityWithId)em.find(PrivatLeistung.class, (Object)id);
            return Optional.ofNullable(PrivatRechnungModelAdapterFactory.getInstance().getModelAdapter(dbObject, null, false).orElse(null));
        }
        return Optional.empty();
    }

    public void clearCache() {
        this.entityManager.clearCache();
    }

    public Class<?> getEntityForType(String type) {
        if ("ch.elexis.privatrechnung.data.Leistung".equals(type)) {
            return PrivatLeistung.class;
        }
        return null;
    }

    public String getTypeForEntity(Object entityInstance) {
        if (entityInstance instanceof PrivatLeistung) {
            return "ch.elexis.privatrechnung.data.Leistung";
        }
        return null;
    }

    public String getTypeForModel(Class<?> interfaze) {
        Class entityClass = this.adapterFactory.getEntityClass(interfaze);
        if (entityClass != null) {
            try {
                return this.getTypeForEntity(entityClass.newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error getting type for model [" + String.valueOf(interfaze) + "]", (Throwable)e);
            }
        }
        return null;
    }

    protected IModelService getCoreModelService() {
        return null;
    }
}

