/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.pdfBills;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.mail.MailAccount;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.e4.jface.preference.URIFieldEditorComposite;
import ch.elexis.core.ui.preferences.ConfigServicePreferenceStore;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.utils.CoreUtil;
import ch.elexis.data.Mandant;
import ch.elexis.data.Query;
import ch.elexis.pdfBills.MailClientHolder;
import ch.elexis.pdfBills.print.PrintProcess;
import ch.elexis.pdfBills.print.PrinterSettingsDialog;
import ch.elexis.pdfBills.print.ScriptInitializer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PreferencePage
extends org.eclipse.jface.preference.PreferencePage
implements IWorkbenchPreferencePage {
    private TabFolder tabFolder;
    private TabItem t40Settings;
    private TabItem t44Settings;
    private TabItem mailConfig;
    private TabItem headerConfig;
    private TabItem outputConfig;
    private TabItem messageConfig;
    private Text headerLine1Text;
    private Text headerLine2Text;
    private Text reminderDays2Text;
    private Text reminderDays3Text;
    private Text mandantHeaderLine1Text;
    private Text mandantHeaderLine2Text;
    private Text mandantReminderDays2Text;
    private Text mandantReminderDays3Text;
    private Text pdfRnTextTP;
    private Text pdfRnTextTG;
    private Text pdfRnTextM1TG;
    private Text pdfRnTextM2TG;
    private Text pdfRnTextM3TG;
    private Text pdfRnTextM1TP;
    private Text pdfRnTextM2TP;
    private Text pdfRnTextM3TP;
    private Text printCommandText;
    private Label printerConfigLabel;
    private Label esrPrinterConfigLabel;
    private Button openDialogBtn;
    private Button openEsrDialogBtn;

    public void init(IWorkbench workbench) {
        this.setTitle("PDF Rechnungsdruck");
        this.setDescription("Hier k\u00f6nnen die Einstellungen f\u00fcr den PDF Rechnungsdruck vorgenommen werden.");
    }

    protected Control createContents(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayout((Layout)new GridLayout());
        this.tabFolder = new TabFolder(ret, 0);
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, false));
        this.t44Settings = new TabItem(this.tabFolder, 0);
        this.t44Settings.setText("Tarmed 4.4 / 4.5");
        this.createSettings(this.t44Settings, "4.4");
        this.getSettings(this.t44Settings);
        this.t40Settings = new TabItem(this.tabFolder, 0);
        this.t40Settings.setText("Tarmed 4.0");
        this.createSettings(this.t40Settings, "4.0");
        this.getSettings(this.t40Settings);
        this.mailConfig = new TabItem(this.tabFolder, 0);
        this.mailConfig.setText("Kopie per Mail");
        this.createMailConfig(this.mailConfig);
        this.headerConfig = new TabItem(this.tabFolder, 0);
        this.headerConfig.setText("Rechnungskopf");
        this.createHeaderConfig(this.headerConfig);
        this.outputConfig = new TabItem(this.tabFolder, 0);
        this.outputConfig.setText("Ausgabe");
        this.createOutputConfig(this.outputConfig);
        this.messageConfig = new TabItem(this.tabFolder, 0);
        this.messageConfig.setText("Rechnungstexte");
        this.createMessageConfig(this.messageConfig);
        final Composite printerConfigComposite = new Composite(ret, 0);
        printerConfigComposite.setLayout((Layout)new GridLayout(2, false));
        printerConfigComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        final Button couvertRight = new Button(printerConfigComposite, 32);
        couvertRight.setText("Couvert-Fenster links");
        couvertRight.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        couvertRight.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CoreHub.localCfg.set("pdf-output/esr.couvert.left", couvertRight.getSelection());
            }
        });
        couvertRight.setSelection(CoreHub.localCfg.get("pdf-output/esr.couvert.left", false));
        final Button doPrint = new Button(printerConfigComposite, 32);
        doPrint.setText("Direkter Druck");
        doPrint.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        doPrint.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CoreHub.localCfg.set("pdf-output/print.direct", doPrint.getSelection());
                PreferencePage.this.updatePrintDirect();
            }
        });
        doPrint.setSelection(CoreHub.localCfg.get("pdf-output/print.direct", false));
        Label label = new Label(printerConfigComposite, 0);
        label.setText("Drucker Konfiguration");
        this.openDialogBtn = new Button(printerConfigComposite, 8);
        this.openDialogBtn.setText("konfigurieren");
        this.openDialogBtn.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.openDialogBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrinterSettingsDialog dialog = new PrinterSettingsDialog(Display.getDefault().getActiveShell(), CoreHub.localCfg.get("pdf-output/print.printer", ""), CoreHub.localCfg.get("pdf-output/print.tray", ""));
                if (dialog.open() == 0) {
                    CoreHub.localCfg.set("pdf-output/print.printer", dialog.getPrinter());
                    CoreHub.localCfg.set("pdf-output/print.tray", dialog.getMediaTray());
                    PreferencePage.this.printerConfigLabel.setText(PreferencePage.this.getPrinterConfigText());
                    printerConfigComposite.layout();
                }
            }
        });
        this.printerConfigLabel = new Label(printerConfigComposite, 0);
        this.printerConfigLabel.setText(this.getPrinterConfigText());
        this.printerConfigLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        label = new Label(printerConfigComposite, 0);
        label.setText("ESR Drucker Konfiguration");
        this.openEsrDialogBtn = new Button(printerConfigComposite, 8);
        this.openEsrDialogBtn.setText("konfigurieren");
        this.openEsrDialogBtn.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.openEsrDialogBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrinterSettingsDialog dialog = new PrinterSettingsDialog(Display.getDefault().getActiveShell(), CoreHub.localCfg.get("pdf-output/esr.print.printer", ""), CoreHub.localCfg.get("pdf-output/esr.print.tray", ""));
                if (dialog.open() == 0) {
                    CoreHub.localCfg.set("pdf-output/esr.print.printer", dialog.getPrinter());
                    CoreHub.localCfg.set("pdf-output/esr.print.tray", dialog.getMediaTray());
                    PreferencePage.this.esrPrinterConfigLabel.setText(PreferencePage.this.getEsrPrinterConfigText());
                    printerConfigComposite.layout();
                }
            }
        });
        this.esrPrinterConfigLabel = new Label(printerConfigComposite, 0);
        this.esrPrinterConfigLabel.setText(this.getEsrPrinterConfigText());
        this.esrPrinterConfigLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        label = new Label(printerConfigComposite, 0);
        label.setText("\nFolgende Variablen k\u00f6nnen in den Befehlen verwendet werden.\nVariablen: " + PrintProcess.getVariablesAsString() + "\nZ.B.: befehl.exe -p [filename]\n");
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        label = new Label(printerConfigComposite, 0);
        label.setText("Befehl");
        this.printCommandText = new Text(printerConfigComposite, 2048);
        this.printCommandText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.printCommandText.setText(CoreHub.localCfg.get("pdf-output/print.command", ""));
        if (CoreUtil.isWindows()) {
            final Button useScript = new Button(printerConfigComposite, 32);
            useScript.setText("Vordefinierte Scripts und Befehle verwenden.");
            if (CoreHub.localCfg.get("pdf-output/print.usescript", false)) {
                useScript.setSelection(true);
                this.printCommandText.setEditable(false);
            }
            useScript.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CoreHub.localCfg.set("pdf-output/print.usescript", useScript.getSelection());
                    if (useScript.getSelection() && StringUtils.isBlank((CharSequence)PreferencePage.this.printCommandText.getText())) {
                        Properties commandsProperties = ScriptInitializer.getPrintCommands("/rsc/script/win/printcommands.properties");
                        if (commandsProperties != null && commandsProperties.get("printer") != null) {
                            PreferencePage.this.printCommandText.setText((String)commandsProperties.get("printer"));
                        }
                        PreferencePage.this.printCommandText.setEditable(false);
                    } else {
                        PreferencePage.this.printCommandText.setEditable(true);
                    }
                }
            });
        }
        this.updatePrintDirect();
        label = new Label(ret, 258);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        final Button useGuarantorPostalAddress = new Button(ret, 32);
        useGuarantorPostalAddress.setText("Postanschrift des Garanten verwenden (Kann zu Abweichungen zwischen XML und PDF f\u00fchren)");
        useGuarantorPostalAddress.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        useGuarantorPostalAddress.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CoreHub.localCfg.set("pdf-output/guarantor.postaladdress", useGuarantorPostalAddress.getSelection());
                PreferencePage.this.updatePrintDirect();
            }
        });
        useGuarantorPostalAddress.setSelection(CoreHub.localCfg.get("pdf-output/guarantor.postaladdress", false));
        return ret;
    }

    private void createOutputConfig(TabItem item) {
        Composite composite = new Composite((Composite)this.tabFolder, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        final Button useGlobalConfig = new Button(composite, 32);
        useGlobalConfig.setText("Globale Ausgabe Verzeichnisse");
        useGlobalConfig.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label lbl = new Label(composite, 0);
        lbl.setText("XML Verzeichnis");
        final URIFieldEditorComposite globalXmlDir = new URIFieldEditorComposite("pdf-outputter/global.output.xmldir", composite, 0);
        globalXmlDir.setPreferenceStore((IPreferenceStore)new ConfigServicePreferenceStore(ConfigServicePreferenceStore.Scope.GLOBAL));
        globalXmlDir.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        globalXmlDir.setFixedScheme("file");
        lbl = new Label(composite, 0);
        lbl.setText("PDF Verzeichnis");
        final URIFieldEditorComposite globalPdfDir = new URIFieldEditorComposite("pdf-outputter/global.output.pdfdir", composite, 0);
        globalPdfDir.setPreferenceStore((IPreferenceStore)new ConfigServicePreferenceStore(ConfigServicePreferenceStore.Scope.GLOBAL));
        globalPdfDir.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        globalPdfDir.setFixedScheme("file");
        useGlobalConfig.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CoreHub.localCfg.set("pdf-outputter/global.output.dirs", useGlobalConfig.getSelection());
                if (useGlobalConfig.getSelection()) {
                    globalXmlDir.setEnabled(true);
                    globalPdfDir.setEnabled(true);
                } else {
                    globalXmlDir.setEnabled(false);
                    globalPdfDir.setEnabled(false);
                }
            }
        });
        useGlobalConfig.setSelection(CoreHub.localCfg.get("pdf-outputter/global.output.dirs", true));
        item.setControl((Control)composite);
    }

    private void createHeaderConfig(TabItem item) {
        Composite composite = new Composite((Composite)this.tabFolder, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite, 0);
        label.setText("Standard-Briefkopf, falls kein Mandanten-spezifischer konfiguriert wurde");
        label = new Label(composite, 258);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        label = new Label(composite, 0);
        label.setText("ESR 1ste Zeile");
        this.headerLine1Text = new Text(composite, 2048);
        this.headerLine1Text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.headerLine1Text.setText(PreferencePage.getConfigTransferGlobal("pdf-output/esr.header.line1", ""));
        label = new Label(composite, 0);
        label.setText("ESR 2te Zeile");
        this.headerLine2Text = new Text(composite, 2048);
        this.headerLine2Text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.headerLine2Text.setText(PreferencePage.getConfigTransferGlobal("pdf-output/esr.header.line2", ""));
        label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        label.setText("Mandanten-spezifischer Briefkopf");
        label = new Label(composite, 258);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        label = new Label(composite, 0);
        label.setText("Mandant");
        final ComboViewer mandantsCombo = new ComboViewer(composite, 2048);
        mandantsCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        mandantsCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Mandant) {
                    return ((Mandant)element).getLabel();
                }
                return super.getText(element);
            }
        });
        Query query = new Query(Mandant.class);
        List input = query.execute();
        Collections.sort(input, new MandantComparator());
        mandantsCombo.setInput((Object)input);
        mandantsCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Mandant mandant = (Mandant)event.getStructuredSelection().getFirstElement();
                PreferencePage.this.mandantHeaderLine1Text.setText(ConfigServiceHolder.getGlobal((String)("pdf-output/esr.header.line1/" + mandant.getId()), (String)""));
                PreferencePage.this.mandantHeaderLine2Text.setText(ConfigServiceHolder.getGlobal((String)("pdf-output/esr.header.line2/" + mandant.getId()), (String)""));
            }
        });
        label = new Label(composite, 0);
        label.setText("ESR 1ste Zeile");
        this.mandantHeaderLine1Text = new Text(composite, 2048);
        this.mandantHeaderLine1Text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.mandantHeaderLine1Text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Mandant mandant = (Mandant)((IStructuredSelection)mandantsCombo.getSelection()).getFirstElement();
                if (mandant != null) {
                    ConfigServiceHolder.setGlobal((String)("pdf-output/esr.header.line1/" + mandant.getId()), (String)PreferencePage.this.mandantHeaderLine1Text.getText());
                }
            }
        });
        label = new Label(composite, 0);
        label.setText("ESR 2te Zeile");
        this.mandantHeaderLine2Text = new Text(composite, 2048);
        this.mandantHeaderLine2Text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.mandantHeaderLine2Text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Mandant mandant = (Mandant)((IStructuredSelection)mandantsCombo.getSelection()).getFirstElement();
                if (mandant != null) {
                    ConfigServiceHolder.setGlobal((String)("pdf-output/esr.header.line2/" + mandant.getId()), (String)PreferencePage.this.mandantHeaderLine2Text.getText());
                }
            }
        });
        item.setControl((Control)composite);
    }

    public static String getConfigTransferGlobal(String key, String defaultValue) {
        String localValue;
        String globalValue = ConfigServiceHolder.get().get(key, null);
        if (globalValue == null && StringUtils.isNotBlank((CharSequence)(localValue = CoreHub.localCfg.get(key, defaultValue)))) {
            ConfigServiceHolder.get().set(key, localValue);
            globalValue = localValue;
        }
        return globalValue != null ? globalValue : defaultValue;
    }

    private void createMailConfig(TabItem item) {
        Composite composite = new Composite((Composite)this.tabFolder, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite, 0);
        label.setText("Konfiguration des mail accounts f\u00fcr die \u00dcbermittlung der Rechnungskopie");
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        label = new Label(composite, 258);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Query query = new Query(Mandant.class);
        List mandants = query.execute();
        Collections.sort(mandants, new MandantComparator());
        for (final Mandant mandant : mandants) {
            if (mandant.isInactive()) continue;
            label = new Label(composite, 0);
            label.setText("Mandant " + mandant.getLabel());
            ComboViewer accountsViewer = new ComboViewer(composite, 2048);
            accountsViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            accountsViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            List<String> manadantAccounts = this.getSendMailAccounts(mandant);
            accountsViewer.setInput(manadantAccounts);
            accountsViewer.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            accountsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    Object selected = event.getStructuredSelection().getFirstElement();
                    if (selected instanceof String && StringUtils.isNotBlank((CharSequence)((String)selected))) {
                        ConfigServiceHolder.setGlobal((String)("pdf-output/mail.mandant.account/" + mandant.getId()), (String)((String)selected));
                    }
                }
            });
            String selectedAccount = ConfigServiceHolder.getGlobal((String)("pdf-output/mail.mandant.account/" + mandant.getId()), null);
            if (!StringUtils.isNotBlank((CharSequence)selectedAccount)) continue;
            accountsViewer.setSelection((ISelection)new StructuredSelection((Object)selectedAccount));
        }
        item.setControl((Control)composite);
    }

    private List<String> getSendMailAccounts(Mandant mandant) {
        ArrayList<String> ret = new ArrayList<String>();
        List accounts = MailClientHolder.get().getAccounts();
        for (String accountId : accounts) {
            Optional accountOptional = MailClientHolder.get().getAccount(accountId);
            if (!accountOptional.isPresent() || ((MailAccount)accountOptional.get()).getType() != MailAccount.TYPE.SMTP) continue;
            ret.add(accountId);
        }
        return ret;
    }

    public Text createMessageTextBox(Composite composite, String msgText) {
        Text textBox = new Text(composite, 2626);
        textBox.setLayoutData((Object)new GridData(771));
        textBox.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        textBox.setText(msgText);
        return textBox;
    }

    private void createMessageConfig(TabItem item) {
        Composite composite = new Composite((Composite)this.tabFolder, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        Label label = new Label(composite, 0);
        label.setText(Messages.Billing_Cfg_MsgTXT + "\nTP = Tiers Payant  TG = Tiers Garant");
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        label = new Label(composite, 258);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        label = new Label(composite, 0);
        label.setText(Messages.Billing_Cfg_Msg + " TP:");
        this.pdfRnTextTP = this.createMessageTextBox(composite, Messages.BillingDefaultMsg);
        this.pdfRnTextTP.setText(this.getValueOrDefault(ConfigServiceHolder.getGlobal((String)"pdf-output/pdf.txt.tp", (String)Messages.BillingDefaultMsg), Messages.BillingDefaultMsg));
        label = new Label(composite, 0);
        label.setText(Messages.Billing_Cfg_Msg + " TG:");
        this.pdfRnTextTG = this.createMessageTextBox(composite, Messages.BillingDefaultMsg);
        this.pdfRnTextTG.setText(this.getValueOrDefault(ConfigServiceHolder.getGlobal((String)"pdf-output/pdf.txt.tg", (String)Messages.BillingDefaultMsg), Messages.BillingDefaultMsg));
        label = new Label(composite, 0);
        label.setText(Messages.Billing_Cfg_Msg + " " + Messages.Core_Invoice_Reminder_1 + " TP:");
        this.pdfRnTextM1TP = this.createMessageTextBox(composite, Messages.BillingDefaultMsg_M1);
        this.pdfRnTextM1TP.setText(this.getValueOrDefault(ConfigServiceHolder.getGlobal((String)"pdf-output/pdf.txt.M1tp", (String)Messages.BillingDefaultMsg_M1), Messages.BillingDefaultMsg_M1));
        label = new Label(composite, 0);
        label.setText(Messages.Billing_Cfg_Msg + " " + Messages.Core_Invoice_Reminder_2 + " TP:");
        this.pdfRnTextM2TP = this.createMessageTextBox(composite, Messages.BillingDefaultMsg_M2);
        this.pdfRnTextM2TP.setText(this.getValueOrDefault(ConfigServiceHolder.getGlobal((String)"pdf-output/pdf.txt.M2tp", (String)Messages.BillingDefaultMsg_M2), Messages.BillingDefaultMsg_M2));
        label = new Label(composite, 0);
        label.setText(Messages.Billing_Cfg_Msg + " " + Messages.Core_Invoice_Reminder_3 + " TP:");
        this.pdfRnTextM3TP = this.createMessageTextBox(composite, Messages.BillingDefaultMsg_M3);
        this.pdfRnTextM3TP.setText(this.getValueOrDefault(ConfigServiceHolder.getGlobal((String)"pdf-output/pdf.txt.M3tp", (String)Messages.BillingDefaultMsg_M3), Messages.BillingDefaultMsg_M3));
        label = new Label(composite, 0);
        label.setText(Messages.Billing_Cfg_Msg + " " + Messages.Core_Invoice_Reminder_1 + " TG:");
        this.pdfRnTextM1TG = this.createMessageTextBox(composite, Messages.BillingDefaultMsg_M1);
        this.pdfRnTextM1TG.setText(this.getValueOrDefault(ConfigServiceHolder.getGlobal((String)"pdf-output/pdf.txt.M1tg", (String)Messages.BillingDefaultMsg_M1), Messages.BillingDefaultMsg_M1));
        label = new Label(composite, 0);
        label.setText(Messages.Billing_Cfg_Msg + " " + Messages.Core_Invoice_Reminder_2 + " TG:");
        this.pdfRnTextM2TG = this.createMessageTextBox(composite, Messages.BillingDefaultMsg_M2);
        this.pdfRnTextM2TG.setText(this.getValueOrDefault(ConfigServiceHolder.getGlobal((String)"pdf-output/pdf.txt.M2tg", (String)Messages.BillingDefaultMsg_M2), Messages.BillingDefaultMsg_M2));
        label = new Label(composite, 0);
        label.setText(Messages.Billing_Cfg_Msg + " " + Messages.Core_Invoice_Reminder_3 + " TG:");
        this.pdfRnTextM3TG = this.createMessageTextBox(composite, Messages.BillingDefaultMsg_M3);
        this.pdfRnTextM3TG.setText(this.getValueOrDefault(ConfigServiceHolder.getGlobal((String)"pdf-output/pdf.txt.M3tg", (String)Messages.BillingDefaultMsg_M3), Messages.BillingDefaultMsg_M3));
        item.setControl((Control)composite);
    }

    private String getValueOrDefault(String value, String defaultValue) {
        return StringUtils.isEmpty((CharSequence)value) ? defaultValue : value;
    }

    private void updatePrintDirect() {
        this.openDialogBtn.setEnabled(CoreHub.localCfg.get("pdf-output/print.direct", false));
        this.openEsrDialogBtn.setEnabled(CoreHub.localCfg.get("pdf-output/print.direct", false));
        this.printCommandText.setEnabled(CoreHub.localCfg.get("pdf-output/print.direct", false));
    }

    private String getEsrPrinterConfigText() {
        StringBuilder sb = new StringBuilder();
        if (!CoreHub.localCfg.get("pdf-output/esr.print.printer", "").isEmpty()) {
            sb.append(CoreHub.localCfg.get("pdf-output/esr.print.printer", ""));
        } else {
            sb.append("Kein Drucker");
        }
        if (!CoreHub.localCfg.get("pdf-output/esr.print.tray", "").isEmpty()) {
            sb.append(", Fach ").append(CoreHub.localCfg.get("pdf-output/esr.print.tray", ""));
        } else {
            sb.append(", Kein Fach");
        }
        return sb.toString();
    }

    private String getPrinterConfigText() {
        StringBuilder sb = new StringBuilder();
        if (!CoreHub.localCfg.get("pdf-output/print.printer", "").isEmpty()) {
            sb.append(CoreHub.localCfg.get("pdf-output/print.printer", ""));
        } else {
            sb.append("Kein Drucker");
        }
        if (!CoreHub.localCfg.get("pdf-output/print.tray", "").isEmpty()) {
            sb.append(", Fach ").append(CoreHub.localCfg.get("pdf-output/print.tray", ""));
        } else {
            sb.append(", Kein Fach");
        }
        return sb.toString();
    }

    public boolean performOk() {
        this.saveSettings(this.t40Settings);
        this.saveSettings(this.t44Settings);
        this.saveSettings(this.messageConfig);
        return super.performOk();
    }

    private void saveSettings(TabItem item) {
        Composite composite = (Composite)item.getControl();
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Text && control.getData() instanceof String) {
                Text text = (Text)control;
                String cfgKey = (String)control.getData();
                String value = text.getText();
                if (value != null && !value.isEmpty() && this.checkValue(value)) {
                    CoreHub.localCfg.set(cfgKey, value);
                }
            }
            ++n2;
        }
        ConfigServiceHolder.setGlobal((String)"pdf-output/esr.header.line1", (String)this.headerLine1Text.getText());
        ConfigServiceHolder.setGlobal((String)"pdf-output/esr.header.line2", (String)this.headerLine2Text.getText());
        CoreHub.localCfg.set("pdf-output/print.command", this.printCommandText.getText());
        ConfigServiceHolder.setGlobal((String)"pdf-output/pdf.txt.tg", (String)this.pdfRnTextTG.getText());
        ConfigServiceHolder.setGlobal((String)"pdf-output/pdf.txt.tp", (String)this.pdfRnTextTP.getText());
        ConfigServiceHolder.setGlobal((String)"pdf-output/pdf.txt.M1tg", (String)this.pdfRnTextM1TG.getText());
        ConfigServiceHolder.setGlobal((String)"pdf-output/pdf.txt.M2tg", (String)this.pdfRnTextM2TG.getText());
        ConfigServiceHolder.setGlobal((String)"pdf-output/pdf.txt.M3tg", (String)this.pdfRnTextM3TG.getText());
        ConfigServiceHolder.setGlobal((String)"pdf-output/pdf.txt.M1tp", (String)this.pdfRnTextM1TP.getText());
        ConfigServiceHolder.setGlobal((String)"pdf-output/pdf.txt.M2tp", (String)this.pdfRnTextM2TP.getText());
        ConfigServiceHolder.setGlobal((String)"pdf-output/pdf.txt.M3tp", (String)this.pdfRnTextM3TP.getText());
        CoreHub.localCfg.flush();
    }

    public boolean checkValue(String value) {
        try {
            Float.parseFloat(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private void getSettings(TabItem item) {
        Composite composite = (Composite)item.getControl();
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Text && control.getData() instanceof String) {
                Text text = (Text)control;
                String cfgKey = (String)control.getData();
                text.setText(PreferencePage.getSetting(cfgKey));
            }
            ++n2;
        }
    }

    public static String getSetting(String cfgKey) {
        return CoreHub.localCfg.get(cfgKey, PreferencePage.getDefault(cfgKey));
    }

    private static String getDefault(String cfgKey) {
        String oldKey = cfgKey.replaceFirst("4.4/", "").replaceFirst("4.0/", "");
        String oldSetting = CoreHub.localCfg.get(oldKey, null);
        if (oldSetting != null) {
            return oldSetting;
        }
        if (cfgKey.endsWith("margin.left")) {
            return "1.5";
        }
        if (cfgKey.endsWith("margin.right")) {
            return "0.7";
        }
        if (cfgKey.endsWith("margin.top")) {
            return "1";
        }
        if (cfgKey.endsWith("margin.bottom")) {
            return "1.5";
        }
        if (cfgKey.endsWith("margin.besr.vertical")) {
            return "0.75";
        }
        if (cfgKey.endsWith("margin.besr.horizontal")) {
            return "0.0";
        }
        return "";
    }

    private void createSettings(TabItem item, String version) {
        Composite composite = new Composite((Composite)this.tabFolder, 0);
        composite.setLayout((Layout)new GridLayout());
        new Label(composite, 256).setText("Rand links [cm]");
        Text pdfLeftMargin = new Text(composite, 128);
        pdfLeftMargin.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)2, (boolean)false));
        pdfLeftMargin.setData((Object)("pdf-output/" + version + "/margin.left"));
        new Label(composite, 512).setText("Rand rechts [cm]");
        Text pdfRightMargin = new Text(composite, 128);
        pdfRightMargin.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)2, (boolean)false));
        pdfRightMargin.setData((Object)("pdf-output/" + version + "/margin.right"));
        new Label(composite, 1024).setText("Rand oben [cm]");
        Text pdfTopMargin = new Text(composite, 128);
        pdfTopMargin.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)2, (boolean)false));
        pdfTopMargin.setData((Object)("pdf-output/" + version + "/margin.top"));
        new Label(composite, 128).setText("Rand unten [cm]");
        Text pdfBottumMagin = new Text(composite, 128);
        pdfBottumMagin.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)2, (boolean)false));
        pdfBottumMagin.setData((Object)("pdf-output/" + version + "/margin.bottom"));
        new Label(composite, 128).setText("BESR Abstand zu Rand unten [cm]");
        Text pdfBesrMarginVertical = new Text(composite, 128);
        pdfBesrMarginVertical.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)2, (boolean)false));
        pdfBesrMarginVertical.setData((Object)("pdf-output/" + version + "/margin.besr.vertical"));
        new Label(composite, 128).setText("BESR Abstand zu Rand rechts [cm]");
        Text pdfBesrMarginHorizontal = new Text(composite, 128);
        pdfBesrMarginHorizontal.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)2, (boolean)false));
        pdfBesrMarginHorizontal.setData((Object)("pdf-output/" + version + "/margin.besr.horizontal"));
        item.setControl((Control)composite);
    }

    private class MandantComparator
    implements Comparator<Mandant> {
        private MandantComparator() {
        }

        @Override
        public int compare(Mandant l, Mandant r) {
            return l.getLabel().compareTo(r.getLabel());
        }
    }
}

