/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.pdfBills.print;

import ch.elexis.core.data.activator.CoreHub;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.LoggerFactory;

public class ScriptInitializer {
    private String scriptFileRscPath;
    private String filename;

    public ScriptInitializer(String scriptFileRscPath) {
        this.scriptFileRscPath = scriptFileRscPath;
        int lastSlash = scriptFileRscPath.lastIndexOf(47);
        if (lastSlash > 0 && lastSlash < scriptFileRscPath.length()) {
            this.filename = scriptFileRscPath.substring(lastSlash + 1);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init() {
        if (this.filename == null || this.scriptFileRscPath == null) throw new IllegalStateException("Could not initialize script [" + this.scriptFileRscPath + "]");
        File folder = ScriptInitializer.getOrCreateScriptFolder();
        if (folder == null || !folder.exists()) return;
        File outFile = new File(folder, this.filename);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                FileOutputStream fout = new FileOutputStream(outFile);
                try {
                    try (InputStream fin = ScriptInitializer.class.getResourceAsStream(this.scriptFileRscPath);){
                        IOUtils.copy((InputStream)fin, (OutputStream)fout);
                    }
                    if (fout == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fout == null) throw throwable;
                    fout.close();
                    throw throwable;
                }
                fout.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not initialize script [" + this.scriptFileRscPath + "]", e);
        }
    }

    public boolean existsInScriptFolder() {
        if (this.filename != null && this.scriptFileRscPath != null) {
            File folder = ScriptInitializer.getOrCreateScriptFolder();
            if (folder != null && folder.exists()) {
                File outFile = new File(folder, this.filename);
                return outFile.exists();
            }
        } else {
            throw new IllegalStateException("Could test script [" + this.scriptFileRscPath + "]");
        }
        return false;
    }

    public String getFilename() {
        return this.filename;
    }

    public static File getOrCreateScriptFolder() {
        File writeableDir = CoreHub.getWritableUserDir();
        if (writeableDir != null && writeableDir.exists()) {
            File scriptFolder = new File(writeableDir, "pdfScript");
            if (!scriptFolder.exists()) {
                scriptFolder.mkdir();
            }
            return scriptFolder;
        }
        return null;
    }

    public static Properties getPrintCommands(String propertiesRscPath) {
        Properties ret = new Properties();
        try {
            ret.load(ScriptInitializer.class.getResourceAsStream(propertiesRscPath));
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)"Fehler beim Einlesen der Script Befehle.");
            LoggerFactory.getLogger(ScriptInitializer.class).error("Error reading print commands properties", (Throwable)e);
        }
        return ret;
    }

    public boolean matchingFileSize() {
        File existingFile;
        File folder;
        if (this.filename != null && this.scriptFileRscPath != null && (folder = ScriptInitializer.getOrCreateScriptFolder()) != null && folder.exists() && (existingFile = new File(folder, this.filename)).exists()) {
            long existingFileSize = existingFile.length();
            try {
                Throwable throwable = null;
                Object var6_7 = null;
                try (InputStream fin = ScriptInitializer.class.getResourceAsStream(this.scriptFileRscPath);){
                    if (fin != null) {
                        boolean bl = (long)fin.available() == existingFileSize;
                        return bl;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }
}

