/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.pdfBills;

import ch.elexis.core.preferences.PreferencesUtil;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.LocalConfigService;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import org.apache.commons.lang3.StringUtils;

public class OutputterUtil {
    public static final String CFG_ROOT = "pdf-outputter/";
    public static final String CFG_PRINT_GLOBALOUTPUTDIRS = "pdf-outputter/global.output.dirs";
    public static final String CFG_PRINT_GLOBALPDFDIR = "pdf-outputter/global.output.pdfdir";
    public static final String CFG_PRINT_GLOBALXMLDIR = "pdf-outputter/global.output.xmldir";
    public static final String CFG_PRINT_BESR = "print.besr";
    public static final String CFG_PRINT_RF = "print.rf";

    public static boolean useGlobalOutputDirs() {
        return OutputterUtil.hasGlobalDirectories() && LocalConfigService.get((String)CFG_PRINT_GLOBALOUTPUTDIRS, (boolean)true);
    }

    private static boolean hasGlobalDirectories() {
        return StringUtils.isNotBlank((CharSequence)PreferencesUtil.getOsSpecificPreference((String)CFG_PRINT_GLOBALPDFDIR, (IConfigService)ConfigServiceHolder.get())) && StringUtils.isNotBlank((CharSequence)PreferencesUtil.getOsSpecificPreference((String)CFG_PRINT_GLOBALXMLDIR, (IConfigService)ConfigServiceHolder.get()));
    }

    public static String getXmlOutputDir(String configRoot) {
        if (OutputterUtil.useGlobalOutputDirs()) {
            return PreferencesUtil.getOsSpecificPreference((String)CFG_PRINT_GLOBALXMLDIR, (IConfigService)ConfigServiceHolder.get());
        }
        return LocalConfigService.get((String)(configRoot + "xmldir"), (String)"");
    }

    public static String getPdfOutputDir(String configRoot) {
        if (OutputterUtil.useGlobalOutputDirs()) {
            return PreferencesUtil.getOsSpecificPreference((String)CFG_PRINT_GLOBALPDFDIR, (IConfigService)ConfigServiceHolder.get());
        }
        return LocalConfigService.get((String)(configRoot + "pdfdir"), (String)"");
    }

    public static boolean isPdfOutputDirValid(String configRoot) {
        if (LocalConfigService.get((String)(configRoot + CFG_PRINT_BESR), (boolean)true) || LocalConfigService.get((String)(configRoot + CFG_PRINT_RF), (boolean)true)) {
            return StringUtils.isNotBlank((CharSequence)OutputterUtil.getPdfOutputDir(configRoot));
        }
        return true;
    }
}

