/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.pdfBills.privat;

import ch.elexis.TarmedRechnung.TarmedACL;
import ch.elexis.TarmedRechnung.XMLExporterUtil;
import ch.elexis.base.ch.ebanking.esr.ESR;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IInvoice;
import ch.elexis.core.model.IOrganization;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.InvoiceState;
import ch.elexis.core.services.ICoverageService;
import ch.elexis.core.services.IFormattedOutput;
import ch.elexis.core.services.IFormattedOutputFactory;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.LocalConfigService;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.CoverageServiceHolder;
import ch.elexis.core.services.holder.InvoiceServiceHolder;
import ch.elexis.core.services.holder.VirtualFilesystemServiceHolder;
import ch.elexis.core.utils.CoreUtil;
import ch.elexis.data.Fall;
import ch.elexis.data.Mandant;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Rechnung;
import ch.elexis.ebanking.qr.QRBillDataBuilder;
import ch.elexis.ebanking.qr.QRBillDataException;
import ch.elexis.ebanking.qr.QRBillImage;
import ch.elexis.pdfBills.OutputterUtil;
import ch.elexis.pdfBills.PreferencePage;
import ch.elexis.pdfBills.print.PrintProcess;
import ch.elexis.pdfBills.print.ScriptInitializer;
import ch.elexis.pdfBills.privat.BundleURIResolver;
import ch.elexis.tarmedprefs.TarmedRequirements;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Money;
import ch.rgw.tools.XMLTool;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.URIResolver;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ElexisPDFGenerator {
    public String leftMargin;
    public String rightMargin;
    public String topMargin;
    public String bottomMargin;
    public String besrMarginVertical;
    public String besrMarginHorizontal;
    private String billXmlFile;
    private Document domDocument;
    private String billNr;
    private String billVersion;
    private String eanList;
    private String vatList;
    private Money mReminders;
    private Money mTotal;
    private Money mDue;
    private InvoiceState invoiceState;
    private List<File> printed;
    private Rechnung rechnung;
    private boolean print = true;

    public ElexisPDFGenerator(String billXmlFile, String nr) {
        this(billXmlFile, nr, InvoiceState.OPEN);
    }

    public ElexisPDFGenerator(String billXmlFile, String nr, InvoiceState invoiceState) {
        this.billXmlFile = billXmlFile;
        this.billNr = nr;
        this.invoiceState = invoiceState;
        this.domDocument = this.readDom();
        this.billVersion = this.getXmlVersion();
        this.eanList = this.getEanList();
        this.vatList = this.getVatList();
        this.initializeMarginSettings();
        this.rechnung = null;
        if (Rechnung.getDefaultConnection() != null) {
            this.rechnung = Rechnung.getFromNr((String)nr);
        }
        if (this.rechnung != null && this.rechnung.exists()) {
            this.mReminders = this.rechnung.getRemindersBetrag();
            this.mTotal = this.rechnung.getBetrag().addMoney(this.mReminders);
            this.mDue = new Money(this.mTotal.doubleValue() - this.rechnung.getAnzahlung().doubleValue());
        } else {
            this.mReminders = new Money();
            this.mTotal = new Money();
            this.mDue = new Money();
        }
    }

    private void initializeMarginSettings() {
        this.bottomMargin = PreferencePage.getSetting((String)("pdf-output/" + this.getMarginBillVersion() + "/margin.bottom")) + "cm";
        this.leftMargin = PreferencePage.getSetting((String)("pdf-output/" + this.getMarginBillVersion() + "/margin.left")) + "cm";
        this.rightMargin = PreferencePage.getSetting((String)("pdf-output/" + this.getMarginBillVersion() + "/margin.right")) + "cm";
        this.topMargin = PreferencePage.getSetting((String)("pdf-output/" + this.getMarginBillVersion() + "/margin.top")) + "cm";
        this.besrMarginVertical = PreferencePage.getSetting((String)("pdf-output/" + this.getMarginBillVersion() + "/margin.besr.vertical")) + "cm";
        this.besrMarginHorizontal = PreferencePage.getSetting((String)("pdf-output/" + this.getMarginBillVersion() + "/margin.besr.horizontal")) + "cm";
    }

    public String getBillVersion() {
        return this.billVersion;
    }

    private String getMarginBillVersion() {
        if ("4.5".equals(this.billVersion)) {
            return "4.4";
        }
        return this.billVersion;
    }

    private Document readDom() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            return dbf.newDocumentBuilder().parse(VirtualFilesystemServiceHolder.get().of(this.billXmlFile).openInputStream());
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error parsing XML", (Throwable)e);
            return null;
        }
    }

    private void generatePdf(File styleSheet, File output) {
        this.generatePdf(styleSheet, output, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void generatePdf(File styleSheet, File output, boolean withQr) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(output));
                try {
                    block30: {
                        InputStream inputStream = VirtualFilesystemServiceHolder.get().of(this.billXmlFile).openInputStream();
                        try {
                            try (FileInputStream xsltStream = new FileInputStream(styleSheet);){
                                BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
                                ServiceReference fopFactoryRef = bundleContext.getServiceReference(IFormattedOutputFactory.class);
                                if (fopFactoryRef == null) throw new IllegalStateException("No IFormattedOutput implementation available");
                                try {
                                    IFormattedOutputFactory fopFactory = (IFormattedOutputFactory)bundleContext.getService(fopFactoryRef);
                                    IFormattedOutput foOutputt = fopFactory.getFormattedOutputImplementation(IFormattedOutputFactory.ObjectType.XMLSTREAM, IFormattedOutputFactory.OutputType.PDF);
                                    HashMap<String, String> parameters = new HashMap<String, String>();
                                    parameters.put("versionParam", "2.0");
                                    parameters.put("leftMargin", this.leftMargin);
                                    parameters.put("rightMargin", this.rightMargin);
                                    parameters.put("topMargin", this.topMargin);
                                    parameters.put("bottomMargin", this.bottomMargin);
                                    parameters.put("besrMarginVertical", this.besrMarginVertical);
                                    parameters.put("besrMarginHorizontal", this.besrMarginHorizontal);
                                    parameters.put("headerLine1", this.getConfigValue("pdf-output/esr.header.line1", " "));
                                    parameters.put("headerLine2", this.getConfigValue("pdf-output/esr.header.line2", " "));
                                    parameters.put("messageText", this.getMessagePDFText(this.invoiceState));
                                    parameters.put("eanList", this.eanList);
                                    parameters.put("vatList", this.vatList);
                                    parameters.put("amountTotal", XMLTool.moneyToXmlDouble((Money)this.mTotal));
                                    parameters.put("amountDue", XMLTool.moneyToXmlDouble((Money)this.mDue));
                                    if (withQr) {
                                        parameters.put("qrJpeg", this.getEncodedQr(this.rechnung));
                                    }
                                    if (LocalConfigService.get((String)"pdf-output/guarantor.postaladdress", (boolean)false)) {
                                        parameters.put("guarantorPostal", this.getGuarantorPostal(this.rechnung));
                                    } else {
                                        parameters.put("guarantorPostal", "");
                                    }
                                    if (LocalConfigService.get((String)"pdf-output/esr.couvert.left", (boolean)false)) {
                                        parameters.put("couvertLeft", "true");
                                    } else {
                                        parameters.put("couvertLeft", "");
                                    }
                                    Optional<IInvoice> invoice = this.getInvoice();
                                    if (invoice.isPresent()) {
                                        parameters.put("billerLine", this.getBillerLine(invoice.get()));
                                        parameters.put("guarantorLine", this.getGuarantorLine(invoice.get()));
                                        parameters.put("creditorLine", this.getCreditorLine(invoice.get()));
                                        parameters.put("insuranceLine", this.getInsuranceLine(invoice.get()));
                                    } else {
                                        parameters.put("billerLine", "");
                                        parameters.put("guarantorLine", "");
                                        parameters.put("creditorLine", "");
                                        parameters.put("insuranceLine", "");
                                    }
                                    if (this.mReminders != null && !this.mReminders.isZero()) {
                                        parameters.put("amountReminders", XMLTool.moneyToXmlDouble((Money)this.mReminders));
                                    }
                                    foOutputt.transform((Object)inputStream, (InputStream)xsltStream, (OutputStream)out, parameters, (URIResolver)new BundleURIResolver());
                                }
                                catch (IllegalStateException e) {
                                    ExHandler.handle((Throwable)e);
                                }
                                bundleContext.ungetService(fopFactoryRef);
                            }
                            if (inputStream == null) break block30;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (inputStream == null) throw throwable;
                            inputStream.close();
                            throw throwable;
                        }
                        inputStream.close();
                    }
                    if (out == null) return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (out == null) throw throwable;
                    ((OutputStream)out).close();
                    throw throwable;
                }
                ((OutputStream)out).close();
                return;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("Error outputting bill", (Throwable)e);
            throw new IllegalStateException("Error outputting bill", e);
        }
    }

    private String getMessagePDFText(InvoiceState invoiceState) {
        String key = "";
        String invStateTxt = this.rechnung.getInvoiceState().toString();
        Fall.Tiers tiers = this.rechnung.getFall().getTiersType();
        switch (invoiceState) {
            case UNKNOWN: 
            case BILLED: 
            case NOT_BILLED: 
            case ONGOING: 
            case OPEN: 
            case OPEN_AND_PRINTED: 
            case IN_EXECUTION: 
            case PARTIAL_LOSS: 
            case TOTAL_LOSS: 
            case PARTIAL_PAYMENT: 
            case PAID: 
            case EXCESSIVE_PAYMENT: 
            case FROM_TODAY: 
            case NOT_FROM_TODAY: 
            case NOT_FROM_YOU: 
            case TO_PRINT: 
            case OWING: 
            case STOP_LEGAL_PROCEEDING: 
            case REJECTED: {
                key = Fall.Tiers.GARANT == tiers ? "pdf-output/pdf.txt.tg" : "pdf-output/pdf.txt.tp";
                invStateTxt = Messages.BillingDefaultMsg;
                break;
            }
            case DEMAND_NOTE_1: 
            case DEMAND_NOTE_1_PRINTED: {
                key = Fall.Tiers.GARANT == tiers ? "pdf-output/pdf.txt.M1tg" : "pdf-output/pdf.txt.M1tp";
                invStateTxt = Messages.BillingDefaultMsg_M1;
                break;
            }
            case DEMAND_NOTE_2: 
            case DEMAND_NOTE_2_PRINTED: {
                key = Fall.Tiers.GARANT == tiers ? "pdf-output/pdf.txt.M2tg" : "pdf-output/pdf.txt.M2tp";
                invStateTxt = Messages.BillingDefaultMsg_M2;
                break;
            }
            case DEMAND_NOTE_3: 
            case DEMAND_NOTE_3_PRINTED: {
                key = Fall.Tiers.GARANT == tiers ? "pdf-output/pdf.txt.M3tg" : "pdf-output/pdf.txt.M3tp";
                invStateTxt = Messages.BillingDefaultMsg_M3;
                break;
            }
            default: {
                LoggerFactory.getLogger(this.getClass()).error("unknown state: " + invoiceState.toString());
            }
        }
        return CoreHub.globalCfg.get(key, invStateTxt);
    }

    private String getInsuranceLine(IInvoice invoice) {
        String kEAN;
        IContact costBearer = invoice.getCoverage().getCostBearer();
        if (costBearer == null) {
            costBearer = invoice.getCoverage().getPatient();
        }
        if (StringUtils.isNotBlank((CharSequence)(kEAN = TarmedRequirements.getEAN((IContact)costBearer)))) {
            return this.getContactLine(costBearer);
        }
        return null;
    }

    private String getCreditorLine(IInvoice invoice) {
        IContact creditor = invoice.getMandator().getBiller();
        TarmedACL.getInstance().getClass();
        if (StringUtils.isNotBlank((CharSequence)((String)creditor.getExtInfo((Object)"TarmedRnAccountOwner")))) {
            IModelService iModelService = CoreModelServiceHolder.get();
            TarmedACL.getInstance().getClass();
            Optional loadedCreditor = iModelService.load((String)creditor.getExtInfo((Object)"TarmedRnAccountOwner"), IContact.class);
            if (loadedCreditor.isPresent()) {
                creditor = (IContact)loadedCreditor.get();
            }
        }
        return this.getContactLine(creditor);
    }

    private String getGuarantorLine(IInvoice invoice) {
        ICoverageService.Tiers tiersType = CoverageServiceHolder.get().getTiersType(invoice.getCoverage());
        IContact guarantor = XMLExporterUtil.getGuarantor((String)tiersType.getShortName(), (IPatient)invoice.getCoverage().getPatient(), (ICoverage)invoice.getCoverage());
        if (guarantor != null) {
            return this.getContactLine(guarantor);
        }
        return null;
    }

    private String getBillerLine(IInvoice invoice) {
        return this.getContactLine(invoice.getMandator().getBiller());
    }

    private String getContactLine(IContact contact) {
        if (contact != null) {
            if (contact.isOrganization()) {
                return contact.getDescription1();
            }
            if (contact.isPerson()) {
                IPerson person = (IPerson)CoreModelServiceHolder.get().load(contact.getId(), IPerson.class).get();
                StringBuilder ret = new StringBuilder();
                if (StringUtils.isNotBlank((CharSequence)person.getTitel())) {
                    ret.append(" ").append(person.getTitel());
                }
                ret.append(" ").append(person.getDescription2());
                ret.append(" ").append(person.getDescription1());
                return ret.toString();
            }
        }
        return null;
    }

    private Optional<IInvoice> getInvoice() {
        if (this.rechnung != null) {
            return NoPoUtil.loadAsIdentifiable((PersistentObject)this.rechnung, IInvoice.class);
        }
        return Optional.empty();
    }

    private String getGuarantorPostal(Rechnung rechnung) {
        IContact guarantor;
        Optional invoice;
        if (rechnung != null && (invoice = CoreModelServiceHolder.get().load(rechnung.getId(), IInvoice.class)).isPresent() && (guarantor = ((IInvoice)invoice.get()).getCoverage().getGuarantor()) != null) {
            return guarantor.getPostalAddress();
        }
        return "";
    }

    private String getEncodedQr(Rechnung rechnung) {
        Optional invoice;
        if (rechnung != null && (invoice = CoreModelServiceHolder.get().load(rechnung.getId(), IInvoice.class)).isPresent()) {
            IContact biller = ((IInvoice)invoice.get()).getMandator().getBiller();
            TarmedACL.getInstance().getClass();
            String string = (String)biller.getExtInfo((Object)"TarmedESRParticipantNumber");
            TarmedACL.getInstance().getClass();
            ESR esr = new ESR(string, (String)biller.getExtInfo((Object)"TarmedESRIdentity"), InvoiceServiceHolder.get().getCombinedId((IInvoice)invoice.get()), 27);
            IContact creditor = ((IInvoice)invoice.get()).getMandator().getBiller();
            TarmedACL.getInstance().getClass();
            if (StringUtils.isNotBlank((CharSequence)((String)creditor.getExtInfo((Object)"TarmedRnAccountOwner")))) {
                IModelService iModelService = CoreModelServiceHolder.get();
                TarmedACL.getInstance().getClass();
                Optional loadedCreditor = iModelService.load((String)creditor.getExtInfo((Object)"TarmedRnAccountOwner"), IContact.class);
                if (loadedCreditor.isPresent()) {
                    creditor = (IContact)loadedCreditor.get();
                }
            }
            TarmedACL.getInstance().getClass();
            String additionalInformation = (String)biller.getExtInfo((Object)"TarmedRnInformation");
            QRBillDataBuilder builder = new QRBillDataBuilder(this.reloadAsPersonOrOrganization(creditor), ((IInvoice)invoice.get()).getOpenAmount(), "CHF", this.reloadAsPersonOrOrganization(this.getDebitor((IInvoice)invoice.get()))).reference(esr.makeRefNr(false)).unstructuredRemark(additionalInformation);
            try {
                Optional encodedImage = new QRBillImage(builder.build()).getEncodedImage();
                if (encodedImage.isPresent()) {
                    return (String)encodedImage.get();
                }
            }
            catch (QRBillDataException e) {
                LoggerFactory.getLogger(this.getClass()).error("Error creating qr code", (Throwable)e);
                MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)"QR code Fehler", (String)this.getErrorMessage(e, invoice));
            }
        }
        return "";
    }

    private String getErrorMessage(QRBillDataException e, Optional<IInvoice> invoice) {
        StringBuilder sb = new StringBuilder();
        sb.append("Fehler beim Erstellen des QR codes.\n");
        if (e.getSourceType() == QRBillDataException.SourceType.CREDITOR) {
            sb.append("Problem mit der Rechnungssteller Information f\u00fcr [" + invoice.get().getMandator().getBiller().getLabel() + "].\n");
            if (e.getContact() != null) {
                sb.append("Bitte die Addresse auf Vollst\u00e4ndigkeit \u00fcberpr\u00fcfen.");
            }
        }
        if (e.getSourceType() == QRBillDataException.SourceType.DEBITOR) {
            if (invoice.get().getCoverage().getCostBearer() != null) {
                sb.append("Problem mit der Kostentr\u00e4ger Information f\u00fcr [" + invoice.get().getCoverage().getCostBearer().getLabel() + "].");
                if (e.getContact() != null) {
                    sb.append("Bitte die Addresse auf Vollst\u00e4ndigkeit \u00fcberpr\u00fcfen.");
                }
            } else {
                sb.append("Problem mit der Kostentr\u00e4ger Information f\u00fcr [" + invoice.get().getCoverage().getLabel() + "] kein Kostentr\u00e4ger.");
            }
        }
        if (e.getSourceType() == QRBillDataException.SourceType.AMOUNT) {
            sb.append("Problem mit dem Rechnungsbetrag.");
        }
        if (e.getSourceType() == QRBillDataException.SourceType.REMARK) {
            sb.append("Problem mit der Rechnungsbemerkung.");
        }
        return sb.toString();
    }

    private IContact reloadAsPersonOrOrganization(IContact contact) {
        if (contact.isPerson() && !(contact instanceof IPerson)) {
            return (IContact)CoreModelServiceHolder.get().load(contact.getId(), IPerson.class).get();
        }
        if (contact.isOrganization() && !(contact instanceof IOrganization)) {
            return (IContact)CoreModelServiceHolder.get().load(contact.getId(), IOrganization.class).get();
        }
        return contact;
    }

    private String getConfigValue(String configId, String defaultValue) {
        Mandant mandant;
        String mandantValue;
        if (this.rechnung != null && StringUtils.isNotBlank((CharSequence)(mandantValue = ConfigServiceHolder.getGlobal((String)(configId + "/" + (mandant = this.rechnung.getMandant()).getId()), null)))) {
            return mandantValue;
        }
        return PreferencePage.getConfigTransferGlobal((String)configId, (String)defaultValue);
    }

    public void printBill(File rsc) {
        this.printed = new ArrayList<File>();
        try {
            File pdf;
            if (LocalConfigService.get((String)"privatqrpdf-output/print.besr", (boolean)true)) {
                pdf = VirtualFilesystemServiceHolder.get().of(OutputterUtil.getPdfOutputDir((String)"privatqrpdf-output/") + File.separator + this.billNr + "_esr.pdf").toFile().orElse(null);
                this.generatePatBill(rsc, pdf);
                this.printPdf(pdf, true);
                this.printed.add(pdf);
            }
            if (LocalConfigService.get((String)"privatqrpdf-output/print.rf", (boolean)true)) {
                pdf = VirtualFilesystemServiceHolder.get().of(OutputterUtil.getPdfOutputDir((String)"privatqrpdf-output/") + File.separator + this.billNr + "_rf.pdf").toFile().orElse(null);
                this.generatePdf(this.getXsltForBill(rsc, XsltType.RECLAIM), pdf);
                this.printPdf(pdf, false);
                this.printed.add(pdf);
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error printing bill", (Throwable)e);
        }
    }

    public void printQrBill(File rsc) {
        this.printed = new ArrayList<File>();
        try {
            File pdf;
            if (LocalConfigService.get((String)"privatqrpdf-output/print.besr", (boolean)true)) {
                pdf = VirtualFilesystemServiceHolder.get().of(OutputterUtil.getPdfOutputDir((String)"privatqrpdf-output/") + File.separator + this.billNr + "_esr.pdf").toFile().orElse(null);
                this.generateQrPatBill(rsc, pdf);
                this.printPdf(pdf, false);
                this.printed.add(pdf);
            }
            if (LocalConfigService.get((String)"privatqrpdf-output/print.rf", (boolean)true)) {
                pdf = VirtualFilesystemServiceHolder.get().of(OutputterUtil.getPdfOutputDir((String)"privatqrpdf-output/") + File.separator + this.billNr + "_rf.pdf").toFile().orElse(null);
                this.generatePdf(this.getQrXsltForBill(rsc, XsltType.RECLAIM), pdf);
                this.printPdf(pdf, false);
                this.printed.add(pdf);
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error printing bill", (Throwable)e);
        }
    }

    private void generateQrPatBill(File rsc, File pdf) {
        if (this.invoiceState == InvoiceState.DEMAND_NOTE_1 || this.invoiceState == InvoiceState.DEMAND_NOTE_1_PRINTED) {
            this.generatePdf(this.getQrXsltForBill(rsc, XsltType.PATBILL_M1), pdf, true);
        } else if (this.invoiceState == InvoiceState.DEMAND_NOTE_2 || this.invoiceState == InvoiceState.DEMAND_NOTE_2_PRINTED) {
            this.generatePdf(this.getQrXsltForBill(rsc, XsltType.PATBILL_M2), pdf, true);
        } else if (this.invoiceState == InvoiceState.DEMAND_NOTE_3 || this.invoiceState == InvoiceState.DEMAND_NOTE_3_PRINTED) {
            this.generatePdf(this.getQrXsltForBill(rsc, XsltType.PATBILL_M3), pdf, true);
        } else {
            this.generatePdf(this.getQrXsltForBill(rsc, XsltType.PATBILL), pdf, true);
        }
    }

    private void generatePatBill(File rsc, File pdf) {
        if (this.invoiceState == InvoiceState.DEMAND_NOTE_1 || this.invoiceState == InvoiceState.DEMAND_NOTE_1_PRINTED) {
            this.generatePdf(this.getXsltForBill(rsc, XsltType.PATBILL_M1), pdf);
        } else if (this.invoiceState == InvoiceState.DEMAND_NOTE_2 || this.invoiceState == InvoiceState.DEMAND_NOTE_2_PRINTED) {
            this.generatePdf(this.getXsltForBill(rsc, XsltType.PATBILL_M2), pdf);
        } else if (this.invoiceState == InvoiceState.DEMAND_NOTE_3 || this.invoiceState == InvoiceState.DEMAND_NOTE_3_PRINTED) {
            this.generatePdf(this.getXsltForBill(rsc, XsltType.PATBILL_M3), pdf);
        } else {
            this.generatePdf(this.getXsltForBill(rsc, XsltType.PATBILL), pdf);
        }
    }

    private boolean printPdf(File pdf, boolean useEsrPrinter) {
        if (this.print && this.isPrintingConfigured()) {
            String printCommand;
            if (CoreUtil.isWindows() && LocalConfigService.get((String)"pdf-output/print.usescript", (boolean)false) && !this.isScriptWinInitialized()) {
                this.initializeScriptWin();
            }
            String toPrinter = LocalConfigService.get((String)"pdf-output/print.printer", (String)"");
            String toTray = LocalConfigService.get((String)"pdf-output/print.tray", (String)"");
            if (useEsrPrinter) {
                toPrinter = LocalConfigService.get((String)"pdf-output/esr.print.printer", (String)"");
                toTray = LocalConfigService.get((String)"pdf-output/esr.print.tray", (String)"");
            }
            if ((printCommand = LocalConfigService.get((String)"pdf-output/print.command", (String)"")) != null) {
                PrintProcess process = new PrintProcess(printCommand);
                process.setPrinter(toPrinter);
                process.setTray(toTray);
                process.setFilename(pdf.getAbsolutePath());
                return process.execute();
            }
        }
        return true;
    }

    private boolean isPrintingConfigured() {
        return LocalConfigService.get((String)"pdf-output/print.direct", (boolean)false) && !LocalConfigService.get((String)"pdf-output/print.command", (String)"").isEmpty();
    }

    private boolean isScriptWinInitialized() {
        ScriptInitializer initializer = new ScriptInitializer("/rsc/script/win/SumatraPDF.exe");
        if (!initializer.existsInScriptFolder()) {
            return false;
        }
        return initializer.matchingFileSize();
    }

    private void initializeScriptWin() {
        ScriptInitializer initializer = new ScriptInitializer("/rsc/script/win/SumatraPDF.exe");
        if (initializer.existsInScriptFolder()) {
            if (MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Script existiert bereits", (String)("Script [" + initializer.getFilename() + "] existiert bereits, soll die Datei \u00fcberschrieben werden?"))) {
                initializer.init();
            }
        } else {
            initializer.init();
        }
    }

    protected boolean isTierGarant() {
        if ("4.4".equals(this.billVersion)) {
            try {
                XPath xPath = XPathFactory.newInstance().newXPath();
                XPathExpression expr = xPath.compile("/request/payload/body/tiers_garant");
                Object result = expr.evaluate(this.domDocument, XPathConstants.NODESET);
                NodeList nodes = (NodeList)result;
                return nodes.getLength() > 0;
            }
            catch (XPathExpressionException e) {
                LoggerFactory.getLogger(this.getClass()).error("Error getting bill type", (Throwable)e);
            }
        }
        return true;
    }

    private IContact getDebitor(IInvoice invoice) {
        IContact costBearer;
        String tiers = "TP";
        ICoverageService.Tiers tiersType = CoverageServiceHolder.get().getTiersType(invoice.getCoverage());
        if (ICoverageService.Tiers.GARANT == tiersType) {
            tiers = "TG";
        }
        IContact ret = XMLExporterUtil.getGuarantor((String)tiers, (IPatient)invoice.getCoverage().getPatient(), (ICoverage)invoice.getCoverage());
        if (tiersType == ICoverageService.Tiers.PAYANT && (costBearer = invoice.getCoverage().getCostBearer()) != null && costBearer.isOrganization()) {
            ret = costBearer;
        }
        return ret;
    }

    private String getEanList() {
        if ("4.4".equals(this.billVersion)) {
            HashSet<String> eanSet = new HashSet<String>();
            try {
                XPath xPath = XPathFactory.newInstance().newXPath();
                XPathExpression expr = xPath.compile("/request/payload/body/services");
                Object result = expr.evaluate(this.domDocument, XPathConstants.NODESET);
                NodeList servicesElements = (NodeList)result;
                int i = 0;
                while (i < servicesElements.getLength()) {
                    Node serviceElement = servicesElements.item(i);
                    NodeList childNodes = serviceElement.getChildNodes();
                    int j = 0;
                    while (j < childNodes.getLength()) {
                        Node child = childNodes.item(j);
                        if (child instanceof Element) {
                            Element element = (Element)child;
                            eanSet.add(element.getAttribute("responsible_id"));
                            eanSet.add(element.getAttribute("provider_id"));
                        }
                        ++j;
                    }
                    ++i;
                }
                StringBuilder eanList = new StringBuilder();
                String[] eanArray = eanSet.toArray(new String[eanSet.size()]);
                int i2 = 0;
                while (i2 < eanArray.length) {
                    if (i2 > 0) {
                        eanList.append(" ");
                    }
                    eanList.append(i2 + 1).append("/").append(eanArray[i2]);
                    ++i2;
                }
                return eanList.toString();
            }
            catch (XPathExpressionException e) {
                LoggerFactory.getLogger(this.getClass()).error("Error getting bill type", (Throwable)e);
            }
        } else if ("4.5".equals(this.billVersion)) {
            HashSet<String> eanSet = new HashSet<String>();
            try {
                XPath xPath = XPathFactory.newInstance().newXPath();
                XPathExpression expr = xPath.compile("/request/payload/body/services");
                Object result = expr.evaluate(this.domDocument, XPathConstants.NODESET);
                NodeList servicesElements = (NodeList)result;
                int i = 0;
                while (i < servicesElements.getLength()) {
                    Node serviceElement = servicesElements.item(i);
                    NodeList childNodes = serviceElement.getChildNodes();
                    int j = 0;
                    while (j < childNodes.getLength()) {
                        Node child = childNodes.item(j);
                        if (child instanceof Element) {
                            Element element = (Element)child;
                            eanSet.add(element.getAttribute("responsible_id"));
                            eanSet.add(element.getAttribute("provider_id"));
                        }
                        ++j;
                    }
                    ++i;
                }
                StringBuilder eanList = new StringBuilder();
                String[] eanArray = eanSet.toArray(new String[eanSet.size()]);
                int i3 = 0;
                while (i3 < eanArray.length) {
                    if (i3 > 0) {
                        eanList.append(" ");
                    }
                    eanList.append(i3 + 1).append("/").append(eanArray[i3]);
                    ++i3;
                }
                return eanList.toString();
            }
            catch (XPathExpressionException e) {
                LoggerFactory.getLogger(this.getClass()).error("Error getting bill type", (Throwable)e);
            }
        }
        return "";
    }

    private String getVatList() {
        if ("4.4".equals(this.billVersion)) {
            HashSet<String> vatrateSet = new HashSet<String>();
            try {
                XPath xPath = XPathFactory.newInstance().newXPath();
                XPathExpression expr = xPath.compile("/request/payload/body/balance/vat/vat_rate");
                Object result = expr.evaluate(this.domDocument, XPathConstants.NODESET);
                NodeList vatrateElements = (NodeList)result;
                int i = 0;
                while (i < vatrateElements.getLength()) {
                    Node vatrateElement = vatrateElements.item(i);
                    vatrateSet.add(((Element)vatrateElement).getAttribute("vat_rate"));
                    ++i;
                }
                String[] vatRateArray = this.getVatRateArray(vatrateSet);
                StringBuilder vatrateList = new StringBuilder();
                int i2 = 0;
                while (i2 < vatRateArray.length) {
                    if (i2 > 0) {
                        vatrateList.append(" ");
                    }
                    vatrateList.append(i2).append("/").append(vatRateArray[i2]);
                    ++i2;
                }
                return vatrateList.toString();
            }
            catch (XPathExpressionException e) {
                LoggerFactory.getLogger(this.getClass()).error("Error getting vat rates", (Throwable)e);
            }
        } else if ("4.5".equals(this.billVersion)) {
            HashSet<String> vatrateSet = new HashSet<String>();
            try {
                XPath xPath = XPathFactory.newInstance().newXPath();
                XPathExpression expr = xPath.compile("/request/payload/body/*/balance/vat/vat_rate");
                Object result = expr.evaluate(this.domDocument, XPathConstants.NODESET);
                NodeList vatrateElements = (NodeList)result;
                int i = 0;
                while (i < vatrateElements.getLength()) {
                    Node vatrateElement = vatrateElements.item(i);
                    vatrateSet.add(((Element)vatrateElement).getAttribute("vat_rate"));
                    ++i;
                }
                String[] vatRateArray = this.getVatRateArray(vatrateSet);
                StringBuilder vatrateList = new StringBuilder();
                int i3 = 0;
                while (i3 < vatRateArray.length) {
                    if (i3 > 0) {
                        vatrateList.append(" ");
                    }
                    vatrateList.append(i3).append("/").append(vatRateArray[i3]);
                    ++i3;
                }
                return vatrateList.toString();
            }
            catch (XPathExpressionException e) {
                LoggerFactory.getLogger(this.getClass()).error("Error getting vat rates", (Throwable)e);
            }
        }
        return "";
    }

    private String[] getVatRateArray(HashSet<String> vatrateSet) {
        String[] ret = new String[]{"0", "2.5", "7.7"};
        String[] vatrates = vatrateSet.toArray(new String[vatrateSet.size()]);
        int i = 0;
        while (i < vatrates.length && i < 3) {
            try {
                Float value = Float.valueOf(vatrates[i]);
                if (value.floatValue() > 0.0f && value.floatValue() < 7.0f) {
                    ret[1] = vatrates[i];
                } else if (value.floatValue() >= 7.0f) {
                    ret[2] = vatrates[i];
                }
            }
            catch (NumberFormatException e) {
                LoggerFactory.getLogger(this.getClass()).warn("Not valid vat rate found, using default", (Object)vatrates[i]);
            }
            ++i;
        }
        return ret;
    }

    protected String getXmlVersion() {
        Attr attr = this.domDocument.getDocumentElement().getAttributeNode("xsi:schemaLocation");
        String location = null;
        if (attr != null) {
            location = attr.getValue();
            if (location.contains("InvoiceRequest_400")) {
                return "4.0";
            }
            if (location.contains("InvoiceRequest_440")) {
                return "4.4";
            }
            if (location.contains("InvoiceRequest_450")) {
                return "4.5";
            }
            if (location.contains("InvoiceRequest_500")) {
                return "5.0";
            }
        }
        return "";
    }

    protected File getXsltForBill(File rsc, XsltType type) {
        if ("4.0".equals(this.billVersion)) {
            throw new IllegalStateException("No privat patbill for tarmed 4.0 bills");
        }
        if ("4.4".equals(this.billVersion)) {
            if (type == XsltType.PATBILL) {
                return new File(rsc, "44_patbill.xsl");
            }
            if (type == XsltType.PATBILL_M1) {
                return new File(rsc, "44_patbill_m1.xsl");
            }
            if (type == XsltType.PATBILL_M2) {
                return new File(rsc, "44_patbill_m2.xsl");
            }
            if (type == XsltType.PATBILL_M3) {
                return new File(rsc, "44_patbill_m3.xsl");
            }
            if (type == XsltType.RECLAIM) {
                return new File(rsc, "44_services.xsl");
            }
        } else if ("4.5".equals(this.billVersion)) {
            if (type == XsltType.PATBILL) {
                return new File(rsc, "45_patbill.xsl");
            }
            if (type == XsltType.PATBILL_M1) {
                return new File(rsc, "45_patbill_m1.xsl");
            }
            if (type == XsltType.PATBILL_M2) {
                return new File(rsc, "45_patbill_m2.xsl");
            }
            if (type == XsltType.PATBILL_M3) {
                return new File(rsc, "45_patbill_m3.xsl");
            }
            if (type == XsltType.RECLAIM) {
                return new File(rsc, "45_services.xsl");
            }
        }
        return null;
    }

    protected File getQrXsltForBill(File rsc, XsltType type) {
        if ("4.0".equals(this.billVersion) || "4.4".equals(this.billVersion)) {
            throw new IllegalStateException("No QR patbill for tarmed 4.0 or 4.4 bills");
        }
        if ("4.5".equals(this.billVersion)) {
            if (type == XsltType.PATBILL) {
                return new File(rsc, "45_qr_patbill.xsl");
            }
            if (type == XsltType.PATBILL_M1) {
                return new File(rsc, "45_qr_patbill_m1.xsl");
            }
            if (type == XsltType.PATBILL_M2) {
                return new File(rsc, "45_qr_patbill_m2.xsl");
            }
            if (type == XsltType.PATBILL_M3) {
                return new File(rsc, "45_qr_patbill_m3.xsl");
            }
            if (type == XsltType.RECLAIM) {
                return new File(rsc, "45_services.xsl");
            }
        } else if ("5.0".equals(this.billVersion)) {
            if (type == XsltType.PATBILL) {
                return new File(rsc, "50_qr_patbill.xsl");
            }
            if (type == XsltType.PATBILL_M1) {
                return new File(rsc, "50_qr_patbill_m1.xsl");
            }
            if (type == XsltType.PATBILL_M2) {
                return new File(rsc, "50_qr_patbill_m2.xsl");
            }
            if (type == XsltType.PATBILL_M3) {
                return new File(rsc, "50_qr_patbill_m3.xsl");
            }
            if (type == XsltType.RECLAIM) {
                return new File(rsc, "50_services.xsl");
            }
        }
        return null;
    }

    public List<File> getPrintedBill() {
        return this.printed;
    }

    public void setPrint(boolean value) {
        this.print = value;
    }

    private static enum XsltType {
        RECLAIM,
        PATBILL,
        PATBILL_M1,
        PATBILL_M2,
        PATBILL_M3;

    }
}

