/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.omnivore.ui.views;

import at.medevit.elexis.inbox.model.IInboxElement;
import at.medevit.elexis.inbox.model.IInboxElementService;
import at.medevit.elexis.inbox.ui.InboxServiceHolder;
import ch.elexis.core.ac.EvACE;
import ch.elexis.core.ac.EvaluatableACE;
import ch.elexis.core.ac.Right;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.service.ContextServiceHolder;
import ch.elexis.core.data.service.StoreToStringServiceHolder;
import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.IQueryCursor;
import ch.elexis.core.services.holder.AccessControlServiceHolder;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.actions.RestrictedAction;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.events.RefreshingPartListener;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.locks.LockRequestingRestrictedAction;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.viewers.DefaultLabelProvider;
import ch.elexis.core.ui.views.IRefreshable;
import ch.elexis.omnivore.data.AutomaticBilling;
import ch.elexis.omnivore.data.Utils;
import ch.elexis.omnivore.model.IDocumentHandle;
import ch.elexis.omnivore.model.util.CategoryUtil;
import ch.elexis.omnivore.ui.Messages;
import ch.elexis.omnivore.ui.service.OmnivoreModelServiceHolder;
import ch.elexis.omnivore.ui.util.UiUtils;
import ch.elexis.omnivore.ui.views.FileImportDialog;
import ch.elexis.omnivore.ui.views.OmnivoreViewerComparator;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.File;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.IToolTipProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmnivoreView
extends ViewPart
implements IRefreshable {
    private TreeViewer viewer;
    private Tree table;
    RestrictedAction editAction;
    RestrictedAction deleteAction;
    RestrictedAction importAction;
    public static String importAction_ID = "ch.elexis.omnivore.data.OmnivoreView.importAction";
    private Action exportAction;
    private Action doubleClickAction;
    private Action flatViewAction;
    private final String[] colLabels = new String[]{"", Messages.OmnivoreView_categoryColumn, Messages.OmnivoreView_dateColumn, Messages.OmnivoreView_dateOriginColumn, Messages.OmnivoreView_titleColumn, Messages.OmnivoreView_keywordsColumn};
    private final String colWidth = "20,80,80,150,500";
    private final String sortSettings = "0,1,-1,false";
    private boolean bFlat = false;
    private String searchTitle = "";
    private String searchKW = "";
    static Logger log = LoggerFactory.getLogger(OmnivoreView.class);
    private OmnivoreViewerComparator ovComparator;
    private IPatient actPatient;
    @Inject
    private IEventBroker eventBroker;
    private RefreshingPartListener udpateOnVisible = new RefreshingPartListener(this){

        public void partDeactivated(IWorkbenchPartReference partRef) {
            if (this.isMatchingPart(partRef)) {
                OmnivoreView.this.saveColumnWidthSettings();
                OmnivoreView.this.saveSortSettings();
            }
        }
    };

    private boolean isActiveControl(Control control) {
        return control != null && !control.isDisposed() && control.isVisible();
    }

    @Inject
    void activePatient(@Optional IPatient patient) {
        Display.getDefault().asyncExec(() -> {
            if (this.isActiveControl((Control)this.table)) {
                this.viewer.refresh();
                this.actPatient = patient;
            }
        });
    }

    @Inject
    void activeUser(@Optional IUser user) {
        Display.getDefault().asyncExec(() -> {
            if (this.isActiveControl((Control)this.table)) {
                this.viewer.refresh();
                this.importAction.reflectRight();
                this.editAction.reflectRight();
                this.deleteAction.reflectRight();
            }
        });
    }

    @Optional
    @Inject
    void updateDocHandle(@UIEventTopic(value="info/elexis/model/update") IDocumentHandle dochandle) {
        if (this.isActiveControl((Control)this.table)) {
            this.viewer.refresh();
        }
    }

    @Inject
    void createDocHandle(@Optional @UIEventTopic(value="info/elexis/model/create") IDocumentHandle dochandle) {
        if (this.isActiveControl((Control)this.table)) {
            this.viewer.refresh();
        }
    }

    @Inject
    void deleteDocHandle(@Optional @UIEventTopic(value="info/elexis/model/delete") IDocumentHandle dochandle) {
        if (this.isActiveControl((Control)this.table)) {
            this.viewer.refresh();
        }
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(4, false));
        Label lSearchTitle = new Label(parent, 0);
        lSearchTitle.setText(Messages.OmnivoreView_searchTitleLabel);
        lSearchTitle.setLayoutData((Object)new GridData(16384, 128, false, false));
        final Text tSearchTitle = new Text(parent, 4);
        tSearchTitle.setLayoutData((Object)new GridData(4, 128, true, false));
        Label lSearchKW = new Label(parent, 0);
        lSearchKW.setText(Messages.OmnivoreView_searchKeywordsLabel);
        lSearchKW.setLayoutData((Object)new GridData(16384, 128, false, false));
        final Text tSearchKW = new Text(parent, 4);
        tSearchKW.setLayoutData((Object)new GridData(4, 128, true, false));
        ModifyListener searchListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OmnivoreView.this.searchKW = tSearchKW.getText();
                OmnivoreView.this.searchTitle = tSearchTitle.getText();
                OmnivoreView.this.viewer.refresh();
            }
        };
        tSearchTitle.addModifyListener(searchListener);
        tSearchKW.addModifyListener(searchListener);
        this.table = new Tree(parent, 66306);
        TreeColumn[] cols = new TreeColumn[this.colLabels.length];
        int i = 0;
        while (i < this.colLabels.length) {
            cols[i] = new TreeColumn(this.table, 0);
            cols[i].setText(this.colLabels[i]);
            cols[i].setData((Object)new Integer(i));
            ++i;
        }
        this.applyUsersColumnWidthSetting();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        this.viewer = new TreeViewer(this.table);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setUseHashlookup(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer, (int)2);
        this.viewer.addSelectionChangedListener(ev -> {
            IDocumentHandle docHandle = (IDocumentHandle)ev.getStructuredSelection().getFirstElement();
            if (docHandle != null && !docHandle.isCategory()) {
                this.eventBroker.post("ui/preview/mimetype/application/pdf", (Object)docHandle);
            }
        });
        this.makeActions();
        this.ovComparator = new OmnivoreViewerComparator();
        this.viewer.setComparator((ViewerComparator)this.ovComparator);
        TreeColumn[] treeCols = this.viewer.getTree().getColumns();
        int i2 = 0;
        while (i2 < treeCols.length) {
            TreeColumn tc = treeCols[i2];
            tc.addSelectionListener(this.getSelectionAdapter(tc, i2));
            ++i2;
        }
        this.applySortDirection();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        final Transfer[] dropTransferTypes = new Transfer[]{FileTransfer.getInstance()};
        this.viewer.addDropSupport(1, dropTransferTypes, (DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                event.detail = 1;
            }

            public void drop(DropTargetEvent event) {
                if (dropTransferTypes[0].isSupportedType(event.currentDataType)) {
                    String[] files = (String[])event.data;
                    String category = null;
                    if (event.item != null && event.item.getData() instanceof IDocumentHandle) {
                        IDocumentHandle dh = (IDocumentHandle)event.item.getData();
                        category = dh.getCategory().getName();
                    }
                    String[] stringArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String file = stringArray[n2];
                        IDocumentHandle handle = UiUtils.assimilate(file, category);
                        if (AutomaticBilling.isEnabled() && handle != null) {
                            AutomaticBilling billing = new AutomaticBilling((IDocument)handle);
                            billing.bill();
                        }
                        OmnivoreView.this.viewer.refresh();
                        ++n2;
                    }
                }
            }
        });
        Transfer[] dragTransferTypes = new Transfer[]{FileTransfer.getInstance(), TextTransfer.getInstance()};
        this.viewer.addDragSupport(1, dragTransferTypes, (DragSourceListener)new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                IStructuredSelection selection = (IStructuredSelection)OmnivoreView.this.viewer.getSelection();
                for (Object object : selection.toList()) {
                    IDocumentHandle dh = (IDocumentHandle)object;
                    if (!dh.isCategory()) continue;
                    event.doit = false;
                }
            }

            public void dragSetData(DragSourceEvent event) {
                IStructuredSelection selection = (IStructuredSelection)OmnivoreView.this.viewer.getSelection();
                if (FileTransfer.getInstance().isSupportedType(event.dataType)) {
                    String[] files = new String[selection.size()];
                    int index = 0;
                    while (index < selection.size()) {
                        IDocumentHandle dh = (IDocumentHandle)selection.toList().get(index);
                        File file = Utils.createTemporaryFile((IDocumentHandle)dh, (String)dh.getTitle());
                        files[index] = file.getAbsolutePath();
                        log.debug("dragSetData; isSupportedType {} data {}", (Object)file.getAbsolutePath(), event.data);
                        ++index;
                    }
                    event.data = files;
                } else {
                    StringBuilder sb = new StringBuilder();
                    int index = 0;
                    while (index < selection.size()) {
                        IDocumentHandle dh = (IDocumentHandle)selection.toList().get(index);
                        sb.append(StoreToStringServiceHolder.getStoreToString((Object)dh)).append(",");
                        log.debug("dragSetData; unsupported dataType {} returning {}", (Object)event.dataType, (Object)sb.toString().replace(",$", ""));
                        ++index;
                    }
                    event.data = sb.toString().replace(",$", "");
                }
            }
        });
        this.viewer.setInput((Object)this.getViewSite());
        this.getSite().getPage().addPartListener((IPartListener2)this.udpateOnVisible);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
    }

    private SelectionListener getSelectionAdapter(final TreeColumn column, final int index) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OmnivoreView.this.ovComparator.setColumn(index);
                OmnivoreView.this.ovComparator.setFlat(OmnivoreView.this.bFlat);
                OmnivoreView.this.viewer.getTree().setSortDirection(OmnivoreView.this.ovComparator.getDirection());
                OmnivoreView.this.viewer.getTree().setSortColumn(column);
                OmnivoreView.this.viewer.refresh();
            }
        };
        return selectionAdapter;
    }

    private void applySortDirection() {
        String[] usrSortSettings = "0,1,-1,false".split(",");
        if (ConfigServiceHolder.getUser((String)"ch.elexis.omnivore//savesortdirection", (boolean)false)) {
            String sortSet = ConfigServiceHolder.getUser((String)"ch.elexis.omnivore//sortdirection", (String)"0,1,-1,false");
            usrSortSettings = sortSet.split(",");
        }
        int propertyIdx = Integer.parseInt(usrSortSettings[0]);
        int direction = Integer.parseInt(usrSortSettings[1]);
        int catDirection = Integer.parseInt(usrSortSettings[2]);
        this.bFlat = Boolean.valueOf(usrSortSettings[3]);
        this.flatViewAction.setChecked(this.bFlat);
        if (!this.bFlat && catDirection != -1) {
            this.sortViewer(1, catDirection);
            this.ovComparator.setCategoryDirection(catDirection);
        }
        if (propertyIdx != 0) {
            this.sortViewer(propertyIdx, direction);
        }
    }

    private void sortViewer(int propertyIdx, int direction) {
        TreeColumn column = this.viewer.getTree().getColumn(propertyIdx);
        this.ovComparator.setColumn(propertyIdx);
        this.ovComparator.setDirection(direction);
        this.ovComparator.setFlat(this.bFlat);
        this.viewer.getTree().setSortDirection(this.ovComparator.getDirection());
        this.viewer.getTree().setSortColumn(column);
        this.viewer.refresh();
    }

    private void applyUsersColumnWidthSetting() {
        TreeColumn[] treeColumns = this.table.getColumns();
        String[] userColWidth = "20,80,80,150,500".split(",");
        if (ConfigServiceHolder.getUser((String)"ch.elexis.omnivore//savecolwidths", (boolean)false)) {
            String ucw = ConfigServiceHolder.getUser((String)"ch.elexis.omnivore//columnwidths", (String)"20,80,80,150,500");
            userColWidth = ucw.split(",");
        }
        int i = 0;
        while (i < treeColumns.length && i < userColWidth.length) {
            treeColumns[i].setWidth(Integer.parseInt(userColWidth[i]));
            ++i;
        }
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener2)this.udpateOnVisible);
        this.saveSortSettings();
        super.dispose();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                OmnivoreView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        MenuManager mnSources = new MenuManager(Messages.OmnivoreView_dataSources);
        manager.add((IAction)this.importAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.editAction);
        manager.add((IAction)this.deleteAction);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.importAction);
        manager.add((IAction)this.exportAction);
        manager.add((IAction)this.flatViewAction);
    }

    private void makeActions() {
        this.importAction = new RestrictedAction((EvaluatableACE)EvACE.of(IDocumentHandle.class, (Right)Right.CREATE), Messages.OmnivoreView_importActionCaption){
            {
                this.setToolTipText(Messages.OmnivoreView_importActionToolTip);
                this.setImageDescriptor(Images.IMG_IMPORT.getImageDescriptor());
            }

            public void doRun() {
                if (ElexisEventDispatcher.getSelectedPatient() == null) {
                    return;
                }
                FileDialog fd = new FileDialog(OmnivoreView.this.getViewSite().getShell(), 4096);
                String filename = fd.open();
                if (filename != null) {
                    IDocumentHandle handle = UiUtils.assimilate(filename);
                    OmnivoreView.this.viewer.refresh();
                    if (handle != null && handle.getContentLength() < 1L) {
                        SWTHelper.showError((String)Messages.OmnivoreView_importActionToolTip, (String)"Beim Import ist eine Fehler aufgetreten. Bitte \u00fcberpr\u00fcfen sie die omnivore Einstellungen, bzw. freien Speicherplatz.");
                        OmnivoreModelServiceHolder.get().remove((Identifiable)handle);
                    }
                }
            }
        };
        this.deleteAction = new LockRequestingRestrictedAction<IDocumentHandle>((EvaluatableACE)EvACE.of(IDocumentHandle.class, (Right)Right.DELETE), Messages.OmnivoreView_deleteActionCaption){
            {
                this.setToolTipText(Messages.OmnivoreView_deleteActionToolTip);
                this.setImageDescriptor(Images.IMG_DELETE.getImageDescriptor());
            }

            public IDocumentHandle getTargetedObject() {
                ISelection selection = OmnivoreView.this.viewer.getSelection();
                return (IDocumentHandle)((IStructuredSelection)selection).getFirstElement();
            }

            public void doRun(IDocumentHandle dh) {
                if (dh.isCategory()) {
                    if (AccessControlServiceHolder.get().evaluate(EvACE.of(IDocumentHandle.class, (Right)Right.DELETE).and(Right.EXECUTE))) {
                        ListDialog ld = new ListDialog(OmnivoreView.this.getViewSite().getShell());
                        IQuery qbe = OmnivoreModelServiceHolder.get().getQuery(IDocumentHandle.class);
                        qbe.and("mimetype", IQuery.COMPARATOR.EQUALS, (Object)"text/category");
                        qbe.and("id", IQuery.COMPARATOR.NOT_EQUALS, (Object)dh.getId());
                        List mainCategories = qbe.execute();
                        ld.setInput((Object)mainCategories);
                        ld.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
                        ld.setLabelProvider((ILabelProvider)new DefaultLabelProvider());
                        ld.setTitle(MessageFormat.format("Kategorie {0} l\u00f6schen", dh.getLabel()));
                        ld.setMessage("Geben Sie bitte an, in welche andere Kategorie die Dokumente dieser Kategorie verschoben werden sollen");
                        int open = ld.open();
                        if (open == 0) {
                            Object[] selection = ld.getResult();
                            if (selection != null && selection.length > 0) {
                                String label = ((IDocumentHandle)selection[0]).getLabel();
                                CategoryUtil.removeCategory((String)dh.getLabel(), (String)label);
                            }
                            OmnivoreView.this.viewer.refresh();
                        }
                    } else {
                        SWTHelper.showError((String)"Insufficient Rights", (String)"You have insufficient rights to delete document categories");
                    }
                } else if (SWTHelper.askYesNo((String)Messages.OmnivoreView_reallyDeleteCaption, (String)MessageFormat.format(Messages.OmnivoreView_reallyDeleteContents, dh.getTitle()))) {
                    OmnivoreModelServiceHolder.get().delete((Deleteable)dh);
                    OmnivoreView.this.viewer.refresh();
                }
            }
        };
        this.editAction = new LockRequestingRestrictedAction<IDocumentHandle>((EvaluatableACE)EvACE.of(IDocumentHandle.class, (Right)Right.UPDATE), Messages.OmnivoreView_editActionCaption){
            {
                this.setToolTipText(Messages.OmnivoreView_editActionTooltip);
                this.setImageDescriptor(Images.IMG_EDIT.getImageDescriptor());
            }

            public IDocumentHandle getTargetedObject() {
                ISelection selection = OmnivoreView.this.viewer.getSelection();
                return (IDocumentHandle)((IStructuredSelection)selection).getFirstElement();
            }

            public void doRun(IDocumentHandle dh) {
                if (dh.isCategory()) {
                    if (AccessControlServiceHolder.get().evaluate(EvACE.of(IDocumentHandle.class, (Right)Right.UPDATE).and(Right.EXECUTE))) {
                        InputDialog id = new InputDialog(OmnivoreView.this.getViewSite().getShell(), MessageFormat.format("Kategorie {0} umbenennen.", dh.getLabel()), "Geben Sie bitte einen neuen Namen f\u00fcr die Kategorie ein", dh.getLabel(), null);
                        if (id.open() == 0) {
                            String nn = id.getValue();
                            CategoryUtil.renameCategory((String)dh.getTitle(), (String)nn);
                            OmnivoreView.this.viewer.refresh();
                        }
                    } else {
                        SWTHelper.showError((String)"Insufficient Rights", (String)"You have insufficient rights to delete document categories");
                    }
                } else {
                    FileImportDialog fid = new FileImportDialog(dh);
                    if (fid.open() == 0) {
                        OmnivoreView.this.viewer.refresh(true);
                    }
                }
            }
        };
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = OmnivoreView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                IDocumentHandle dh = (IDocumentHandle)obj;
                if (dh.isCategory()) {
                    if (OmnivoreView.this.viewer.getExpandedState((Object)dh)) {
                        OmnivoreView.this.viewer.collapseToLevel((Object)dh, -1);
                    } else {
                        OmnivoreView.this.viewer.expandToLevel((Object)dh, -1);
                    }
                } else {
                    UiUtils.open(dh);
                }
            }
        };
        this.exportAction = new Action(Messages.OmnivoreView_exportActionCaption){
            {
                this.setImageDescriptor(Images.IMG_EXPORT.getImageDescriptor());
                this.setToolTipText(Messages.OmnivoreView_exportActionTooltip);
            }

            public void run() {
                ISelection selection = OmnivoreView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj == null) {
                    return;
                }
                IDocumentHandle dh = (IDocumentHandle)obj;
                String mime = dh.getMimeType();
                FileDialog fd = new FileDialog(OmnivoreView.this.getSite().getShell(), 8192);
                fd.setFileName(mime);
                String fname = fd.open();
                if (fname != null && !Utils.storeExternal((IDocumentHandle)dh, (String)fname)) {
                    SWTHelper.showError((String)Messages.OmnivoreView_configErrorCaption, (String)Messages.OmnivoreView_configErrorText);
                }
            }
        };
        this.flatViewAction = new Action(Messages.OmnivoreView_flatActionCaption, 2){
            {
                this.setImageDescriptor(Images.IMG_FILTER.getImageDescriptor());
                this.setToolTipText(Messages.OmnivoreView_flatActionTooltip);
            }

            public void run() {
                OmnivoreView.this.bFlat = this.isChecked();
                OmnivoreView.this.viewer.refresh();
            }
        };
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                OmnivoreView.this.doubleClickAction.run();
            }
        });
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
        this.refresh();
    }

    private void saveColumnWidthSettings() {
        TreeColumn[] treeColumns = this.viewer.getTree().getColumns();
        StringBuilder sb = new StringBuilder();
        TreeColumn[] treeColumnArray = treeColumns;
        int n = treeColumns.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn tc = treeColumnArray[n2];
            sb.append(tc.getWidth());
            sb.append(",");
            ++n2;
        }
        ConfigServiceHolder.setUser((String)"ch.elexis.omnivore//columnwidths", (String)sb.toString());
    }

    private void saveSortSettings() {
        int propertyIdx = this.ovComparator.getPropertyIndex();
        int direction = this.ovComparator.getDirectionDigit();
        int catDirection = this.ovComparator.getCategoryDirection();
        ConfigServiceHolder.setUser((String)"ch.elexis.omnivore//sortdirection", (String)(propertyIdx + "," + direction + "," + catDirection + "," + this.bFlat));
    }

    public void refresh() {
        this.activePatient(ContextServiceHolder.get().getActivePatient().orElse(null));
    }

    public ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"ch.elexis.omnivoredirect", (String)path);
    }

    @Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout((MPart)part, (boolean)currentState);
    }

    class ViewContentProvider
    implements ITreeContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        private void addFilters(IQuery<IDocumentHandle> qbe) {
            qbe.and("title", IQuery.COMPARATOR.LIKE, (Object)("%" + OmnivoreView.this.searchTitle + "%"));
            String[] stringArray = OmnivoreView.this.searchKW.split(" ");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String kw = stringArray[n2];
                if (StringUtils.isNotBlank((CharSequence)kw)) {
                    qbe.and("keywords", IQuery.COMPARATOR.LIKE, (Object)("%" + kw + "%"));
                }
                ++n2;
            }
        }

        private boolean filterMatches(String[] kws, IDocumentHandle h) {
            if (!h.getTitle().toLowerCase().contains(OmnivoreView.this.searchTitle.toLowerCase())) {
                return false;
            }
            String dkw = h.getKeywords().toLowerCase();
            String[] stringArray = kws;
            int n = kws.length;
            int n2 = 0;
            while (n2 < n) {
                String kw = stringArray[n2];
                if (!dkw.contains(kw)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        private List<IDocumentHandle> filterList(List<IDocumentHandle> list) {
            LinkedList<IDocumentHandle> result = new LinkedList<IDocumentHandle>();
            String[] kws = OmnivoreView.this.searchKW.toLowerCase().split(" ");
            for (IDocumentHandle dh : list) {
                if (!this.filterMatches(kws, dh)) continue;
                result.add(dh);
            }
            return result;
        }

        public Object[] getElements(Object parent) {
            LinkedList<Object> ret = new LinkedList<Object>();
            IPatient pat = ContextServiceHolder.get().getActivePatient().orElse(null);
            if (!OmnivoreView.this.bFlat && pat != null) {
                List cats = CategoryUtil.getCategories();
                for (IDocumentHandle dh : cats) {
                    if (this.filterList(Utils.getMembers((IDocumentHandle)dh, (IPatient)pat)).size() <= 0) continue;
                    ret.add(dh);
                }
                IQuery qbe = OmnivoreModelServiceHolder.get().getQuery(IDocumentHandle.class);
                qbe.and("kontakt", IQuery.COMPARATOR.EQUALS, (Object)pat);
                this.addFilters((IQuery<IDocumentHandle>)qbe);
                List root = qbe.execute().parallelStream().filter(d -> d.isCategory()).collect(Collectors.toList());
                ret.addAll(root);
            } else if (pat != null) {
                IQuery qbe = OmnivoreModelServiceHolder.get().getQuery(IDocumentHandle.class);
                qbe.and("kontakt", IQuery.COMPARATOR.EQUALS, (Object)pat);
                this.addFilters((IQuery<IDocumentHandle>)qbe);
                List docs = qbe.execute().parallelStream().filter(d -> !d.isCategory()).collect(Collectors.toList());
                ret.addAll(docs);
            }
            return ret.toArray();
        }

        public Object[] getChildren(Object parentElement) {
            IPatient pat = ContextServiceHolder.get().getActivePatient().orElse(null);
            if (!OmnivoreView.this.bFlat && pat != null && parentElement instanceof IDocumentHandle) {
                IDocumentHandle dhParent = (IDocumentHandle)parentElement;
                return this.filterList(Utils.getMembers((IDocumentHandle)dhParent, (IPatient)pat)).toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (!OmnivoreView.this.bFlat && element instanceof IDocumentHandle) {
                IDocumentHandle dh = (IDocumentHandle)element;
                return dh.getCategory();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IDocumentHandle) {
                IDocumentHandle dh = (IDocumentHandle)element;
                return dh.isCategory();
            }
            return false;
        }
    }

    class ViewLabelProvider
    extends ColumnLabelProvider
    implements IToolTipProvider {
        private SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");

        ViewLabelProvider() {
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            int columnIndex = cell.getColumnIndex();
            if (!(element instanceof IDocumentHandle)) {
                cell.setText("");
                return;
            }
            IDocumentHandle dh = (IDocumentHandle)element;
            if (dh.isCategory()) {
                cell.setText(columnIndex == 1 ? dh.getCategory().getName() : "");
                return;
            }
            switch (columnIndex) {
                case 0: {
                    cell.setText("");
                    break;
                }
                case 1: {
                    cell.setText(OmnivoreView.this.bFlat ? dh.getCategory().getName() : "");
                    break;
                }
                case 2: {
                    cell.setText(this.dateFormat.format(dh.getLastchanged()));
                    break;
                }
                case 3: {
                    cell.setText(this.dateFormat.format(dh.getCreated()));
                    break;
                }
                case 4: {
                    cell.setText(dh.getTitle());
                    break;
                }
                case 5: {
                    cell.setText(dh.getKeywords());
                    break;
                }
                default: {
                    cell.setText("");
                }
            }
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }

        public Image getImage(Object obj) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String getToolTipText(Object element) {
            if (!(element instanceof IDocumentHandle)) return null;
            IDocumentHandle docHandle = (IDocumentHandle)element;
            if (docHandle.isCategory()) return null;
            String docId = docHandle.getId();
            String objectToSearch = "ch.elexis.omnivore.data.DocHandle::" + docId;
            IQuery inboxQuery = InboxServiceHolder.getModelService().getQuery(IInboxElement.class);
            inboxQuery.and("object", IQuery.COMPARATOR.EQUALS, (Object)objectToSearch);
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (IQueryCursor cursor = inboxQuery.executeAsCursor();){
                    IInboxElement inboxElement;
                    String inboxElementObjectString;
                    do {
                        if (cursor.hasNext()) continue;
                        return null;
                    } while (!(inboxElementObjectString = (inboxElement = (IInboxElement)cursor.next()).getObject().toString()).contains(docId));
                    IInboxElementService.State state = inboxElement.getState();
                    if (state != IInboxElementService.State.SEEN) return "Nicht gesehen";
                    String mandatorCode = inboxElement.getMandator().getCode();
                    String lastUpdateFormatted = this.formatLastUpdate(inboxElement.getLastupdate(), mandatorCode);
                    return "Gesehen " + lastUpdateFormatted;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    }
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return null;
        }

        private String formatLastUpdate(Long timestamp, String mandatorCode) {
            Date date = new Date(timestamp);
            SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm");
            return sdf.format(date) + " " + mandatorCode;
        }
    }
}

