/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.omnivore.ui.views;

import ch.elexis.core.ac.EvACE;
import ch.elexis.core.ac.EvaluatableACE;
import ch.elexis.core.ac.Right;
import ch.elexis.core.model.ICategory;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.AccessControlServiceHolder;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.omnivore.data.Preferences;
import ch.elexis.omnivore.model.IDocumentHandle;
import ch.elexis.omnivore.model.TransientCategory;
import ch.elexis.omnivore.model.util.CategoryUtil;
import ch.elexis.omnivore.ui.Messages;
import ch.elexis.omnivore.ui.service.OmnivoreModelServiceHolder;
import ch.elexis.omnivore.ui.util.CategorySelectDialog;
import ch.rgw.tools.TimeTool;
import com.tiff.common.ui.datepicker.DatePickerCombo;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class FileImportDialog
extends TitleAreaDialog {
    String file;
    IDocumentHandle dh;
    DatePickerCombo saveDatePicker;
    DatePickerCombo originDatePicker;
    Text tTitle;
    Text tKeywords;
    Combo cbCategories;
    public Date saveDate;
    public Date originDate;
    public String title;
    public String keywords;
    public String category;
    private String preSelectedCategory;

    public FileImportDialog(IDocumentHandle dh) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.dh = dh;
        this.file = dh.getTitle();
    }

    public FileImportDialog(String name) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.file = name;
    }

    public FileImportDialog(String name, String preSelectedCategory) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.file = name;
        this.preSelectedCategory = preSelectedCategory;
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayout((Layout)new GridLayout());
        ret.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        if (Preferences.getDateModifiable()) {
            Composite dateComposite = new Composite(ret, 0);
            dateComposite.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
            dateComposite.setLayout((Layout)new RowLayout(256));
            new Label(dateComposite, 0).setText(Messages.FileImportDialog_dateLabel);
            this.saveDatePicker = new DatePickerCombo(dateComposite, 0);
            if (this.dh == null) {
                this.saveDatePicker.setDate(new Date());
            } else {
                this.saveDatePicker.setDate(new TimeTool(this.dh.getLastchanged()).getTime());
            }
            new Label(dateComposite, 0).setText(Messages.FileImportDialog_dateOriginLabel);
            this.originDatePicker = new DatePickerCombo(dateComposite, 0);
            if (this.dh == null) {
                this.originDatePicker.setDate(new Date());
            } else {
                this.originDatePicker.setDate(new TimeTool(this.dh.getCreated()).getTime());
            }
        }
        new Label(ret, 0).setText(Messages.FileImportDialog_categoryLabel);
        Composite cCats = new Composite(ret, 0);
        cCats.setFocus();
        cCats.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        cCats.setLayout((Layout)new RowLayout(256));
        this.cbCategories = new Combo(cCats, 4);
        RowData rd = new RowData(200, -1);
        this.cbCategories.setLayoutData((Object)rd);
        Button bNewCat = new Button(cCats, 8);
        bNewCat.setImage(Images.IMG_NEW.getImage());
        bNewCat.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog id = new InputDialog(FileImportDialog.this.getShell(), Messages.FileImportDialog_newCategoryCaption, Messages.FileImportDialog_newCategoryText, null, null);
                if (id.open() == 0) {
                    CategoryUtil.addCategory((String)id.getValue());
                    FileImportDialog.this.cbCategories.add(id.getValue());
                    FileImportDialog.this.cbCategories.setText(id.getValue());
                }
            }
        });
        Button bEditCat = new Button(cCats, 8);
        bEditCat.setImage(Images.IMG_EDIT.getImage());
        bEditCat.setToolTipText(Messages.DocumentMetaDataDialog_renameCategory);
        bEditCat.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String old = FileImportDialog.this.cbCategories.getText();
                InputDialog id = new InputDialog(FileImportDialog.this.getShell(), MessageFormat.format(Messages.DocumentMetaDataDialog_renameCategoryConfirm, old), Messages.DocumentMetaDataDialog_renameCategoryText, old, null);
                if (id.open() == 0) {
                    String nn = id.getValue();
                    CategoryUtil.renameCategory((String)old, (String)nn);
                    FileImportDialog.this.cbCategories.remove(old);
                    FileImportDialog.this.cbCategories.add(nn);
                    FileImportDialog.this.cbCategories.select(FileImportDialog.this.cbCategories.getItemCount() - 1);
                }
            }
        });
        Button bDeleteCat = new Button(cCats, 8);
        bDeleteCat.setImage(Images.IMG_DELETE.getImage());
        bDeleteCat.setToolTipText(Messages.Core_Delete_Document_Category);
        bDeleteCat.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                String old = FileImportDialog.this.cbCategories.getText();
                CategorySelectDialog catSelectDialog = new CategorySelectDialog(FileImportDialog.this.getShell(), MessageFormat.format(Messages.DocumentMetaDataDialog_deleteCategoryConfirm, old), Messages.DocumentMetaDataDialog_deleteCategoryConfirmText, CategoryUtil.getCategoriesNames());
                if (catSelectDialog.open() == 0) {
                    String newCategory = catSelectDialog.getSelectedCategory();
                    CategoryUtil.removeCategory((String)old, (String)newCategory);
                    FileImportDialog.this.cbCategories.remove(old);
                    FileImportDialog.this.cbCategories.add(newCategory);
                    FileImportDialog.this.cbCategories.setText(newCategory);
                }
            }
        });
        List cats = CategoryUtil.getCategoriesNames();
        if (cats.size() > 0) {
            Collections.sort(cats);
            this.cbCategories.setItems(cats.toArray(new String[0]));
            if (this.preSelectedCategory == null) {
                this.cbCategories.select(0);
            } else {
                String[] items = this.cbCategories.getItems();
                int i = 0;
                while (i < items.length) {
                    if (items[i].equals(this.preSelectedCategory)) {
                        this.cbCategories.select(i);
                    }
                    ++i;
                }
            }
        }
        new Label(ret, 0).setText(Messages.FileImportDialog_titleLabel);
        this.tTitle = SWTHelper.createText((Composite)ret, (int)1, (int)0);
        new Label(ret, 0).setText(Messages.FileImportDialog_keywordsLabel);
        this.tKeywords = SWTHelper.createText((Composite)ret, (int)4, (int)512);
        this.tTitle.setText(this.file);
        if (this.dh != null) {
            this.tKeywords.setText(this.dh.getKeywords());
            this.cbCategories.setText(this.dh.getCategory().getName());
        }
        bEditCat.setEnabled(AccessControlServiceHolder.get().evaluate((EvaluatableACE)EvACE.of(ICategory.class, (Right)Right.UPDATE)));
        bDeleteCat.setEnabled(AccessControlServiceHolder.get().evaluate((EvaluatableACE)EvACE.of(ICategory.class, (Right)Right.DELETE)));
        bNewCat.setEnabled(AccessControlServiceHolder.get().evaluate((EvaluatableACE)EvACE.of(ICategory.class, (Right)Right.CREATE)));
        return ret;
    }

    public void create() {
        super.create();
        this.setTitle(this.file);
        this.getShell().setText(Messages.FileImportDialog_importCaption);
        this.setMessage(Messages.FileImportDialog_importFileText);
    }

    protected void okPressed() {
        this.setDateValues();
        this.keywords = this.tKeywords.getText();
        this.title = this.tTitle.getText();
        this.category = this.cbCategories.getText();
        if (this.dh != null) {
            this.dh.setLastchanged(this.saveDate);
            this.dh.setCreated(this.originDate);
            if (this.category.length() > 0) {
                this.dh.setCategory((ICategory)new TransientCategory(this.category));
            }
            this.dh.setTitle(this.title);
            this.dh.setKeywords(this.keywords);
            OmnivoreModelServiceHolder.get().save((Identifiable)this.dh);
        }
        super.okPressed();
    }

    private void setDateValues() {
        if (this.saveDatePicker != null) {
            this.saveDate = this.saveDatePicker.getDate();
        }
        if (this.originDatePicker != null) {
            this.originDate = this.originDatePicker.getDate();
        }
        if (this.saveDate == null && this.originDate != null) {
            this.saveDate = this.originDate;
        } else if (this.originDate == null && this.saveDate != null) {
            this.originDate = this.saveDate;
        } else if (this.saveDate == null && this.originDate == null) {
            this.saveDate = new Date();
            this.originDate = new Date();
        }
    }

    protected boolean isResizable() {
        return true;
    }
}

