/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.omnivore.ui.dbcheck;

import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.INativeQuery;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.IQueryCursor;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.dbcheck.external.ExternalMaintenance;
import ch.elexis.core.ui.dialogs.base.InputDialog;
import ch.elexis.omnivore.model.IDocumentHandle;
import ch.elexis.omnivore.ui.service.OmnivoreModelServiceHolder;
import ch.elexis.scripting.CSVWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.LoggerFactory;

public class RebuildFromDirectory
extends ExternalMaintenance {
    private String importPath;
    private boolean matchDbId;
    private boolean matchMimetype;
    private static final String DOCHANDLE_MIME_QUERY = "SELECT ID FROM ch_elexis_omnivore_data WHERE deleted = '0' AND mimetype = ?1";
    private INativeQuery mimeQuery;

    public String executeMaintenance(IProgressMonitor pm, String DBVersion) {
        this.mimeQuery = null;
        Display display = Display.getDefault();
        display.syncExec(() -> {
            InputDialog dlg;
            if (!ConfigServiceHolder.get().get("ch.elexis.omnivore/store_in_fs", false)) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)"Omnivore Konfiguration Speichern im Dateisystem nicht aktiv.");
            }
            if ((dlg = new InputDialog(Display.getDefault().getActiveShell(), "Verzeichnis", "Absoluter Pfad zum Verzeichnis aus dem wieder hergestellt werden soll.", "", new IInputValidator(){

                public String isValid(String newText) {
                    File file = new File(newText);
                    if (file.exists() && file.isDirectory()) {
                        return null;
                    }
                    return "[" + newText + "] ist kein vorhandenes Verzeichnis";
                }
            }, 0){

                protected Control createDialogArea(Composite parent) {
                    Composite c = (Composite)super.createDialogArea(parent);
                    final Button bMatchId = new Button(c, 32);
                    bMatchId.setText("Dateiname ist DB ID");
                    bMatchId.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            (this).RebuildFromDirectory.this.matchDbId = bMatchId.getSelection();
                        }
                    });
                    final Button bMatchMime = new Button(c, 32);
                    bMatchMime.setText("Dateiname ist Mimetype");
                    bMatchMime.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            (this).RebuildFromDirectory.this.matchMimetype = bMatchMime.getSelection();
                        }
                    });
                    return c;
                }
            }).open() == 0 && dlg.getValue() != null && !dlg.getValue().isEmpty()) {
                this.importPath = dlg.getValue();
            }
        });
        int imported = 0;
        int total = 0;
        if (this.matchDbId || this.matchMimetype) {
            if (StringUtils.isNotBlank((CharSequence)this.importPath)) {
                File importDir = new File(this.importPath);
                File[] files = importDir.listFiles();
                pm.beginTask("Wiederherstellen aus Dateien", files.length);
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File importFile = fileArray[n2];
                    if (importFile.isFile()) {
                        Object found;
                        String fileId = FilenameUtils.getBaseName((String)importFile.getName());
                        Optional documentHandle = Optional.empty();
                        if (this.matchDbId) {
                            documentHandle = OmnivoreModelServiceHolder.get().load(fileId, IDocumentHandle.class, true);
                        } else if (this.matchMimetype) {
                            if (this.mimeQuery == null) {
                                this.mimeQuery = OmnivoreModelServiceHolder.get().getNativeQuery(DOCHANDLE_MIME_QUERY);
                            }
                            if (!(found = this.mimeQuery.executeWithParameters(Collections.singletonMap(1, importFile.getName())).collect(Collectors.toList())).isEmpty()) {
                                if (found.size() == 1) {
                                    String handleId = found.get(0).toString();
                                    documentHandle = OmnivoreModelServiceHolder.get().load(handleId, IDocumentHandle.class, true);
                                } else {
                                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Multiple DB entries for file [" + importFile.getName() + "]");
                                }
                            }
                        }
                        if (documentHandle.isPresent()) {
                            try {
                                found = null;
                                Object var15_21 = null;
                                try (FileInputStream fi = new FileInputStream(importFile);){
                                    ((IDocumentHandle)documentHandle.get()).setContent((InputStream)fi);
                                    ++imported;
                                }
                                catch (Throwable throwable) {
                                    if (found == null) {
                                        found = throwable;
                                    } else if (found != throwable) {
                                        ((Throwable)found).addSuppressed(throwable);
                                    }
                                    throw found;
                                }
                            }
                            catch (IOException e) {
                                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error importing file", (Throwable)e);
                            }
                            this.moveToImported(importFile);
                        } else {
                            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("No DB entry for file [" + importFile.getName() + "]");
                        }
                        pm.worked(1);
                        ++total;
                    }
                    ++n2;
                }
                pm.beginTask("\u00dcberpr\u00fcfen aller Omnivore Eintr\u00e4ge", -1);
                IQuery queryAll = OmnivoreModelServiceHolder.get().getQuery(IDocumentHandle.class);
                ArrayList<IDocumentHandle> invalidEntries = new ArrayList<IDocumentHandle>();
                Throwable throwable = null;
                fileArray = null;
                try (IQueryCursor all = queryAll.executeAsCursor();){
                    while (all.hasNext()) {
                        IDocumentHandle dh = (IDocumentHandle)all.next();
                        if (dh.isCategory() || !this.isMissingEntry(dh)) continue;
                        invalidEntries.add(dh);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                if (!invalidEntries.isEmpty()) {
                    this.writeCsv(invalidEntries, importDir);
                }
            }
        } else {
            return "Kein Dateiname Vergleich zu DB Feld ausgew\u00e4hlt";
        }
        return "Es wurden " + imported + " Dateien von " + total + " importiert";
    }

    private void moveToImported(File importFile) {
        try {
            File importedDir = new File(importFile.getParentFile(), "imported");
            FileUtils.moveFileToDirectory((File)importFile, (File)importedDir, (boolean)true);
        }
        catch (IOException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error moving file to imported dir", (Throwable)e);
        }
    }

    private void writeCsv(List<IDocumentHandle> invalidEntries, File importDir) {
        block15: {
            CSVWriter csv = null;
            try {
                try {
                    csv = new CSVWriter((Writer)new FileWriter(new File(importDir, "invalid_omnivore.csv")));
                    String[] header = new String[]{"id", "patnr", "patdesc1", "patdesc2", "category", "title", "mime", "keywords"};
                    csv.writeNext(header);
                    for (IDocumentHandle entry : invalidEntries) {
                        IPatient pat = entry.getPatient();
                        String[] line = new String[header.length];
                        line[0] = entry.getId();
                        if (pat != null) {
                            line[1] = pat.getCode();
                            line[2] = pat.getDescription1();
                            line[3] = pat.getDescription2();
                        } else {
                            line[1] = "no pat";
                            line[2] = "no pat";
                            line[3] = "no pat";
                        }
                        line[4] = entry.getCategory() != null ? entry.getCategory().getName() : "no cat";
                        line[5] = entry.getTitle();
                        line[6] = entry.getMimeType();
                        line[7] = entry.getKeywords();
                        csv.writeNext(line);
                    }
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error writing csv with invalid omnivore entries", (Throwable)e);
                    if (csv == null) break block15;
                    try {
                        csv.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (csv != null) {
                    try {
                        csv.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private boolean isMissingEntry(IDocumentHandle dh) {
        try {
            InputStream content = dh.getContent();
            content.close();
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    public String getMaintenanceDescription() {
        return "Omnivore aus Verzeichnis wiederherstellen.";
    }
}

