/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.omnivore.ui.inbox;

import at.medevit.elexis.inbox.model.IInboxElementService;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.services.EncounterServiceHolder;
import ch.elexis.omnivore.model.IDocumentHandle;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

@Component(property={"event.topics=info/elexis/model/create"})
public class DocHandleInboxService
implements EventHandler {
    @Reference
    private IInboxElementService service;
    @Reference
    private IConfigService configService;

    private void createInboxElement(IDocumentHandle docHandle) {
        if (docHandle != null && !docHandle.isCategory()) {
            Optional encounter = EncounterServiceHolder.get().getLatestEncounter(docHandle.getPatient());
            IMandator mandator = null;
            mandator = encounter.isPresent() ? ((IEncounter)encounter.get()).getMandator() : (IMandator)ContextServiceHolder.get().getActiveMandator().orElse(null);
            if (mandator != null) {
                this.service.createInboxElement(docHandle.getPatient(), mandator, (Identifiable)docHandle);
            }
        }
    }

    public void handleEvent(Event event) {
        boolean showCreatedInInbox = this.configService.get("ch.elexis.omnivore/showCreatedInInbox", true);
        if (showCreatedInInbox && event.getProperty("org.eclipse.e4.data") instanceof IDocumentHandle) {
            this.createInboxElement((IDocumentHandle)event.getProperty("org.eclipse.e4.data"));
        }
    }
}

