/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.omnivore.ui.util;

import ch.elexis.omnivore.model.util.CategoryUtil;
import ch.elexis.omnivore.ui.Messages;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CategorySelectDialog
extends Dialog {
    private Combo combo;
    private Text textInput;
    private List<String> categories;
    private String selectedCategory;
    private String title;
    private String message;

    public CategorySelectDialog(Shell parentShell, String title, String message, List<String> categories) {
        super(parentShell);
        this.title = title;
        this.message = message;
        this.categories = categories;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        Label label = new Label(container, 0);
        label.setText(this.message);
        this.textInput = new Text(container, 2048);
        this.textInput.setMessage(Messages.DocumentMetaDataDialog_deleteCategoryComboConfirmText);
        this.combo = new Combo(container, 12);
        this.combo.add(Messages.DocumentMetaDataDialog_deleteCategoryComboConfirm);
        for (String category : this.categories) {
            this.combo.add(category);
        }
        this.combo.select(0);
        return container;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected void okPressed() {
        String userInput = this.textInput.getText().trim();
        if (!userInput.isEmpty()) {
            if (!this.categories.contains(userInput)) {
                CategoryUtil.addCategory((String)userInput);
            }
            this.selectedCategory = userInput;
        } else {
            this.selectedCategory = this.combo.getText();
        }
        super.okPressed();
    }

    public String getSelectedCategory() {
        return this.selectedCategory;
    }
}

