/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.omnivore.ui.dbcheck;

import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.IQueryCursor;
import ch.elexis.core.services.IVirtualFilesystemService;
import ch.elexis.core.ui.dbcheck.external.ExternalMaintenance;
import ch.elexis.omnivore.model.IDocumentHandle;
import ch.elexis.omnivore.model.util.Utils;
import ch.elexis.omnivore.ui.service.OmnivoreModelServiceHolder;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixOrDeleteInvalidDocHandles
extends ExternalMaintenance {
    private Logger logger = LoggerFactory.getLogger(FixOrDeleteInvalidDocHandles.class);
    private int deleteCount;
    private int repairCount;

    public String executeMaintenance(IProgressMonitor pm, String DBVersion) {
        IQuery query = OmnivoreModelServiceHolder.get().getQuery(IDocumentHandle.class);
        query.and("id", IQuery.COMPARATOR.NOT_EQUALS, (Object)"1");
        query.and((EStructuralFeature)ModelPackage.Literals.IDOCUMENT__MIME_TYPE, IQuery.COMPARATOR.NOT_EQUALS, (Object)"text/category");
        Throwable throwable = null;
        Object var5_6 = null;
        try (IQueryCursor cursor = query.executeAsCursor();){
            pm.beginTask("Bitte warten, Omnivore Eitr\u00e4ge werden gepr\u00fcft ...", cursor.size());
            this.deleteCount = 0;
            this.repairCount = 0;
            while (cursor.hasNext()) {
                IDocumentHandle docHandle = (IDocumentHandle)cursor.next();
                this.logger.info("Loading content of DocHandle [" + docHandle.getId() + "]");
                InputStream ret = docHandle.getContent();
                if (ret != null) continue;
                IVirtualFilesystemService.IVirtualFilesystemHandle vfsHandle = Utils.getStorageFile((IDocumentHandle)docHandle, (boolean)true);
                try {
                    if (vfsHandle == null || vfsHandle.exists()) continue;
                    IVirtualFilesystemService.IVirtualFilesystemHandle directory = vfsHandle.getParent();
                    if (directory != null && directory.exists()) {
                        IVirtualFilesystemService.IVirtualFilesystemHandle[] handles = directory.listHandles(handle -> Objects.equals(FilenameUtils.getBaseName((String)handle.getName()), docHandle.getId()));
                        if (handles.length > 0) {
                            this.repair(docHandle, handles[0]);
                            continue;
                        }
                        this.delete(docHandle);
                        continue;
                    }
                    this.delete(docHandle);
                }
                catch (IOException e) {
                    this.logger.warn("DocHandle [" + docHandle.getId() + "]", (Throwable)e);
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return "Es wurden " + this.deleteCount + " Eintr\u00e4ge entfernt (Details siehe Log)\nEs wurden " + this.repairCount + " Eintr\u00e4ge repariert (Details siehe Log)";
    }

    private void repair(IDocumentHandle docHandle, IVirtualFilesystemService.IVirtualFilesystemHandle file) {
        ++this.repairCount;
        this.logger.warn("Repair DocHandle [" + docHandle.getLabel() + "] of patient [" + (docHandle.getPatient() != null ? docHandle.getPatient().getPatientNr() : "no patient") + "] with file [" + file.getName() + "]");
        docHandle.setMimeType(file.getName());
    }

    private void delete(IDocumentHandle docHandle) {
        ++this.deleteCount;
        this.logger.warn("Delete DocHandle [" + docHandle.getLabel() + "] of patient [" + (docHandle.getPatient() != null ? docHandle.getPatient().getPatientNr() : "no patient") + "]");
        OmnivoreModelServiceHolder.get().delete((Deleteable)docHandle);
    }

    public String getMaintenanceDescription() {
        return "Omnivore Eintr\u00e4ge \u00fcberpr\u00fcfen, reparieren oder entfernen";
    }
}

