/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.omnivore.model;

import ch.elexis.core.jpa.entities.DocHandle;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.Kontakt;
import ch.elexis.core.jpa.model.adapter.AbstractIdDeleteModelAdapter;
import ch.elexis.core.model.ICategory;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IHistory;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IXid;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.INativeQuery;
import ch.elexis.core.services.IVirtualFilesystemService;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.VirtualFilesystemServiceHolder;
import ch.elexis.core.services.holder.XidServiceHolder;
import ch.elexis.core.time.TimeUtil;
import ch.elexis.core.types.DocumentStatus;
import ch.elexis.core.types.DocumentStatusMapper;
import ch.elexis.omnivore.model.IDocumentHandle;
import ch.elexis.omnivore.model.Messages;
import ch.elexis.omnivore.model.TransientCategory;
import ch.elexis.omnivore.model.internal.ModelUtil;
import ch.elexis.omnivore.model.internal.Preferences;
import ch.elexis.omnivore.model.service.OmnivoreModelServiceHolder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;

public class DocumentDocHandle
extends AbstractIdDeleteModelAdapter<DocHandle>
implements Identifiable,
IDocumentHandle {
    private String storeId = "";

    public DocumentDocHandle(DocHandle entity) {
        super((EntityWithId)entity);
    }

    public String getTitle() {
        return ((DocHandle)this.getEntity()).getTitle();
    }

    public void setTitle(String value) {
        ((DocHandle)this.getEntityMarkDirty()).setTitle(value);
    }

    public String getDescription() {
        return "";
    }

    public void setDescription(String value) {
    }

    public List<DocumentStatus> getStatus() {
        int status = ((DocHandle)this.getEntity()).getStatus();
        return new ArrayList<DocumentStatus>(DocumentStatusMapper.map((int)status));
    }

    public void setStatus(DocumentStatus status, boolean active) {
        HashSet<DocumentStatus> _statusSet = new HashSet<DocumentStatus>(this.getStatus());
        if (active) {
            _statusSet.add(status);
        } else {
            _statusSet.remove(status);
        }
        int value = DocumentStatusMapper.map(_statusSet);
        ((DocHandle)this.getEntity()).setStatus(value);
    }

    public Date getCreated() {
        LocalDate creationDate = ((DocHandle)this.getEntity()).getCreationDate();
        return creationDate != null ? this.toDate(creationDate) : this.getLastchanged();
    }

    public void setCreated(Date value) {
        ((DocHandle)this.getEntityMarkDirty()).setCreationDate(TimeUtil.toLocalDate((Date)value));
    }

    public Date getLastchanged() {
        if (((DocHandle)this.getEntity()).getDatum() != null) {
            return this.toDate(((DocHandle)this.getEntity()).getDatum());
        }
        if (((DocHandle)this.getEntity()).getLastupdate() != null) {
            return new Date(((DocHandle)this.getEntity()).getLastupdate());
        }
        return new Date(0L);
    }

    public void setLastchanged(Date value) {
        ((DocHandle)this.getEntityMarkDirty()).setDatum(TimeUtil.toLocalDate((Date)value));
    }

    public String getMimeType() {
        return StringUtils.defaultString((String)((DocHandle)this.getEntity()).getMimetype());
    }

    public void setMimeType(String value) {
        ((DocHandle)this.getEntityMarkDirty()).setMimetype(value);
    }

    public ICategory getCategory() {
        if (((DocHandle)this.getEntity()).getCategory() != null) {
            return new TransientCategory(((DocHandle)this.getEntity()).getCategory());
        }
        return new TransientCategory("?");
    }

    public void setCategory(ICategory value) {
        ((DocHandle)this.getEntityMarkDirty()).setCategory(value.getName());
    }

    public List<IHistory> getHistory() {
        return Collections.emptyList();
    }

    public String getStoreId() {
        return StringUtils.isNotEmpty((CharSequence)this.storeId) ? this.storeId : "ch.elexis.data.store.omnivore";
    }

    public void setStoreId(String value) {
        this.storeId = value;
    }

    public String getExtension() {
        return ModelUtil.evaluateFileExtension(((DocHandle)this.getEntity()).getMimetype());
    }

    public void setExtension(String value) {
    }

    public String getKeywords() {
        return StringUtils.defaultString((String)((DocHandle)this.getEntity()).getKeywords());
    }

    public void setKeywords(String value) {
        ((DocHandle)this.getEntityMarkDirty()).setKeywords(value);
    }

    public IPatient getPatient() {
        return CoreModelServiceHolder.get().load(((DocHandle)this.getEntity()).getKontakt().getId(), IPatient.class).orElse(null);
    }

    public void setPatient(IPatient value) {
        if (value instanceof AbstractIdDeleteModelAdapter) {
            ((DocHandle)this.getEntityMarkDirty()).setKontakt((Kontakt)((AbstractIdDeleteModelAdapter)value).getEntity());
        } else if (value == null) {
            ((DocHandle)this.getEntityMarkDirty()).setKontakt(null);
        }
    }

    public IContact getAuthor() {
        return null;
    }

    public void setAuthor(IContact value) {
    }

    public InputStream getContent() {
        byte[] contents = this.getContents();
        if (contents != null) {
            return new ByteArrayInputStream(contents);
        }
        return null;
    }

    public void setContent(InputStream content) {
        block12: {
            this.setStatus(DocumentStatus.PREPROCESSED, false);
            this.setStatus(DocumentStatus.INDEXED, false);
            this.setLastchanged(new Date());
            try {
                IVirtualFilesystemService.IVirtualFilesystemHandle vfsHandle = this.getStorageFile(false);
                if (vfsHandle == null) {
                    ((DocHandle)this.getEntityMarkDirty()).setDoc(IOUtils.toByteArray((InputStream)content));
                    break block12;
                }
                Throwable throwable = null;
                Object var4_6 = null;
                try (OutputStream out = vfsHandle.openOutputStream();){
                    out.write(IOUtils.toByteArray((InputStream)content));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).error("Error setting content", (Throwable)e);
            }
        }
    }

    private byte[] getContents() {
        byte[] ret = ((DocHandle)this.getEntity()).getDoc();
        if (ret == null) {
            IVirtualFilesystemService.IVirtualFilesystemHandle vfsHandle = this.getStorageFile(true);
            try {
                if (vfsHandle != null && vfsHandle.exists()) {
                    byte[] bytes = vfsHandle.readAllBytes();
                    if (!Preferences.storeInFilesystem()) {
                        ((DocHandle)this.getEntity()).setDoc(bytes);
                    }
                    return bytes;
                }
                LoggerFactory.getLogger(this.getClass()).error("Error content of [{}] from [{}] does not exist", (Object)this.getId(), (Object)vfsHandle);
            }
            catch (Exception ex) {
                LoggerFactory.getLogger(this.getClass()).error("Getting content of [{}] fails [{}]", new Object[]{this.getId(), vfsHandle, ex});
                throw new IllegalStateException(ex);
            }
        }
        return ret;
    }

    public long getContentLength() {
        Object next;
        INativeQuery nativeQuery = CoreModelServiceHolder.get().getNativeQuery("SELECT LENGTH(DOC) FROM CH_ELEXIS_OMNIVORE_DATA WHERE ID = ?1");
        Iterator result = nativeQuery.executeWithParameters(nativeQuery.getIndexedParameterMap(new Object[]{1, this.getId()})).iterator();
        if (result.hasNext() && (next = result.next()) != null) {
            return Long.parseLong(next.toString());
        }
        try {
            IVirtualFilesystemService.IVirtualFilesystemHandle vfsHandle = this.getStorageFile(false);
            if (vfsHandle != null && vfsHandle.canRead()) {
                return vfsHandle.getContentLenght();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return -1L;
    }

    @Override
    public IVirtualFilesystemService.IVirtualFilesystemHandle getHandle() {
        return this.getStorageFile(true);
    }

    public IVirtualFilesystemService.IVirtualFilesystemHandle getStorageFile(boolean force) {
        if (force || Preferences.storeInFilesystem()) {
            String pathname = Preferences.getBasepath();
            if (pathname != null) {
                try {
                    IVirtualFilesystemService.IVirtualFilesystemHandle storageDir = VirtualFilesystemServiceHolder.get().of(pathname);
                    if (storageDir.isDirectory()) {
                        IPatient patient = CoreModelServiceHolder.get().load(((DocHandle)this.getEntity()).getKontakt().getId(), IPatient.class).orElse(null);
                        if (patient != null) {
                            IVirtualFilesystemService.IVirtualFilesystemHandle noExtensionFile;
                            IVirtualFilesystemService.IVirtualFilesystemHandle file;
                            IVirtualFilesystemService.IVirtualFilesystemHandle patientDir = storageDir.subDir(patient.getPatientNr());
                            if (!patientDir.exists()) {
                                patientDir.mkdir();
                            }
                            if (!(file = patientDir.subFile(this.getId() + "." + this.getExtension())).exists() && (noExtensionFile = patientDir.subFile(this.getId())).exists()) {
                                noExtensionFile.copyTo(file);
                                noExtensionFile.delete();
                            }
                            return file;
                        }
                        if (((DocHandle)this.getEntity()).getKontakt() == null) {
                            LoggerFactory.getLogger(this.getClass()).error("DocHandle [" + ((DocHandle)this.getEntity()).getId() + "] has no patient");
                        } else {
                            LoggerFactory.getLogger(this.getClass()).error("Contact [" + ((DocHandle)this.getEntity()).getKontakt().getId() + "] is not a patient");
                        }
                    }
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(this.getClass()).error("DocHandle [" + ((DocHandle)this.getEntity()).getId() + "] IOException", (Throwable)e);
                    return null;
                }
            }
            if (Preferences.storeInFilesystem()) {
                LoggerFactory.getLogger(this.getClass()).error("Config error: " + Messages.DocHandle_configErrorText);
            }
        }
        return null;
    }

    @Override
    public boolean isCategory() {
        return this.getMimeType().equals("text/category");
    }

    @Override
    public boolean exportToFileSystem() {
        byte[] doc = ((DocHandle)this.getEntity()).getDoc();
        if (doc == null) {
            return true;
        }
        IVirtualFilesystemService.IVirtualFilesystemHandle vfsHandle = this.getStorageFile(true);
        if (vfsHandle != null) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (OutputStream out = vfsHandle.openOutputStream();){
                    out.write(doc);
                    ((DocHandle)this.getEntity()).setDoc(null);
                    OmnivoreModelServiceHolder.get().save((Identifiable)this);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ios) {
                LoggerFactory.getLogger(this.getClass()).error("Exporting dochandle [" + this.getId() + "] to filesystem fails.");
                return false;
            }
        }
        return true;
    }

    public boolean addXid(String domain, String id, boolean updateIfExists) {
        return XidServiceHolder.get().addXid((Identifiable)this, domain, id, updateIfExists);
    }

    public IXid getXid(String domain) {
        return XidServiceHolder.get().getXid((Identifiable)this, domain);
    }

    public String getLabel() {
        if (this.isCategory()) {
            return this.getTitle();
        }
        StringBuilder sb = new StringBuilder();
        Date date = this.getCreated();
        if (date != null) {
            SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy");
            sb.append(format.format(date));
            sb.append(" ");
        }
        sb.append(this.getTitle());
        return sb.toString();
    }
}

