/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.omnivore.model.internal;

import ch.elexis.core.services.holder.ConfigServiceHolder;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;

public class Preferences {
    public static boolean storeInFilesystem() {
        if (StringUtils.isNotEmpty((CharSequence)System.getProperty("ch.elexis.documents"))) {
            return true;
        }
        if (ConfigServiceHolder.getGlobal((String)"ch.elexis.omnivore/store_in_fs_global", (boolean)false)) {
            return ConfigServiceHolder.getGlobal((String)"ch.elexis.omnivore/store_in_fs", (boolean)false);
        }
        return ConfigServiceHolder.getLocal((String)"ch.elexis.omnivore/store_in_fs", (boolean)false);
    }

    public static String getBasepath() {
        String demoPath = System.getProperty("ch.elexis.documents");
        if (StringUtils.isNotEmpty((CharSequence)demoPath)) {
            File f = new File(demoPath);
            if (!f.isAbsolute()) {
                f = new File(System.getProperty("user.dir"), demoPath);
            }
            try {
                f = f.getCanonicalFile();
            }
            catch (IOException e) {
                f = f.getAbsoluteFile();
            }
            if (!f.exists()) {
                if (f.mkdirs()) {
                    LoggerFactory.getLogger(Preferences.class).info("Created missing demo path for Dokumente: {}", (Object)f.getAbsolutePath());
                } else {
                    LoggerFactory.getLogger(Preferences.class).warn("Could not create demo path for Dokumente: {}", (Object)f.getAbsolutePath());
                }
            }
            LoggerFactory.getLogger(Preferences.class).info("Demo mode enabled \u2013 documents are saved under: {}", (Object)f.getAbsolutePath());
            return f.getAbsolutePath();
        }
        String ret = "";
        ret = ConfigServiceHolder.getGlobal((String)"ch.elexis.omnivore/store_in_fs_global", (boolean)false) ? ConfigServiceHolder.getGlobal((String)"ch.elexis.omnivore/basepath", null) : ConfigServiceHolder.getLocal((String)"ch.elexis.omnivore/basepath", null);
        if (StringUtils.contains((CharSequence)ret, (CharSequence)"no protocol: ")) {
            ret = ret.replaceAll("no protocol: ", "");
        }
        return ret;
    }
}

