/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.omnivore.data;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.util.FileUtility;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.exchange.IExchangeContributor;
import ch.elexis.core.ui.exchange.XChangeContainer;
import ch.elexis.core.ui.exchange.elements.DocumentElement;
import ch.elexis.core.ui.exchange.elements.MedicalElement;
import ch.elexis.core.ui.exchange.elements.XChangeElement;
import ch.elexis.data.Kontakt;
import ch.elexis.data.PersistentObject;
import ch.elexis.omnivore.data.Messages;
import ch.elexis.omnivore.data.service.internal.OmnivoreModelServiceHolder;
import ch.elexis.omnivore.model.IDocumentHandle;
import ch.rgw.tools.MimeTool;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.slf4j.LoggerFactory;

public class xChangeContributor
implements IExchangeContributor {
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");

    public void exportHook(MedicalElement me) {
        XChangeContainer container = me.getContainer();
        PersistentObject pat = container.getMapping((XChangeElement)me);
        IPatient iPatient = CoreModelServiceHolder.get().load(pat.getId(), IPatient.class).orElse(null);
        if (iPatient != null) {
            IQuery query = OmnivoreModelServiceHolder.get().getQuery(IDocumentHandle.class);
            query.and("kontakt", IQuery.COMPARATOR.EQUALS, (Object)iPatient);
            List docs = query.execute();
            for (IDocumentHandle dh : docs) {
                try {
                    String m2;
                    DocumentElement de = new DocumentElement();
                    de.setDefaultXid(dh.getId());
                    de.setTitle(dh.getTitle());
                    de.setOriginator((Kontakt)ElexisEventDispatcher.getSelectedMandator());
                    de.setDate(dateFormat.format(dh.getCreated()));
                    de.addMeta("Keywords", dh.getKeywords());
                    de.addMeta("category", dh.getCategory().getName());
                    de.addMeta("plugin", "ch.elexis.omnivore");
                    de.setHint(Messages.xChangeContributor_thisIsAnOmnivoreDoc);
                    de.setSubject(dh.getCategory().getName());
                    String mime = dh.getMimeType();
                    if (!mime.matches("[a-zA-Z-]+/[a-zA-Z-]+2") && (m2 = MimeTool.getMimeType((String)(mime = FileUtility.getFileExtension((String)mime)).substring(1))).length() > 0) {
                        mime = m2;
                    }
                    de.setMimetype(mime);
                    byte[] cnt = IOUtils.toByteArray((InputStream)dh.getContent());
                    me.getSender().addBinary(de.getID(), cnt);
                    me.addDocument(de);
                    container.addChoice((XChangeElement)de, dh.getTitle(), (Object)dh);
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(this.getClass()).error("Error exporting document", (Throwable)e);
                }
            }
        }
    }

    public void importHook(XChangeContainer container, PersistentObject context) {
    }

    public void setInitializationData(IConfigurationElement arg0, String arg1, Object arg2) throws CoreException {
    }

    public boolean init(MedicalElement me, boolean bExport) {
        return true;
    }
}

