/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.omnivore.data;

import ch.elexis.core.data.interfaces.text.IOpaqueDocument;
import ch.elexis.core.data.services.IDocumentManager;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.ICategory;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.data.Patient;
import ch.elexis.omnivore.data.AutomaticBilling;
import ch.elexis.omnivore.data.Messages;
import ch.elexis.omnivore.data.model.OpaqueDocumentAdapter;
import ch.elexis.omnivore.data.service.internal.OmnivoreModelServiceHolder;
import ch.elexis.omnivore.model.IDocumentHandle;
import ch.elexis.omnivore.model.TransientCategory;
import ch.elexis.omnivore.model.util.CategoryUtil;
import ch.rgw.tools.RegexpFilter;
import ch.rgw.tools.TimeSpan;
import ch.rgw.tools.TimeTool;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class DocumentManagement
implements IDocumentManager {
    public boolean addCategorie(String categorie) {
        CategoryUtil.addCategory((String)categorie);
        return true;
    }

    public String addDocument(IOpaqueDocument doc) throws ElexisException {
        return this.addDocument(doc, false);
    }

    public String addDocument(IOpaqueDocument doc, boolean automaticBilling) throws ElexisException {
        IPatient iPatient = CoreModelServiceHolder.get().load(doc.getPatient().getId(), IPatient.class).orElse(null);
        if (iPatient != null) {
            IDocumentHandle docHandle = (IDocumentHandle)OmnivoreModelServiceHolder.get().create(IDocumentHandle.class);
            OmnivoreModelServiceHolder.get().setEntityProperty("id", (Object)doc.getGUID(), (Identifiable)docHandle);
            String category = doc.getCategory();
            if (category == null || category.length() < 1) {
                category = CategoryUtil.getDefaultCategory().getName();
            } else {
                CategoryUtil.ensureCategoryAvailability((String)category);
            }
            docHandle.setCategory((ICategory)new TransientCategory(category));
            docHandle.setPatient(iPatient);
            docHandle.setCreated(new TimeTool(doc.getCreationDate()).getTime());
            docHandle.setTitle(doc.getTitle());
            docHandle.setKeywords(doc.getKeywords());
            docHandle.setMimeType(doc.getMimeType());
            docHandle.setContent(doc.getContentsAsStream());
            OmnivoreModelServiceHolder.get().save((Identifiable)docHandle);
            if (automaticBilling && AutomaticBilling.isEnabled()) {
                AutomaticBilling billing = new AutomaticBilling((IDocument)docHandle);
                billing.bill();
            }
            return docHandle.getId();
        }
        throw new IllegalStateException("No patient available");
    }

    public String[] getCategories() {
        return CategoryUtil.getCategoriesNames().toArray(new String[0]);
    }

    public InputStream getDocument(String id) {
        IDocumentHandle dh = OmnivoreModelServiceHolder.get().load(id, IDocumentHandle.class).orElse(null);
        if (dh != null) {
            return dh.getContent();
        }
        return null;
    }

    public List<IOpaqueDocument> listDocuments(Patient pat, String categoryMatch, String titleMatch, String keywordMatch, TimeSpan dateMatch, String contentsMatch) throws ElexisException {
        IQuery qbe = OmnivoreModelServiceHolder.get().getQuery(IDocumentHandle.class);
        if (pat != null) {
            IPatient iPatient = CoreModelServiceHolder.get().load(pat.getId(), IPatient.class).orElse(null);
            qbe.and("kontakt", IQuery.COMPARATOR.EQUALS, (Object)iPatient);
        }
        if (dateMatch != null) {
            LocalDate from = dateMatch.from.toLocalDate();
            LocalDate until = dateMatch.until.toLocalDate();
            qbe.and("creationDate", IQuery.COMPARATOR.GREATER_OR_EQUAL, (Object)from);
            qbe.and("creationDate", IQuery.COMPARATOR.LESS_OR_EQUAL, (Object)until);
        }
        ArrayList<RegexpFilter> filters = new ArrayList<RegexpFilter>();
        if (titleMatch != null) {
            if (titleMatch.matches("/.+/")) {
                filters.add(new RegexpFilter(titleMatch.substring(1, titleMatch.length() - 1)));
            } else {
                qbe.and("title", IQuery.COMPARATOR.EQUALS, (Object)titleMatch);
            }
        }
        if (keywordMatch != null) {
            if (keywordMatch.matches("/.+/")) {
                filters.add(new RegexpFilter(keywordMatch.substring(1, keywordMatch.length() - 1)));
            } else {
                qbe.and("keywords", IQuery.COMPARATOR.LIKE, (Object)("%" + keywordMatch + "%"));
            }
        }
        if (categoryMatch != null) {
            if (categoryMatch.matches("/.+/")) {
                filters.add(new RegexpFilter(categoryMatch.substring(1, categoryMatch.length() - 1)));
            } else {
                qbe.and("category", IQuery.COMPARATOR.EQUALS, (Object)categoryMatch);
            }
        }
        if (contentsMatch != null) {
            throw new ElexisException(this.getClass(), Messages.DocumentManagement_contentsMatchNotSupported, 5);
        }
        List dox = qbe.execute();
        if (!filters.isEmpty()) {
            dox = dox.parallelStream().filter(d -> this.applyFilters((IDocumentHandle)d, (List<RegexpFilter>)filters)).collect(Collectors.toList());
        }
        ArrayList<IOpaqueDocument> ret = new ArrayList<IOpaqueDocument>(dox.size());
        for (IDocumentHandle doc : dox) {
            ret.add(new OpaqueDocumentAdapter(doc));
        }
        return ret;
    }

    private boolean applyFilters(IDocumentHandle d, List<RegexpFilter> filters) {
        for (RegexpFilter regexpFilter : filters) {
            if (regexpFilter.select((Object)d)) continue;
            return false;
        }
        return true;
    }

    public boolean removeDocument(String id) {
        IDocumentHandle dh = OmnivoreModelServiceHolder.get().load(id, IDocumentHandle.class).orElse(null);
        if (dh != null) {
            OmnivoreModelServiceHolder.get().delete((Deleteable)dh);
            return true;
        }
        return false;
    }
}

