/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.notes;

import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.viewers.DefaultLabelProvider;
import ch.elexis.notes.Messages;
import ch.elexis.notes.Note;
import ch.elexis.notes.NotesContentProvider;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class NotesList
extends Composite {
    TreeViewer tv;
    Composite parent;
    Text tFilter;
    String filterExpr;
    NotesFilter notesFilter = new NotesFilter();
    HashMap<Note, String> matches = new HashMap();

    NotesList(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout());
        this.parent = parent;
        Composite cFilter = new Composite((Composite)this, 0);
        cFilter.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        cFilter.setLayout((Layout)new GridLayout(3, false));
        ImageHyperlink clearSearchFieldHyperlink = new ImageHyperlink(cFilter, 0);
        clearSearchFieldHyperlink.setImage(Images.IMG_CLEAR.getImage());
        clearSearchFieldHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                NotesList.this.tFilter.setText("");
                NotesList.this.filterExpr = "";
                NotesList.this.matches.clear();
                NotesList.this.tv.collapseAll();
                NotesList.this.tv.removeFilter((ViewerFilter)NotesList.this.notesFilter);
            }
        });
        new Label(cFilter, 0).setText(Messages.NotesList_searchLabel);
        this.tFilter = new Text(cFilter, 4);
        this.tFilter.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.tFilter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                NotesList.this.filterExpr = NotesList.this.tFilter.getText().toLowerCase();
                NotesList.this.matches.clear();
                if (NotesList.this.filterExpr.length() == 0) {
                    NotesList.this.tv.removeFilter((ViewerFilter)NotesList.this.notesFilter);
                    NotesList.this.tv.collapseAll();
                } else {
                    NotesList.this.tv.addFilter((ViewerFilter)NotesList.this.notesFilter);
                    NotesList.this.tv.expandAll();
                }
            }
        });
        this.tv = new TreeViewer((Composite)this, 0);
        this.tv.getControl().setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.tv.setContentProvider((IContentProvider)new NotesContentProvider());
        this.tv.setLabelProvider((IBaseLabelProvider)new DefaultLabelProvider());
        this.tv.setUseHashlookup(true);
        this.tv.setInput((Object)parent);
        this.tv.addSelectionChangedListener((ISelectionChangedListener)GlobalEventDispatcher.getInstance().getDefaultListener());
    }

    public void dispose() {
        this.tv.removeSelectionChangedListener((ISelectionChangedListener)GlobalEventDispatcher.getInstance().getDefaultListener());
    }

    class NotesFilter
    extends ViewerFilter {
        NotesFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (NotesList.this.filterExpr.length() == 0) {
                return true;
            }
            boolean bMatch = this.isMatch((Note)((Object)element), NotesList.this.filterExpr);
            if (bMatch) {
                Note parent = (Note)((Object)element);
                while ((parent = parent.getParent()) != null) {
                    NotesList.this.matches.put(parent, NotesList.this.filterExpr);
                }
            }
            return bMatch;
        }

        private boolean isMatch(Note n, String t) {
            if (NotesList.this.matches.get((Object)n) != null) {
                return true;
            }
            String lbl = n.getLabel().toLowerCase();
            if (lbl.startsWith(t) || n.getKeywords().contains(t)) {
                NotesList.this.matches.put(n, t);
                return true;
            }
            List<Note> l = n.getChildren();
            for (Note note : l) {
                if (!this.isMatch(note, t)) continue;
                NotesList.this.matches.put(n, t);
                return true;
            }
            return false;
        }
    }
}

