/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.molemax.handler;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThumbnailHandler {
    public static final int THUMBNAIL_MAX_WIDTH = 300;
    public static final int THUMBNAIL_MAX_HEIGHT = 300;
    private static Logger logger = LoggerFactory.getLogger(ThumbnailHandler.class);

    public static File createThumbnail(File originalImage) {
        File thumbnailFile;
        block7: {
            String extension;
            boolean result;
            BufferedImage originalBufferedImage;
            block6: {
                try {
                    originalBufferedImage = ImageIO.read(originalImage);
                    if (originalBufferedImage != null) break block6;
                    logger.error("Error: The image could not be read: " + originalImage.getAbsolutePath());
                    return null;
                }
                catch (IOException e) {
                    logger.error("Error when creating the thumbnail: " + e.getMessage(), (Throwable)e);
                    return null;
                }
            }
            double aspectRatio = (double)originalBufferedImage.getWidth() / (double)originalBufferedImage.getHeight();
            int thumbnailWidth = 300;
            int thumbnailHeight = (int)(300.0 / aspectRatio);
            if (thumbnailHeight > 300) {
                thumbnailHeight = 300;
                thumbnailWidth = (int)(300.0 * aspectRatio);
            }
            Image thumbnailImage = originalBufferedImage.getScaledInstance(thumbnailWidth, thumbnailHeight, 4);
            BufferedImage thumbnailBufferedImage = new BufferedImage(thumbnailWidth, thumbnailHeight, 1);
            Graphics2D g2d = thumbnailBufferedImage.createGraphics();
            g2d.drawImage(thumbnailImage, 0, 0, null);
            g2d.dispose();
            File thumbnailDirectory = new File(originalImage.getParentFile(), "thumbnails");
            if (!thumbnailDirectory.exists()) {
                thumbnailDirectory.mkdirs();
            }
            if (result = ImageIO.write((RenderedImage)thumbnailBufferedImage, extension = ThumbnailHandler.getFileExtension(originalImage.getName()), thumbnailFile = new File(thumbnailDirectory, originalImage.getName()))) break block7;
            logger.error("Error: Thumbnail could not be written: " + thumbnailFile.getAbsolutePath());
            return null;
        }
        return thumbnailFile;
    }

    private static String getFileExtension(String fileName) {
        return FilenameUtils.getExtension((String)fileName).toLowerCase();
    }

    public static boolean isSupportedImageFormat(String fileName) {
        String lowerCaseFileName = fileName.toLowerCase();
        return lowerCaseFileName.endsWith(".png") || lowerCaseFileName.endsWith(".jpg") || lowerCaseFileName.endsWith(".jpeg") || lowerCaseFileName.endsWith(".bmp") || lowerCaseFileName.endsWith(".gif");
    }
}

