/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.molemax.data;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.util.Log;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.rgw.io.FileTool;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import ch.rgw.tools.VersionInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class Tracker
extends PersistentObject {
    private static final String TABLENAME = "CH_ELEXIS_MOLEMAX";
    private static final String VERSION = "0.2.0";
    private static final String createTable = "CREATE TABLE CH_ELEXIS_MOLEMAX (ID           VARCHAR(25) primary key, deleted CHAR(1) default '0', patientID    VARCHAR(25), parentID VARCHAR(25), date CHAR(8),slot CHAR(3), koord VARCHAR(40),  ExtInfo\tBLOB, lastupdate BIGINT);";
    private static final String createIndex = " CREATE INDEX MLMX1 ON CH_ELEXIS_MOLEMAX (patientID);";
    private static final String insertVersion = "INSERT INTO CH_ELEXIS_MOLEMAX (ID,koord) VALUES ('VERSION','0.2.0');";
    private static final String createDB = "CREATE TABLE CH_ELEXIS_MOLEMAX (ID           VARCHAR(25) primary key, deleted CHAR(1) default '0', patientID    VARCHAR(25), parentID VARCHAR(25), date CHAR(8),slot CHAR(3), koord VARCHAR(40),  ExtInfo\tBLOB, lastupdate BIGINT); CREATE INDEX MLMX1 ON CH_ELEXIS_MOLEMAX (patientID);INSERT INTO CH_ELEXIS_MOLEMAX (ID,koord) VALUES ('VERSION','0.2.0');";
    private static final String updateDB011 = "ALTER  TABLE CH_ELEXIS_MOLEMAX ADD parentID VARCHAR(25);";
    private static final String updateDB020 = "ALTER TABLE CH_ELEXIS_MOLEMAX ADD lastupdate BIGINT;";
    static Log log;
    private static int[] map;
    Image image = null;

    static {
        VersionInfo vi;
        log = Log.get((String)"Molemax");
        int[] nArray = new int[12];
        nArray[1] = 4;
        nArray[2] = 8;
        nArray[3] = 1;
        nArray[4] = 5;
        nArray[5] = 9;
        nArray[6] = 2;
        nArray[7] = 6;
        nArray[8] = 10;
        nArray[9] = 3;
        nArray[10] = 7;
        nArray[11] = 11;
        map = nArray;
        Tracker.addMapping((String)TABLENAME, (String[])new String[]{"PatientID=patientID", "ParentID=parentID", "Datum=S:D:date", "slot", "koord", "ExtInfo"});
        Tracker version = Tracker.load("VERSION");
        if (!version.exists()) {
            if (PersistentObject.tableExists((String)TABLENAME)) {
                Tracker.createOrModifyTable((String)"DROP TABLE CH_ELEXIS_MOLEMAX");
            }
            Tracker.createOrModifyTable((String)createDB);
        }
        if ((vi = new VersionInfo(version.get("koord"))).isOlder(VERSION)) {
            if (vi.isEqual(new VersionInfo("0.1.0"))) {
                Tracker.createOrModifyTable((String)updateDB011);
                version.set("koord", VERSION);
                log.log("Update auf 0.2.0", 6);
            } else if (vi.isEqual(new VersionInfo("0.1.1"))) {
                Tracker.createOrModifyTable((String)updateDB020);
                version.set("koord", VERSION);
                log.log("Update auf 0.2.0", 6);
            } else {
                SWTHelper.alert((String)"Kann Molemax nicht starten", (String)"Zu alte Version der Datenbank");
            }
        }
    }

    public Tracker(Patient p, Tracker parent, String date, int slot, Rectangle pos) {
        this.create(null);
        if (date == null) {
            date = new TimeTool().toString(4);
        }
        this.set(new String[]{"PatientID", "ParentID", "Datum", "slot", "koord"}, new String[]{p.getId(), parent.getId(), date, Integer.toString(slot), Tracker.makeFilename(pos, null)});
    }

    public Tracker(Patient p, String date, int slot, File file) {
        Pattern pattern;
        Matcher matcher;
        StringBuilder sb = new StringBuilder();
        sb.append(Tracker.makeDescriptor(p, date, slot));
        File dir = new File(sb.toString());
        if (!dir.exists() && !dir.mkdirs()) {
            SWTHelper.showError((String)"Schreibfehler", (String)("Konnte Verzeichnis " + dir.getAbsolutePath() + " nicht erstellen. Speicherverzeichnis korrekt angegeben?"));
            return;
        }
        sb.append(File.separator);
        String ext = FileTool.getExtension((String)file.getName());
        String fname = "base." + ext;
        sb.append(fname);
        File out = new File(sb.toString());
        if (!FileTool.copyFile((File)file, (File)out, (int)0)) {
            SWTHelper.showError((String)"I/O Fehler", (String)"Kann das Bild nicht \u00fcbertragen");
        } else {
            this.create(null);
            this.set(new String[]{"PatientID", "ParentID", "Datum", "slot", "koord"}, new String[]{p.getId(), "NIL", date, Integer.toString(slot), fname});
        }
        if (slot == 0 && (matcher = (pattern = Pattern.compile("([a-z_\\-]+)([0-9]+)(\\.[a-z0-9]+)", 2)).matcher(file.getName())).matches()) {
            String tryname;
            File path = file.getParentFile();
            String prefix = matcher.group(1);
            String val = matcher.group(2);
            int numlen = val.length();
            String postfix = matcher.group(3);
            int v = Integer.parseInt(val);
            boolean bSerie = true;
            int i = v;
            while (i < v + 11) {
                tryname = prefix + StringTool.pad((int)1, (char)'0', (String)Integer.toString(i), (int)numlen) + postfix;
                if (!new File(path, tryname).exists()) {
                    bSerie = false;
                    break;
                }
                ++i;
            }
            if (bSerie && SWTHelper.askYesNo((String)"Ganze Serie einlesen?", (String)"Dieses Bild scheint das erste Bild einer Serie zu sein. Ganze Serie einlesen?")) {
                i = v + 1;
                while (i < v + 12) {
                    tryname = prefix + StringTool.pad((int)1, (char)'0', (String)Integer.toString(i), (int)numlen) + postfix;
                    int slotnr = map[i - v];
                    Tracker tracker = new Tracker(p, date, slotnr, new File(path, tryname));
                    ++i;
                }
                ElexisEventDispatcher.fireSelectionEvent((PersistentObject)p);
            }
        }
    }

    public boolean setFile(File file) {
        File out;
        int idx = 0;
        do {
            StringBuilder sb = new StringBuilder();
            sb.append(this.makeFilename()).append("-").append(idx);
            String ext = FileTool.getExtension((String)file.getName());
            sb.append(".").append(ext);
            out = new File(sb.toString());
            ++idx;
        } while (out.exists());
        if (!FileTool.copyFile((File)file, (File)out, (int)0)) {
            SWTHelper.showError((String)"I/O Fehler", (String)"Kann das Bild nicht \u00fcbertragen");
            return false;
        }
        this.set("koord", out.getName());
        return true;
    }

    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
    }

    private File findSequenceFile() {
        String path = this.makeFilename();
        File file = new File(path);
        if (!file.exists()) {
            String seq;
            String fname = this.get("koord");
            String[] flds = FileTool.getNakedFilename((String)fname).split("-");
            String ext = FileTool.getExtension((String)fname);
            if (flds.length > 4 && (seq = flds[4]).matches("[0-9]+")) {
                int is = Integer.parseInt(seq);
                while (is-- > 0) {
                    try {
                        fname = Tracker.makeFilename(Integer.parseInt(flds[0]), Integer.parseInt(flds[1]), Integer.parseInt(flds[2]), Integer.parseInt(flds[3]), is, ext);
                        this.set("koord", fname);
                        path = this.makeFilename();
                        file = new File(path);
                        if (!file.exists() || !file.canRead()) continue;
                        return file;
                    }
                    catch (Exception ex) {
                        ExHandler.handle((Throwable)ex);
                    }
                }
            }
            return null;
        }
        return file;
    }

    public Image createImage() {
        if (this.image != null) {
            return this.image;
        }
        File file = this.findSequenceFile();
        if (file == null) {
            return null;
        }
        try {
            FileInputStream fis = new FileInputStream(file);
            this.image = new Image((Device)UiDesk.getDisplay(), (InputStream)fis);
            return this.image;
        }
        catch (FileNotFoundException e) {
            ExHandler.handle((Throwable)e);
            return null;
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            return this.image;
        }
    }

    public Image createImageScaled(Point size) {
        Image orig = this.createImage();
        Image scaled = new Image((Device)UiDesk.getDisplay(), orig.getImageData().scaledTo(size.x, size.y));
        return scaled;
    }

    public int getSlot() {
        return Tracker.checkZero((Object)this.get("slot"));
    }

    public Rectangle getBounds() {
        String koord = this.get("koord");
        String[] k = koord.split("[\\.-]");
        if (k.length > 3) {
            try {
                return new Rectangle(Integer.parseInt(k[0]), Integer.parseInt(k[1]), Integer.parseInt(k[2]), Integer.parseInt(k[3]));
            }
            catch (NumberFormatException nx) {
                ExHandler.handle((Throwable)nx);
            }
        } else {
            Image img = this.createImage();
            if (img != null) {
                ImageData imd = img.getImageData();
                return new Rectangle(imd.x, imd.y, imd.width, imd.height);
            }
        }
        return null;
    }

    public String getLabel() {
        TimeTool tt = new TimeTool(this.get("Datum"));
        return tt.toString(4);
    }

    public static Tracker load(String id) {
        return new Tracker(id);
    }

    protected Tracker(String id) {
        super(id);
    }

    protected Tracker() {
    }

    protected String getTableName() {
        return TABLENAME;
    }

    public Patient getPatient() {
        return Patient.load((String)this.get("PatientID"));
    }

    public Tracker getParent() {
        String parentID = Tracker.checkNull((Object)this.get("ParentID"));
        if (parentID.equals("NIL")) {
            return null;
        }
        Tracker ret = Tracker.load(parentID);
        if (ret.isValid()) {
            return ret;
        }
        return null;
    }

    public String getDate() {
        return this.get("Datum");
    }

    String makeFilename() {
        StringBuilder ret = new StringBuilder();
        Tracker parent = this.getParent();
        String date = this.getDate();
        if (parent != null) {
            date = parent.getDate();
        }
        ret.append(Tracker.makeDescriptor(this.getPatient(), date, this.getSlot())).append(File.separator).append(this.get("koord"));
        return ret.toString();
    }

    public static Tracker[] getImageStack(Tracker parent) {
        if (parent == null) {
            return new Tracker[0];
        }
        Query qbe = new Query(Tracker.class);
        qbe.add("PatientID", "=", parent.get("PatientID"));
        qbe.add("ParentID", "=", parent.getId());
        List list = qbe.execute();
        Collections.sort(list, new Comparator<Tracker>(){

            @Override
            public int compare(Tracker arg0, Tracker arg1) {
                if (arg0 != null && arg1 != null) {
                    TimeTool tt1;
                    TimeTool tt0 = new TimeTool(arg0.get("Datum"));
                    int i = tt0.compareTo((Calendar)(tt1 = new TimeTool(arg1.get("Datum"))));
                    if (i == 0) {
                        Rectangle r0 = arg0.getBounds();
                        Rectangle r1 = arg1.getBounds();
                        if (r0 != null && r1 != null) {
                            return SWTHelper.size((Rectangle)r0) - SWTHelper.size((Rectangle)r1);
                        }
                    }
                    return i;
                }
                return 0;
            }
        });
        Tracker[] ret = new Tracker[list.size() + 1];
        int i = 1;
        while (i < ret.length) {
            ret[i] = (Tracker)((Object)list.get(i - 1));
            ++i;
        }
        ret[0] = parent;
        return ret;
    }

    public static String getLastSequenceDate(Patient pat) {
        Query qbe = new Query(Tracker.class);
        qbe.add("PatientID", "=", pat.getId());
        qbe.add("ParentID", "=", "NIL");
        List list = qbe.execute();
        if (list.size() > 0) {
            Tracker ret = (Tracker)((Object)list.get(0));
            if (list.size() > 1) {
                TimeTool lastDate = new TimeTool("19700101");
                TimeTool cmp = new TimeTool();
                for (Tracker tracker : list) {
                    cmp.set(tracker.get("Datum"));
                    if (!cmp.isAfter(lastDate)) continue;
                    lastDate.set(cmp);
                    ret = tracker;
                }
            }
            return ret.getDate();
        }
        return null;
    }

    public static Tracker loadBase(Patient patient, String date, int slot) {
        List list;
        Query qbe = new Query(Tracker.class);
        qbe.add("PatientID", "=", patient.getId());
        qbe.add("slot", "=", Integer.toString(slot));
        qbe.add("ParentID", "=", "NIL");
        if (date != null) {
            qbe.add("Datum", "=", date);
        }
        if ((list = qbe.execute()).size() > 0) {
            Tracker ret = (Tracker)((Object)list.get(0));
            if (date == null && list.size() > 1) {
                TimeTool lastDate = new TimeTool("19700101");
                TimeTool cmp = new TimeTool();
                for (Tracker tracker : list) {
                    cmp.set(tracker.get("Datum"));
                    if (!cmp.isAfter(lastDate)) continue;
                    lastDate = cmp;
                    ret = tracker;
                }
            }
            return ret;
        }
        return null;
    }

    public static int getTrackerAtPoint(Tracker[] slot, int x, int y) {
        int i = slot.length - 1;
        while (i >= 0) {
            Rectangle rec = slot[i].getBounds();
            if (rec.contains(x, y)) {
                return i;
            }
            --i;
        }
        return 0;
    }

    public static List<Tracker> getTrackersAtPoint(Tracker[] slot, int x, int y) {
        ArrayList<Tracker> ret = new ArrayList<Tracker>(slot.length);
        int i = 1;
        while (i < slot.length) {
            Rectangle rec = slot[i].getBounds();
            if (rec != null && rec.contains(x, y)) {
                ret.add(slot[i]);
            }
            ++i;
        }
        return ret;
    }

    public static String makeDescriptor(Patient p, String date, int slot) {
        if (date == null) {
            date = Tracker.getLastSequenceDate(p);
        }
        StringBuilder ret = new StringBuilder();
        ret.append(CoreHub.localCfg.get("molemax/imagebase", "")).append(File.separator);
        String name = p.getName();
        ret.append(name.length() > 2 ? name.substring(0, 2) : name);
        String vname = p.getVorname();
        ret.append(vname.length() > 2 ? vname.substring(0, 2) : vname);
        ret.append(p.getPatCode()).append(File.separator).append(new TimeTool(date).toString(9)).append(File.separator).append(slot);
        return ret.toString();
    }

    private static String makeFilename(int x, int y, int w, int h, int seq, String ext) {
        StringBuilder sb = new StringBuilder();
        sb.append(x).append("-").append(y).append("-").append(w).append("-").append(h).append("-").append(seq);
        if (ext != null) {
            sb.append(".").append(ext);
        }
        return sb.toString();
    }

    public static String makeDescriptorImage(Patient p) {
        String basePath = CoreHub.localCfg.get("molemax/imagebase", "");
        String customPath = CoreHub.localCfg.get("molemax/custom_imagebase", "");
        if (StringUtils.isBlank((CharSequence)basePath) || StringUtils.isBlank((CharSequence)customPath)) {
            log.log("Error: Base path or user-defined path is not set.", 3);
            return "";
        }
        StringBuilder ret = new StringBuilder();
        ret.append(basePath).append(File.separator);
        String separator = Tracker.getRegexSafeSeparator();
        String[] pathSegments = customPath.split(separator);
        Pattern pattern = Pattern.compile("(Name|Vorname|PatNum|Datum(-[yMd.]+)?|Uhrzeit(-[Hhmsa:]+)?|Slot)(-\\d+)?");
        int i = 0;
        while (i < pathSegments.length) {
            String segment = pathSegments[i];
            Matcher matcher = pattern.matcher(segment);
            while (matcher.find()) {
                SimpleDateFormat sdf;
                String match = matcher.group();
                String keyword = match.split("-")[0];
                int length = -1;
                if (match.contains("-") && !keyword.equals("Datum") && !keyword.equals("Uhrzeit")) {
                    length = Integer.parseInt(match.split("-")[1]);
                }
                if (keyword.equals("PatNum")) {
                    String patCode = p.getPatCode();
                    ret.append(patCode);
                    continue;
                }
                if (keyword.equals("Name")) {
                    String namCode = p.getName();
                    if (length != -1 && namCode.length() > length) {
                        namCode = namCode.substring(0, length);
                    }
                    ret.append(namCode);
                    continue;
                }
                if (keyword.equals("Vorname")) {
                    String vorCode = p.getVorname();
                    if (length != -1 && vorCode.length() > length) {
                        vorCode = vorCode.substring(0, length);
                    }
                    ret.append(vorCode);
                    continue;
                }
                if (keyword.equals("Datum")) {
                    String dateFormat = match.split("-")[1];
                    sdf = new SimpleDateFormat(dateFormat);
                    String formattedDate = sdf.format(new Date());
                    ret.append(formattedDate);
                    continue;
                }
                if (!keyword.equals("Uhrzeit")) continue;
                String timeFormat = match.split("-")[1];
                sdf = new SimpleDateFormat(timeFormat);
                String formattedTime = sdf.format(new Date());
                ret.append(formattedTime);
            }
            if (i < pathSegments.length - 1) {
                ret.append(File.separator);
            }
            ++i;
        }
        return ret.toString();
    }

    private static String makeFilename(Rectangle rec, String ext) {
        StringBuilder sb = new StringBuilder();
        sb.append(Integer.toString(rec.x)).append("-").append(Integer.toString(rec.y)).append("-").append(Integer.toString(rec.width)).append("-").append(Integer.toString(rec.height));
        if (ext != null) {
            sb.append(".").append(ext);
        }
        return sb.toString();
    }

    public static void delete(Tracker[] myTracker) {
        if (myTracker != null) {
            Tracker[] trackerArray = myTracker;
            int n = myTracker.length;
            int n2 = 0;
            while (n2 < n) {
                Tracker t = trackerArray[n2];
                if (t != null) {
                    t.delete();
                }
                ++n2;
            }
            myTracker = new Tracker[]{};
        }
    }

    public static void dispose(Tracker[] myTracker) {
        if (myTracker != null) {
            Tracker[] trackerArray = myTracker;
            int n = myTracker.length;
            int n2 = 0;
            while (n2 < n) {
                Tracker t = trackerArray[n2];
                if (t != null) {
                    t.dispose();
                }
                ++n2;
            }
            myTracker = new Tracker[]{};
        }
    }

    public boolean delete() {
        String fname;
        File file;
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
        if (this.isValid() && (file = new File(fname = this.makeFilename())).exists()) {
            file.delete();
        }
        return super.delete();
    }

    public boolean isValid() {
        if (this.getPatient().isValid()) {
            return super.isValid();
        }
        return false;
    }

    public void setInfoString(String name, String text) {
        Map extinfo = this.getMap("ExtInfo");
        extinfo.put(name, text);
        this.setMap("ExtInfo", extinfo);
    }

    public String getInfoString(String name) {
        Map extinfo = this.getMap("ExtInfo");
        return Tracker.checkNull(extinfo.get(name));
    }

    private static String getRegexSafeSeparator() {
        return Pattern.quote(File.separator);
    }
}

