/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.mednet.webapi.ui.preferences;

import ch.elexis.core.rcp.utils.OsgiServiceUtil;
import ch.elexis.core.services.IConfigService;
import java.util.Optional;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferenceInitializer
extends AbstractPreferenceInitializer {
    private static final Logger logger = LoggerFactory.getLogger(PreferenceInitializer.class);
    private IConfigService configService;

    public PreferenceInitializer() {
        Optional optionalService = OsgiServiceUtil.getServiceWait(IConfigService.class, (long)1000L);
        if (optionalService.isPresent()) {
            this.configService = (IConfigService)optionalService.get();
            this.initializeDefaultPreferences();
        } else {
            logger.error("PreferenceInitializer: Could not retrieve IConfigService.");
        }
    }

    public void initializeDefaultPreferences() {
        if (this.configService == null) {
            logger.error("initializeDefaultPreferences: ConfigService is null, cannot set defaults.");
            return;
        }
        this.setDefaultIfEmpty("MedNetDownloadpathPreference");
        this.setDefaultIfEmpty("MedNetUserStringPreference");
    }

    private void setDefaultIfEmpty(String key) {
        String currentVal = this.configService.getActiveUserContact(key, null);
        if (currentVal == null || currentVal.isEmpty()) {
            this.configService.setActiveUserContact(key, "");
        }
    }
}

