/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.mednet.webapi.ui.parts;

import ch.elexis.mednet.webapi.core.IMednetAuthUi;
import ch.elexis.mednet.webapi.core.constants.URLConstants;
import ch.elexis.mednet.webapi.core.messages.Messages;
import ch.elexis.mednet.webapi.ui.handler.PatientFetcher;
import ch.elexis.mednet.webapi.ui.navigation.NavigationState;
import ch.elexis.mednet.webapi.ui.parts.CustomerComposite;
import ch.elexis.mednet.webapi.ui.parts.FormComposite;
import ch.elexis.mednet.webapi.ui.parts.ProviderComposite;
import ch.elexis.mednet.webapi.ui.parts.SubmittedFormsComposite;
import ch.elexis.mednet.webapi.ui.util.ButtonFactory;
import ch.elexis.mednet.webapi.ui.util.CompositeEffectHandler;
import jakarta.annotation.PostConstruct;
import java.util.Stack;
import org.eclipse.e4.ui.services.EMenuService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.ResourceManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;

public class MedNetMainComposite {
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    private IMednetAuthUi authUi;
    private Composite medNetViewerComposite;
    private Stack<NavigationState> navigationStack = new Stack();
    private CustomerComposite customerComposite;
    private ProviderComposite providerComposite;
    private FormComposite formComposite;
    private SubmittedFormsComposite submittedFormsComposite;
    private PatientFetcher patientFetcher;
    private Color customBlue;
    private Composite navigationBreadcrumbComposite;

    @PostConstruct
    public void createControls(Composite parent, EMenuService menuService) {
        parent.setLayout((Layout)new GridLayout(2, false));
        Composite navigationComposite = new Composite(parent, 0);
        GridData navGridData = new GridData(4, 4, false, true);
        navGridData.widthHint = 200;
        navigationComposite.setLayoutData((Object)navGridData);
        navigationComposite.setLayout((Layout)new GridLayout(1, false));
        this.customBlue = new Color((Device)parent.getDisplay(), new RGB(42, 108, 155));
        navigationComposite.setBackground(this.customBlue);
        Composite mainContentComposite = new Composite(parent, 0);
        mainContentComposite.setLayout((Layout)new GridLayout(1, false));
        mainContentComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.navigationBreadcrumbComposite = new Composite(mainContentComposite, 0);
        GridLayout breadcrumbLayout = new GridLayout(10, false);
        breadcrumbLayout.marginHeight = 5;
        breadcrumbLayout.marginWidth = 5;
        this.navigationBreadcrumbComposite.setLayout((Layout)breadcrumbLayout);
        GridData breadcrumbGridData = new GridData(4, 128, true, false);
        breadcrumbGridData.heightHint = 30;
        this.navigationBreadcrumbComposite.setLayoutData((Object)breadcrumbGridData);
        this.medNetViewerComposite = new Composite(mainContentComposite, 0);
        this.medNetViewerComposite.setLayout((Layout)new GridLayout(1, false));
        this.medNetViewerComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createLogoAndButtons(navigationComposite);
        this.showInitialLogo();
        parent.addDisposeListener(e -> this.customBlue.dispose());
    }

    private void createLogoAndButtons(Composite navigationComposite) {
        Composite logoComposite = new Composite(navigationComposite, 0);
        logoComposite.setLayout((Layout)new GridLayout(2, false));
        logoComposite.setBackground(this.customBlue);
        GridData logoCompositeGridData = new GridData(0x1000000, 0x1000000, true, false);
        logoCompositeGridData.heightHint = 80;
        logoComposite.setLayoutData((Object)logoCompositeGridData);
        Label imageLabel = new Label(logoComposite, 0);
        imageLabel.setImage(ResourceManager.getPluginImage((String)"ch.elexis.mednet.webapi.ui", (String)"icons/heartbeat.png"));
        imageLabel.setBackground(this.customBlue);
        Label logoLabel = new Label(logoComposite, 0);
        logoLabel.setImage(ResourceManager.getPluginImage((String)"ch.elexis.mednet.webapi.ui", (String)"icons/logo_mednet_white.png"));
        logoLabel.setForeground(navigationComposite.getDisplay().getSystemColor(1));
        logoLabel.setBackground(this.customBlue);
        logoLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        ButtonFactory.createToggleButtonComposite(navigationComposite, "icons/on-off-button-rot.png", "icons/on-off-button-gruen.png", Messages.MedNetMainComposite_activateImport, this.customBlue);
        ButtonFactory.createButtonComposite(navigationComposite, "icons/barcode_white.png", "icons/barcode_blue.png", Messages.MedNetMainComposite_formWithPatientData, this.customBlue, this::connect);
        ButtonFactory.createButtonComposite(navigationComposite, "icons/Group_white.png", "icons/Group_blue.png", Messages.MedNetMainComposite_showPatients, this.customBlue, () -> this.openMednetDocuments(URLConstants.getBaseApiUrl() + "/DoctorUser/patients"));
        ButtonFactory.createButtonComposite(navigationComposite, "icons/bars_white.png", "icons/bars_blue.png", Messages.MedNetMainComposite_tasks, this.customBlue, () -> this.openMednetDocuments(URLConstants.getBaseApiUrl() + "/DoctorUser/tasks"));
        ButtonFactory.createButtonComposite(navigationComposite, "icons/google_docs_white.png", "icons/google_docs_blue.png", Messages.MedNetMainComposite_documents, this.customBlue, () -> this.openMednetDocuments(URLConstants.getBaseApiUrl() + "/DoctorUser/documents"));
        ButtonFactory.createButtonComposite(navigationComposite, "icons/address_book_regular_white.png", "icons/address_book_regular_blue.png", Messages.MedNetMainComposite_therapy, this.customBlue, () -> this.openMednetDocuments(URLConstants.getBaseApiUrl() + "/DoctorUser/chronic-diseases/chronic-diseases-list"));
        ButtonFactory.createButtonComposite(navigationComposite, "icons/import_white.png", "icons/import_blue.png", Messages.MedNetMainComposite_forms, this.customBlue, this::showSubmittedForms);
    }

    private void openMednetDocuments(String link) {
        BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        ServiceReference serviceReference = context.getServiceReference(IMednetAuthUi.class);
        this.authUi = (IMednetAuthUi)context.getService(serviceReference);
        if (this.authUi != null) {
            this.authUi.openBrowser(link);
        } else {
            MessageDialog.openError((Shell)this.medNetViewerComposite.getShell(), (String)Messages.MedNetMainComposite_error, (String)Messages.MedNetMainComposite_browserError);
        }
    }

    private void showInitialLogo() {
        Composite logoContainer = new Composite(this.medNetViewerComposite, 0);
        logoContainer.setLayout((Layout)new GridLayout(1, false));
        GridData logoContainerData = new GridData(0x1000000, 0x1000000, true, true);
        logoContainer.setLayoutData((Object)logoContainerData);
        Label logoLabel = new Label(logoContainer, 0);
        logoLabel.setBackground(this.medNetViewerComposite.getBackground());
        Image logoImage = ResourceManager.getPluginImage((String)"ch.elexis.mednet.webapi.ui", (String)"icons/logo_mednet_fullcolor.png");
        logoLabel.setImage(logoImage);
        GridData logoGridData = new GridData(0x1000000, 0x1000000, true, true);
        logoLabel.setLayoutData((Object)logoGridData);
        this.medNetViewerComposite.layout();
    }

    public void loadCustomers() {
        this.clearPreviousData();
        this.customerComposite = new CustomerComposite(this.medNetViewerComposite, this::onCustomerSelected);
        this.customerComposite.show();
        this.navigationStack.clear();
        this.updateBreadcrumbNavigation();
        this.medNetViewerComposite.layout();
    }

    private void onCustomerSelected(Integer customerId, String customerName) {
        this.loadProviders(customerId, customerName);
    }

    private void showSubmittedForms() {
        this.clearPreviousData();
        this.submittedFormsComposite = new SubmittedFormsComposite(this.medNetViewerComposite);
        this.submittedFormsComposite.showSubmittedForms();
        this.medNetViewerComposite.layout();
    }

    public void loadProviders(Integer customerId, String customerName) {
        this.clearPreviousData();
        this.removeStatesAfter("CUSTOMER");
        if (!this.navigationStack.isEmpty() && "CUSTOMER".equals(this.navigationStack.peek().state)) {
            NavigationState customerState = this.navigationStack.peek();
            customerState.customerId = customerId;
            customerState.customerName = customerName;
        } else {
            this.navigationStack.push(new NavigationState("CUSTOMER", customerId, null, null, null, customerName, null));
        }
        this.providerComposite = new ProviderComposite(this.medNetViewerComposite, this::onProviderSelected, this.patientFetcher);
        this.providerComposite.show(customerId);
        this.updateBreadcrumbNavigation();
        this.medNetViewerComposite.layout();
    }

    private void onProviderSelected(Integer providerId, String providerName) {
        this.loadForms(providerId, providerName);
    }

    public void loadForms(Integer providerId, String providerName) {
        if (!this.navigationStack.isEmpty()) {
            NavigationState previousState = this.navigationStack.peek();
            if (previousState.customerId != null) {
                this.clearPreviousData();
                if (!"PROVIDER".equals(previousState.state) || !previousState.providerId.equals(providerId)) {
                    this.removeStatesAfter("CUSTOMER");
                    this.navigationStack.push(new NavigationState("PROVIDER", previousState.customerId, providerId, null, null, previousState.customerName, providerName));
                }
                this.formComposite = new FormComposite(this.medNetViewerComposite, (customerId, providerId1, formId, formName) -> {
                    this.removeStatesAfter("PROVIDER");
                    this.navigationStack.push(new NavigationState("FORM", customerId, providerId1, formId, formName, navigationState.customerName, providerName));
                    this.updateBreadcrumbNavigation();
                });
                this.formComposite.show(previousState.customerId, providerId);
                this.updateBreadcrumbNavigation();
                this.medNetViewerComposite.layout();
            }
        }
    }

    private void connect() {
        this.loadCustomers();
    }

    private void clearPreviousData() {
        Control[] controlArray = this.medNetViewerComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
    }

    private void updateBreadcrumbNavigation() {
        Control[] controlArray = this.navigationBreadcrumbComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        int i = 0;
        while (i < this.navigationStack.size()) {
            NavigationState state = (NavigationState)this.navigationStack.get(i);
            int stateIndex = i++;
            Composite breadcrumbComposite = new Composite(this.navigationBreadcrumbComposite, 0);
            breadcrumbComposite.setLayout((Layout)new GridLayout(2, false));
            breadcrumbComposite.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            breadcrumbComposite.setBackground(this.navigationBreadcrumbComposite.getDisplay().getSystemColor(1));
            Label iconLabel = new Label(breadcrumbComposite, 0);
            iconLabel.setBackground(breadcrumbComposite.getBackground());
            Image leftArrowIcon = ResourceManager.getPluginImage((String)"ch.elexis.mednet.webapi.ui", (String)"icons/left-arrow.png");
            Image leftArrowIconWhite = ResourceManager.getPluginImage((String)"ch.elexis.mednet.webapi.ui", (String)"icons/left-arrow_white.png");
            iconLabel.setImage(leftArrowIcon);
            Label textLabel = new Label(breadcrumbComposite, 0);
            textLabel.setText(this.getBreadcrumbText(state));
            textLabel.setBackground(breadcrumbComposite.getBackground());
            textLabel.setForeground(this.customBlue);
            textLabel.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
            CompositeEffectHandler.addHoverEffectBreadcrumbNavigation(breadcrumbComposite, iconLabel, textLabel, leftArrowIcon, leftArrowIconWhite, this.customBlue);
            CompositeEffectHandler.addPressReleaseEffect(breadcrumbComposite, iconLabel, textLabel, leftArrowIconWhite, () -> this.navigateToState(stateIndex), breadcrumbComposite.getBackground());
        }
        this.navigationBreadcrumbComposite.layout();
    }

    private void navigateToState(int stateIndex) {
        while (this.navigationStack.size() > stateIndex + 1) {
            this.navigationStack.pop();
        }
        NavigationState targetState = this.navigationStack.peek();
        if ("CUSTOMER".equals(targetState.state)) {
            this.loadCustomers();
        } else if ("PROVIDER".equals(targetState.state)) {
            this.loadProviders(targetState.customerId, targetState.customerName);
        } else if ("FORM".equals(targetState.state)) {
            this.loadForms(targetState.providerId, targetState.providerName);
        }
        this.updateBreadcrumbNavigation();
    }

    private void removeStatesAfter(String stateName) {
        int index = -1;
        int i = 0;
        while (i < this.navigationStack.size()) {
            if (stateName.equals(((NavigationState)this.navigationStack.get((int)i)).state)) {
                index = i;
                break;
            }
            ++i;
        }
        if (index >= 0) {
            while (this.navigationStack.size() > index + 1) {
                this.navigationStack.pop();
            }
        }
    }

    private String getBreadcrumbText(NavigationState state) {
        if ("CUSTOMER".equals(state.state)) {
            return state.customerName != null ? state.customerName : Messages.BreadcrumbNavigation_customers;
        }
        if ("PROVIDER".equals(state.state)) {
            return state.providerName != null ? state.providerName : Messages.BreadcrumbNavigation_providers;
        }
        if ("FORM".equals(state.state)) {
            return state.formName != null ? state.formName : Messages.BreadcrumbNavigation_forms;
        }
        return "";
    }
}

