/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.mednet.webapi.ui.parts;

import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.documents.composites.DocumentsSelectionComposite;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.mednet.webapi.core.messages.Messages;
import ch.elexis.mednet.webapi.ui.handler.DocumentRemovalListener;
import ch.elexis.mednet.webapi.ui.parts.AttachmentsComposite;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DocumentsSelectionDialog
extends TitleAreaDialog {
    private DocumentsSelectionComposite attachmentsSelection;
    private List<IDocument> selectedDocuments = new ArrayList<IDocument>();
    private AttachmentsComposite attachments;
    private String attachmentsString;
    private String documentsString;
    private String toString = "";
    private Button epdCheckbox;
    private boolean isEpdSelected = false;

    public DocumentsSelectionDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(16);
        CoreUiUtil.injectServices((Object)((Object)this));
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setMinimumSize(800, 500);
        Composite area = (Composite)super.createDialogArea(parent);
        area.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setTitle(Messages.DocumentsSelectionDialog_selectionTitle);
        Label lbl = new Label(container, 256);
        lbl.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        lbl = new Label(container, 0);
        lbl.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        lbl.setText(Messages.DocumentsSelectionDialog_doubleClickToAttach);
        final Text searchField = new Text(container, 2048);
        searchField.setMessage(Messages.DocumentsSelectionDialog_search);
        searchField.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.attachmentsSelection = new DocumentsSelectionComposite(container, 0);
        this.attachmentsSelection.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.attachmentsSelection.setPatient((IPatient)ContextServiceHolder.get().getActivePatient().orElse(null));
        this.attachmentsSelection.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (DocumentsSelectionDialog.this.selectedDocuments.size() < 3) {
                    if (event.getSelection() instanceof IStructuredSelection && !event.getSelection().isEmpty()) {
                        IDocument selectedDocument = (IDocument)((IStructuredSelection)event.getSelection()).getFirstElement();
                        DocumentsSelectionDialog.this.attachments.addDocument(selectedDocument);
                        DocumentsSelectionDialog.this.selectedDocuments.add(selectedDocument);
                    }
                } else {
                    MessageDialog.openWarning(null, (String)Messages.DocumentsSelectionDialog_limitReachedTitle, (String)Messages.DocumentsSelectionDialog_limitReachedMessage);
                }
            }
        });
        searchField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String searchText = searchField.getText();
                DocumentsSelectionDialog.this.attachmentsSelection.setFilter(searchText);
            }
        });
        this.epdCheckbox = new Button(container, 32);
        this.epdCheckbox.setText(Messages.DocumentsSelectionDialog_epdCheckbox);
        this.epdCheckbox.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.attachments = new AttachmentsComposite(container, 0);
        this.attachments.setLayoutData(new GridData(4, 128, true, true, 2, 1));
        this.attachments.setAttachments(this.attachmentsString);
        this.attachments.setDocuments(this.documentsString);
        this.attachments.setPostfix(this.toString);
        this.attachments.setDocumentRemovalListener(new DocumentRemovalListener(){

            @Override
            public void documentRemoved(IDocument document) {
                DocumentsSelectionDialog.this.selectedDocuments.removeIf(doc -> doc.getId().equals(document.getId()));
            }
        });
        return area;
    }

    protected void okPressed() {
        this.isEpdSelected = this.epdCheckbox.getSelection();
        super.okPressed();
    }

    public List<IDocument> getSelectedDocuments() {
        return this.selectedDocuments;
    }

    public boolean isEpdCheckboxSelected() {
        return this.isEpdSelected;
    }
}

