/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.mednet.webapi.ui.handler;

import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.mednet.webapi.core.messages.Messages;
import ch.elexis.mednet.webapi.ui.handler.PatientFetcher;
import ch.elexis.mednet.webapi.ui.handler.ServiceHelper;
import ch.elexis.mednet.webapi.ui.handler.TableHelper;
import ch.elexis.mednet.webapi.ui.parts.DocumentsSelectionDialog;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataHandler {
    private static final Logger logger = LoggerFactory.getLogger(DataHandler.class);
    private static final Gson gson = new Gson();
    private static boolean isEpdSelected = false;

    public static void fetchAndDisplayProviders(Table providerTable, int customerID) {
        providerTable.removeAll();
        Optional<String> authToken = ServiceHelper.getAuthToken("mednet");
        if (authToken.isPresent()) {
            String token = authToken.get();
            PatientFetcher fetcher = new PatientFetcher(token);
            String providerResponse = fetcher.fetchProvidersId(customerID);
            Type providerListType = new TypeToken<List<Map<String, Object>>>(){}.getType();
            List providers = (List)gson.fromJson(providerResponse, providerListType);
            String[] keys = new String[]{"id", "lastName", "specialty"};
            String[] defaults = new String[]{"Unknown ID", "Unknown Last Name", "N/A"};
            TableHelper.fillTableFromList(providerTable, providers, providerTable.getDisplay(), keys, defaults);
            logger.info("Providers fetched and displayed successfully.");
        } else {
            logger.warn("No authentication token available.");
        }
    }

    public static boolean loadSubmittedFormsData(Table submittedFormsTable, Integer customerId) {
        Optional<String> authToken = ServiceHelper.getAuthToken("mednet");
        if (authToken.isPresent()) {
            block6: {
                String token = authToken.get();
                PatientFetcher fetcher = new PatientFetcher(token);
                String submittedFormsResponse = fetcher.fetchSubmitFormsId(customerId);
                if (submittedFormsResponse.startsWith("Error")) {
                    logger.error("Error loading forms: " + submittedFormsResponse);
                    return false;
                }
                Type formListType = new TypeToken<List<Map<String, Object>>>(){}.getType();
                List forms = (List)gson.fromJson(submittedFormsResponse, formListType);
                if (forms == null || forms.isEmpty()) break block6;
                String[] keys = new String[]{"referenceNr", "downloadUrl", "externalPatientId", "patientLastName", "patientDateOfBirth", "packageType", "title", "customer.lastName", "provider.lastName", "patientFirstName", "packageId"};
                String[] defaults = new String[]{"Unknown ID", "Unknown URL", "None Set", "Unknown Last Name", "Unknown Birthdate", "Unknown Type", "No Title", "Unknown Sender", "Unknown Receiver", "Unknown First Name", "No PackageId"};
                TableHelper.fillTableFromList(submittedFormsTable, forms, submittedFormsTable.getDisplay(), keys, defaults);
                logger.info("Submitted forms loaded successfully.");
                return true;
            }
            try {
                logger.info("No submitted forms available.");
            }
            catch (JsonSyntaxException ex) {
                logger.error("Error parsing JSON response: " + ex.getMessage());
            }
        } else {
            logger.warn("No authentication token available.");
        }
        return false;
    }

    public static void fetchAndDisplayFormsForProvider(Table formTable, Integer providerId, Integer customerId) {
        formTable.removeAll();
        Optional<String> authToken = ServiceHelper.getAuthToken("mednet");
        if (authToken.isPresent()) {
            String token = authToken.get();
            PatientFetcher fetcher = new PatientFetcher(token);
            String formsResponse = fetcher.fetchFormsByProviderIdWithRetry(customerId, providerId);
            Type formListType = new TypeToken<List<Map<String, Object>>>(){}.getType();
            List forms = (List)gson.fromJson(formsResponse, formListType);
            String[] keys = new String[]{"id", "title", "description"};
            String[] defaults = new String[]{"Unknown ID", "Unknown Title", "N/A"};
            TableHelper.fillTableFromList(formTable, forms, formTable.getDisplay(), keys, defaults);
            logger.info("Forms fetched for provider and displayed successfully.");
        } else {
            logger.warn("No authentication token available.");
        }
    }

    public static void fetchAndDisplayCustomers(Table customerTable) {
        Optional<String> authToken = ServiceHelper.getAuthToken("mednet");
        if (authToken.isPresent()) {
            String token = authToken.get();
            PatientFetcher fetcher = new PatientFetcher(token);
            String customerResponse = fetcher.fetchCustomerId();
            Type customerListType = new TypeToken<List<Map<String, Object>>>(){}.getType();
            List customers = (List)gson.fromJson(customerResponse, customerListType);
            String[] keys = new String[]{"id", "firstName", "lastName"};
            String[] defaults = new String[]{"Unknown ID", "Unknown First Name", "Unknown Last Name"};
            TableHelper.fillTableFromList(customerTable, customers, customerTable.getDisplay(), keys, defaults);
            logger.info("Customers fetched and displayed successfully.");
        } else {
            logger.warn("No authentication token available.");
        }
    }

    public static void fillPatientData(Integer customerId, Integer providerId, Integer formId) {
        Optional<String> authToken;
        Optional pat = ContextServiceHolder.get().getActivePatient();
        if (!pat.isPresent()) {
            Display.getDefault().asyncExec(() -> {
                Shell shell = Display.getDefault().getActiveShell();
                MessageDialog.openWarning((Shell)shell, (String)Messages.DataHandler_noPatientSelectedTitle, (String)Messages.DataHandler_noPatientSelectedMessage);
            });
            logger.warn("No active patient selected.");
            return;
        }
        IPatient ipatient = (IPatient)pat.get();
        List<IDocument> selectedDocuments = null;
        boolean confirmBeforeSend = ConfigServiceHolder.get().getActiveUserContact("mednet.confirmBeforeSend", true);
        boolean sendDocuments = false;
        if (confirmBeforeSend) {
            sendDocuments = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)Messages.DataHandler_sendDocumentsTitle, (String)Messages.DataHandler_sendDocumentsMessage);
        }
        if (sendDocuments) {
            DocumentsSelectionDialog dialog = new DocumentsSelectionDialog(Display.getDefault().getActiveShell());
            if (dialog.open() == 0) {
                selectedDocuments = dialog.getSelectedDocuments();
                isEpdSelected = dialog.isEpdCheckboxSelected();
                logger.info("Documents selected to be sent: " + selectedDocuments.size());
            } else {
                logger.info("No documents selected.");
                return;
            }
        }
        if ((authToken = ServiceHelper.getAuthToken("mednet")).isPresent()) {
            String token = authToken.get();
            PatientFetcher fetcher = new PatientFetcher(token);
            Map<String, Integer> patientData = Map.of("customerId", customerId, "providerId", providerId, "formId", formId);
            try {
                JsonObject patientJson = gson.toJsonTree(patientData).getAsJsonObject();
                String response = fetcher.fillPatientData(ipatient, patientJson, selectedDocuments, isEpdSelected);
                logger.info("Patient data sent successfully: {}", (Object)response);
            }
            catch (Exception ex) {
                logger.error("Error sending patient data", (Throwable)ex);
            }
        } else {
            logger.warn("No authentication token available.");
        }
    }

    public static void loadCustomersFromApi(CCombo customerCombo) {
        Optional<String> authToken = ServiceHelper.getAuthToken("mednet");
        if (authToken.isPresent()) {
            String token = authToken.get();
            PatientFetcher fetcher = new PatientFetcher(token);
            String customerResponse = fetcher.fetchCustomerId();
            Type customerListType = new TypeToken<List<Map<String, Object>>>(){}.getType();
            List customers = (List)gson.fromJson(customerResponse, customerListType);
            int i = 0;
            while (i < customers.size()) {
                Map customer = (Map)customers.get(i);
                int customerId = ((Double)customer.get("id")).intValue();
                String customerName = customer.getOrDefault("lastName", "Unknown Name");
                String customerFirstName = customer.getOrDefault("firstName", "Unknown First Name");
                customerCombo.add(customerId + " - " + customerFirstName + " " + customerName);
                ++i;
            }
            customerCombo.select(0);
            logger.info("Customers loaded from API and displayed in the combo box.");
        } else {
            logger.warn("No authentication token available.");
        }
    }
}

