/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.mednet.webapi.ui.parts;

import ch.elexis.core.model.tasks.TaskException;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.mednet.webapi.core.handler.SingleFileDownloaderHandler;
import ch.elexis.mednet.webapi.core.messages.Messages;
import ch.elexis.mednet.webapi.ui.handler.DataHandler;
import ch.elexis.mednet.webapi.ui.handler.ImportOmnivore;
import ch.elexis.mednet.webapi.ui.util.UIStyleTableHelper;
import java.net.URI;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubmittedFormsComposite {
    private static final Logger logger = LoggerFactory.getLogger(SubmittedFormsComposite.class);
    private Composite parent;
    private CCombo customerCombo;
    private Label noFormsLabel;
    private Table submittedFormsTable;

    public SubmittedFormsComposite(Composite parent) {
        this.parent = parent;
    }

    public void showSubmittedForms() {
        this.parent.setLayout((Layout)new GridLayout(1, false));
        Composite labelComposite = new Composite(this.parent, 0);
        labelComposite.setLayout((Layout)new GridLayout(2, false));
        GridData labelCompositeData = new GridData(4, 0x1000000, true, false);
        labelComposite.setLayoutData((Object)labelCompositeData);
        this.noFormsLabel = new Label(labelComposite, 0);
        this.noFormsLabel.setText(Messages.SubmittedFormsComposite_noErrorForms);
        this.noFormsLabel.setBackground(UiDesk.getColor((String)"gruen"));
        this.noFormsLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.noFormsLabel.setVisible(false);
        Button refreshButton = new Button(labelComposite, 8);
        refreshButton.setText("Refresh");
        refreshButton.setImage(Images.IMG_REFRESH.getImage());
        refreshButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        refreshButton.addListener(13, e -> this.refreshTableData());
        this.customerCombo = UIStyleTableHelper.createStyledCCombo(this.parent);
        DataHandler.loadCustomersFromApi(this.customerCombo);
        this.customerCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.submittedFormsTable = UIStyleTableHelper.createStyledTable(this.parent);
        String[] columnHeaders = new String[]{Messages.ColumnHeaders_OrderNo, Messages.ColumnHeaders_Date, Messages.ColumnHeaders_PatientNo, Messages.ColumnHeaders_PatientName, Messages.ColumnHeaders_Birthdate, Messages.ColumnHeaders_Type, Messages.ColumnHeaders_ExportsAndAttachments, Messages.ColumnHeaders_Sender, Messages.ColumnHeaders_Receiver};
        int[] columnWidths = new int[]{80, 120, 90, 120, 100, 50, 120, 100, 100};
        UIStyleTableHelper.addTableColumns(this.submittedFormsTable, columnHeaders, columnWidths);
        this.submittedFormsTable.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.loadSubmittedFormsCombo();
        this.customerCombo.addListener(13, event -> {
            String selectedCustomer;
            Integer customerId;
            int selectedIndex = this.customerCombo.getSelectionIndex();
            if (selectedIndex >= 0 && (customerId = this.extractCustomerId(selectedCustomer = this.customerCombo.getItem(selectedIndex))) != null) {
                this.loadSubmittedFormsData(customerId);
            }
        });
        this.submittedFormsTable.addListener(8, event -> this.handleTableDoubleClick());
        this.submittedFormsTable.addListener(11, event -> this.adjustTableColumnWidths());
    }

    private Integer extractCustomerId(String selectedCustomer) {
        try {
            String[] parts = selectedCustomer.split("-");
            if (parts.length > 0) {
                String idPart = parts[0].trim();
                return Integer.parseInt(idPart);
            }
        }
        catch (NumberFormatException ex) {
            logger.error("Error parsing customer ID from selected customer: {}", (Object)selectedCustomer, (Object)ex);
        }
        return null;
    }

    private void loadSubmittedFormsData(Integer customerId) {
        this.submittedFormsTable.removeAll();
        boolean hasData = DataHandler.loadSubmittedFormsData(this.submittedFormsTable, customerId);
        this.noFormsLabel.setVisible(!hasData);
    }

    private void loadSubmittedFormsCombo() {
        String selectedCustomer;
        Integer customerId;
        int selectedIndex = this.customerCombo.getSelectionIndex();
        if (selectedIndex >= 0 && (customerId = this.extractCustomerId(selectedCustomer = this.customerCombo.getItem(selectedIndex))) != null) {
            boolean hasData = DataHandler.loadSubmittedFormsData(this.submittedFormsTable, customerId);
            this.noFormsLabel.setVisible(!hasData);
        }
    }

    private void handleTableDoubleClick() {
        TableItem[] selection = this.submittedFormsTable.getSelection();
        if (selection.length > 0) {
            TableItem selectedItem = selection[0];
            String downloadUrl = (String)selectedItem.getData("downloadUrl");
            String packageId = (String)selectedItem.getData("packageId");
            String objectId = this.extractObjectIdFromDownloadUrl(downloadUrl);
            String createDate = selectedItem.getText(1);
            String patientNr = selectedItem.getText(2);
            String patientName = selectedItem.getText(3);
            String exportType = selectedItem.getText(6);
            String receiver = selectedItem.getText(8);
            String sender = selectedItem.getText(7);
            List downloadHeadersList = (List)selectedItem.getData("downloadHeaders");
            if (downloadUrl != null && objectId != null) {
                SingleFileDownloaderHandler singleDownloader = new SingleFileDownloaderHandler();
                singleDownloader.downloadSingleFile(downloadUrl, patientNr, patientName, exportType, receiver, sender, downloadHeadersList, packageId, createDate);
            } else {
                logger.warn("Download URL or Object ID is missing.");
            }
            try {
                IStatus status = new ImportOmnivore().run();
                if (!status.isOK()) {
                    throw new TaskException(6, "Import failed with status: " + status.getMessage());
                }
            }
            catch (Exception ex) {
                logger.error("Error executing import task: {}", (Object)ex.getMessage(), (Object)ex);
            }
            this.refreshTableData();
        }
    }

    private void adjustTableColumnWidths() {
        int tableWidth = this.submittedFormsTable.getClientArea().width;
        int totalWidth = 0;
        int i = 0;
        while (i < this.submittedFormsTable.getColumnCount() - 1) {
            totalWidth += this.submittedFormsTable.getColumn(i).getWidth();
            ++i;
        }
        if (this.submittedFormsTable.getColumnCount() > 0) {
            this.submittedFormsTable.getColumn(this.submittedFormsTable.getColumnCount() - 1).setWidth(Math.max(100, tableWidth - totalWidth));
        }
    }

    private String extractObjectIdFromDownloadUrl(String downloadUrl) {
        if (downloadUrl == null) {
            return null;
        }
        try {
            String path = URI.create(downloadUrl).getPath();
            String[] segments = path.split("/");
            if (segments.length >= 4) {
                String objectIdWithExtension = segments[4];
                int dotIndex = objectIdWithExtension.lastIndexOf(46);
                if (dotIndex > 0) {
                    return objectIdWithExtension.substring(0, dotIndex);
                }
                return objectIdWithExtension;
            }
        }
        catch (Exception ex) {
            logger.error("Error extracting objectId: {}", (Object)ex.getMessage(), (Object)ex);
        }
        return null;
    }

    public void refreshTableData() {
        String selectedCustomer;
        Integer customerId;
        if (this.customerCombo == null || this.customerCombo.isDisposed()) {
            logger.warn("customerCombo ist disposed oder null. refreshTableData wird abgebrochen.");
            return;
        }
        int selectedIndex = this.customerCombo.getSelectionIndex();
        if (selectedIndex >= 0 && (customerId = this.extractCustomerId(selectedCustomer = this.customerCombo.getItem(selectedIndex))) != null) {
            this.loadSubmittedFormsData(customerId);
        }
    }

    public boolean isDisposed() {
        return this.parent == null || this.parent.isDisposed();
    }
}

