/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.mednet.webapi.ui.parts;

import ch.elexis.mednet.webapi.core.messages.Messages;
import ch.elexis.mednet.webapi.ui.handler.DataHandler;
import ch.elexis.mednet.webapi.ui.handler.PatientFetcher;
import ch.elexis.mednet.webapi.ui.handler.TableHelper;
import ch.elexis.mednet.webapi.ui.util.UIStyleTableHelper;
import java.util.function.Consumer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ProviderComposite {
    private Composite parent;
    private Consumer<Integer> loadFormsCallback;
    private IProviderSelectionListener providerSelectionListener;
    private PatientFetcher patientFetcher;
    private boolean ascending = true;

    public ProviderComposite(Composite parent, IProviderSelectionListener providerSelectionListener, PatientFetcher patientFetcher) {
        this.parent = parent;
        this.providerSelectionListener = providerSelectionListener;
        this.patientFetcher = patientFetcher;
    }

    public void show(Integer customerId) {
        this.parent.setLayout((Layout)UIStyleTableHelper.createStyledGridLayout());
        Text searchBox = new Text(this.parent, 896);
        searchBox.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        searchBox.setMessage(Messages.Composite_searchBoxMessage);
        Table providerTable = UIStyleTableHelper.createStyledTable(this.parent);
        String[] columnHeaders = new String[]{Messages.ProviderComposite_Anbieter_ID, Messages.ProviderComposite_Anbieter_Name};
        int[] nArray = new int[2];
        nArray[1] = 250;
        int[] columnWidths = nArray;
        TableColumn[] columns = new TableColumn[columnHeaders.length];
        int i = 0;
        while (i < columnHeaders.length) {
            TableColumn column = new TableColumn(providerTable, 0);
            column.setText(columnHeaders[i]);
            column.setWidth(columnWidths[i]);
            columns[i] = column;
            if (i == 0) {
                column.setResizable(false);
            }
            int columnIndex = i++;
            column.addListener(13, event -> TableHelper.sortTable(providerTable, columnIndex));
        }
        DataHandler.fetchAndDisplayProviders(providerTable, customerId);
        searchBox.addModifyListener(event -> {
            String searchText = searchBox.getText().toLowerCase();
            TableHelper.filterTable(providerTable, searchText);
        });
        providerTable.addListener(11, event -> {
            int tableWidth = table.getClientArea().width;
            int totalWidth = 0;
            int i = 0;
            while (i < providerTable.getColumnCount() - 1) {
                totalWidth += providerTable.getColumn(i).getWidth();
                ++i;
            }
            int remainingWidth = Math.max(100, tableWidth - totalWidth);
            columns[columns.length - 1].setWidth(remainingWidth);
        });
        providerTable.addListener(8, event -> {
            TableItem[] selection = providerTable.getSelection();
            if (selection.length > 0) {
                TableItem selectedItem = selection[0];
                Integer providerId = Integer.parseInt(selectedItem.getText(0));
                String providerName = selectedItem.getText(1);
                if (providerId != null) {
                    this.providerSelectionListener.onProviderSelected(providerId, providerName);
                }
            }
        });
        this.parent.layout();
    }

    public static interface IProviderSelectionListener {
        public void onProviderSelected(Integer var1, String var2);
    }
}

